/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.conf;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.conf.PropagatingConfigurationObserver;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ConfigurationManager {
    public static final Log LOG = LogFactory.getLog(ConfigurationManager.class);
    private Set<ConfigurationObserver> configurationObservers = Collections.newSetFromMap(new WeakHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObserver(ConfigurationObserver observer) {
        Set<ConfigurationObserver> set = this.configurationObservers;
        synchronized (set) {
            this.configurationObservers.add(observer);
            if (observer instanceof PropagatingConfigurationObserver) {
                ((PropagatingConfigurationObserver)observer).registerChildren(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterObserver(ConfigurationObserver observer) {
        Set<ConfigurationObserver> set = this.configurationObservers;
        synchronized (set) {
            this.configurationObservers.remove(observer);
            if (observer instanceof PropagatingConfigurationObserver) {
                ((PropagatingConfigurationObserver)observer).deregisterChildren(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAllObservers(Configuration conf) {
        Set<ConfigurationObserver> set = this.configurationObservers;
        synchronized (set) {
            for (ConfigurationObserver observer : this.configurationObservers) {
                try {
                    if (observer == null) continue;
                    observer.onConfigurationChange(conf);
                }
                catch (Throwable t) {
                    LOG.error("Encountered a throwable while notifying observers:  of type : " + observer.getClass().getCanonicalName() + "(" + observer + ")", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumObservers() {
        Set<ConfigurationObserver> set = this.configurationObservers;
        synchronized (set) {
            return this.configurationObservers.size();
        }
    }
}

