/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MasterCallable;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.MasterCoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.RegionServerCoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.apache.hive.org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HBaseAdmin
implements Admin {
    private static final Log LOG = LogFactory.getLog(HBaseAdmin.class);
    private static final String ZK_IDENTIFIER_PREFIX = "hbase-admin-on-";
    private ClusterConnection connection;
    private volatile Configuration conf;
    private final long pause;
    private final int numRetries;
    private final int retryLongerMultiplier;
    private final int syncWaitTimeout;
    private boolean aborted;
    private boolean cleanupConnectionOnClose = false;
    private boolean closed = false;
    private int operationTimeout;
    private RpcRetryingCallerFactory rpcCallerFactory;

    @Deprecated
    public HBaseAdmin(Configuration c) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this(ConnectionManager.getConnectionInternal(new Configuration(c)));
        this.cleanupConnectionOnClose = true;
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Deprecated
    public HBaseAdmin(Connection connection) throws MasterNotRunningException, ZooKeeperConnectionException {
        this((ClusterConnection)connection);
    }

    HBaseAdmin(ClusterConnection connection) {
        this.conf = connection.getConfiguration();
        this.connection = connection;
        this.pause = this.conf.getLong("hbase.client.pause", 100L);
        this.numRetries = this.conf.getInt("hbase.client.retries.number", 31);
        this.retryLongerMultiplier = this.conf.getInt("hbase.client.retries.longer.multiplier", 10);
        this.operationTimeout = this.conf.getInt("hbase.client.operation.timeout", 1200000);
        this.syncWaitTimeout = this.conf.getInt("hbase.client.sync.wait.timeout.msec", 600000);
        this.rpcCallerFactory = RpcRetryingCallerFactory.instantiate(this.conf);
    }

    @Override
    public void abort(String why, Throwable e) {
        this.aborted = true;
        throw new RuntimeException(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public HConnection getConnection() {
        return this.connection;
    }

    @Deprecated
    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.connection.isMasterRunning();
    }

    @Override
    public boolean tableExists(TableName tableName) throws IOException {
        return MetaTableAccessor.tableExists(this.connection, tableName);
    }

    public boolean tableExists(byte[] tableName) throws IOException {
        return this.tableExists(TableName.valueOf(tableName));
    }

    public boolean tableExists(String tableName) throws IOException {
        return this.tableExists(TableName.valueOf(tableName));
    }

    @Override
    public HTableDescriptor[] listTables() throws IOException {
        return this.listTables((Pattern)null, false);
    }

    @Override
    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        return this.listTables(pattern, false);
    }

    @Override
    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables(Pattern.compile(regex), false);
    }

    @Override
    public HTableDescriptor[] listTables(final Pattern pattern, final boolean includeSysTables) throws IOException {
        return this.executeCallable(new MasterCallable<HTableDescriptor[]>(this.getConnection()){

            @Override
            public HTableDescriptor[] call(int callTimeout) throws ServiceException {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(pattern, includeSysTables);
                return ProtobufUtil.getHTableDescriptorArray(this.master.getTableDescriptors(null, req));
            }
        });
    }

    @Override
    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        return this.listTables(Pattern.compile(regex), includeSysTables);
    }

    @Deprecated
    public String[] getTableNames() throws IOException {
        TableName[] tableNames = this.listTableNames();
        String[] result = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            result[i] = tableNames[i].getNameAsString();
        }
        return result;
    }

    @Deprecated
    public String[] getTableNames(Pattern pattern) throws IOException {
        TableName[] tableNames = this.listTableNames(pattern);
        String[] result = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            result[i] = tableNames[i].getNameAsString();
        }
        return result;
    }

    @Deprecated
    public String[] getTableNames(String regex) throws IOException {
        return this.getTableNames(Pattern.compile(regex));
    }

    @Override
    public TableName[] listTableNames() throws IOException {
        return this.listTableNames((Pattern)null, false);
    }

    @Override
    public TableName[] listTableNames(Pattern pattern) throws IOException {
        return this.listTableNames(pattern, false);
    }

    @Override
    public TableName[] listTableNames(String regex) throws IOException {
        return this.listTableNames(Pattern.compile(regex), false);
    }

    @Override
    public TableName[] listTableNames(final Pattern pattern, final boolean includeSysTables) throws IOException {
        return this.executeCallable(new MasterCallable<TableName[]>(this.getConnection()){

            @Override
            public TableName[] call(int callTimeout) throws ServiceException {
                MasterProtos.GetTableNamesRequest req = RequestConverter.buildGetTableNamesRequest(pattern, includeSysTables);
                return ProtobufUtil.getTableNameArray(this.master.getTableNames(null, req).getTableNamesList());
            }
        });
    }

    @Override
    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        return this.listTableNames(Pattern.compile(regex), includeSysTables);
    }

    @Override
    public HTableDescriptor getTableDescriptor(final TableName tableName) throws TableNotFoundException, IOException {
        if (tableName == null) {
            return null;
        }
        HTableDescriptor htd = this.executeCallable(new MasterCallable<HTableDescriptor>(this.getConnection()){

            @Override
            public HTableDescriptor call(int callTimeout) throws ServiceException {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableName);
                MasterProtos.GetTableDescriptorsResponse htds = this.master.getTableDescriptors(null, req);
                if (!htds.getTableSchemaList().isEmpty()) {
                    return HTableDescriptor.convert(htds.getTableSchemaList().get(0));
                }
                return null;
            }
        });
        if (htd != null) {
            return htd;
        }
        throw new TableNotFoundException(tableName.getNameAsString());
    }

    public HTableDescriptor getTableDescriptor(byte[] tableName) throws TableNotFoundException, IOException {
        return this.getTableDescriptor(TableName.valueOf(tableName));
    }

    private long getPauseTime(int tries) {
        int triesCount = tries;
        if (triesCount >= HConstants.RETRY_BACKOFF.length) {
            triesCount = HConstants.RETRY_BACKOFF.length - 1;
        }
        return this.pause * (long)HConstants.RETRY_BACKOFF[triesCount];
    }

    @Override
    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    @Override
    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo(startKey, endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split(startKey, endKey, numRegions - 3);
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    @Override
    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        Future<Void> future = this.createTableAsyncV2(desc, splitKeys);
        try {
            future.get(this.syncWaitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for table to be enabled; meta scan was done");
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    @Override
    public void createTableAsync(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.createTableAsyncV2(desc, splitKeys);
    }

    private Future<Void> createTableAsyncV2(final HTableDescriptor desc, final byte[][] splitKeys) throws IOException {
        if (desc.getTableName() == null) {
            throw new IllegalArgumentException("TableName cannot be null");
        }
        if (splitKeys != null && splitKeys.length > 0) {
            Arrays.sort(splitKeys, Bytes.BYTES_COMPARATOR);
            byte[] lastKey = null;
            for (byte[] splitKey : splitKeys) {
                if (Bytes.compareTo(splitKey, HConstants.EMPTY_BYTE_ARRAY) == 0) {
                    throw new IllegalArgumentException("Empty split key must not be passed in the split keys.");
                }
                if (lastKey != null && Bytes.equals(splitKey, lastKey)) {
                    throw new IllegalArgumentException("All split keys must be unique, found duplicate: " + Bytes.toStringBinary(splitKey) + ", " + Bytes.toStringBinary(lastKey));
                }
                lastKey = splitKey;
            }
        }
        MasterProtos.CreateTableResponse response = this.executeCallable(new MasterCallable<MasterProtos.CreateTableResponse>(this.getConnection()){

            @Override
            public MasterProtos.CreateTableResponse call(int callTimeout) throws ServiceException {
                MasterProtos.CreateTableRequest request = RequestConverter.buildCreateTableRequest(desc, splitKeys);
                return this.master.createTable(null, request);
            }
        });
        return new CreateTableFuture(this, desc, splitKeys, response);
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(TableName.valueOf(tableName));
    }

    public void deleteTable(byte[] tableName) throws IOException {
        this.deleteTable(TableName.valueOf(tableName));
    }

    @Override
    public void deleteTable(TableName tableName) throws IOException {
        Future<Void> future = this.deleteTableAsyncV2(tableName);
        try {
            future.get(this.syncWaitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for table to be deleted");
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    private Future<Void> deleteTableAsyncV2(final TableName tableName) throws IOException {
        MasterProtos.DeleteTableResponse response = this.executeCallable(new MasterCallable<MasterProtos.DeleteTableResponse>(this.getConnection()){

            @Override
            public MasterProtos.DeleteTableResponse call(int callTimeout) throws ServiceException {
                MasterProtos.DeleteTableRequest req = RequestConverter.buildDeleteTableRequest(tableName);
                return this.master.deleteTable(null, req);
            }
        });
        return new DeleteTableFuture(this, tableName, response);
    }

    @Override
    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        return this.deleteTables(Pattern.compile(regex));
    }

    @Override
    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            try {
                this.deleteTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info("Failed to delete table " + table.getTableName(), ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    @Override
    public void truncateTable(final TableName tableName, final boolean preserveSplits) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                MasterProtos.TruncateTableRequest req = RequestConverter.buildTruncateTableRequest(tableName, preserveSplits);
                this.master.truncateTable(null, req);
                return null;
            }
        });
    }

    @Override
    public void enableTable(TableName tableName) throws IOException {
        Future<Void> future = this.enableTableAsyncV2(tableName);
        try {
            future.get(this.syncWaitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for table to be disabled");
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    public void enableTable(byte[] tableName) throws IOException {
        this.enableTable(TableName.valueOf(tableName));
    }

    public void enableTable(String tableName) throws IOException {
        this.enableTable(TableName.valueOf(tableName));
    }

    private void waitUntilTableIsEnabled(TableName tableName) throws IOException {
        boolean enabled = false;
        long start = EnvironmentEdgeManager.currentTime();
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier; ++tries) {
            try {
                enabled = this.isTableEnabled(tableName);
            }
            catch (TableNotFoundException tnfe) {
                enabled = false;
            }
            boolean bl = enabled = enabled && this.isTableAvailable(tableName);
            if (enabled) break;
            long sleep = this.getPauseTime(tries);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sleeping= " + sleep + "ms, waiting for all regions to be " + "enabled in " + tableName);
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
        }
        if (!enabled) {
            long msec = EnvironmentEdgeManager.currentTime() - start;
            throw new IOException("Table '" + tableName + "' not yet enabled, after " + msec + "ms.");
        }
    }

    @Override
    public void enableTableAsync(TableName tableName) throws IOException {
        this.enableTableAsyncV2(tableName);
    }

    public void enableTableAsync(byte[] tableName) throws IOException {
        this.enableTable(TableName.valueOf(tableName));
    }

    public void enableTableAsync(String tableName) throws IOException {
        this.enableTableAsync(TableName.valueOf(tableName));
    }

    private Future<Void> enableTableAsyncV2(final TableName tableName) throws IOException {
        TableName.isLegalFullyQualifiedTableName(tableName.getName());
        MasterProtos.EnableTableResponse response = this.executeCallable(new MasterCallable<MasterProtos.EnableTableResponse>(this.getConnection()){

            @Override
            public MasterProtos.EnableTableResponse call(int callTimeout) throws ServiceException {
                LOG.info("Started enable of " + tableName);
                MasterProtos.EnableTableRequest req = RequestConverter.buildEnableTableRequest(tableName);
                return this.master.enableTable(null, req);
            }
        });
        return new EnableTableFuture(this, tableName, response);
    }

    @Override
    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.enableTables(Pattern.compile(regex));
    }

    @Override
    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableDisabled(table.getTableName())) continue;
            try {
                this.enableTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info("Failed to enable table " + table.getTableName(), ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    @Override
    public void disableTableAsync(TableName tableName) throws IOException {
        this.disableTableAsyncV2(tableName);
    }

    public void disableTableAsync(byte[] tableName) throws IOException {
        this.disableTableAsync(TableName.valueOf(tableName));
    }

    public void disableTableAsync(String tableName) throws IOException {
        this.disableTableAsync(TableName.valueOf(tableName));
    }

    @Override
    public void disableTable(TableName tableName) throws IOException {
        Future<Void> future = this.disableTableAsyncV2(tableName);
        try {
            future.get(this.syncWaitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for table to be disabled");
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    public void disableTable(byte[] tableName) throws IOException {
        this.disableTable(TableName.valueOf(tableName));
    }

    public void disableTable(String tableName) throws IOException {
        this.disableTable(TableName.valueOf(tableName));
    }

    private Future<Void> disableTableAsyncV2(final TableName tableName) throws IOException {
        TableName.isLegalFullyQualifiedTableName(tableName.getName());
        MasterProtos.DisableTableResponse response = this.executeCallable(new MasterCallable<MasterProtos.DisableTableResponse>(this.getConnection()){

            @Override
            public MasterProtos.DisableTableResponse call(int callTimeout) throws ServiceException {
                LOG.info("Started disable of " + tableName);
                MasterProtos.DisableTableRequest req = RequestConverter.buildDisableTableRequest(tableName);
                return this.master.disableTable(null, req);
            }
        });
        return new DisableTableFuture(this, tableName, response);
    }

    @Override
    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.disableTables(Pattern.compile(regex));
    }

    @Override
    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableEnabled(table.getTableName())) continue;
            try {
                this.disableTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info("Failed to disable table " + table.getTableName(), ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    private void checkTableExistence(TableName tableName) throws IOException {
        if (!this.tableExists(tableName)) {
            throw new TableNotFoundException(tableName);
        }
    }

    @Override
    public boolean isTableEnabled(TableName tableName) throws IOException {
        this.checkTableExistence(tableName);
        return this.connection.isTableEnabled(tableName);
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf(tableName));
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf(tableName));
    }

    @Override
    public boolean isTableDisabled(TableName tableName) throws IOException {
        this.checkTableExistence(tableName);
        return this.connection.isTableDisabled(tableName);
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf(tableName));
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf(tableName));
    }

    @Override
    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.connection.isTableAvailable(tableName);
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf(tableName));
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf(tableName));
    }

    @Override
    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.connection.isTableAvailable(tableName, splitKeys);
    }

    public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
        return this.isTableAvailable(TableName.valueOf(tableName), splitKeys);
    }

    public boolean isTableAvailable(String tableName, byte[][] splitKeys) throws IOException {
        return this.isTableAvailable(TableName.valueOf(tableName), splitKeys);
    }

    @Override
    public Pair<Integer, Integer> getAlterStatus(final TableName tableName) throws IOException {
        return this.executeCallable(new MasterCallable<Pair<Integer, Integer>>(this.getConnection()){

            @Override
            public Pair<Integer, Integer> call(int callTimeout) throws ServiceException {
                MasterProtos.GetSchemaAlterStatusRequest req = RequestConverter.buildGetSchemaAlterStatusRequest(tableName);
                MasterProtos.GetSchemaAlterStatusResponse ret = this.master.getSchemaAlterStatus(null, req);
                Pair<Integer, Integer> pair = new Pair<Integer, Integer>(ret.getYetToUpdateRegions(), ret.getTotalRegions());
                return pair;
            }
        });
    }

    @Override
    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        return this.getAlterStatus(TableName.valueOf(tableName));
    }

    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf(tableName), column);
    }

    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf(tableName), column);
    }

    @Override
    public void addColumn(final TableName tableName, final HColumnDescriptor column) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                MasterProtos.AddColumnRequest req = RequestConverter.buildAddColumnRequest(tableName, column);
                this.master.addColumn(null, req);
                return null;
            }
        });
    }

    public void deleteColumn(byte[] tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf(tableName), Bytes.toBytes(columnName));
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf(tableName), Bytes.toBytes(columnName));
    }

    @Override
    public void deleteColumn(final TableName tableName, final byte[] columnName) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                MasterProtos.DeleteColumnRequest req = RequestConverter.buildDeleteColumnRequest(tableName, columnName);
                this.master.deleteColumn(null, req);
                return null;
            }
        });
    }

    public void modifyColumn(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf(tableName), descriptor);
    }

    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf(tableName), descriptor);
    }

    @Override
    public void modifyColumn(final TableName tableName, final HColumnDescriptor descriptor) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                MasterProtos.ModifyColumnRequest req = RequestConverter.buildModifyColumnRequest(tableName, descriptor);
                this.master.modifyColumn(null, req);
                return null;
            }
        });
    }

    @Override
    public void closeRegion(String regionname, String serverName) throws IOException {
        this.closeRegion(Bytes.toBytes(regionname), serverName);
    }

    @Override
    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        if (serverName != null) {
            Pair<HRegionInfo, ServerName> pair = MetaTableAccessor.getRegion(this.connection, regionname);
            if (pair == null || pair.getFirst() == null) {
                throw new UnknownRegionException(Bytes.toStringBinary(regionname));
            }
            this.closeRegion(ServerName.valueOf(serverName), pair.getFirst());
        } else {
            Pair<HRegionInfo, ServerName> pair = MetaTableAccessor.getRegion(this.connection, regionname);
            if (pair == null) {
                throw new UnknownRegionException(Bytes.toStringBinary(regionname));
            }
            if (pair.getSecond() == null) {
                throw new NoServerForRegionException(Bytes.toStringBinary(regionname));
            }
            this.closeRegion(pair.getSecond(), pair.getFirst());
        }
    }

    @Override
    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        if (null == serverName || "".equals(serverName.trim())) {
            throw new IllegalArgumentException("The servername cannot be null or empty.");
        }
        ServerName sn = ServerName.valueOf(serverName);
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.CloseRegionRequest request = RequestConverter.buildCloseRegionRequest(sn, encodedRegionName, false);
        try {
            AdminProtos.CloseRegionResponse response = admin.closeRegion(null, request);
            boolean isRegionClosed = response.getClosed();
            if (!isRegionClosed) {
                LOG.error("Not able to close the region " + encodedRegionName + ".");
            }
            return isRegionClosed;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Override
    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        ProtobufUtil.closeRegion(admin, sn, hri.getRegionName(), false);
    }

    @Override
    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        return ProtobufUtil.getOnlineRegions(admin);
    }

    @Override
    public void flush(TableName tableName) throws IOException {
        this.checkTableExists(tableName);
        if (this.isTableDisabled(tableName)) {
            LOG.info("Table is disabled: " + tableName.getNameAsString());
            return;
        }
        this.execProcedure("flush-table-proc", tableName.getNameAsString(), new HashMap<String, String>());
    }

    @Override
    public void flushRegion(byte[] regionName) throws IOException {
        Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(regionName);
        if (regionServerPair == null) {
            throw new IllegalArgumentException("Unknown regionname: " + Bytes.toStringBinary(regionName));
        }
        if (regionServerPair.getSecond() == null) {
            throw new NoServerForRegionException(Bytes.toStringBinary(regionName));
        }
        this.flush(regionServerPair.getSecond(), regionServerPair.getFirst());
    }

    @Deprecated
    public void flush(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.flush(Bytes.toBytes(tableNameOrRegionName));
    }

    @Deprecated
    public void flush(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        try {
            this.flushRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException e) {
            this.flush(TableName.valueOf(tableNameOrRegionName));
        }
    }

    private void flush(ServerName sn, HRegionInfo hri) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.FlushRegionRequest request = RequestConverter.buildFlushRegionRequest(hri.getRegionName());
        try {
            admin.flushRegion(null, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Override
    public void compact(TableName tableName) throws IOException {
        this.compact(tableName, null, false);
    }

    @Override
    public void compactRegion(byte[] regionName) throws IOException {
        this.compactRegion(regionName, null, false);
    }

    @Deprecated
    public void compact(String tableNameOrRegionName) throws IOException {
        this.compact(Bytes.toBytes(tableNameOrRegionName));
    }

    @Deprecated
    public void compact(byte[] tableNameOrRegionName) throws IOException {
        try {
            this.compactRegion(tableNameOrRegionName, null, false);
        }
        catch (IllegalArgumentException e) {
            this.compact(TableName.valueOf(tableNameOrRegionName), null, false);
        }
    }

    @Override
    public void compact(TableName tableName, byte[] columnFamily) throws IOException {
        this.compact(tableName, columnFamily, false);
    }

    @Override
    public void compactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.compactRegion(regionName, columnFamily, false);
    }

    @Deprecated
    public void compact(String tableOrRegionName, String columnFamily) throws IOException {
        this.compact(Bytes.toBytes(tableOrRegionName), Bytes.toBytes(columnFamily));
    }

    @Deprecated
    public void compact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
        try {
            this.compactRegion(tableNameOrRegionName, columnFamily, false);
        }
        catch (IllegalArgumentException e) {
            this.compact(TableName.valueOf(tableNameOrRegionName), columnFamily, false);
        }
    }

    @Override
    public void compactRegionServer(ServerName sn, boolean major) throws IOException, InterruptedException {
        for (HRegionInfo region : this.getOnlineRegions(sn)) {
            this.compact(sn, region, major, null);
        }
    }

    @Override
    public void majorCompact(TableName tableName) throws IOException {
        this.compact(tableName, null, true);
    }

    @Override
    public void majorCompactRegion(byte[] regionName) throws IOException {
        this.compactRegion(regionName, null, true);
    }

    @Deprecated
    public void majorCompact(String tableNameOrRegionName) throws IOException {
        this.majorCompact(Bytes.toBytes(tableNameOrRegionName));
    }

    @Deprecated
    public void majorCompact(byte[] tableNameOrRegionName) throws IOException {
        try {
            this.compactRegion(tableNameOrRegionName, null, true);
        }
        catch (IllegalArgumentException e) {
            this.compact(TableName.valueOf(tableNameOrRegionName), null, true);
        }
    }

    @Override
    public void majorCompact(TableName tableName, byte[] columnFamily) throws IOException {
        this.compact(tableName, columnFamily, true);
    }

    @Override
    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.compactRegion(regionName, columnFamily, true);
    }

    @Deprecated
    public void majorCompact(String tableNameOrRegionName, String columnFamily) throws IOException {
        this.majorCompact(Bytes.toBytes(tableNameOrRegionName), Bytes.toBytes(columnFamily));
    }

    @Deprecated
    public void majorCompact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
        try {
            this.compactRegion(tableNameOrRegionName, columnFamily, true);
        }
        catch (IllegalArgumentException e) {
            this.compact(TableName.valueOf(tableNameOrRegionName), columnFamily, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(TableName tableName, byte[] columnFamily, boolean major) throws IOException {
        try (ZooKeeperWatcher zookeeper = null;){
            this.checkTableExists(tableName);
            zookeeper = new ZooKeeperWatcher(this.conf, ZK_IDENTIFIER_PREFIX + this.connection.toString(), new ThrowableAbortable());
            List<Pair<HRegionInfo, ServerName>> pairs = MetaTableAccessor.getTableRegionsAndLocations(zookeeper, this.connection, tableName);
            for (Pair<HRegionInfo, ServerName> pair : pairs) {
                if (pair.getFirst().isOffline() || pair.getSecond() == null) continue;
                try {
                    this.compact(pair.getSecond(), pair.getFirst(), major, columnFamily);
                }
                catch (NotServingRegionException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Trying to" + (major ? " major" : "") + " compact " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e));
                }
            }
        }
    }

    private void compactRegion(byte[] regionName, byte[] columnFamily, boolean major) throws IOException {
        Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(regionName);
        if (regionServerPair == null) {
            throw new IllegalArgumentException("Invalid region: " + Bytes.toStringBinary(regionName));
        }
        if (regionServerPair.getSecond() == null) {
            throw new NoServerForRegionException(Bytes.toStringBinary(regionName));
        }
        this.compact(regionServerPair.getSecond(), regionServerPair.getFirst(), major, columnFamily);
    }

    private void compact(ServerName sn, HRegionInfo hri, boolean major, byte[] family) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.CompactRegionRequest request = RequestConverter.buildCompactRegionRequest(hri.getRegionName(), major, family);
        try {
            admin.compactRegion(null, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Override
    public void move(final byte[] encodedRegionName, final byte[] destServerName) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                try {
                    MasterProtos.MoveRegionRequest request = RequestConverter.buildMoveRegionRequest(encodedRegionName, destServerName);
                    this.master.moveRegion(null, request);
                }
                catch (DeserializationException de) {
                    LOG.error("Could not parse destination server name: " + de);
                    throw new ServiceException((Throwable)new DoNotRetryIOException(de));
                }
                return null;
            }
        });
    }

    @Override
    public void assign(byte[] regionName) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        final byte[] toBeAssigned = this.getRegionName(regionName);
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                MasterProtos.AssignRegionRequest request = RequestConverter.buildAssignRegionRequest(toBeAssigned);
                this.master.assignRegion(null, request);
                return null;
            }
        });
    }

    @Override
    public void unassign(byte[] regionName, final boolean force) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        final byte[] toBeUnassigned = this.getRegionName(regionName);
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                MasterProtos.UnassignRegionRequest request = RequestConverter.buildUnassignRegionRequest(toBeUnassigned, force);
                this.master.unassignRegion(null, request);
                return null;
            }
        });
    }

    @Override
    public void offline(final byte[] regionName) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                this.master.offlineRegion(null, RequestConverter.buildOfflineRegionRequest(regionName));
                return null;
            }
        });
    }

    @Override
    public boolean setBalancerRunning(final boolean on, final boolean synchronous) throws IOException {
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                MasterProtos.SetBalancerRunningRequest req = RequestConverter.buildSetBalancerRunningRequest(on, synchronous);
                return this.master.setBalancerRunning(null, req).getPrevBalanceValue();
            }
        });
    }

    @Override
    public boolean balancer() throws IOException {
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                return this.master.balance(null, RequestConverter.buildBalanceRequest()).getBalancerRan();
            }
        });
    }

    @Override
    public boolean isBalancerEnabled() throws IOException {
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                return this.master.isBalancerEnabled(null, RequestConverter.buildIsBalancerEnabledRequest()).getEnabled();
            }
        });
    }

    @Override
    public boolean enableCatalogJanitor(final boolean enable) throws IOException {
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                return this.master.enableCatalogJanitor(null, RequestConverter.buildEnableCatalogJanitorRequest(enable)).getPrevValue();
            }
        });
    }

    @Override
    public int runCatalogScan() throws IOException {
        return this.executeCallable(new MasterCallable<Integer>(this.getConnection()){

            @Override
            public Integer call(int callTimeout) throws ServiceException {
                return this.master.runCatalogScan(null, RequestConverter.buildCatalogScanRequest()).getScanResult();
            }
        });
    }

    @Override
    public boolean isCatalogJanitorEnabled() throws IOException {
        return this.executeCallable(new MasterCallable<Boolean>(this.getConnection()){

            @Override
            public Boolean call(int callTimeout) throws ServiceException {
                return this.master.isCatalogJanitorEnabled(null, RequestConverter.buildIsCatalogJanitorEnabledRequest()).getValue();
            }
        });
    }

    @Override
    public void mergeRegions(final byte[] encodedNameOfRegionA, final byte[] encodedNameOfRegionB, final boolean forcible) throws IOException {
        Pair<HRegionInfo, ServerName> pair = this.getRegion(encodedNameOfRegionA);
        if (pair != null && pair.getFirst().getReplicaId() != 0) {
            throw new IllegalArgumentException("Can't invoke merge on non-default regions directly");
        }
        pair = this.getRegion(encodedNameOfRegionB);
        if (pair != null && pair.getFirst().getReplicaId() != 0) {
            throw new IllegalArgumentException("Can't invoke merge on non-default regions directly");
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                try {
                    MasterProtos.DispatchMergingRegionsRequest request = RequestConverter.buildDispatchMergingRegionsRequest(encodedNameOfRegionA, encodedNameOfRegionB, forcible);
                    this.master.dispatchMergingRegions(null, request);
                }
                catch (DeserializationException de) {
                    LOG.error("Could not parse destination server name: " + de);
                }
                return null;
            }
        });
    }

    @Override
    public void split(TableName tableName) throws IOException {
        this.split(tableName, null);
    }

    @Override
    public void splitRegion(byte[] regionName) throws IOException {
        this.splitRegion(regionName, null);
    }

    @Deprecated
    public void split(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(Bytes.toBytes(tableNameOrRegionName));
    }

    @Deprecated
    public void split(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(tableNameOrRegionName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void split(TableName tableName, byte[] splitPoint) throws IOException {
        try (ZooKeeperWatcher zookeeper = null;){
            this.checkTableExists(tableName);
            zookeeper = new ZooKeeperWatcher(this.conf, ZK_IDENTIFIER_PREFIX + this.connection.toString(), new ThrowableAbortable());
            List<Pair<HRegionInfo, ServerName>> pairs = MetaTableAccessor.getTableRegionsAndLocations(zookeeper, this.connection, tableName);
            for (Pair<HRegionInfo, ServerName> pair : pairs) {
                HRegionInfo r;
                if (pair.getSecond() == null || (r = pair.getFirst()).isSplitParent() || r.getReplicaId() != 0 || splitPoint != null && !r.containsRow(splitPoint)) continue;
                this.split(pair.getSecond(), pair.getFirst(), splitPoint);
            }
        }
    }

    @Override
    public void splitRegion(byte[] regionName, byte[] splitPoint) throws IOException {
        Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(regionName);
        if (regionServerPair == null) {
            throw new IllegalArgumentException("Invalid region: " + Bytes.toStringBinary(regionName));
        }
        if (regionServerPair.getFirst() != null && regionServerPair.getFirst().getReplicaId() != 0) {
            throw new IllegalArgumentException("Can't split replicas directly. Replicas are auto-split when their primary is split.");
        }
        if (regionServerPair.getSecond() == null) {
            throw new NoServerForRegionException(Bytes.toStringBinary(regionName));
        }
        this.split(regionServerPair.getSecond(), regionServerPair.getFirst(), splitPoint);
    }

    @Deprecated
    public void split(String tableNameOrRegionName, String splitPoint) throws IOException {
        this.split(Bytes.toBytes(tableNameOrRegionName), Bytes.toBytes(splitPoint));
    }

    @Deprecated
    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException {
        try {
            this.splitRegion(tableNameOrRegionName, splitPoint);
        }
        catch (IllegalArgumentException e) {
            this.split(TableName.valueOf(tableNameOrRegionName), splitPoint);
        }
    }

    @VisibleForTesting
    public void split(ServerName sn, HRegionInfo hri, byte[] splitPoint) throws IOException {
        if (hri.getStartKey() != null && splitPoint != null && Bytes.compareTo(hri.getStartKey(), splitPoint) == 0) {
            throw new IOException("should not give a splitkey which equals to startkey!");
        }
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        ProtobufUtil.split(admin, hri, splitPoint);
    }

    @Override
    public void modifyTable(final TableName tableName, final HTableDescriptor htd) throws IOException {
        if (!tableName.equals(htd.getTableName())) {
            throw new IllegalArgumentException("the specified table name '" + tableName + "' doesn't match with the HTD one: " + htd.getTableName());
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                MasterProtos.ModifyTableRequest request = RequestConverter.buildModifyTableRequest(tableName, htd);
                this.master.modifyTable(null, request);
                return null;
            }
        });
    }

    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf(tableName), htd);
    }

    public void modifyTable(String tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf(tableName), htd);
    }

    Pair<HRegionInfo, ServerName> getRegion(byte[] regionName) throws IOException {
        if (regionName == null) {
            throw new IllegalArgumentException("Pass a table name or region name");
        }
        Pair pair = MetaTableAccessor.getRegion(this.connection, regionName);
        if (pair == null) {
            final AtomicReference<Object> result = new AtomicReference<Object>(null);
            final String encodedName = Bytes.toString(regionName);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result data) throws IOException {
                    HRegionInfo info = HRegionInfo.getHRegionInfo(data);
                    if (info == null) {
                        LOG.warn("No serialized HRegionInfo in " + data);
                        return true;
                    }
                    RegionLocations rl = MetaTableAccessor.getRegionLocations(data);
                    boolean matched = false;
                    ServerName sn = null;
                    for (HRegionLocation h : rl.getRegionLocations()) {
                        if (h == null || !encodedName.equals(h.getRegionInfo().getEncodedName())) continue;
                        sn = h.getServerName();
                        info = h.getRegionInfo();
                        matched = true;
                    }
                    if (!matched) {
                        return true;
                    }
                    result.set(new Pair<HRegionInfo, Object>(info, sn));
                    return false;
                }
            };
            MetaScanner.metaScan(this.connection, visitor, null);
            pair = result.get();
        }
        return pair;
    }

    private byte[] getRegionName(byte[] regionNameOrEncodedRegionName) throws IOException {
        if (Bytes.equals(regionNameOrEncodedRegionName, HRegionInfo.FIRST_META_REGIONINFO.getRegionName()) || Bytes.equals(regionNameOrEncodedRegionName, HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes())) {
            return HRegionInfo.FIRST_META_REGIONINFO.getRegionName();
        }
        byte[] tmp = regionNameOrEncodedRegionName;
        Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(regionNameOrEncodedRegionName);
        if (regionServerPair != null && regionServerPair.getFirst() != null) {
            tmp = regionServerPair.getFirst().getRegionName();
        }
        return tmp;
    }

    private TableName checkTableExists(TableName tableName) throws IOException {
        if (!MetaTableAccessor.tableExists(this.connection, tableName)) {
            throw new TableNotFoundException(tableName);
        }
        return tableName;
    }

    @Override
    public synchronized void shutdown() throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                this.master.shutdown(null, MasterProtos.ShutdownRequest.newBuilder().build());
                return null;
            }
        });
    }

    @Override
    public synchronized void stopMaster() throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                this.master.stopMaster(null, MasterProtos.StopMasterRequest.newBuilder().build());
                return null;
            }
        });
    }

    @Override
    public synchronized void stopRegionServer(String hostnamePort) throws IOException {
        String hostname = Addressing.parseHostname(hostnamePort);
        int port = Addressing.parsePort(hostnamePort);
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(ServerName.valueOf(hostname, port, 0L));
        AdminProtos.StopServerRequest request = RequestConverter.buildStopServerRequest("Called by admin client " + this.connection.toString());
        try {
            admin.stopServer(null, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Override
    public ClusterStatus getClusterStatus() throws IOException {
        return this.executeCallable(new MasterCallable<ClusterStatus>(this.getConnection()){

            @Override
            public ClusterStatus call(int callTimeout) throws ServiceException {
                MasterProtos.GetClusterStatusRequest req = RequestConverter.buildGetClusterStatusRequest();
                return ClusterStatus.convert(this.master.getClusterStatus(null, req).getClusterStatus());
            }
        });
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void createNamespace(final NamespaceDescriptor descriptor) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws Exception {
                this.master.createNamespace(null, MasterProtos.CreateNamespaceRequest.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(descriptor)).build());
                return null;
            }
        });
    }

    @Override
    public void modifyNamespace(final NamespaceDescriptor descriptor) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws Exception {
                this.master.modifyNamespace(null, MasterProtos.ModifyNamespaceRequest.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(descriptor)).build());
                return null;
            }
        });
    }

    @Override
    public void deleteNamespace(final String name) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws Exception {
                this.master.deleteNamespace(null, MasterProtos.DeleteNamespaceRequest.newBuilder().setNamespaceName(name).build());
                return null;
            }
        });
    }

    @Override
    public NamespaceDescriptor getNamespaceDescriptor(final String name) throws IOException {
        return this.executeCallable(new MasterCallable<NamespaceDescriptor>(this.getConnection()){

            @Override
            public NamespaceDescriptor call(int callTimeout) throws Exception {
                return ProtobufUtil.toNamespaceDescriptor(this.master.getNamespaceDescriptor(null, MasterProtos.GetNamespaceDescriptorRequest.newBuilder().setNamespaceName(name).build()).getNamespaceDescriptor());
            }
        });
    }

    @Override
    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        return this.executeCallable(new MasterCallable<NamespaceDescriptor[]>(this.getConnection()){

            @Override
            public NamespaceDescriptor[] call(int callTimeout) throws Exception {
                List<HBaseProtos.NamespaceDescriptor> list = this.master.listNamespaceDescriptors(null, MasterProtos.ListNamespaceDescriptorsRequest.newBuilder().build()).getNamespaceDescriptorList();
                NamespaceDescriptor[] res = new NamespaceDescriptor[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    res[i] = ProtobufUtil.toNamespaceDescriptor(list.get(i));
                }
                return res;
            }
        });
    }

    @Override
    public HTableDescriptor[] listTableDescriptorsByNamespace(final String name) throws IOException {
        return this.executeCallable(new MasterCallable<HTableDescriptor[]>(this.getConnection()){

            @Override
            public HTableDescriptor[] call(int callTimeout) throws Exception {
                List<HBaseProtos.TableSchema> list = this.master.listTableDescriptorsByNamespace(null, MasterProtos.ListTableDescriptorsByNamespaceRequest.newBuilder().setNamespaceName(name).build()).getTableSchemaList();
                HTableDescriptor[] res = new HTableDescriptor[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    res[i] = HTableDescriptor.convert(list.get(i));
                }
                return res;
            }
        });
    }

    @Override
    public TableName[] listTableNamesByNamespace(final String name) throws IOException {
        return this.executeCallable(new MasterCallable<TableName[]>(this.getConnection()){

            @Override
            public TableName[] call(int callTimeout) throws Exception {
                List<HBaseProtos.TableName> tableNames = this.master.listTableNamesByNamespace(null, MasterProtos.ListTableNamesByNamespaceRequest.newBuilder().setNamespaceName(name).build()).getTableNameList();
                TableName[] result = new TableName[tableNames.size()];
                for (int i = 0; i < tableNames.size(); ++i) {
                    result[i] = ProtobufUtil.toTableName(tableNames.get(i));
                }
                return result;
            }
        });
    }

    public static void checkHBaseAvailable(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, ServiceException, IOException {
        Configuration copyOfConf = HBaseConfiguration.create(conf);
        copyOfConf.setInt("hbase.client.retries.number", 1);
        copyOfConf.setInt("zookeeper.recovery.retry", 0);
        try (ClusterConnection connection = (ClusterConnection)ConnectionFactory.createConnection(copyOfConf);){
            try (ZooKeeperKeepAliveConnection zkw = null;){
                zkw = ((ConnectionManager.HConnectionImplementation)connection).getKeepAliveZooKeeperWatcher();
                zkw.getRecoverableZooKeeper().getZooKeeper().exists(zkw.baseZNode, false);
            }
            connection.isMasterRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
        List<HRegionInfo> Regions = null;
        try (ZooKeeperWatcher zookeeper = new ZooKeeperWatcher(this.conf, ZK_IDENTIFIER_PREFIX + this.connection.toString(), new ThrowableAbortable());){
            Regions = MetaTableAccessor.getTableRegions(zookeeper, this.connection, tableName, true);
        }
        return Regions;
    }

    public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
        return this.getTableRegions(TableName.valueOf(tableName));
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.cleanupConnectionOnClose && this.connection != null && !this.closed) {
            this.connection.close();
            this.closed = true;
        }
    }

    @Override
    public HTableDescriptor[] getTableDescriptorsByTableName(final List<TableName> tableNames) throws IOException {
        return this.executeCallable(new MasterCallable<HTableDescriptor[]>(this.getConnection()){

            @Override
            public HTableDescriptor[] call(int callTimeout) throws Exception {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableNames);
                return ProtobufUtil.getHTableDescriptorArray(this.master.getTableDescriptors(null, req));
            }
        });
    }

    private HTableDescriptor getTableDescriptorByTableName(TableName tableName) throws IOException {
        ArrayList<TableName> tableNames = new ArrayList<TableName>(1);
        tableNames.add(tableName);
        HTableDescriptor[] htdl = this.getTableDescriptorsByTableName(tableNames);
        if (htdl == null || htdl.length == 0) {
            return null;
        }
        return htdl[0];
    }

    @Override
    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        ArrayList<TableName> tableNames = new ArrayList<TableName>(names.size());
        for (String name : names) {
            tableNames.add(TableName.valueOf(name));
        }
        return this.getTableDescriptorsByTableName(tableNames);
    }

    private AdminProtos.RollWALWriterResponse rollWALWriterImpl(ServerName sn) throws IOException, FailedLogCloseException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.RollWALWriterRequest request = RequestConverter.buildRollWALWriterRequest();
        try {
            return admin.rollWALWriter(null, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Deprecated
    public synchronized byte[][] rollHLogWriter(String serverName) throws IOException, FailedLogCloseException {
        ServerName sn = ServerName.valueOf(serverName);
        AdminProtos.RollWALWriterResponse response = this.rollWALWriterImpl(sn);
        int regionCount = response.getRegionToFlushCount();
        if (0 == regionCount) {
            return null;
        }
        byte[][] regionsToFlush = new byte[regionCount][];
        for (int i = 0; i < regionCount; ++i) {
            ByteString region = response.getRegionToFlush(i);
            regionsToFlush[i] = region.toByteArray();
        }
        return regionsToFlush;
    }

    @Override
    public synchronized void rollWALWriter(ServerName serverName) throws IOException, FailedLogCloseException {
        this.rollWALWriterImpl(serverName);
    }

    @Override
    public String[] getMasterCoprocessors() {
        try {
            return this.getClusterStatus().getMasterCoprocessors();
        }
        catch (IOException e) {
            LOG.error("Could not getClusterStatus()", e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tableName) throws IOException {
        AdminProtos.GetRegionInfoResponse.CompactionState state = AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
        try (ZooKeeperWatcher zookeeper = new ZooKeeperWatcher(this.conf, ZK_IDENTIFIER_PREFIX + this.connection.toString(), new ThrowableAbortable());){
            this.checkTableExists(tableName);
            List<Pair<HRegionInfo, ServerName>> pairs = MetaTableAccessor.getTableRegionsAndLocations(zookeeper, this.connection, tableName);
            Iterator<Pair<HRegionInfo, ServerName>> i$ = pairs.iterator();
            while (i$.hasNext()) {
                Pair<HRegionInfo, ServerName> pair = i$.next();
                if (pair.getFirst().isOffline() || pair.getSecond() == null) continue;
                try {
                    ServerName sn = pair.getSecond();
                    AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
                    AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(pair.getFirst().getRegionName(), true);
                    AdminProtos.GetRegionInfoResponse response = admin.getRegionInfo(null, request);
                    switch (response.getCompactionState()) {
                        case MAJOR_AND_MINOR: {
                            AdminProtos.GetRegionInfoResponse.CompactionState compactionState = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
                            return compactionState;
                        }
                        case MAJOR: {
                            if (state == AdminProtos.GetRegionInfoResponse.CompactionState.MINOR) {
                                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
                                return compactionState;
                            }
                            state = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR;
                            break;
                        }
                        case MINOR: {
                            if (state == AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR) {
                                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
                                return compactionState;
                            }
                            state = AdminProtos.GetRegionInfoResponse.CompactionState.MINOR;
                            break;
                        }
                    }
                }
                catch (NotServingRegionException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Trying to get compaction state of " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e));
                }
                catch (RemoteException e) {
                    if (e.getMessage().indexOf(NotServingRegionException.class.getName()) < 0) throw e;
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Trying to get compaction state of " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e));
                }
            }
            return state;
        }
    }

    @Override
    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] regionName) throws IOException {
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(regionName);
            if (regionServerPair == null) {
                throw new IllegalArgumentException("Invalid region: " + Bytes.toStringBinary(regionName));
            }
            if (regionServerPair.getSecond() == null) {
                throw new NoServerForRegionException(Bytes.toStringBinary(regionName));
            }
            ServerName sn = regionServerPair.getSecond();
            AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
            AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(regionServerPair.getFirst().getRegionName(), true);
            AdminProtos.GetRegionInfoResponse response = admin.getRegionInfo(null, request);
            return response.getCompactionState();
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Deprecated
    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(String tableNameOrRegionName) throws IOException, InterruptedException {
        return this.getCompactionState(Bytes.toBytes(tableNameOrRegionName));
    }

    @Deprecated
    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        try {
            return this.getCompactionStateForRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException e) {
            return this.getCompactionState(TableName.valueOf(tableNameOrRegionName));
        }
    }

    @Override
    public void snapshot(String snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, tableName, HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    public void snapshot(String snapshotName, String tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, TableName.valueOf(tableName), HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    public void snapshot(byte[] snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type flushType) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(Bytes.toString(snapshotName), Bytes.toString(tableName), flushType);
    }

    @Override
    public void snapshot(byte[] snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(Bytes.toString(snapshotName), tableName, HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    public void snapshot(byte[] snapshotName, byte[] tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(Bytes.toString(snapshotName), TableName.valueOf(tableName), HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    @Override
    public void snapshot(String snapshotName, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
        builder.setTable(tableName.getNameAsString());
        builder.setName(snapshotName);
        builder.setType(type);
        this.snapshot(builder.build());
    }

    public void snapshot(String snapshotName, String tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, TableName.valueOf(tableName), type);
    }

    public void snapshot(String snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, TableName.valueOf(tableName), type);
    }

    @Override
    public void snapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
        MasterProtos.SnapshotResponse response = this.takeSnapshotAsync(snapshot);
        final MasterProtos.IsSnapshotDoneRequest request = MasterProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build();
        MasterProtos.IsSnapshotDoneResponse done = null;
        long start = EnvironmentEdgeManager.currentTime();
        long max = response.getExpectedTimeout();
        long maxPauseTime = max / (long)this.numRetries;
        int tries = 0;
        LOG.debug("Waiting a max of " + max + " ms for snapshot '" + ClientSnapshotDescriptionUtils.toString(snapshot) + "'' to complete. (max " + maxPauseTime + " ms per retry)");
        while (tries == 0 || EnvironmentEdgeManager.currentTime() - start < max && !done.getDone()) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > maxPauseTime ? maxPauseTime : sleep;
                LOG.debug("(#" + tries + ") Sleeping: " + sleep + "ms while waiting for snapshot completion.");
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
            LOG.debug("Getting current status of snapshot from master...");
            done = this.executeCallable(new MasterCallable<MasterProtos.IsSnapshotDoneResponse>(this.getConnection()){

                @Override
                public MasterProtos.IsSnapshotDoneResponse call(int callTimeout) throws ServiceException {
                    return this.master.isSnapshotDone(null, request);
                }
            });
        }
        if (!done.getDone()) {
            throw new SnapshotCreationException("Snapshot '" + snapshot.getName() + "' wasn't completed in expectedTime:" + max + " ms", snapshot);
        }
    }

    @Override
    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        final MasterProtos.SnapshotRequest request = MasterProtos.SnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        return this.executeCallable(new MasterCallable<MasterProtos.SnapshotResponse>(this.getConnection()){

            @Override
            public MasterProtos.SnapshotResponse call(int callTimeout) throws ServiceException {
                return this.master.snapshot(null, request);
            }
        });
    }

    @Override
    public boolean isSnapshotFinished(final HBaseProtos.SnapshotDescription snapshot) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        return this.executeCallable(new MasterCallable<MasterProtos.IsSnapshotDoneResponse>(this.getConnection()){

            @Override
            public MasterProtos.IsSnapshotDoneResponse call(int callTimeout) throws ServiceException {
                return this.master.isSnapshotDone(null, MasterProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build());
            }
        }).getDone();
    }

    @Override
    public void restoreSnapshot(byte[] snapshotName) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(Bytes.toString(snapshotName));
    }

    @Override
    public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        boolean takeFailSafeSnapshot = this.conf.getBoolean("hbase.snapshot.restore.take.failsafe.snapshot", false);
        this.restoreSnapshot(snapshotName, takeFailSafeSnapshot);
    }

    @Override
    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(Bytes.toString(snapshotName), takeFailSafeSnapshot);
    }

    @Override
    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        TableName tableName = null;
        for (HBaseProtos.SnapshotDescription snapshotInfo : this.listSnapshots()) {
            if (!snapshotInfo.getName().equals(snapshotName)) continue;
            tableName = TableName.valueOf(snapshotInfo.getTable());
            break;
        }
        if (tableName == null) {
            throw new RestoreSnapshotException("Unable to find the table name for snapshot=" + snapshotName);
        }
        if (!this.tableExists(tableName)) {
            this.cloneSnapshot(snapshotName, tableName);
            return;
        }
        if (!this.isTableDisabled(tableName)) {
            throw new TableNotDisabledException(tableName);
        }
        String failSafeSnapshotSnapshotName = null;
        if (takeFailSafeSnapshot) {
            failSafeSnapshotSnapshotName = this.conf.get("hbase.snapshot.restore.failsafe.name", "hbase-failsafe-{snapshot.name}-{restore.timestamp}");
            failSafeSnapshotSnapshotName = failSafeSnapshotSnapshotName.replace("{snapshot.name}", snapshotName).replace("{table.name}", tableName.toString().replace(':', '.')).replace("{restore.timestamp}", String.valueOf(EnvironmentEdgeManager.currentTime()));
            LOG.info("Taking restore-failsafe snapshot: " + failSafeSnapshotSnapshotName);
            this.snapshot(failSafeSnapshotSnapshotName, tableName);
        }
        try {
            this.internalRestoreSnapshot(snapshotName, tableName);
        }
        catch (IOException e) {
            if (takeFailSafeSnapshot) {
                try {
                    this.internalRestoreSnapshot(failSafeSnapshotSnapshotName, tableName);
                    String msg = "Restore snapshot=" + snapshotName + " failed. Rollback to snapshot=" + failSafeSnapshotSnapshotName + " succeeded.";
                    LOG.error(msg, e);
                    throw new RestoreSnapshotException(msg, e);
                }
                catch (IOException ex) {
                    String msg = "Failed to restore and rollback to snapshot=" + failSafeSnapshotSnapshotName;
                    LOG.error(msg, ex);
                    throw new RestoreSnapshotException(msg, e);
                }
            }
            throw new RestoreSnapshotException("Failed to restore snapshot=" + snapshotName, e);
        }
        if (takeFailSafeSnapshot) {
            try {
                LOG.info("Deleting restore-failsafe snapshot: " + failSafeSnapshotSnapshotName);
                this.deleteSnapshot(failSafeSnapshotSnapshotName);
            }
            catch (IOException e) {
                LOG.error("Unable to remove the failsafe snapshot: " + failSafeSnapshotSnapshotName, e);
            }
        }
    }

    public void cloneSnapshot(byte[] snapshotName, byte[] tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        this.cloneSnapshot(Bytes.toString(snapshotName), TableName.valueOf(tableName));
    }

    @Override
    public void cloneSnapshot(byte[] snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        this.cloneSnapshot(Bytes.toString(snapshotName), tableName);
    }

    public void cloneSnapshot(String snapshotName, String tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        this.cloneSnapshot(snapshotName, TableName.valueOf(tableName));
    }

    @Override
    public void cloneSnapshot(String snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        if (this.tableExists(tableName)) {
            throw new TableExistsException(tableName);
        }
        this.internalRestoreSnapshot(snapshotName, tableName);
        this.waitUntilTableIsEnabled(tableName);
    }

    @Override
    public byte[] execProcedureWithRet(String signature, String instance, Map<String, String> props) throws IOException {
        HBaseProtos.ProcedureDescription.Builder builder = HBaseProtos.ProcedureDescription.newBuilder();
        builder.setSignature(signature).setInstance(instance);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            HBaseProtos.NameStringPair pair = HBaseProtos.NameStringPair.newBuilder().setName(entry.getKey()).setValue(entry.getValue()).build();
            builder.addConfiguration(pair);
        }
        final MasterProtos.ExecProcedureRequest request = MasterProtos.ExecProcedureRequest.newBuilder().setProcedure(builder.build()).build();
        MasterProtos.ExecProcedureResponse response = this.executeCallable(new MasterCallable<MasterProtos.ExecProcedureResponse>(this.getConnection()){

            @Override
            public MasterProtos.ExecProcedureResponse call(int callTimeout) throws ServiceException {
                return this.master.execProcedureWithRet(null, request);
            }
        });
        return response.hasReturnData() ? response.getReturnData().toByteArray() : null;
    }

    @Override
    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        HBaseProtos.ProcedureDescription.Builder builder = HBaseProtos.ProcedureDescription.newBuilder();
        builder.setSignature(signature).setInstance(instance);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            HBaseProtos.NameStringPair pair = HBaseProtos.NameStringPair.newBuilder().setName(entry.getKey()).setValue(entry.getValue()).build();
            builder.addConfiguration(pair);
        }
        final MasterProtos.ExecProcedureRequest request = MasterProtos.ExecProcedureRequest.newBuilder().setProcedure(builder.build()).build();
        MasterProtos.ExecProcedureResponse response = this.executeCallable(new MasterCallable<MasterProtos.ExecProcedureResponse>(this.getConnection()){

            @Override
            public MasterProtos.ExecProcedureResponse call(int callTimeout) throws ServiceException {
                return this.master.execProcedure(null, request);
            }
        });
        long start = EnvironmentEdgeManager.currentTime();
        long max = response.getExpectedTimeout();
        long maxPauseTime = max / (long)this.numRetries;
        int tries = 0;
        LOG.debug("Waiting a max of " + max + " ms for procedure '" + signature + " : " + instance + "'' to complete. (max " + maxPauseTime + " ms per retry)");
        boolean done = false;
        while (tries == 0 || EnvironmentEdgeManager.currentTime() - start < max && !done) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > maxPauseTime ? maxPauseTime : sleep;
                LOG.debug("(#" + tries + ") Sleeping: " + sleep + "ms while waiting for procedure completion.");
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
            LOG.debug("Getting current status of procedure from master...");
            done = this.isProcedureFinished(signature, instance, props);
        }
        if (!done) {
            throw new IOException("Procedure '" + signature + " : " + instance + "' wasn't completed in expectedTime:" + max + " ms");
        }
    }

    @Override
    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        HBaseProtos.ProcedureDescription.Builder builder = HBaseProtos.ProcedureDescription.newBuilder();
        builder.setSignature(signature).setInstance(instance);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            HBaseProtos.NameStringPair pair = HBaseProtos.NameStringPair.newBuilder().setName(entry.getKey()).setValue(entry.getValue()).build();
            builder.addConfiguration(pair);
        }
        final HBaseProtos.ProcedureDescription desc = builder.build();
        return this.executeCallable(new MasterCallable<MasterProtos.IsProcedureDoneResponse>(this.getConnection()){

            @Override
            public MasterProtos.IsProcedureDoneResponse call(int callTimeout) throws ServiceException {
                return this.master.isProcedureDone(null, MasterProtos.IsProcedureDoneRequest.newBuilder().setProcedure(desc).build());
            }
        }).getDone();
    }

    private void internalRestoreSnapshot(String snapshotName, TableName tableName) throws IOException, RestoreSnapshotException {
        HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).setTable(tableName.getNameAsString()).build();
        this.internalRestoreSnapshotAsync(snapshot);
        final MasterProtos.IsRestoreSnapshotDoneRequest request = MasterProtos.IsRestoreSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build();
        MasterProtos.IsRestoreSnapshotDoneResponse done = MasterProtos.IsRestoreSnapshotDoneResponse.newBuilder().setDone(false).buildPartial();
        long maxPauseTime = 5000L;
        int tries = 0;
        while (!done.getDone()) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > 5000L ? 5000L : sleep;
                LOG.debug(tries + ") Sleeping: " + sleep + " ms while we wait for snapshot restore to complete.");
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
            LOG.debug("Getting current status of snapshot restore from master...");
            done = this.executeCallable(new MasterCallable<MasterProtos.IsRestoreSnapshotDoneResponse>(this.getConnection()){

                @Override
                public MasterProtos.IsRestoreSnapshotDoneResponse call(int callTimeout) throws ServiceException {
                    return this.master.isRestoreSnapshotDone(null, request);
                }
            });
        }
        if (!done.getDone()) {
            throw new RestoreSnapshotException("Snapshot '" + snapshot.getName() + "' wasn't restored.");
        }
    }

    private MasterProtos.RestoreSnapshotResponse internalRestoreSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, RestoreSnapshotException {
        ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        final MasterProtos.RestoreSnapshotRequest request = MasterProtos.RestoreSnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        return this.executeCallable(new MasterCallable<MasterProtos.RestoreSnapshotResponse>(this.getConnection()){

            @Override
            public MasterProtos.RestoreSnapshotResponse call(int callTimeout) throws ServiceException {
                return this.master.restoreSnapshot(null, request);
            }
        });
    }

    @Override
    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        return this.executeCallable(new MasterCallable<List<HBaseProtos.SnapshotDescription>>(this.getConnection()){

            @Override
            public List<HBaseProtos.SnapshotDescription> call(int callTimeout) throws ServiceException {
                return this.master.getCompletedSnapshots(null, MasterProtos.GetCompletedSnapshotsRequest.newBuilder().build()).getSnapshotsList();
            }
        });
    }

    @Override
    public List<HBaseProtos.SnapshotDescription> listSnapshots(String regex) throws IOException {
        return this.listSnapshots(Pattern.compile(regex));
    }

    @Override
    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        LinkedList<HBaseProtos.SnapshotDescription> matched = new LinkedList<HBaseProtos.SnapshotDescription>();
        List<HBaseProtos.SnapshotDescription> snapshots = this.listSnapshots();
        for (HBaseProtos.SnapshotDescription snapshot : snapshots) {
            if (!pattern.matcher(snapshot.getName()).matches()) continue;
            matched.add(snapshot);
        }
        return matched;
    }

    @Override
    public void deleteSnapshot(byte[] snapshotName) throws IOException {
        this.deleteSnapshot(Bytes.toString(snapshotName));
    }

    @Override
    public void deleteSnapshot(final String snapshotName) throws IOException {
        TableName.isLegalFullyQualifiedTableName(Bytes.toBytes(snapshotName));
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                this.master.deleteSnapshot(null, MasterProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).build()).build());
                return null;
            }
        });
    }

    @Override
    public void deleteSnapshots(String regex) throws IOException {
        this.deleteSnapshots(Pattern.compile(regex));
    }

    @Override
    public void deleteSnapshots(Pattern pattern) throws IOException {
        List<HBaseProtos.SnapshotDescription> snapshots = this.listSnapshots(pattern);
        for (HBaseProtos.SnapshotDescription snapshot : snapshots) {
            try {
                this.internalDeleteSnapshot(snapshot);
            }
            catch (IOException ex) {
                LOG.info("Failed to delete snapshot " + snapshot.getName() + " for table " + snapshot.getTable(), ex);
            }
        }
    }

    private void internalDeleteSnapshot(final HBaseProtos.SnapshotDescription snapshot) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                this.master.deleteSnapshot(null, MasterProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(snapshot).build());
                return null;
            }
        });
    }

    @Override
    public void setQuota(final QuotaSettings quota) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call(int callTimeout) throws ServiceException {
                this.master.setQuota(null, QuotaSettings.buildSetQuotaRequestProto(quota));
                return null;
            }
        });
    }

    @Override
    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) throws IOException {
        return QuotaRetriever.open(this.conf, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V executeCallable(MasterCallable<V> callable) throws IOException {
        RpcRetryingCaller<V> caller = this.rpcCallerFactory.newCaller();
        try {
            Object t = caller.callWithRetries(callable, this.operationTimeout);
            return (V)t;
        }
        finally {
            callable.close();
        }
    }

    @Override
    public CoprocessorRpcChannel coprocessorService() {
        return new MasterCoprocessorRpcChannel(this.connection);
    }

    @Override
    public CoprocessorRpcChannel coprocessorService(ServerName sn) {
        return new RegionServerCoprocessorRpcChannel(this.connection, sn);
    }

    @Override
    public void updateConfiguration(ServerName server) throws IOException {
        try {
            this.connection.getAdmin(server).updateConfiguration(null, AdminProtos.UpdateConfigurationRequest.getDefaultInstance());
        }
        catch (ServiceException e) {
            throw ProtobufUtil.getRemoteException(e);
        }
    }

    @Override
    public void updateConfiguration() throws IOException {
        for (ServerName server : this.getClusterStatus().getServers()) {
            this.updateConfiguration(server);
        }
    }

    @Override
    public int getMasterInfoPort() throws IOException {
        ConnectionManager.HConnectionImplementation connection = (ConnectionManager.HConnectionImplementation)this.connection;
        ZooKeeperKeepAliveConnection zkw = connection.getKeepAliveZooKeeperWatcher();
        try {
            return MasterAddressTracker.getMasterInfoPort(zkw);
        }
        catch (KeeperException e) {
            throw new IOException("Failed to get master info port from MasterAddressTracker", e);
        }
    }

    @Override
    public long getLastMajorCompactionTimestamp(final TableName tableName) throws IOException {
        return this.executeCallable(new MasterCallable<Long>(this.getConnection()){

            @Override
            public Long call(int callTimeout) throws ServiceException {
                MasterProtos.MajorCompactionTimestampRequest req = MasterProtos.MajorCompactionTimestampRequest.newBuilder().setTableName(ProtobufUtil.toProtoTableName(tableName)).build();
                return this.master.getLastMajorCompactionTimestamp(null, req).getCompactionTimestamp();
            }
        });
    }

    @Override
    public long getLastMajorCompactionTimestampForRegion(final byte[] regionName) throws IOException {
        return this.executeCallable(new MasterCallable<Long>(this.getConnection()){

            @Override
            public Long call(int callTimeout) throws ServiceException {
                MasterProtos.MajorCompactionTimestampForRegionRequest req = MasterProtos.MajorCompactionTimestampForRegionRequest.newBuilder().setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName)).build();
                return this.master.getLastMajorCompactionTimestampForRegion(null, req).getCompactionTimestamp();
            }
        });
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    protected static class ProcedureFuture<V>
    implements Future<V> {
        private ExecutionException exception = null;
        private boolean procResultFound = false;
        private boolean done = false;
        private V result = null;
        private final HBaseAdmin admin;
        private final Long procId;

        public ProcedureFuture(HBaseAdmin admin, Long procId) {
            this.admin = admin;
            this.procId = procId;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.done) {
                long deadlineTs = EnvironmentEdgeManager.currentTime() + unit.toMillis(timeout);
                try {
                    try {
                        if (this.procId != null) {
                            this.result = this.waitProcedureResult(this.procId, deadlineTs);
                        }
                        if (!this.procResultFound) {
                            this.result = this.waitOperationResult(deadlineTs);
                        }
                        this.result = this.postOperationResult(this.result, deadlineTs);
                        this.done = true;
                    }
                    catch (IOException e) {
                        this.result = this.postOpeartionFailure(e, deadlineTs);
                        this.done = true;
                    }
                }
                catch (IOException e) {
                    this.exception = new ExecutionException(e);
                    this.done = true;
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        protected HBaseAdmin getAdmin() {
            return this.admin;
        }

        private V waitProcedureResult(long procId, long deadlineTs) throws IOException, TimeoutException, InterruptedException {
            MasterProtos.GetProcedureResultRequest request = MasterProtos.GetProcedureResultRequest.newBuilder().setProcId(procId).build();
            int tries = 0;
            IOException serviceEx = null;
            while (EnvironmentEdgeManager.currentTime() < deadlineTs) {
                MasterProtos.GetProcedureResultResponse response;
                block7: {
                    response = null;
                    try {
                        response = this.getProcedureResult(request);
                    }
                    catch (IOException e) {
                        serviceEx = ProcedureFuture.unwrapException(e);
                        LOG.warn("failed to get the procedure result procId=" + procId, serviceEx);
                        if (!(serviceEx instanceof DoNotRetryIOException)) break block7;
                        LOG.warn("Proc-v2 is unsupported on this master: " + serviceEx.getMessage(), serviceEx);
                        this.procResultFound = false;
                        return null;
                    }
                }
                if (response != null && response.getState() != MasterProtos.GetProcedureResultResponse.State.RUNNING) {
                    this.procResultFound = response.getState() != MasterProtos.GetProcedureResultResponse.State.NOT_FOUND;
                    return this.convertResult(response);
                }
                try {
                    Thread.sleep(this.getAdmin().getPauseTime(tries++));
                }
                catch (InterruptedException e) {
                    throw new InterruptedException("Interrupted while waiting for the result of proc " + procId);
                }
            }
            if (serviceEx != null) {
                throw serviceEx;
            }
            throw new TimeoutException("The procedure " + procId + " is still running");
        }

        private static IOException unwrapException(IOException e) {
            if (e instanceof RemoteException) {
                return ((RemoteException)((Object)e)).unwrapRemoteException();
            }
            return e;
        }

        protected MasterProtos.GetProcedureResultResponse getProcedureResult(final MasterProtos.GetProcedureResultRequest request) throws IOException {
            return (MasterProtos.GetProcedureResultResponse)this.admin.executeCallable(new MasterCallable<MasterProtos.GetProcedureResultResponse>(this.admin.getConnection()){

                @Override
                public MasterProtos.GetProcedureResultResponse call(int callTimeout) throws ServiceException {
                    return this.master.getProcedureResult(null, request);
                }
            });
        }

        protected V convertResult(MasterProtos.GetProcedureResultResponse response) throws IOException {
            if (response.hasException()) {
                throw ForeignExceptionUtil.toIOException(response.getException());
            }
            return null;
        }

        protected V waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            return null;
        }

        protected V postOperationResult(V result, long deadlineTs) throws IOException, TimeoutException {
            return result;
        }

        protected V postOpeartionFailure(IOException exception, long deadlineTs) throws IOException, TimeoutException {
            throw exception;
        }

        protected void waitForState(long deadlineTs, WaitForStateCallable callable) throws IOException, TimeoutException {
            int tries = 0;
            IOException serverEx = null;
            long startTime = EnvironmentEdgeManager.currentTime();
            while (EnvironmentEdgeManager.currentTime() < deadlineTs) {
                serverEx = null;
                try {
                    if (callable.checkState(tries)) {
                        return;
                    }
                }
                catch (IOException e) {
                    serverEx = e;
                }
                try {
                    Thread.sleep(this.getAdmin().getPauseTime(tries++));
                }
                catch (InterruptedException e) {
                    callable.throwInterruptedException();
                }
            }
            if (serverEx != null) {
                throw ProcedureFuture.unwrapException(serverEx);
            }
            callable.throwTimeoutException(EnvironmentEdgeManager.currentTime() - startTime);
        }

        protected static interface WaitForStateCallable {
            public boolean checkState(int var1) throws IOException;

            public void throwInterruptedException() throws InterruptedIOException;

            public void throwTimeoutException(long var1) throws TimeoutException;
        }
    }

    private static class ThrowableAbortable
    implements Abortable {
        private ThrowableAbortable() {
        }

        @Override
        public void abort(String why, Throwable e) {
            throw new RuntimeException(why, e);
        }

        @Override
        public boolean isAborted() {
            return true;
        }
    }

    private static class DisableTableFuture
    extends ProcedureFuture<Void> {
        private final TableName tableName;

        public DisableTableFuture(HBaseAdmin admin, TableName tableName, MasterProtos.DisableTableResponse response) {
            super(admin, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
            this.tableName = tableName;
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitTableDisabled(deadlineTs);
            return null;
        }

        @Override
        protected Void postOperationResult(Void result, long deadlineTs) throws IOException, TimeoutException {
            LOG.info("Disabled " + this.tableName);
            return result;
        }

        private void waitTableDisabled(long deadlineTs) throws IOException, TimeoutException {
            this.waitForState(deadlineTs, new ProcedureFuture.WaitForStateCallable(){

                @Override
                public boolean checkState(int tries) throws IOException {
                    return DisableTableFuture.this.getAdmin().isTableDisabled(DisableTableFuture.this.tableName);
                }

                @Override
                public void throwInterruptedException() throws InterruptedIOException {
                    throw new InterruptedIOException("Interrupted when waiting for table to be disabled");
                }

                @Override
                public void throwTimeoutException(long elapsedTime) throws TimeoutException {
                    throw new TimeoutException("Table " + DisableTableFuture.this.tableName + " not yet disabled after " + elapsedTime + "msec");
                }
            });
        }
    }

    private static class EnableTableFuture
    extends ProcedureFuture<Void> {
        private final TableName tableName;

        public EnableTableFuture(HBaseAdmin admin, TableName tableName, MasterProtos.EnableTableResponse response) {
            super(admin, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
            this.tableName = tableName;
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitTableEnabled(deadlineTs);
            return null;
        }

        @Override
        protected Void postOperationResult(Void result, long deadlineTs) throws IOException, TimeoutException {
            LOG.info("Enabled " + this.tableName);
            return result;
        }

        private void waitTableEnabled(long deadlineTs) throws IOException, TimeoutException {
            this.waitForState(deadlineTs, new ProcedureFuture.WaitForStateCallable(){

                @Override
                public boolean checkState(int tries) throws IOException {
                    boolean enabled;
                    try {
                        enabled = EnableTableFuture.this.getAdmin().isTableEnabled(EnableTableFuture.this.tableName);
                    }
                    catch (TableNotFoundException tnfe) {
                        return false;
                    }
                    return enabled && EnableTableFuture.this.getAdmin().isTableAvailable(EnableTableFuture.this.tableName);
                }

                @Override
                public void throwInterruptedException() throws InterruptedIOException {
                    throw new InterruptedIOException("Interrupted when waiting for table to be enabled");
                }

                @Override
                public void throwTimeoutException(long elapsedTime) throws TimeoutException {
                    throw new TimeoutException("Table " + EnableTableFuture.this.tableName + " not yet enabled after " + elapsedTime + "msec");
                }
            });
        }
    }

    private static class DeleteTableFuture
    extends ProcedureFuture<Void> {
        private final TableName tableName;

        public DeleteTableFuture(HBaseAdmin admin, TableName tableName, MasterProtos.DeleteTableResponse response) {
            super(admin, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
            this.tableName = tableName;
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitTableNotFound(deadlineTs);
            return null;
        }

        @Override
        protected Void postOperationResult(Void result, long deadlineTs) throws IOException, TimeoutException {
            this.getAdmin().getConnection().clearRegionCache(this.tableName);
            LOG.info("Deleted " + this.tableName);
            return result;
        }

        private void waitTableNotFound(long deadlineTs) throws IOException, TimeoutException {
            this.waitForState(deadlineTs, new ProcedureFuture.WaitForStateCallable(){

                @Override
                public boolean checkState(int tries) throws IOException {
                    return !DeleteTableFuture.this.getAdmin().tableExists(DeleteTableFuture.this.tableName);
                }

                @Override
                public void throwInterruptedException() throws InterruptedIOException {
                    throw new InterruptedIOException("Interrupted when waiting for table to be deleted");
                }

                @Override
                public void throwTimeoutException(long elapsedTime) throws TimeoutException {
                    throw new TimeoutException("Table " + DeleteTableFuture.this.tableName + " not yet deleted after " + elapsedTime + "msec");
                }
            });
        }
    }

    private static class CreateTableFuture
    extends ProcedureFuture<Void> {
        private final HTableDescriptor desc;
        private final byte[][] splitKeys;

        public CreateTableFuture(HBaseAdmin admin, HTableDescriptor desc, byte[][] splitKeys, MasterProtos.CreateTableResponse response) {
            super(admin, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
            this.splitKeys = splitKeys;
            this.desc = desc;
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitForTableEnabled(deadlineTs);
            this.waitForAllRegionsOnline(deadlineTs);
            return null;
        }

        @Override
        protected Void postOperationResult(Void result, long deadlineTs) throws IOException, TimeoutException {
            LOG.info("Created " + this.desc.getTableName());
            return result;
        }

        private void waitForTableEnabled(long deadlineTs) throws IOException, TimeoutException {
            this.waitForState(deadlineTs, new ProcedureFuture.WaitForStateCallable(){

                @Override
                public boolean checkState(int tries) throws IOException {
                    try {
                        if (CreateTableFuture.this.getAdmin().isTableAvailable(CreateTableFuture.this.desc.getTableName())) {
                            return true;
                        }
                    }
                    catch (TableNotFoundException tnfe) {
                        LOG.debug("Table " + CreateTableFuture.this.desc.getTableName() + " was not enabled, sleeping. tries=" + tries);
                    }
                    return false;
                }

                @Override
                public void throwInterruptedException() throws InterruptedIOException {
                    throw new InterruptedIOException("Interrupted when waiting for table " + CreateTableFuture.this.desc.getTableName() + " to be enabled");
                }

                @Override
                public void throwTimeoutException(long elapsedTime) throws TimeoutException {
                    throw new TimeoutException("Table " + CreateTableFuture.this.desc.getTableName() + " not enabled after " + elapsedTime + "msec");
                }
            });
        }

        private void waitForAllRegionsOnline(long deadlineTs) throws IOException, TimeoutException {
            final AtomicInteger actualRegCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result rowResult) throws IOException {
                    HRegionLocation[] locations;
                    RegionLocations list = MetaTableAccessor.getRegionLocations(rowResult);
                    if (list == null) {
                        LOG.warn("No serialized HRegionInfo in " + rowResult);
                        return true;
                    }
                    HRegionLocation l = list.getRegionLocation();
                    if (l == null) {
                        return true;
                    }
                    if (!l.getRegionInfo().getTable().equals(CreateTableFuture.this.desc.getTableName())) {
                        return false;
                    }
                    if (l.getRegionInfo().isOffline() || l.getRegionInfo().isSplit()) {
                        return true;
                    }
                    for (HRegionLocation location : locations = list.getRegionLocations()) {
                        ServerName serverName;
                        if (location == null || (serverName = location.getServerName()) == null || serverName.getHostAndPort() == null) continue;
                        actualRegCount.incrementAndGet();
                    }
                    return true;
                }
            };
            int tries = 0;
            Object serverEx = null;
            int numRegs = (this.splitKeys == null ? 1 : this.splitKeys.length + 1) * this.desc.getRegionReplication();
            while (EnvironmentEdgeManager.currentTime() < deadlineTs) {
                actualRegCount.set(0);
                MetaScanner.metaScan(this.getAdmin().getConnection(), visitor, this.desc.getTableName());
                if (actualRegCount.get() == numRegs) {
                    return;
                }
                try {
                    Thread.sleep(this.getAdmin().getPauseTime(tries++));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("Interrupted when opening regions; " + actualRegCount.get() + " of " + numRegs + " regions processed so far");
                }
            }
            throw new TimeoutException("Only " + actualRegCount.get() + " of " + numRegs + " regions are online; retries exhausted.");
        }
    }
}

