/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.util;

import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;

public class HBaseVersion {
    private static final String HBASE_94_VERSION = "0.94";
    private static final String HBASE_96_VERSION = "0.96";
    private static final String HBASE_98_VERSION = "0.98";
    private static final String HBASE_10_VERSION = "1.0";
    private static final String CDH_CLASSIFIER = "cdh";
    private static final Logger LOG = LoggerFactory.getLogger(HBaseVersion.class);
    private static Version currentVersion;
    private static String versionString;

    public static Version get() {
        return currentVersion;
    }

    public static String getVersionString() {
        return versionString;
    }

    public static void main(String[] args) {
        boolean verbose = args.length == 1 && "-v".equals(args[0]);
        Version version = HBaseVersion.get();
        System.out.println(version.getMajorVersion());
        if (verbose) {
            System.out.println("versionString=" + HBaseVersion.getVersionString());
        }
    }

    static {
        try {
            VersionNumber ver;
            Class<?> versionInfoClass = Class.forName("org.apache.hadoop.hbase.util.VersionInfo");
            Method versionMethod = versionInfoClass.getMethod("getVersion", new Class[0]);
            versionString = (String)versionMethod.invoke(null, new Object[0]);
            currentVersion = versionString.startsWith(HBASE_94_VERSION) ? Version.HBASE_94 : (versionString.startsWith(HBASE_96_VERSION) ? Version.HBASE_96 : (versionString.startsWith(HBASE_98_VERSION) ? Version.HBASE_98 : (versionString.startsWith(HBASE_10_VERSION) ? ((ver = VersionNumber.create(versionString)).getClassifier() != null && ver.getClassifier().startsWith(CDH_CLASSIFIER) ? Version.HBASE_10_CDH : Version.HBASE_10) : Version.UNKNOWN)));
        }
        catch (Throwable e) {
            LOG.error("Unable to determine HBase version from string '{}', are HBase classes available?", (Object)versionString);
            LOG.error("Exception was: ", e);
            currentVersion = Version.UNKNOWN;
        }
    }

    public static class VersionNumber {
        private static final Pattern PATTERN = Pattern.compile("(\\d+)(\\.(\\d+))?(\\.(\\d+))?(\\.(\\d+))?(\\-(?!SNAPSHOT)([^\\-]+))?(\\-SNAPSHOT)?");
        private Integer major;
        private Integer minor;
        private Integer patch;
        private Integer last;
        private String classifier;
        private boolean snapshot;

        private VersionNumber(Integer major, Integer minor, Integer patch, Integer last, String classifier, boolean snapshot) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.last = last;
            this.classifier = classifier;
            this.snapshot = snapshot;
        }

        public Integer getMajor() {
            return this.major;
        }

        public Integer getMinor() {
            return this.minor;
        }

        public Integer getPatch() {
            return this.patch;
        }

        public Integer getLast() {
            return this.last;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public boolean isSnapshot() {
            return this.snapshot;
        }

        public static VersionNumber create(String versionString) throws ParseException {
            Matcher matcher = PATTERN.matcher(versionString);
            if (matcher.matches()) {
                String majorString = matcher.group(1);
                String minorString = matcher.group(3);
                String patchString = matcher.group(5);
                String last = matcher.group(7);
                String classifier = matcher.group(9);
                String snapshotString = matcher.group(10);
                return new VersionNumber(new Integer(majorString), minorString != null ? new Integer(minorString) : null, patchString != null ? new Integer(patchString) : null, last != null ? new Integer(last) : null, classifier, "-SNAPSHOT".equals(snapshotString));
            }
            throw new ParseException("Input string did not match expected pattern: major[.minor[.patch]][-classifier][-SNAPSHOT]", 0);
        }
    }

    public static enum Version {
        HBASE_94("0.94"),
        HBASE_96("0.96"),
        HBASE_98("0.98"),
        HBASE_10("1.0"),
        HBASE_10_CDH("1.0-cdh"),
        UNKNOWN("unknown");

        final String majorVersion;

        private Version(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        public String getMajorVersion() {
            return this.majorVersion;
        }
    }
}

