/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.hbase10.coprocessor;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionCodec;
import co.cask.tephra.TxConstants;
import co.cask.tephra.coprocessor.TransactionStateCache;
import co.cask.tephra.coprocessor.TransactionStateCacheSupplier;
import co.cask.tephra.hbase10.Filters;
import co.cask.tephra.hbase10.coprocessor.TransactionVisibilityFilter;
import co.cask.tephra.persist.TransactionSnapshot;
import co.cask.tephra.util.TxUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.com.google.common.base.Supplier;
import org.apache.hive.com.google.common.collect.Maps;
import org.apache.hive.com.google.common.collect.Sets;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

public class TransactionProcessor
extends BaseRegionObserver {
    private static final Log LOG = LogFactory.getLog(TransactionProcessor.class);
    private TransactionStateCache cache;
    private final TransactionCodec txCodec;
    protected Map<byte[], Long> ttlByFamily = Maps.newTreeMap(Bytes.BYTES_COMPARATOR);
    protected boolean allowEmptyValues = false;

    public TransactionProcessor() {
        this.txCodec = new TransactionCodec();
    }

    @Override
    public void start(CoprocessorEnvironment e) throws IOException {
        if (e instanceof RegionCoprocessorEnvironment) {
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e;
            Supplier<TransactionStateCache> cacheSupplier = this.getTransactionStateCacheSupplier(env);
            this.cache = cacheSupplier.get();
            HTableDescriptor tableDesc = ((HRegion)env.getRegion()).getTableDesc();
            for (HColumnDescriptor columnDesc : tableDesc.getFamilies()) {
                String columnTTL = columnDesc.getValue("dataset.table.ttl");
                long ttl = 0L;
                if (columnTTL != null) {
                    try {
                        ttl = Long.parseLong(columnTTL);
                        LOG.info("Family " + columnDesc.getNameAsString() + " has TTL of " + columnTTL);
                    }
                    catch (NumberFormatException nfe) {
                        LOG.warn("Invalid TTL value configured for column family " + columnDesc.getNameAsString() + ", value = " + columnTTL);
                    }
                }
                this.ttlByFamily.put(columnDesc.getName(), ttl);
            }
            this.allowEmptyValues = env.getConfiguration().getBoolean("data.tx.allow.empty.values", false);
        }
    }

    protected Supplier<TransactionStateCache> getTransactionStateCacheSupplier(RegionCoprocessorEnvironment env) {
        return new TransactionStateCacheSupplier(env.getConfiguration());
    }

    @Override
    public void stop(CoprocessorEnvironment e) throws IOException {
    }

    @Override
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        Transaction tx = this.getFromOperation(get);
        if (tx != null) {
            this.projectFamilyDeletes(get);
            get.setMaxVersions();
            get.setTimeRange(TxUtils.getOldestVisibleTimestamp(this.ttlByFamily, tx), TxUtils.getMaxVisibleTimestamp(tx));
            Filter newFilter = Filters.combine(this.getTransactionFilter(tx, ScanType.USER_SCAN), get.getFilter());
            get.setFilter(newFilter);
        }
    }

    @Override
    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> e, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (delete.getAttribute("cask.tx.rollback") != null) {
            return;
        }
        Put deleteMarkers = new Put(delete.getRow(), delete.getTimeStamp());
        for (byte[] family : delete.getFamilyCellMap().keySet()) {
            List familyCells = (List)delete.getFamilyCellMap().get(family);
            if (this.isFamilyDelete(familyCells)) {
                deleteMarkers.add(family, TxConstants.FAMILY_DELETE_QUALIFIER, ((Cell)familyCells.get(0)).getTimestamp(), HConstants.EMPTY_BYTE_ARRAY);
                continue;
            }
            int cellSize = familyCells.size();
            for (int i = 0; i < cellSize; ++i) {
                Cell cell = (Cell)familyCells.get(i);
                deleteMarkers.add(family, CellUtil.cloneQualifier(cell), cell.getTimestamp(), HConstants.EMPTY_BYTE_ARRAY);
            }
        }
        ((HRegion)e.getEnvironment().getRegion()).put(deleteMarkers);
        e.bypass();
    }

    private boolean isFamilyDelete(List<Cell> familyCells) {
        return familyCells.size() == 1 && CellUtil.isDeleteFamily(familyCells.get(0));
    }

    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
        Transaction tx = this.getFromOperation(scan);
        if (tx != null) {
            this.projectFamilyDeletes(scan);
            scan.setMaxVersions();
            scan.setTimeRange(TxUtils.getOldestVisibleTimestamp(this.ttlByFamily, tx), TxUtils.getMaxVisibleTimestamp(tx));
            Filter newFilter = Filters.combine(this.getTransactionFilter(tx, ScanType.USER_SCAN), scan.getFilter());
            scan.setFilter(newFilter);
        }
        return s;
    }

    private Scan projectFamilyDeletes(Scan scan) {
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : scan.getFamilyMap().entrySet()) {
            NavigableSet<byte[]> columns = entry.getValue();
            if (columns == null || columns.isEmpty()) continue;
            scan.addColumn(entry.getKey(), TxConstants.FAMILY_DELETE_QUALIFIER);
        }
        return scan;
    }

    private Get projectFamilyDeletes(Get get) {
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : get.getFamilyMap().entrySet()) {
            NavigableSet<byte[]> columns = entry.getValue();
            if (columns == null || columns.isEmpty()) continue;
            get.addColumn(entry.getKey(), TxConstants.FAMILY_DELETE_QUALIFIER);
        }
        return get;
    }

    @Override
    public InternalScanner preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, KeyValueScanner memstoreScanner, InternalScanner scanner) throws IOException {
        return this.createStoreScanner(c.getEnvironment(), "flush", this.cache.getLatestState(), store, Collections.singletonList(memstoreScanner), ScanType.COMPACT_RETAIN_DELETES, Long.MIN_VALUE);
    }

    @Override
    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s, CompactionRequest request) throws IOException {
        return this.createStoreScanner(c.getEnvironment(), "compaction", this.cache.getLatestState(), store, scanners, scanType, earliestPutTs);
    }

    protected InternalScanner createStoreScanner(RegionCoprocessorEnvironment env, String action, TransactionSnapshot snapshot, Store store, List<? extends KeyValueScanner> scanners, ScanType type, long earliestPutTs) throws IOException {
        if (snapshot == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Region " + env.getRegion().getRegionNameAsString() + ", no current transaction state found, defaulting to normal " + action + " scanner");
            }
            return null;
        }
        Transaction dummyTx = TxUtils.createDummyTransaction(snapshot);
        Scan scan = new Scan();
        scan.setMaxVersions();
        scan.setFilter(new IncludeInProgressFilter(dummyTx.getVisibilityUpperBound(), snapshot.getInvalid(), this.getTransactionFilter(dummyTx, type)));
        return new StoreScanner(store, store.getScanInfo(), scan, scanners, type, store.getSmallestReadPoint(), earliestPutTs);
    }

    private Transaction getFromOperation(OperationWithAttributes op) throws IOException {
        byte[] encoded = op.getAttribute("cask.tx");
        if (encoded != null) {
            return this.txCodec.decode(encoded);
        }
        return null;
    }

    protected Filter getTransactionFilter(Transaction tx, ScanType type) {
        return new TransactionVisibilityFilter(tx, this.ttlByFamily, this.allowEmptyValues, type);
    }

    static class IncludeInProgressFilter
    extends FilterBase {
        private final long visibilityUpperBound;
        private final Set<Long> invalidIds;
        private final Filter txFilter;

        public IncludeInProgressFilter(long upperBound, Collection<Long> invalids, Filter transactionFilter) {
            this.visibilityUpperBound = upperBound;
            this.invalidIds = Sets.newHashSet(invalids);
            this.txFilter = transactionFilter;
        }

        @Override
        public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
            long ts = cell.getTimestamp();
            if (ts > this.visibilityUpperBound) {
                if (this.invalidIds.contains(ts)) {
                    return Filter.ReturnCode.SKIP;
                }
                return Filter.ReturnCode.INCLUDE;
            }
            return this.txFilter.filterKeyValue(cell);
        }
    }
}

