/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import co.cask.tephra.Transaction;
import co.cask.tephra.distributed.TransactionConverterUtils;
import co.cask.tephra.distributed.thrift.TTransactionServer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Set;
import org.apache.hive.com.google.common.base.Function;
import org.apache.hive.com.google.common.collect.ImmutableSet;
import org.apache.hive.com.google.common.collect.Iterables;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.hive.org.apache.thrift.transport.TTransport;

public class TransactionServiceThriftClient {
    private static final Function<byte[], ByteBuffer> BYTES_WRAPPER = new Function<byte[], ByteBuffer>(){

        @Override
        public ByteBuffer apply(byte[] input) {
            return ByteBuffer.wrap(input);
        }
    };
    TTransport transport;
    TTransactionServer.Client client;

    public TransactionServiceThriftClient(TTransport transport) {
        this.transport = transport;
        TBinaryProtocol protocol = new TBinaryProtocol(transport);
        this.client = new TTransactionServer.Client(protocol);
    }

    public void close() {
        if (this.transport.isOpen()) {
            this.transport.close();
        }
    }

    public Transaction startLong() throws TException {
        return TransactionConverterUtils.unwrap(this.client.startLong());
    }

    public Transaction startShort() throws TException {
        return TransactionConverterUtils.unwrap(this.client.startShort());
    }

    public Transaction startShort(int timeout) throws TException {
        return TransactionConverterUtils.unwrap(this.client.startShortTimeout(timeout));
    }

    public boolean canCommit(Transaction tx, Collection<byte[]> changeIds) throws TException {
        return this.client.canCommitTx(TransactionConverterUtils.wrap(tx), ImmutableSet.copyOf(Iterables.transform(changeIds, BYTES_WRAPPER))).isValue();
    }

    public boolean commit(Transaction tx) throws TException {
        return this.client.commitTx(TransactionConverterUtils.wrap(tx)).isValue();
    }

    public void abort(Transaction tx) throws TException {
        this.client.abortTx(TransactionConverterUtils.wrap(tx));
    }

    public boolean invalidate(long tx) throws TException {
        return this.client.invalidateTx(tx);
    }

    public Transaction checkpoint(Transaction tx) throws TException {
        return TransactionConverterUtils.unwrap(this.client.checkpoint(TransactionConverterUtils.wrap(tx)));
    }

    public InputStream getSnapshotStream() throws TException {
        ByteBuffer buffer = this.client.getSnapshot();
        if (buffer.hasArray()) {
            return new ByteArrayInputStream(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }
        byte[] snapshot = new byte[buffer.remaining()];
        buffer.get(snapshot);
        return new ByteArrayInputStream(snapshot);
    }

    public String status() throws TException {
        return this.client.status();
    }

    public void resetState() throws TException {
        this.client.resetState();
    }

    public boolean truncateInvalidTx(Set<Long> invalidTxIds) throws TException {
        return this.client.truncateInvalidTx(invalidTxIds).isValue();
    }

    public boolean truncateInvalidTxBefore(long time) throws TException {
        return this.client.truncateInvalidTxBefore(time).isValue();
    }

    public int getInvalidSize() throws TException {
        return this.client.invalidTxSize();
    }
}

