/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import co.cask.tephra.distributed.AbstractClientProvider;
import co.cask.tephra.distributed.TransactionServiceThriftClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.twill.discovery.DiscoveryServiceClient;

public class SingleUseClientProvider
extends AbstractClientProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SingleUseClientProvider.class);
    final int timeout;

    public SingleUseClientProvider(Configuration conf, DiscoveryServiceClient discoveryServiceClient, int timeout) {
        super(conf, discoveryServiceClient);
        this.timeout = timeout;
    }

    @Override
    public TransactionServiceThriftClient getClient() throws TException {
        try {
            return this.newClient(this.timeout);
        }
        catch (TException e) {
            LOG.error("Unable to create new tx client: " + e.getMessage());
            throw e;
        }
    }

    @Override
    public void returnClient(TransactionServiceThriftClient client) {
        this.discardClient(client);
    }

    @Override
    public void discardClient(TransactionServiceThriftClient client) {
        client.close();
    }

    public String toString() {
        return "Single-use(timeout = " + this.timeout + ")";
    }
}

