/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.util.Preconditions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamGraphTest {
    StreamGraphTest() {
    }

    @Test
    void testTopologicalSort() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SingleOutputStreamOperator source1 = env.fromSequence(0L, 3L).name("source");
        SingleOutputStreamOperator map1 = source1.map((MapFunction & Serializable)value -> value).name("map1");
        source1.union(new DataStream[]{map1}).map((MapFunction & Serializable)value -> value).name("map2").sinkTo((Sink)new DiscardingSink()).name("sink");
        StreamGraph streamGraph = env.getStreamGraph();
        List sortedStreamNodes = streamGraph.getStreamNodesSortedTopologicallyFromSources();
        StreamGraphTest.assertBefore("source", "map1", sortedStreamNodes);
        StreamGraphTest.assertBefore("source", "map2", sortedStreamNodes);
        StreamGraphTest.assertBefore("map1", "map2", sortedStreamNodes);
        StreamGraphTest.assertBefore("map2", "sink", sortedStreamNodes);
    }

    private static void assertBefore(String node1, String node2, List<StreamNode> streamNodes) {
        StreamNode n1 = (StreamNode)Preconditions.checkNotNull((Object)StreamGraphTest.getStreamNodeByName(node1, streamNodes));
        StreamNode n2 = (StreamNode)Preconditions.checkNotNull((Object)StreamGraphTest.getStreamNodeByName(node2, streamNodes));
        boolean seenFirst = false;
        for (StreamNode n : streamNodes) {
            if (n == n1) {
                seenFirst = true;
                continue;
            }
            if (n != n2) continue;
            if (seenFirst) break;
            Assertions.fail((String)("The first vertex (" + String.valueOf(n1) + ") is not before the second vertex (" + String.valueOf(n2) + ")"));
            break;
        }
    }

    private static StreamNode getStreamNodeByName(String nodeName, List<StreamNode> streamNodes) {
        for (StreamNode streamNode : streamNodes) {
            if (!streamNode.getOperatorName().contains(nodeName)) continue;
            return streamNode;
        }
        return null;
    }
}

