/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV3Serializer;
import org.apache.flink.runtime.state.InputStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OutputStateHandle;

public class OperatorSnapshotUtil {
    public static String getResourceFilename(String filename) {
        ClassLoader cl = OperatorSnapshotUtil.class.getClassLoader();
        URL resource = cl.getResource(filename);
        return resource.getFile();
    }

    public static void writeStateHandle(OperatorSubtaskState state, String path) throws IOException {
        FileOutputStream out = new FileOutputStream(path);
        try (DataOutputStream dos = new DataOutputStream(out);){
            dos.writeInt(3);
            MetadataV3Serializer.serializeStreamStateHandle(null, (DataOutputStream)dos);
            StateObjectCollection rawOperatorState = state.getRawOperatorState();
            if (rawOperatorState != null) {
                dos.writeInt(rawOperatorState.size());
                for (Object operatorStateHandle : rawOperatorState) {
                    MetadataV3Serializer.INSTANCE.serializeOperatorStateHandleUtil((OperatorStateHandle)operatorStateHandle, dos);
                }
            } else {
                dos.writeInt(-1);
            }
            StateObjectCollection managedOperatorState = state.getManagedOperatorState();
            if (managedOperatorState != null) {
                dos.writeInt(managedOperatorState.size());
                for (Object operatorStateHandle : managedOperatorState) {
                    MetadataV3Serializer.INSTANCE.serializeOperatorStateHandleUtil((OperatorStateHandle)operatorStateHandle, dos);
                }
            } else {
                dos.writeInt(-1);
            }
            StateObjectCollection rawKeyedState = state.getRawKeyedState();
            if (rawKeyedState != null) {
                dos.writeInt(rawKeyedState.size());
                for (Object keyedStateHandle : rawKeyedState) {
                    MetadataV3Serializer.INSTANCE.serializeKeyedStateHandleUtil((KeyedStateHandle)keyedStateHandle, dos);
                }
            } else {
                dos.writeInt(-1);
            }
            StateObjectCollection managedKeyedState = state.getManagedKeyedState();
            if (managedKeyedState != null) {
                dos.writeInt(managedKeyedState.size());
                for (KeyedStateHandle keyedStateHandle : managedKeyedState) {
                    MetadataV3Serializer.INSTANCE.serializeKeyedStateHandleUtil(keyedStateHandle, dos);
                }
            } else {
                dos.writeInt(-1);
            }
            StateObjectCollection inputChannelStateHandles = state.getInputChannelState();
            dos.writeInt(inputChannelStateHandles.size());
            for (InputStateHandle inputChannelStateHandle : inputChannelStateHandles) {
                MetadataV3Serializer.INSTANCE.serializeInputStateHandle(inputChannelStateHandle, dos);
            }
            StateObjectCollection resultSubpartitionStateHandles = state.getResultSubpartitionState();
            dos.writeInt(inputChannelStateHandles.size());
            for (OutputStateHandle resultSubpartitionStateHandle : resultSubpartitionStateHandles) {
                MetadataV3Serializer.INSTANCE.serializeOutputStateHandle(resultSubpartitionStateHandle, dos);
            }
            dos.flush();
        }
    }

    public static OperatorSubtaskState readStateHandle(String path) throws IOException, ClassNotFoundException {
        FileInputStream in = new FileInputStream(path);
        try (DataInputStream dis = new DataInputStream(in);){
            int v = dis.readInt();
            MetadataV3Serializer.deserializeStreamStateHandle((DataInputStream)dis);
            ArrayList<OperatorStateHandle> rawOperatorState = null;
            int numRawOperatorStates = dis.readInt();
            if (numRawOperatorStates >= 0) {
                rawOperatorState = new ArrayList<OperatorStateHandle>();
                for (int i = 0; i < numRawOperatorStates; ++i) {
                    OperatorStateHandle operatorState = MetadataV3Serializer.INSTANCE.deserializeOperatorStateHandleUtil(dis);
                    rawOperatorState.add(operatorState);
                }
            }
            ArrayList<OperatorStateHandle> managedOperatorState = null;
            int numManagedOperatorStates = dis.readInt();
            if (numManagedOperatorStates >= 0) {
                managedOperatorState = new ArrayList<OperatorStateHandle>();
                for (int i = 0; i < numManagedOperatorStates; ++i) {
                    OperatorStateHandle operatorState = MetadataV3Serializer.INSTANCE.deserializeOperatorStateHandleUtil(dis);
                    managedOperatorState.add(operatorState);
                }
            }
            ArrayList<KeyedStateHandle> rawKeyedState = null;
            int numRawKeyedStates = dis.readInt();
            if (numRawKeyedStates >= 0) {
                rawKeyedState = new ArrayList<KeyedStateHandle>();
                for (int i = 0; i < numRawKeyedStates; ++i) {
                    KeyedStateHandle keyedState = MetadataV3Serializer.INSTANCE.deserializeKeyedStateHandleUtil(dis);
                    rawKeyedState.add(keyedState);
                }
            }
            ArrayList<KeyedStateHandle> managedKeyedState = null;
            int numManagedKeyedStates = dis.readInt();
            if (numManagedKeyedStates >= 0) {
                managedKeyedState = new ArrayList<KeyedStateHandle>();
                for (int i = 0; i < numManagedKeyedStates; ++i) {
                    KeyedStateHandle keyedState = MetadataV3Serializer.INSTANCE.deserializeKeyedStateHandleUtil(dis);
                    managedKeyedState.add(keyedState);
                }
            }
            StateObjectCollection inputChannelStateHandles = v == 3 ? MetadataV3Serializer.INSTANCE.deserializeInputStateHandle(dis) : StateObjectCollection.empty();
            StateObjectCollection resultSubpartitionStateHandles = v == 3 ? MetadataV3Serializer.INSTANCE.deserializeOutputStateHandle(dis) : StateObjectCollection.empty();
            OperatorSubtaskState operatorSubtaskState = OperatorSubtaskState.builder().setManagedOperatorState(new StateObjectCollection(managedOperatorState)).setRawOperatorState(new StateObjectCollection(rawOperatorState)).setManagedKeyedState(new StateObjectCollection(managedKeyedState)).setRawKeyedState(new StateObjectCollection(rawKeyedState)).setInputChannelState(inputChannelStateHandles).setResultSubpartitionState(resultSubpartitionStateHandles).build();
            return operatorSubtaskState;
        }
    }
}

