/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.BroadcastState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.co.CoBroadcastWithKeyedOperator;
import org.apache.flink.streaming.util.AbstractBroadcastStreamOperatorTestHarness;

public class KeyedBroadcastOperatorTestHarness<K, IN1, IN2, OUT>
extends AbstractBroadcastStreamOperatorTestHarness<IN1, IN2, OUT> {
    public KeyedBroadcastOperatorTestHarness(CoBroadcastWithKeyedOperator<K, IN1, IN2, OUT> operator, KeySelector<IN1, K> keySelector, TypeInformation<K> keyType, int maxParallelism, int numSubtasks, int subtaskIndex) throws Exception {
        super(operator, maxParallelism, numSubtasks, subtaskIndex);
        ClosureCleaner.clean(keySelector, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)false);
        this.config.setStatePartitioner(0, keySelector);
        this.config.setStateKeySerializer(keyType.createSerializer(this.executionConfig.getSerializerConfig()));
        this.config.serializeAllConfigs();
    }

    public <KS, V> BroadcastState<KS, V> getBroadcastState(MapStateDescriptor<KS, V> stateDescriptor) throws Exception {
        return this.getOperator().getOperatorStateBackend().getBroadcastState(stateDescriptor);
    }
}

