/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect.utils;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestGateway;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestHandler;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.util.OptionalFailure;
import org.assertj.core.api.Assertions;

public class TestJobClient
implements JobClient,
CoordinationRequestGateway {
    private final JobID jobId;
    private final String operatorUid;
    private final CoordinationRequestHandler handler;
    private final JobInfoProvider infoProvider;
    private JobStatus jobStatus;
    private JobExecutionResult jobExecutionResult;

    public TestJobClient(JobID jobId, String operatorUid, CoordinationRequestHandler handler, JobInfoProvider infoProvider) {
        this.jobId = jobId;
        this.operatorUid = operatorUid;
        this.handler = handler;
        this.infoProvider = infoProvider;
        this.jobStatus = JobStatus.RUNNING;
        this.jobExecutionResult = null;
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public CompletableFuture<JobStatus> getJobStatus() {
        return CompletableFuture.completedFuture(this.jobStatus);
    }

    public CompletableFuture<Void> cancel() {
        this.jobStatus = JobStatus.CANCELED;
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<String> stopWithSavepoint(boolean advanceToEndOfEventTime, @Nullable String savepointDirectory, SavepointFormatType formatType) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<String> triggerSavepoint(@Nullable String savepointDirectory, SavepointFormatType formatType) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Map<String, Object>> getAccumulators() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<JobExecutionResult> getJobExecutionResult() {
        return CompletableFuture.completedFuture(this.jobExecutionResult);
    }

    public CompletableFuture<CoordinationResponse> sendCoordinationRequest(String operatorUid, CoordinationRequest request) {
        CoordinationResponse response;
        if (this.jobStatus.isGloballyTerminalState()) {
            throw new RuntimeException("Job terminated");
        }
        Assertions.assertThat((String)operatorUid).isEqualTo(this.operatorUid);
        try {
            response = (CoordinationResponse)this.handler.handleCoordinationRequest(request).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.infoProvider.isJobFinished()) {
            this.jobStatus = JobStatus.FINISHED;
            this.jobExecutionResult = new JobExecutionResult(this.jobId, 0L, this.infoProvider.getAccumulatorResults());
        }
        return CompletableFuture.completedFuture(response);
    }

    public static interface JobInfoProvider {
        public boolean isJobFinished();

        public Map<String, OptionalFailure<Object>> getAccumulatorResults();
    }
}

