/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.event;

import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.event.task.IntegerTaskEvent;
import org.apache.flink.runtime.event.task.StringTaskEvent;
import org.apache.flink.runtime.io.network.api.TaskEventHandler;
import org.apache.flink.runtime.util.event.EventListener;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskEventHandlerTest {
    TaskEventHandlerTest() {
    }

    @Test
    void testEventNotificationManager() {
        TaskEventHandler evm = new TaskEventHandler();
        TestEventListener listener = new TestEventListener();
        evm.subscribe((EventListener)listener, StringTaskEvent.class);
        StringTaskEvent stringTaskEvent1 = new StringTaskEvent("Test 1");
        evm.publish((TaskEvent)stringTaskEvent1);
        evm.publish((TaskEvent)new IntegerTaskEvent(5));
        Assertions.assertThat((Object)listener.getLastReceivedEvent()).isNotNull();
        StringTaskEvent receivedStringEvent = (StringTaskEvent)listener.getLastReceivedEvent();
        Assertions.assertThat((Object)((Object)stringTaskEvent1)).isEqualTo((Object)receivedStringEvent);
    }

    private static class TestEventListener
    implements EventListener<TaskEvent> {
        private TaskEvent receivedEvent = null;

        private TestEventListener() {
        }

        public void onEvent(TaskEvent event) {
            this.receivedEvent = event;
        }

        public TaskEvent getLastReceivedEvent() {
            return this.receivedEvent;
        }
    }
}

