/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.util.Random;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorageAccess;
import org.apache.flink.util.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FsStorageLocationReferenceTest {
    private static final Logger LOG = LoggerFactory.getLogger(FsStorageLocationReferenceTest.class);

    FsStorageLocationReferenceTest() {
    }

    @Test
    void testEncodeAndDecode() throws Exception {
        Path path = FsStorageLocationReferenceTest.randomPath(new Random());
        try {
            CheckpointStorageLocationReference ref = AbstractFsCheckpointStorageAccess.encodePathAsReference((Path)path);
            Path decoded = AbstractFsCheckpointStorageAccess.decodePathFromReference((CheckpointStorageLocationReference)ref);
            Assertions.assertThat((Object)decoded).isEqualTo((Object)path);
        }
        catch (Error | Exception e) {
            LOG.error("ERROR FOR PATH " + String.valueOf(path));
            throw e;
        }
    }

    @Test
    void testDecodingTooShortReference() {
        Assertions.assertThatThrownBy(() -> AbstractFsCheckpointStorageAccess.decodePathFromReference((CheckpointStorageLocationReference)new CheckpointStorageLocationReference(new byte[2]))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDecodingGarbage() {
        byte[] bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        Assertions.assertThatThrownBy(() -> AbstractFsCheckpointStorageAccess.decodePathFromReference((CheckpointStorageLocationReference)new CheckpointStorageLocationReference(bytes))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDecodingDefaultReference() {
        Assertions.assertThatThrownBy(() -> AbstractFsCheckpointStorageAccess.decodePathFromReference((CheckpointStorageLocationReference)CheckpointStorageLocationReference.getDefault())).isInstanceOf(IllegalArgumentException.class);
    }

    private static Path randomPath(Random rnd) {
        while (true) {
            try {
                StringBuilder path = new StringBuilder();
                path.append(StringUtils.getRandomString((Random)rnd, (int)1, (int)5, (char)'a', (char)'z'));
                path.append("://");
                path.append(StringUtils.getRandomString((Random)rnd, (int)10, (int)20));
                path.append(":");
                path.append(rnd.nextInt(50000) + 1);
                for (int j = rnd.nextInt(5) + 1; j > 0; --j) {
                    path.append('/');
                    path.append(StringUtils.getRandomString((Random)rnd, (int)3, (int)15));
                }
                return new Path(path.toString());
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }
}

