/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.testutils.statemigration.TestType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StateSerializerProviderTest {
    StateSerializerProviderTest() {
    }

    @Test
    void testCurrentSchemaSerializerForEagerlyRegisteredStateSerializerProvider() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.V1TestTypeSerializer());
        Assertions.assertThat((Object)testProvider.currentSchemaSerializer()).isInstanceOf(TestType.V1TestTypeSerializer.class);
    }

    @Test
    void testCurrentSchemaSerializerForLazilyRegisteredStateSerializerProvider() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        Assertions.assertThat((Object)testProvider.currentSchemaSerializer()).isInstanceOf(TestType.V1TestTypeSerializer.class);
    }

    @Test
    void testPreviousSchemaSerializerForEagerlyRegisteredStateSerializerProvider() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.V1TestTypeSerializer());
        Assertions.assertThatThrownBy(() -> ((StateSerializerProvider)testProvider).previousSchemaSerializer()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testPreviousSchemaSerializerForLazilyRegisteredStateSerializerProvider() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        Assertions.assertThat((Object)testProvider.previousSchemaSerializer()).isInstanceOf(TestType.V1TestTypeSerializer.class);
    }

    @Test
    void testLazyInstantiationOfPreviousSchemaSerializer() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot((TypeSerializerSnapshot)new ExceptionThrowingSerializerSnapshot());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((StateSerializerProvider)testProvider).previousSchemaSerializer()).withFailMessage("expected to fail when accessing the restore serializer.", new Object[0])).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testRegisterNewSerializerWithEagerlyRegisteredStateSerializerProviderShouldFail() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.V1TestTypeSerializer());
        Assertions.assertThatThrownBy(() -> testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V2TestTypeSerializer())).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testRegisterNewSerializerTwiceWithLazilyRegisteredStateSerializerProviderShouldFail() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V2TestTypeSerializer());
        Assertions.assertThatThrownBy(() -> testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V2TestTypeSerializer())).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testLazilyRegisterNewCompatibleAsIsSerializer() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V1TestTypeSerializer());
        Assertions.assertThat((boolean)schemaCompatibility.isCompatibleAsIs()).isTrue();
        Assertions.assertThat((Object)testProvider.currentSchemaSerializer()).isInstanceOf(TestType.V1TestTypeSerializer.class);
        Assertions.assertThat((Object)testProvider.previousSchemaSerializer()).isInstanceOf(TestType.V1TestTypeSerializer.class);
    }

    @Test
    void testLazilyRegisterNewCompatibleAfterMigrationSerializer() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V2TestTypeSerializer());
        Assertions.assertThat((boolean)schemaCompatibility.isCompatibleAfterMigration()).isTrue();
        Assertions.assertThat((Object)testProvider.currentSchemaSerializer()).isInstanceOf(TestType.V2TestTypeSerializer.class);
        Assertions.assertThat((Object)testProvider.previousSchemaSerializer()).isInstanceOf(TestType.V1TestTypeSerializer.class);
    }

    @Test
    void testLazilyRegisterNewSerializerRequiringReconfiguration() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.ReconfigurationRequiringTestTypeSerializer());
        Assertions.assertThat((boolean)schemaCompatibility.isCompatibleWithReconfiguredSerializer()).isTrue();
        Assertions.assertThat((Object)testProvider.currentSchemaSerializer()).isInstanceOf(TestType.V1TestTypeSerializer.class);
    }

    @Test
    void testLazilyRegisterIncompatibleSerializer() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.IncompatibleTestTypeSerializer());
        Assertions.assertThat((boolean)schemaCompatibility.isIncompatible()).isTrue();
        Assertions.assertThatThrownBy(() -> ((StateSerializerProvider)testProvider).currentSchemaSerializer()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testSetSerializerSnapshotWithLazilyRegisteredSerializerProviderShouldFail() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        Assertions.assertThatThrownBy(() -> testProvider.setPreviousSerializerSnapshotForRestoredState(serializer.snapshotConfiguration())).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testSetSerializerSnapshotTwiceWithEagerlyRegisteredSerializerProviderShouldFail() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)serializer);
        testProvider.setPreviousSerializerSnapshotForRestoredState(serializer.snapshotConfiguration());
        Assertions.assertThatThrownBy(() -> testProvider.setPreviousSerializerSnapshotForRestoredState(serializer.snapshotConfiguration())).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testEagerlyRegisterNewCompatibleAsIsSerializer() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.V1TestTypeSerializer());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.setPreviousSerializerSnapshotForRestoredState(new TestType.V1TestTypeSerializer().snapshotConfiguration());
        Assertions.assertThat((boolean)schemaCompatibility.isCompatibleAsIs()).isTrue();
        Assertions.assertThat((Object)testProvider.currentSchemaSerializer()).isInstanceOf(TestType.V1TestTypeSerializer.class);
        Assertions.assertThat((Object)testProvider.previousSchemaSerializer()).isInstanceOf(TestType.V1TestTypeSerializer.class);
    }

    @Test
    void testEagerlyRegisterCompatibleAfterMigrationSerializer() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.V2TestTypeSerializer());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.setPreviousSerializerSnapshotForRestoredState(new TestType.V1TestTypeSerializer().snapshotConfiguration());
        Assertions.assertThat((boolean)schemaCompatibility.isCompatibleAfterMigration()).isTrue();
        Assertions.assertThat((Object)testProvider.currentSchemaSerializer()).isInstanceOf(TestType.V2TestTypeSerializer.class);
        Assertions.assertThat((Object)testProvider.previousSchemaSerializer()).isInstanceOf(TestType.V1TestTypeSerializer.class);
    }

    @Test
    void testEagerlyRegisterNewSerializerRequiringReconfiguration() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.ReconfigurationRequiringTestTypeSerializer());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.setPreviousSerializerSnapshotForRestoredState(new TestType.V1TestTypeSerializer().snapshotConfiguration());
        Assertions.assertThat((boolean)schemaCompatibility.isCompatibleWithReconfiguredSerializer()).isTrue();
        Assertions.assertThat((Object)testProvider.currentSchemaSerializer()).isInstanceOf(TestType.V1TestTypeSerializer.class);
    }

    @Test
    void testEagerlyRegisterIncompatibleSerializer() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.IncompatibleTestTypeSerializer());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.setPreviousSerializerSnapshotForRestoredState(new TestType.V1TestTypeSerializer().snapshotConfiguration());
        Assertions.assertThat((boolean)schemaCompatibility.isIncompatible()).isTrue();
        Assertions.assertThatThrownBy(() -> ((StateSerializerProvider)testProvider).currentSchemaSerializer()).isInstanceOf(IllegalStateException.class);
    }

    public static class ExceptionThrowingSerializerSnapshot
    implements TypeSerializerSnapshot<String> {
        public TypeSerializer<String> restoreSerializer() {
            throw new UnsupportedOperationException();
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            throw new UnsupportedOperationException();
        }

        public TypeSerializerSchemaCompatibility<String> resolveSchemaCompatibility(TypeSerializerSnapshot<String> oldSerializerSnapshot) {
            throw new UnsupportedOperationException();
        }

        public int getCurrentVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

