/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.InternalPriorityQueue;
import org.apache.flink.runtime.state.KeyExtractorFunction;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.Keyed;
import org.apache.flink.runtime.state.PriorityComparable;
import org.apache.flink.runtime.state.PriorityComparator;
import org.apache.flink.runtime.state.heap.AbstractHeapPriorityQueueElement;
import org.apache.flink.shaded.guava33.com.google.common.primitives.UnsignedBytes;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.MathUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class InternalPriorityQueueTestBase {
    protected static final KeyGroupRange KEY_GROUP_RANGE = new KeyGroupRange(0, 2);
    protected static final KeyExtractorFunction<TestElement> KEY_EXTRACTOR_FUNCTION = TestElement::getKey;
    protected static final PriorityComparator<TestElement> TEST_ELEMENT_PRIORITY_COMPARATOR = (left, right) -> Long.compare(left.getPriority(), right.getPriority());
    protected static final Comparator<TestElement> TEST_ELEMENT_COMPARATOR = new TestElementComparator();

    protected Comparator<Long> getTestElementPriorityComparator() {
        return Long::compareTo;
    }

    private long getHighestPriorityValueForComparator() {
        return this.getTestElementPriorityComparator().compare(-1L, 1L) > 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
    }

    protected static void insertRandomElements(@Nonnull InternalPriorityQueue<TestElement> priorityQueue, @Nonnull Set<TestElement> checkSet, int count) {
        ThreadLocalRandom localRandom = ThreadLocalRandom.current();
        int numUniqueKeys = Math.max(count / 4, 64);
        long duplicatePriority = Long.MIN_VALUE;
        boolean checkEndSizes = priorityQueue.isEmpty();
        for (int i = 0; i < count; ++i) {
            long elementPriority;
            TestElement element;
            do {
                if (duplicatePriority == Long.MIN_VALUE) {
                    elementPriority = localRandom.nextLong();
                    continue;
                }
                elementPriority = duplicatePriority;
                duplicatePriority = Long.MIN_VALUE;
            } while (!checkSet.add(element = new TestElement(localRandom.nextInt(numUniqueKeys), elementPriority)));
            if (localRandom.nextInt(10) == 0) {
                duplicatePriority = element.getPriority();
            }
            boolean headChangedIndicated = priorityQueue.add((Object)element);
            if (!element.equals(priorityQueue.peek())) continue;
            Assertions.assertThat((boolean)headChangedIndicated).isTrue();
        }
        if (checkEndSizes) {
            Assertions.assertThat((int)priorityQueue.size()).isEqualTo(count);
        }
    }

    @Test
    void testPeekPollOrder() {
        TestElement testElement;
        int initialCapacity = 4;
        int testSize = 1000;
        Comparator<Long> comparator = this.getTestElementPriorityComparator();
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(4);
        HashSet<TestElement> checkSet = new HashSet<TestElement>(1000);
        InternalPriorityQueueTestBase.insertRandomElements(priorityQueue, checkSet, 1000);
        long lastPriorityValue = this.getHighestPriorityValueForComparator();
        int lastSize = priorityQueue.size();
        Assertions.assertThat((int)lastSize).isEqualTo(1000);
        while ((testElement = (TestElement)((Object)priorityQueue.peek())) != null) {
            Assertions.assertThat((boolean)priorityQueue.isEmpty()).isFalse();
            Assertions.assertThat((int)priorityQueue.size()).isEqualTo(lastSize);
            Assertions.assertThat((Object)((Object)((TestElement)((Object)priorityQueue.poll())))).isEqualTo((Object)testElement);
            Assertions.assertThat((boolean)checkSet.remove((Object)testElement)).isTrue();
            Assertions.assertThat((long)testElement.getPriority()).isGreaterThanOrEqualTo(lastPriorityValue);
            lastPriorityValue = testElement.getPriority();
            --lastSize;
        }
        Assertions.assertThat((boolean)priorityQueue.isEmpty()).isTrue();
        Assertions.assertThat((int)priorityQueue.size()).isZero();
        Assertions.assertThat(checkSet).isEmpty();
    }

    @Test
    void testRemoveInsertMixKeepsOrder() {
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(3);
        Comparator<Long> comparator = this.getTestElementPriorityComparator();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int testSize = 300;
        int addCounterMax = 75;
        int iterationsTillNextAdds = random.nextInt(75);
        HashSet<TestElement> checkSet = new HashSet<TestElement>(300);
        InternalPriorityQueueTestBase.insertRandomElements(priorityQueue, checkSet, 300);
        while (!checkSet.isEmpty()) {
            long highestPrioValue = this.getHighestPriorityValueForComparator();
            Iterator<TestElement> iterator = checkSet.iterator();
            TestElement element = iterator.next();
            iterator.remove();
            boolean removesHead = element.equals(priorityQueue.peek());
            if (removesHead) {
                Assertions.assertThat((boolean)priorityQueue.remove((Object)element)).isTrue();
            } else {
                priorityQueue.remove((Object)element);
            }
            long currentPriorityWatermark = removesHead ? element.getPriority() : highestPrioValue;
            while ((element = (TestElement)((Object)priorityQueue.poll())) != null) {
                Assertions.assertThat((long)element.getPriority()).isGreaterThanOrEqualTo(currentPriorityWatermark);
                currentPriorityWatermark = element.getPriority();
                if (--iterationsTillNextAdds != 0) continue;
                iterationsTillNextAdds = random.nextInt(75);
                InternalPriorityQueueTestBase.insertRandomElements(priorityQueue, new HashSet<TestElement>(checkSet), 1 + random.nextInt(3));
                currentPriorityWatermark = ((TestElement)((Object)priorityQueue.peek())).getPriority();
            }
            Assertions.assertThat((boolean)priorityQueue.isEmpty()).isTrue();
            priorityQueue.addAll(checkSet);
        }
    }

    @Test
    void testPoll() {
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(3);
        Comparator<Long> comparator = this.getTestElementPriorityComparator();
        Assertions.assertThat((Object)((Object)((TestElement)((Object)priorityQueue.poll())))).isNull();
        int testSize = 345;
        HashSet<TestElement> checkSet = new HashSet<TestElement>(345);
        InternalPriorityQueueTestBase.insertRandomElements(priorityQueue, checkSet, 345);
        long lastPriorityValue = this.getHighestPriorityValueForComparator();
        while (!priorityQueue.isEmpty()) {
            TestElement removed = (TestElement)((Object)priorityQueue.poll());
            Assertions.assertThat((Object)((Object)removed)).isNotNull();
            Assertions.assertThat((boolean)checkSet.remove((Object)removed)).isTrue();
            Assertions.assertThat((long)removed.getPriority()).isGreaterThanOrEqualTo(lastPriorityValue);
            lastPriorityValue = removed.getPriority();
        }
        Assertions.assertThat(checkSet).isEmpty();
        Assertions.assertThat((Object)((Object)((TestElement)((Object)priorityQueue.poll())))).isNull();
    }

    @Test
    void testIsEmpty() {
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        Assertions.assertThat((boolean)priorityQueue.isEmpty()).isTrue();
        Assertions.assertThat((boolean)priorityQueue.add((Object)new TestElement(4711L, 42L))).isTrue();
        Assertions.assertThat((boolean)priorityQueue.isEmpty()).isFalse();
        priorityQueue.poll();
        Assertions.assertThat((boolean)priorityQueue.isEmpty()).isTrue();
    }

    @Test
    void testBulkAddRestoredElements() throws Exception {
        int testSize = 10;
        HashSet<TestElement> elementSet = new HashSet<TestElement>(10);
        for (int i = 0; i < 10; ++i) {
            elementSet.add(new TestElement(i, i));
        }
        ArrayList<TestElement> twoTimesElementSet = new ArrayList<TestElement>(elementSet.size() * 2);
        for (TestElement testElement : elementSet) {
            twoTimesElementSet.add(testElement.deepCopy());
            twoTimesElementSet.add(testElement.deepCopy());
        }
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        priorityQueue.addAll(twoTimesElementSet);
        priorityQueue.addAll(elementSet);
        int expectedSize = this.testSetSemanticsAgainstDuplicateElements() ? elementSet.size() : 3 * elementSet.size();
        Assertions.assertThat((int)priorityQueue.size()).isEqualTo(expectedSize);
        try (CloseableIterator iterator = priorityQueue.iterator();){
            while (iterator.hasNext()) {
                if (this.testSetSemanticsAgainstDuplicateElements()) {
                    Assertions.assertThat((boolean)elementSet.remove(iterator.next())).isTrue();
                    continue;
                }
                Assertions.assertThat(elementSet).contains((Object[])new TestElement[]{(TestElement)((Object)iterator.next())});
            }
        }
        if (this.testSetSemanticsAgainstDuplicateElements()) {
            Assertions.assertThat(elementSet).isEmpty();
        }
    }

    @Test
    void testIterator() throws Exception {
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        try (CloseableIterator iterator = priorityQueue.iterator();){
            Assertions.assertThat((Iterator)iterator).isExhausted();
            Assertions.assertThatThrownBy(() -> iterator.next()).isInstanceOf(NoSuchElementException.class);
        }
        int testSize = 10;
        HashSet<TestElement> checkSet = new HashSet<TestElement>(10);
        InternalPriorityQueueTestBase.insertRandomElements(priorityQueue, checkSet, 10);
        try (CloseableIterator iterator = priorityQueue.iterator();){
            while (iterator.hasNext()) {
                Assertions.assertThat((boolean)checkSet.remove(iterator.next())).isTrue();
            }
            Assertions.assertThat(checkSet).isEmpty();
        }
    }

    @Test
    void testAdd() {
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        List<TestElement> testElements = Arrays.asList(new TestElement(4711L, 42L), new TestElement(815L, 23L));
        testElements.sort((l, r) -> this.getTestElementPriorityComparator().compare(r.priority, l.priority));
        Assertions.assertThat((boolean)priorityQueue.add((Object)testElements.get(0))).isTrue();
        if (this.testSetSemanticsAgainstDuplicateElements()) {
            priorityQueue.add((Object)testElements.get(0).deepCopy());
        }
        Assertions.assertThat((int)priorityQueue.size()).isOne();
        Assertions.assertThat((boolean)priorityQueue.add((Object)testElements.get(1))).isTrue();
        Assertions.assertThat((int)priorityQueue.size()).isEqualTo(2);
        Assertions.assertThat((Object)((Object)((TestElement)((Object)priorityQueue.poll())))).isEqualTo((Object)testElements.get(1));
        Assertions.assertThat((int)priorityQueue.size()).isOne();
        Assertions.assertThat((Object)((Object)((TestElement)((Object)priorityQueue.poll())))).isEqualTo((Object)testElements.get(0));
        Assertions.assertThat((int)priorityQueue.size()).isZero();
    }

    @Test
    void testRemove() {
        InternalPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        long key = 4711L;
        long priorityValue = 42L;
        TestElement testElement = new TestElement(4711L, 42L);
        if (this.testSetSemanticsAgainstDuplicateElements()) {
            Assertions.assertThat((boolean)priorityQueue.remove((Object)testElement)).isFalse();
        }
        Assertions.assertThat((boolean)priorityQueue.add((Object)testElement)).isTrue();
        Assertions.assertThat((boolean)priorityQueue.remove((Object)testElement)).isTrue();
        if (this.testSetSemanticsAgainstDuplicateElements()) {
            Assertions.assertThat((boolean)priorityQueue.remove((Object)testElement)).isFalse();
        }
        Assertions.assertThat((boolean)priorityQueue.isEmpty()).isTrue();
    }

    protected abstract InternalPriorityQueue<TestElement> newPriorityQueue(int var1);

    protected abstract boolean testSetSemanticsAgainstDuplicateElements();

    protected static class TestElementComparator
    implements Comparator<TestElement> {
        protected TestElementComparator() {
        }

        @Override
        public int compare(TestElement o1, TestElement o2) {
            ByteArrayOutputStreamWithPos os = new ByteArrayOutputStreamWithPos();
            DataOutputViewStreamWrapper ow = new DataOutputViewStreamWrapper((OutputStream)os);
            try {
                TestElementSerializer.INSTANCE.serialize(o1, (DataOutputView)ow);
                byte[] a1 = os.toByteArray();
                os.reset();
                TestElementSerializer.INSTANCE.serialize(o2, (DataOutputView)ow);
                byte[] a2 = os.toByteArray();
                return UnsignedBytes.lexicographicalComparator().compare(a1, a2);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static class TestElementSerializer
    extends TypeSerializer<TestElement> {
        private static final int REVISION = 1;
        public static final TestElementSerializer INSTANCE = new TestElementSerializer();

        protected TestElementSerializer() {
        }

        public boolean isImmutableType() {
            return true;
        }

        public TypeSerializer<TestElement> duplicate() {
            return this;
        }

        public TestElement createInstance() {
            throw new UnsupportedOperationException();
        }

        public TestElement copy(TestElement from) {
            return new TestElement(from.key, from.priority);
        }

        public TestElement copy(TestElement from, TestElement reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return 16;
        }

        public void serialize(TestElement record, DataOutputView target) throws IOException {
            target.writeLong(MathUtils.flipSignBit((long)record.getPriority()));
            target.writeLong(record.getKey().longValue());
        }

        public TestElement deserialize(DataInputView source) throws IOException {
            long prio = MathUtils.flipSignBit((long)source.readLong());
            long key = source.readLong();
            return new TestElement(key, prio);
        }

        public TestElement deserialize(TestElement reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            this.serialize(this.deserialize(source), target);
        }

        public boolean equals(Object obj) {
            return false;
        }

        public int hashCode() {
            return 4711;
        }

        protected int getRevision() {
            return 1;
        }

        public Snapshot snapshotConfiguration() {
            return new Snapshot(this.getRevision());
        }

        public static class Snapshot
        implements TypeSerializerSnapshot<TestElement> {
            private int revision;

            public Snapshot() {
            }

            public Snapshot(int revision) {
                this.revision = revision;
            }

            public boolean equals(Object obj) {
                return obj instanceof Snapshot && this.revision == ((Snapshot)obj).revision;
            }

            public int hashCode() {
                return this.revision;
            }

            public int getCurrentVersion() {
                return 0;
            }

            public int getRevision() {
                return this.revision;
            }

            public void writeSnapshot(DataOutputView out) throws IOException {
                out.writeInt(this.revision);
            }

            public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
                this.revision = in.readInt();
            }

            public TypeSerializer<TestElement> restoreSerializer() {
                return new TestElementSerializer();
            }

            public TypeSerializerSchemaCompatibility<TestElement> resolveSchemaCompatibility(TypeSerializerSnapshot<TestElement> oldSerializerSnapshot) {
                if (!(oldSerializerSnapshot instanceof Snapshot)) {
                    return TypeSerializerSchemaCompatibility.incompatible();
                }
                Snapshot snapshot = (Snapshot)oldSerializerSnapshot;
                return snapshot.getRevision() <= this.revision ? TypeSerializerSchemaCompatibility.compatibleAsIs() : TypeSerializerSchemaCompatibility.incompatible();
            }
        }
    }

    protected static class TestElement
    extends AbstractHeapPriorityQueueElement
    implements Keyed<Long>,
    PriorityComparable<TestElement> {
        private final long key;
        private final long priority;

        public TestElement(long key, long priority) {
            this.key = key;
            this.priority = priority;
        }

        public int comparePriorityTo(@Nonnull TestElement other) {
            return Long.compare(this.priority, other.priority);
        }

        public Long getKey() {
            return this.key;
        }

        public long getPriority() {
            return this.priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TestElement that = (TestElement)((Object)o);
            return this.key == that.key && this.priority == that.priority;
        }

        public int hashCode() {
            return Objects.hash(this.getKey(), this.getPriority());
        }

        public TestElement deepCopy() {
            return new TestElement(this.key, this.priority);
        }

        public String toString() {
            return "TestElement{key=" + this.key + ", priority=" + this.priority + "}";
        }
    }
}

