/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.failure.FailureEnricherUtils;
import org.apache.flink.runtime.scheduler.adaptive.CreatedTest;
import org.apache.flink.runtime.scheduler.adaptive.MockStateWithoutExecutionGraphContext;
import org.apache.flink.runtime.scheduler.adaptive.StateWithoutExecutionGraph;
import org.apache.flink.util.FlinkException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateWithoutExecutionGraphTest {
    private static final Logger LOG = LoggerFactory.getLogger(CreatedTest.class);
    @RegisterExtension
    private MockStateWithoutExecutionGraphContext ctx = new MockStateWithoutExecutionGraphContext();

    StateWithoutExecutionGraphTest() {
    }

    @Test
    void testCancelTransitionsToFinished() {
        TestingStateWithoutExecutionGraph state = new TestingStateWithoutExecutionGraph(this.ctx, LOG);
        this.ctx.setExpectFinished(archivedExecutionGraph -> {
            Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.CANCELED);
            Assertions.assertThat((Object)archivedExecutionGraph.getFailureInfo()).isNull();
        });
        state.cancel();
    }

    @Test
    void testSuspendTransitionsToFinished() {
        FlinkException expectedException = new FlinkException("This is a test exception");
        TestingStateWithoutExecutionGraph state = new TestingStateWithoutExecutionGraph(this.ctx, LOG);
        this.ctx.setExpectFinished(archivedExecutionGraph -> {
            Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.SUSPENDED);
            Assertions.assertThat((Object)archivedExecutionGraph.getFailureInfo()).isNotNull();
            Assertions.assertThat((Throwable)archivedExecutionGraph.getFailureInfo().getException().deserializeError(this.getClass().getClassLoader())).isEqualTo((Object)expectedException);
        });
        state.suspend((Throwable)expectedException);
    }

    @Test
    void testTransitionToFinishedOnGlobalFailure() {
        TestingStateWithoutExecutionGraph state = new TestingStateWithoutExecutionGraph(this.ctx, LOG);
        RuntimeException expectedException = new RuntimeException("This is a test exception");
        this.ctx.setExpectFinished(archivedExecutionGraph -> {
            Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.FAILED);
            Assertions.assertThat((Object)archivedExecutionGraph.getFailureInfo()).isNotNull();
            Assertions.assertThat((Throwable)archivedExecutionGraph.getFailureInfo().getException().deserializeError(this.getClass().getClassLoader())).isEqualTo((Object)expectedException);
        });
        state.handleGlobalFailure(expectedException, FailureEnricherUtils.EMPTY_FAILURE_LABELS);
    }

    private static final class TestingStateWithoutExecutionGraph
    extends StateWithoutExecutionGraph {
        TestingStateWithoutExecutionGraph(StateWithoutExecutionGraph.Context context, Logger logger) {
            super(context, logger);
        }

        public JobStatus getJobStatus() {
            return null;
        }
    }
}

