/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.json;

import java.io.Serializable;
import org.apache.flink.runtime.rest.messages.json.SerializedValueDeserializer;
import org.apache.flink.runtime.rest.messages.json.SerializedValueSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SerializedValueSerializerTest {
    private ObjectMapper objectMapper;

    SerializedValueSerializerTest() {
    }

    @BeforeEach
    void setUp() {
        this.objectMapper = JacksonMapperFactory.createObjectMapper();
        SimpleModule simpleModule = new SimpleModule();
        JavaType serializedValueWildcardType = this.objectMapper.getTypeFactory().constructType(new TypeReference<SerializedValue<?>>(){});
        simpleModule.addSerializer((JsonSerializer)new SerializedValueSerializer(serializedValueWildcardType));
        simpleModule.addDeserializer(SerializedValue.class, (JsonDeserializer)new SerializedValueDeserializer(serializedValueWildcardType));
        this.objectMapper.registerModule((Module)simpleModule);
    }

    @Test
    void testSerializationDeserialization() throws Exception {
        String json = this.objectMapper.writeValueAsString((Object)new SerializedValue((Object)new TestClass()));
        SerializedValue serializedValue = (SerializedValue)this.objectMapper.readValue(json, (TypeReference)new TypeReference<SerializedValue<TestClass>>(){});
        TestClass deserializedValue = (TestClass)serializedValue.deserializeValue(ClassLoader.getSystemClassLoader());
        Assertions.assertThat((String)deserializedValue.foo).isEqualTo("baz");
        Assertions.assertThat((int)deserializedValue.bar).isOne();
    }

    private static class TestClass
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String foo = "baz";
        private int bar = 1;

        private TestClass() {
        }
    }
}

