/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.AllCallbackWrapper;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.runtime.rest.FileUpload;
import org.apache.flink.runtime.rest.MultipartUploadExtension;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

class RestClientMultipartTest {
    @TempDir
    private static Path tempDir;
    @RegisterExtension
    private static final AllCallbackWrapper<MultipartUploadExtension> MULTIPART_UPLOAD_EXTENSION_WRAPPER;
    private static RestClient restClient;
    public static MultipartUploadExtension multipartUploadExtension;

    RestClientMultipartTest() {
    }

    @BeforeAll
    static void setupClient() throws ConfigurationException {
        multipartUploadExtension = (MultipartUploadExtension)MULTIPART_UPLOAD_EXTENSION_WRAPPER.getCustomExtension();
        restClient = new RestClient(new Configuration(), Executors.directExecutor());
    }

    @AfterEach
    void reset() {
        ((MultipartUploadExtension)MULTIPART_UPLOAD_EXTENSION_WRAPPER.getCustomExtension()).resetState();
    }

    @AfterAll
    static void teardownClient() {
        if (restClient != null) {
            restClient.shutdown(Duration.ofSeconds(10L));
        }
    }

    @Test
    void testMixedMultipart() throws Exception {
        Collection files = multipartUploadExtension.getFilesToUpload().stream().map(file -> new FileUpload(file.toPath(), "application/octet-stream")).collect(Collectors.toList());
        MultipartUploadExtension.TestRequestBody json = new MultipartUploadExtension.TestRequestBody();
        CompletableFuture responseFuture = restClient.sendRequest(multipartUploadExtension.getServerSocketAddress().getHostName(), multipartUploadExtension.getServerSocketAddress().getPort(), multipartUploadExtension.getMixedHandler().getMessageHeaders(), (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)json, files);
        responseFuture.get();
        Assertions.assertThat((Object)json).isEqualTo((Object)RestClientMultipartTest.multipartUploadExtension.getMixedHandler().lastReceivedRequest);
    }

    @Test
    void testJsonMultipart() throws Exception {
        MultipartUploadExtension.TestRequestBody json = new MultipartUploadExtension.TestRequestBody();
        CompletableFuture responseFuture = restClient.sendRequest(multipartUploadExtension.getServerSocketAddress().getHostName(), multipartUploadExtension.getServerSocketAddress().getPort(), multipartUploadExtension.getJsonHandler().getMessageHeaders(), (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)json, Collections.emptyList());
        responseFuture.get();
        Assertions.assertThat((Object)json).isEqualTo((Object)RestClientMultipartTest.multipartUploadExtension.getJsonHandler().lastReceivedRequest);
    }

    @Test
    void testFileMultipart() throws Exception {
        Collection files = multipartUploadExtension.getFilesToUpload().stream().map(file -> new FileUpload(file.toPath(), "application/octet-stream")).collect(Collectors.toList());
        CompletableFuture responseFuture = restClient.sendRequest(multipartUploadExtension.getServerSocketAddress().getHostName(), multipartUploadExtension.getServerSocketAddress().getPort(), multipartUploadExtension.getFileHandler().getMessageHeaders(), (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)EmptyRequestBody.getInstance(), files);
        responseFuture.get();
    }

    static {
        MULTIPART_UPLOAD_EXTENSION_WRAPPER = new AllCallbackWrapper((CustomExtension)new MultipartUploadExtension(() -> tempDir));
    }
}

