/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.stream.Stream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.SchedulerExecutionMode;
import org.apache.flink.configuration.StateRecoveryOptions;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobmaster.DefaultSlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.jobmaster.slotpool.PreferredAllocationRequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.RequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SimpleRequestSlotMatchingStrategy;
import org.apache.flink.runtime.scheduler.DefaultSchedulerFactory;
import org.apache.flink.runtime.scheduler.adaptive.AdaptiveSchedulerFactory;
import org.apache.flink.runtime.scheduler.adaptivebatch.AdaptiveBatchSchedulerFactory;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@ExtendWith(value={TestLoggerExtension.class})
class DefaultSlotPoolServiceSchedulerFactoryTest {
    DefaultSlotPoolServiceSchedulerFactoryTest() {
    }

    @Test
    void testFallsBackToDefaultSchedulerIfAdaptiveSchedulerInBatchJob() {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.SCHEDULER, (Object)JobManagerOptions.SchedulerType.Adaptive);
        DefaultSlotPoolServiceSchedulerFactory defaultSlotPoolServiceSchedulerFactory = DefaultSlotPoolServiceSchedulerFactory.fromConfiguration((Configuration)configuration, (JobType)JobType.BATCH, (boolean)true);
        Assertions.assertThat((Object)defaultSlotPoolServiceSchedulerFactory.getSchedulerNGFactory()).isInstanceOf(AdaptiveBatchSchedulerFactory.class);
        Assertions.assertThat((Comparable)defaultSlotPoolServiceSchedulerFactory.getSchedulerType()).isEqualTo((Object)JobManagerOptions.SchedulerType.AdaptiveBatch);
    }

    @Test
    void testAdaptiveSchedulerForReactiveMode() {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.SCHEDULER_MODE, (Object)SchedulerExecutionMode.REACTIVE);
        DefaultSlotPoolServiceSchedulerFactory defaultSlotPoolServiceSchedulerFactory = DefaultSlotPoolServiceSchedulerFactory.fromConfiguration((Configuration)configuration, (JobType)JobType.STREAMING, (boolean)false);
        Assertions.assertThat((Object)defaultSlotPoolServiceSchedulerFactory.getSchedulerNGFactory()).isInstanceOf(AdaptiveSchedulerFactory.class);
        Assertions.assertThat((Comparable)defaultSlotPoolServiceSchedulerFactory.getSchedulerType()).isEqualTo((Object)JobManagerOptions.SchedulerType.Adaptive);
    }

    @Test
    void testFallBackSchedulerWithAdaptiveSchedulerTestProperty() {
        String propertyValue = this.saveAdaptiveSchedulerTestPropertyValue();
        System.setProperty("flink.tests.enable-adaptive-scheduler", "true");
        DefaultSlotPoolServiceSchedulerFactory defaultSlotPoolServiceSchedulerFactory = DefaultSlotPoolServiceSchedulerFactory.fromConfiguration((Configuration)new Configuration(), (JobType)JobType.BATCH, (boolean)true);
        Assertions.assertThat((Object)defaultSlotPoolServiceSchedulerFactory.getSchedulerNGFactory()).isInstanceOf(AdaptiveBatchSchedulerFactory.class);
        Assertions.assertThat((Comparable)defaultSlotPoolServiceSchedulerFactory.getSchedulerType()).isEqualTo((Object)JobManagerOptions.SchedulerType.AdaptiveBatch);
        defaultSlotPoolServiceSchedulerFactory = DefaultSlotPoolServiceSchedulerFactory.fromConfiguration((Configuration)new Configuration(), (JobType)JobType.STREAMING, (boolean)false);
        Assertions.assertThat((Object)defaultSlotPoolServiceSchedulerFactory.getSchedulerNGFactory()).isInstanceOf(AdaptiveSchedulerFactory.class);
        Assertions.assertThat((Comparable)defaultSlotPoolServiceSchedulerFactory.getSchedulerType()).isEqualTo((Object)JobManagerOptions.SchedulerType.Adaptive);
        this.restoreAdaptiveSchedulerTestPropertiesValue(propertyValue);
    }

    @Test
    void testFallBackSchedulerWithoutAdaptiveSchedulerTestProperty() {
        String propertyValue = this.saveAdaptiveSchedulerTestPropertyValue();
        System.clearProperty("flink.tests.enable-adaptive-scheduler");
        DefaultSlotPoolServiceSchedulerFactory defaultSlotPoolServiceSchedulerFactory = DefaultSlotPoolServiceSchedulerFactory.fromConfiguration((Configuration)new Configuration(), (JobType)JobType.BATCH, (boolean)true);
        Assertions.assertThat((Object)defaultSlotPoolServiceSchedulerFactory.getSchedulerNGFactory()).isInstanceOf(AdaptiveBatchSchedulerFactory.class);
        Assertions.assertThat((Comparable)defaultSlotPoolServiceSchedulerFactory.getSchedulerType()).isEqualTo((Object)JobManagerOptions.SchedulerType.AdaptiveBatch);
        defaultSlotPoolServiceSchedulerFactory = DefaultSlotPoolServiceSchedulerFactory.fromConfiguration((Configuration)new Configuration(), (JobType)JobType.STREAMING, (boolean)false);
        Assertions.assertThat((Object)defaultSlotPoolServiceSchedulerFactory.getSchedulerNGFactory()).isInstanceOf(DefaultSchedulerFactory.class);
        Assertions.assertThat((Comparable)defaultSlotPoolServiceSchedulerFactory.getSchedulerType()).isEqualTo((Object)JobManagerOptions.SchedulerType.Default);
        this.restoreAdaptiveSchedulerTestPropertiesValue(propertyValue);
    }

    @ParameterizedTest
    @MethodSource(value={"testGetRequestSlotMatchingStrategy"})
    public void testGetRequestSlotMatchingStrategy(boolean isLocalRecoveryEnabled, JobType jobType, RequestSlotMatchingStrategy expected) {
        Configuration configuration = new Configuration();
        configuration.set(StateRecoveryOptions.LOCAL_RECOVERY, (Object)isLocalRecoveryEnabled);
        Assertions.assertThat((Object)DefaultSlotPoolServiceSchedulerFactory.getRequestSlotMatchingStrategy((Configuration)configuration, (JobType)jobType)).isSameAs((Object)expected);
    }

    private static Stream<Arguments> testGetRequestSlotMatchingStrategy() {
        return Stream.of(Arguments.of((Object[])new Object[]{false, JobType.BATCH, SimpleRequestSlotMatchingStrategy.INSTANCE}), Arguments.of((Object[])new Object[]{false, JobType.STREAMING, SimpleRequestSlotMatchingStrategy.INSTANCE}), Arguments.of((Object[])new Object[]{true, JobType.BATCH, SimpleRequestSlotMatchingStrategy.INSTANCE}), Arguments.of((Object[])new Object[]{true, JobType.STREAMING, PreferredAllocationRequestSlotMatchingStrategy.INSTANCE}));
    }

    private String saveAdaptiveSchedulerTestPropertyValue() {
        return System.getProperty("flink.tests.enable-adaptive-scheduler");
    }

    private void restoreAdaptiveSchedulerTestPropertiesValue(String savedPropertyValue) {
        if (savedPropertyValue == null) {
            System.clearProperty("flink.tests.enable-adaptive-scheduler");
        } else {
            System.setProperty("flink.tests.enable-adaptive-scheduler", savedPropertyValue);
        }
    }
}

