/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.jsonplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.jsonplan.JsonPlanGenerator;
import org.apache.flink.runtime.jobgraph.jsonplan.StreamGraphJsonSchema;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.rest.messages.JobPlanInfo;
import org.apache.flink.runtime.util.JobVertexConnectionUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class JsonGeneratorTest {
    @Test
    public void testGeneratorWithoutAnyAttachements() {
        try {
            JobVertex source1 = new JobVertex("source 1");
            JobVertex source2 = new JobVertex("source 2");
            source2.setInvokableClass(DummyInvokable.class);
            JobVertex source3 = new JobVertex("source 3");
            JobVertex intermediate1 = new JobVertex("intermediate 1");
            JobVertex intermediate2 = new JobVertex("intermediate 2");
            JobVertex join1 = new JobVertex("join 1");
            JobVertex join2 = new JobVertex("join 2");
            JobVertex sink1 = new JobVertex("sink 1");
            JobVertex sink2 = new JobVertex("sink 2");
            JobVertexConnectionUtils.connectNewDataSetAsInput(intermediate1, source1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            JobVertexConnectionUtils.connectNewDataSetAsInput(intermediate2, source2, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
            JobVertexConnectionUtils.connectNewDataSetAsInput(join1, intermediate1, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
            JobVertexConnectionUtils.connectNewDataSetAsInput(join1, intermediate2, DistributionPattern.ALL_TO_ALL, ResultPartitionType.BLOCKING);
            JobVertexConnectionUtils.connectNewDataSetAsInput(join2, join1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            JobVertexConnectionUtils.connectNewDataSetAsInput(join2, source3, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
            JobVertexConnectionUtils.connectNewDataSetAsInput(sink1, join2, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            JobVertexConnectionUtils.connectNewDataSetAsInput(sink2, join1, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
            JobGraph jg = JobGraphTestUtils.batchJobGraph(source1, source2, source3, intermediate1, intermediate2, join1, join2, sink1, sink2);
            JobPlanInfo.Plan plan = JsonPlanGenerator.generatePlan((JobGraph)jg);
            Assert.assertNotNull((Object)plan);
            Assert.assertEquals((Object)jg.getJobID().toString(), (Object)plan.getJobId());
            Assert.assertEquals((Object)jg.getName(), (Object)plan.getName());
            Assert.assertEquals((Object)jg.getJobType().name(), (Object)plan.getType());
            Assertions.assertThat((Collection)plan.getNodes()).isNotEmpty();
            Assertions.assertThat((int)plan.getNodes().size()).isEqualTo(9);
            for (JobPlanInfo.Plan.Node node : plan.getNodes()) {
                this.checkVertexExists(node.getId(), jg);
                String description = node.getDescription();
                Assert.assertTrue((description.startsWith("source") || description.startsWith("sink") || description.startsWith("intermediate") || description.startsWith("join") ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void checkVertexExists(String vertexId, JobGraph graph) {
        JobVertexID id = JobVertexID.fromHexString((String)vertexId);
        for (JobVertex vertex : graph.getVertices()) {
            if (!vertex.getID().equals((Object)id)) continue;
            return;
        }
        Assert.fail((String)("could not find vertex with id " + vertexId + " in JobGraph"));
    }

    @Test
    public void testGenerateStreamGraphJson() throws JsonProcessingException {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.fromSequence(0L, 1L).disableChaining().print();
        StreamGraph streamGraph = env.getStreamGraph();
        HashMap<Integer, JobVertexID> jobVertexIdMap = new HashMap<Integer, JobVertexID>();
        String streamGraphJson = JsonPlanGenerator.generateStreamGraphJson((StreamGraph)streamGraph, jobVertexIdMap);
        ObjectMapper mapper = JacksonMapperFactory.createObjectMapper();
        StreamGraphJsonSchema parsedStreamGraph = (StreamGraphJsonSchema)mapper.readValue(streamGraphJson, StreamGraphJsonSchema.class);
        ArrayList<String> expectedJobVertexIds = new ArrayList<String>();
        expectedJobVertexIds.add(null);
        expectedJobVertexIds.add(null);
        JsonGeneratorTest.validateStreamGraph(streamGraph, parsedStreamGraph, expectedJobVertexIds);
        for (StreamNode node : streamGraph.getStreamNodes()) {
            jobVertexIdMap.put(node.getId(), new JobVertexID());
        }
        streamGraphJson = JsonPlanGenerator.generateStreamGraphJson((StreamGraph)streamGraph, jobVertexIdMap);
        parsedStreamGraph = (StreamGraphJsonSchema)mapper.readValue(streamGraphJson, StreamGraphJsonSchema.class);
        JsonGeneratorTest.validateStreamGraph(streamGraph, parsedStreamGraph, jobVertexIdMap.values().stream().map(AbstractID::toString).collect(Collectors.toList()));
    }

    private static void validateStreamGraph(StreamGraph streamGraph, StreamGraphJsonSchema parsedStreamGraph, List<String> expectedJobVertexIds) {
        ArrayList realJobVertexIds = new ArrayList();
        parsedStreamGraph.getNodes().forEach(node -> {
            StreamNode streamNode = streamGraph.getStreamNode(Integer.valueOf(Integer.parseInt(node.getId())));
            Assert.assertEquals((Object)node.getOperator(), (Object)streamNode.getOperatorName());
            Assert.assertEquals((Object)node.getParallelism(), (Object)streamNode.getParallelism());
            Assert.assertEquals((Object)node.getDescription(), (Object)streamNode.getOperatorDescription());
            JsonGeneratorTest.validateStreamEdge(node.getInputs(), streamNode.getInEdges());
            realJobVertexIds.add(node.getJobVertexId());
        });
        Assert.assertEquals(expectedJobVertexIds, realJobVertexIds);
    }

    private static void validateStreamEdge(List<StreamGraphJsonSchema.JsonStreamEdgeSchema> jsonStreamEdges, List<StreamEdge> streamEdges) {
        Assert.assertEquals((long)jsonStreamEdges.size(), (long)streamEdges.size());
        for (int i = 0; i < jsonStreamEdges.size(); ++i) {
            StreamGraphJsonSchema.JsonStreamEdgeSchema edgeToValidate = jsonStreamEdges.get(i);
            StreamEdge expectedEdge = streamEdges.get(i);
            Assert.assertEquals((Object)String.valueOf(expectedEdge.getSourceId()), (Object)edgeToValidate.getId());
            Assert.assertEquals((Object)expectedEdge.getPartitioner().toString(), (Object)edgeToValidate.getShipStrategy());
            Assert.assertEquals((Object)expectedEdge.getExchangeMode().name(), (Object)edgeToValidate.getExchange());
        }
    }
}

