/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.apache.flink.shaded.guava33.com.google.common.collect.Queues;
import org.apache.flink.util.Preconditions;

public class TestPooledBufferProvider
implements BufferProvider {
    private final BlockingQueue<MemorySegment> segments = new LinkedBlockingDeque<MemorySegment>();
    private final TestBufferFactory bufferFactory;
    private final PooledBufferProviderRecycler bufferRecycler;

    public TestPooledBufferProvider(int poolSize) {
        this(poolSize, 32768);
    }

    public TestPooledBufferProvider(int poolSize, int bufferSize) {
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0);
        this.bufferRecycler = new PooledBufferProviderRecycler(this.segments);
        this.bufferFactory = new TestBufferFactory(poolSize, bufferSize, this.bufferRecycler);
    }

    public Buffer requestBuffer() {
        MemorySegment memorySegment = this.requestMemorySegment();
        return memorySegment == null ? null : new NetworkBuffer(memorySegment, (BufferRecycler)this.bufferRecycler);
    }

    public BufferBuilder requestBufferBuilder() {
        MemorySegment memorySegment = this.requestMemorySegment();
        if (memorySegment != null) {
            return new BufferBuilder(memorySegment, (BufferRecycler)this.bufferRecycler);
        }
        return null;
    }

    public BufferBuilder requestBufferBuilder(int targetChannel) {
        return this.requestBufferBuilder();
    }

    public BufferBuilder requestBufferBuilderBlocking() throws InterruptedException {
        return new BufferBuilder(this.requestMemorySegmentBlocking(), (BufferRecycler)this.bufferRecycler);
    }

    public BufferBuilder requestBufferBuilderBlocking(int targetChannel) throws InterruptedException {
        return this.requestBufferBuilderBlocking();
    }

    public boolean addBufferListener(BufferListener listener) {
        return this.bufferRecycler.registerListener(listener);
    }

    public boolean isDestroyed() {
        return false;
    }

    public MemorySegment requestMemorySegment() {
        MemorySegment buffer = (MemorySegment)this.segments.poll();
        if (buffer != null) {
            return buffer;
        }
        return this.bufferFactory.createMemorySegment();
    }

    public MemorySegment requestMemorySegmentBlocking() throws InterruptedException {
        MemorySegment buffer = (MemorySegment)this.segments.poll();
        if (buffer != null) {
            return buffer;
        }
        buffer = this.bufferFactory.createMemorySegment();
        if (buffer != null) {
            return buffer;
        }
        return this.segments.take();
    }

    public CompletableFuture<?> getAvailableFuture() {
        return AVAILABLE;
    }

    public int getNumberOfAvailableSegments() {
        return this.segments.size();
    }

    private static class PooledBufferProviderRecycler
    implements BufferRecycler {
        private final Object listenerRegistrationLock = new Object();
        private final Queue<MemorySegment> segments;
        private final ConcurrentLinkedQueue<BufferListener> registeredListeners = Queues.newConcurrentLinkedQueue();

        public PooledBufferProviderRecycler(Queue<MemorySegment> segments) {
            this.segments = segments;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle(MemorySegment segment) {
            Object object = this.listenerRegistrationLock;
            synchronized (object) {
                BufferListener listener = this.registeredListeners.poll();
                if (listener == null) {
                    this.segments.add(segment);
                } else {
                    listener.notifyBufferAvailable((Buffer)new NetworkBuffer(segment, (BufferRecycler)this));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean registerListener(BufferListener listener) {
            Object object = this.listenerRegistrationLock;
            synchronized (object) {
                if (this.segments.isEmpty()) {
                    this.registeredListeners.add(listener);
                    return true;
                }
                return false;
            }
        }
    }
}

