/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.io.IOException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageInputChannelId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.AvailabilityNotifier;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;

public class TestingTierConsumerAgent
implements TierConsumerAgent {
    private final Consumer<TieredStorageMemoryManager> memoryManagerConsumer;
    private final Runnable startNotifier;
    private final Supplier<Buffer> bufferSupplier;
    private final Runnable availabilityNotifierRegistrationRunnable;
    private final Runnable updateTierShuffleDescriptorRunnable;
    private final Runnable closeNotifier;
    private final BiFunction<TieredStoragePartitionId, ResultSubpartitionIndexSet, Integer> peekNextBufferSubpartitionIdFunction;

    private TestingTierConsumerAgent(Runnable startNotifier, Consumer<TieredStorageMemoryManager> memoryManagerConsumer, Supplier<Buffer> bufferSupplier, Runnable availabilityNotifierRegistrationRunnable, Runnable updateTierShuffleDescriptorRunnable, Runnable closeNotifier, BiFunction<TieredStoragePartitionId, ResultSubpartitionIndexSet, Integer> peekNextBufferSubpartitionIdFunction) {
        this.startNotifier = startNotifier;
        this.memoryManagerConsumer = memoryManagerConsumer;
        this.bufferSupplier = bufferSupplier;
        this.availabilityNotifierRegistrationRunnable = availabilityNotifierRegistrationRunnable;
        this.updateTierShuffleDescriptorRunnable = updateTierShuffleDescriptorRunnable;
        this.closeNotifier = closeNotifier;
        this.peekNextBufferSubpartitionIdFunction = peekNextBufferSubpartitionIdFunction;
    }

    public void setup(TieredStorageMemoryManager memoryManager) {
        this.memoryManagerConsumer.accept(memoryManager);
    }

    public void start() {
        this.startNotifier.run();
    }

    public int peekNextBufferSubpartitionId(TieredStoragePartitionId partitionId, ResultSubpartitionIndexSet indexSet) throws IOException {
        return this.peekNextBufferSubpartitionIdFunction.apply(partitionId, indexSet);
    }

    public Optional<Buffer> getNextBuffer(TieredStoragePartitionId partitionId, TieredStorageSubpartitionId subpartitionId, int segmentId) {
        Buffer buffer = this.bufferSupplier.get();
        return buffer == null ? Optional.empty() : Optional.of(buffer);
    }

    public void registerAvailabilityNotifier(AvailabilityNotifier notifier) {
        this.availabilityNotifierRegistrationRunnable.run();
    }

    public void updateTierShuffleDescriptor(TieredStoragePartitionId partitionId, TieredStorageInputChannelId inputChannelId, TieredStorageSubpartitionId subpartitionId, TierShuffleDescriptor tierShuffleDescriptor) {
        this.updateTierShuffleDescriptorRunnable.run();
    }

    public void close() throws IOException {
        this.closeNotifier.run();
    }

    public static class Builder {
        private Runnable startNotifier = () -> {};
        private Consumer<TieredStorageMemoryManager> memoryManagerConsumer = memoryManager -> {};
        private Supplier<Buffer> bufferSupplier = () -> null;
        private Runnable availabilityNotifierRegistrationRunnable = () -> {};
        private Runnable updateTierShuffleDescriptorRunnable = () -> {};
        private Runnable closeNotifier = () -> {};
        private BiFunction<TieredStoragePartitionId, ResultSubpartitionIndexSet, Integer> peekNextBufferSubpartitionIdFunction = (ignore1, ignore2) -> -1;

        public Builder setStartNotifier(Runnable startNotifier) {
            this.startNotifier = startNotifier;
            return this;
        }

        public Builder setMemoryManagerConsumer(Consumer<TieredStorageMemoryManager> memoryManagerConsumer) {
            this.memoryManagerConsumer = memoryManagerConsumer;
            return this;
        }

        public Builder setBufferSupplier(Supplier<Buffer> bufferSupplier) {
            this.bufferSupplier = bufferSupplier;
            return this;
        }

        public Builder setAvailabilityNotifierRegistrationRunnable(Runnable availabilityNotifierRegistrationRunnable) {
            this.availabilityNotifierRegistrationRunnable = availabilityNotifierRegistrationRunnable;
            return this;
        }

        public Builder setUpdateTierShuffleDescriptorRunnable(Runnable updateTierShuffleDescriptorRunnable) {
            this.updateTierShuffleDescriptorRunnable = updateTierShuffleDescriptorRunnable;
            return this;
        }

        public Builder setCloseNotifier(Runnable closeNotifier) {
            this.closeNotifier = closeNotifier;
            return this;
        }

        public Builder setPeekNextBufferSubpartitionIdFunction(BiFunction<TieredStoragePartitionId, ResultSubpartitionIndexSet, Integer> peekNextBufferSubpartitionIdFunction) {
            this.peekNextBufferSubpartitionIdFunction = peekNextBufferSubpartitionIdFunction;
            return this;
        }

        public TestingTierConsumerAgent build() {
            return new TestingTierConsumerAgent(this.startNotifier, this.memoryManagerConsumer, this.bufferSupplier, this.availabilityNotifierRegistrationRunnable, this.updateTierShuffleDescriptorRunnable, this.closeNotifier, this.peekNextBufferSubpartitionIdFunction);
        }
    }
}

