/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileIndex;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.TestingProducerMergedPartitionFileIndex;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ProducerMergedPartitionFileWriterTest {
    @TempDir
    private Path tempFolder;

    ProducerMergedPartitionFileWriterTest() {
    }

    @Test
    void testWrite() throws IOException {
        int numSubpartitions = 5;
        int numSegments = 10;
        int numBuffersPerSegment = 10;
        int bufferSizeBytes = 3;
        AtomicInteger receivedBuffers = new AtomicInteger(0);
        TestingProducerMergedPartitionFileIndex partitionFileIndex = new TestingProducerMergedPartitionFileIndex.Builder().setIndexFilePath(new File(this.tempFolder.toFile(), "testIndex").toPath()).setAddBuffersConsumer(buffers -> receivedBuffers.getAndAdd(buffers.size())).build();
        Path testFile = new File(this.tempFolder.toFile(), "testFile").toPath();
        ProducerMergedPartitionFileWriter partitionFileWriter = new ProducerMergedPartitionFileWriter(testFile, (ProducerMergedPartitionFileIndex)partitionFileIndex);
        List<PartitionFileWriter.SubpartitionBufferContext> subpartitionBuffers = TieredStorageTestUtils.generateBuffersToWrite(numSubpartitions, numSegments, numBuffersPerSegment, bufferSizeBytes);
        partitionFileWriter.write(TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID()), subpartitionBuffers);
        partitionFileWriter.release();
        byte[] bytesRead = Files.readAllBytes(testFile);
        int numExpectedBuffers = numSubpartitions * numSegments * numBuffersPerSegment;
        int numExpectedBytes = numExpectedBuffers * (8 + bufferSizeBytes);
        Assertions.assertThat((AtomicInteger)receivedBuffers).hasValue(numExpectedBuffers);
        Assertions.assertThat((int)bytesRead.length).isEqualTo(numExpectedBytes);
    }

    @Test
    void testRelease() {
        AtomicBoolean isReleased = new AtomicBoolean(false);
        TestingProducerMergedPartitionFileIndex partitionFileIndex = new TestingProducerMergedPartitionFileIndex.Builder().setIndexFilePath(new File(this.tempFolder.toFile(), "testIndex").toPath()).setReleaseRunnable(() -> isReleased.set(true)).build();
        ProducerMergedPartitionFileWriter partitionFileWriter = new ProducerMergedPartitionFileWriter(new File(this.tempFolder.toFile(), "testFile1").toPath(), (ProducerMergedPartitionFileIndex)partitionFileIndex);
        partitionFileWriter.release();
        Assertions.assertThat((AtomicBoolean)isReleased).isTrue();
    }
}

