/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexRegionHelper;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileRegionWriteReadUtils;

public class TestingFileDataIndexRegion
implements FileDataIndexRegionHelper.Region {
    public static final int REGION_SIZE = 16;
    private final Supplier<Integer> getSizeSupplier;
    private final Supplier<Integer> getFirstBufferIndexSupplier;
    private final Supplier<Long> getRegionFileOffsetSupplier;
    private final Supplier<Long> getRegionFileEndOffsetSupplier;
    private final Supplier<Integer> getNumBuffersSupplier;
    private final Function<Integer, Boolean> containBufferFunction;

    private TestingFileDataIndexRegion(Supplier<Integer> getSizeSupplier, Supplier<Integer> getFirstBufferIndexSupplier, Supplier<Long> getRegionFileOffsetSupplier, Supplier<Long> getRegionFileEndOffsetSupplier, Supplier<Integer> getNumBuffersSupplier, Function<Integer, Boolean> containBufferFunction) {
        this.getSizeSupplier = getSizeSupplier;
        this.getFirstBufferIndexSupplier = getFirstBufferIndexSupplier;
        this.getRegionFileOffsetSupplier = getRegionFileOffsetSupplier;
        this.getRegionFileEndOffsetSupplier = getRegionFileEndOffsetSupplier;
        this.getNumBuffersSupplier = getNumBuffersSupplier;
        this.containBufferFunction = containBufferFunction;
    }

    public int getSize() {
        return this.getSizeSupplier.get();
    }

    public int getFirstBufferIndex() {
        return this.getFirstBufferIndexSupplier.get();
    }

    public long getRegionStartOffset() {
        return this.getRegionFileOffsetSupplier.get();
    }

    public long getRegionEndOffset() {
        return this.getRegionFileEndOffsetSupplier.get();
    }

    public int getNumBuffers() {
        return this.getNumBuffersSupplier.get();
    }

    public boolean containBuffer(int bufferIndex) {
        return this.containBufferFunction.apply(bufferIndex);
    }

    public static void writeRegionToFile(FileChannel channel, TestingFileDataIndexRegion region) throws IOException {
        ByteBuffer regionBuffer = TestingFileDataIndexRegion.allocateHeaderBuffer();
        regionBuffer.clear();
        regionBuffer.putInt(region.getFirstBufferIndex());
        regionBuffer.putInt(region.getNumBuffers());
        regionBuffer.putLong(region.getRegionStartOffset());
        regionBuffer.flip();
        BufferReaderWriterUtil.writeBuffers((FileChannel)channel, (long)regionBuffer.capacity(), (ByteBuffer[])new ByteBuffer[]{regionBuffer});
    }

    public static TestingFileDataIndexRegion readRegionFromFile(FileChannel channel, long fileOffset) throws IOException {
        ByteBuffer regionBuffer = TestingFileDataIndexRegion.allocateHeaderBuffer();
        regionBuffer.clear();
        BufferReaderWriterUtil.readByteBufferFully((FileChannel)channel, (ByteBuffer)regionBuffer, (long)fileOffset);
        regionBuffer.flip();
        int firstBufferIndex = regionBuffer.getInt();
        int numBuffers = regionBuffer.getInt();
        long firstBufferOffset = regionBuffer.getLong();
        return new Builder().setGetSizeSupplier(() -> 16).setGetFirstBufferIndexSupplier(() -> firstBufferIndex).setGetRegionFileOffsetSupplier(() -> firstBufferOffset).setGetNumBuffersSupplier(() -> numBuffers).setContainBufferFunction(bufferIndex -> TestingFileDataIndexRegion.getContainBufferFunction(bufferIndex, firstBufferIndex, numBuffers)).build();
    }

    private static ByteBuffer allocateHeaderBuffer() {
        return FileRegionWriteReadUtils.allocateAndConfigureBuffer((int)16);
    }

    public static boolean getContainBufferFunction(int bufferIndex, int firstBufferIndex, int numBuffers) {
        return bufferIndex >= firstBufferIndex && bufferIndex < firstBufferIndex + numBuffers;
    }

    public static class Builder {
        private Supplier<Integer> getSizeSupplier = () -> 0;
        private Supplier<Integer> getFirstBufferIndexSupplier = () -> 0;
        private Supplier<Long> getRegionFileOffsetSupplier = () -> 0L;
        private Supplier<Long> getRegionFileEndOffsetSupplier = () -> 0L;
        private Supplier<Integer> getNumBuffersSupplier = () -> 0;
        private Function<Integer, Boolean> containBufferFunction = bufferIndex -> false;

        public Builder setGetSizeSupplier(Supplier<Integer> getSizeSupplier) {
            this.getSizeSupplier = getSizeSupplier;
            return this;
        }

        public Builder setGetFirstBufferIndexSupplier(Supplier<Integer> getFirstBufferIndexSupplier) {
            this.getFirstBufferIndexSupplier = getFirstBufferIndexSupplier;
            return this;
        }

        public Builder setGetRegionFileOffsetSupplier(Supplier<Long> getRegionFileOffsetSupplier) {
            this.getRegionFileOffsetSupplier = getRegionFileOffsetSupplier;
            return this;
        }

        public Builder setGetRegionFileEndOffsetSupplier(Supplier<Long> getRegionFileEndOffsetSupplier) {
            this.getRegionFileEndOffsetSupplier = getRegionFileEndOffsetSupplier;
            return this;
        }

        public Builder setGetNumBuffersSupplier(Supplier<Integer> getNumBuffersSupplier) {
            this.getNumBuffersSupplier = getNumBuffersSupplier;
            return this;
        }

        public Builder setContainBufferFunction(Function<Integer, Boolean> containBufferFunction) {
            this.containBufferFunction = containBufferFunction;
            return this;
        }

        public TestingFileDataIndexRegion build() {
            return new TestingFileDataIndexRegion(this.getSizeSupplier, this.getFirstBufferIndexSupplier, this.getRegionFileOffsetSupplier, this.getRegionFileEndOffsetSupplier, this.getNumBuffersSupplier, this.containBufferFunction);
        }
    }
}

