/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.executiongraph.failover.ExponentialDelayRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.FailureRateRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.FixedDelayRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.NoRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartBackoffTimeStrategyFactoryLoader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RestartBackoffTimeStrategyFactoryLoaderTest {
    RestartBackoffTimeStrategyFactoryLoaderTest() {
    }

    @Test
    void testNoRestartStrategySpecifiedInJobConfig() {
        Configuration jobConf = new Configuration();
        jobConf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.NO_RESTART_STRATEGY.getMainValue());
        Configuration clusterConf = new Configuration();
        clusterConf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.FIXED_DELAY.getMainValue());
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((Configuration)jobConf, (Configuration)clusterConf, (boolean)false);
        Assertions.assertThat((Comparable)NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.INSTANCE).isEqualTo((Object)factory);
    }

    @Test
    void testFixedDelayStrategySpecifiedInJobConfig() {
        Configuration jobConf = new Configuration();
        jobConf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.FIXED_DELAY.getMainValue());
        Configuration clusterConf = new Configuration();
        clusterConf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.EXPONENTIAL_DELAY.getMainValue());
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((Configuration)jobConf, (Configuration)clusterConf, (boolean)false);
        Assertions.assertThat((Object)factory).isInstanceOf(FixedDelayRestartBackoffTimeStrategy.FixedDelayRestartBackoffTimeStrategyFactory.class);
    }

    @Test
    void testExponentialDelayStrategySpecifiedInJobConfig() {
        Configuration jobConf = new Configuration();
        jobConf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.EXPONENTIAL_DELAY.getMainValue());
        Configuration clusterConf = new Configuration();
        clusterConf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.FAILURE_RATE.getMainValue());
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((Configuration)jobConf, (Configuration)clusterConf, (boolean)false);
        Assertions.assertThat((Object)factory).isInstanceOf(ExponentialDelayRestartBackoffTimeStrategy.ExponentialDelayRestartBackoffTimeStrategyFactory.class);
    }

    @Test
    void testFailureRateStrategySpecifiedInJobConfig() {
        Configuration jobConf = new Configuration();
        jobConf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.FAILURE_RATE.getMainValue());
        Configuration clusterConf = new Configuration();
        clusterConf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.FIXED_DELAY.getMainValue());
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((Configuration)jobConf, (Configuration)clusterConf, (boolean)false);
        Assertions.assertThat((Object)factory).isInstanceOf(FailureRateRestartBackoffTimeStrategy.FailureRateRestartBackoffTimeStrategyFactory.class);
    }

    @Test
    void testInvalidStrategySpecifiedInJobConfig() {
        Configuration conf = new Configuration();
        conf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"invalid-strategy");
        Assertions.assertThatThrownBy(() -> RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((Configuration)conf, (Configuration)new Configuration(), (boolean)false)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testNoRestartStrategySpecifiedInClusterConfig() {
        Configuration conf = new Configuration();
        conf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.NO_RESTART_STRATEGY.getMainValue());
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((Configuration)new Configuration(), (Configuration)conf, (boolean)false);
        Assertions.assertThat((Comparable)NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.INSTANCE).isEqualTo((Object)factory);
    }

    @Test
    void testFixedDelayStrategySpecifiedInClusterConfig() {
        Configuration conf = new Configuration();
        conf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.FIXED_DELAY.getMainValue());
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((Configuration)new Configuration(), (Configuration)conf, (boolean)false);
        Assertions.assertThat((Object)factory).isInstanceOf(FixedDelayRestartBackoffTimeStrategy.FixedDelayRestartBackoffTimeStrategyFactory.class);
    }

    @Test
    void testExponentialDelayStrategySpecifiedInClusterConfig() {
        Configuration conf = new Configuration();
        conf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.EXPONENTIAL_DELAY.getMainValue());
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((Configuration)new Configuration(), (Configuration)conf, (boolean)false);
        Assertions.assertThat((Object)factory).isInstanceOf(ExponentialDelayRestartBackoffTimeStrategy.ExponentialDelayRestartBackoffTimeStrategyFactory.class);
    }

    @Test
    void testFailureRateStrategySpecifiedInClusterConfig() {
        Configuration conf = new Configuration();
        conf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)RestartStrategyOptions.RestartStrategyType.FAILURE_RATE.getMainValue());
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((Configuration)new Configuration(), (Configuration)conf, (boolean)false);
        Assertions.assertThat((Object)factory).isInstanceOf(FailureRateRestartBackoffTimeStrategy.FailureRateRestartBackoffTimeStrategyFactory.class);
    }

    @Test
    void testInvalidStrategySpecifiedInClusterConfig() {
        Configuration conf = new Configuration();
        conf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"invalid-strategy");
        Assertions.assertThatThrownBy(() -> RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((Configuration)new Configuration(), (Configuration)conf, (boolean)false)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testNoStrategySpecifiedWhenCheckpointingEnabled() {
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((Configuration)new Configuration(), (Configuration)new Configuration(), (boolean)true);
        RestartBackoffTimeStrategy strategy = factory.create();
        Assertions.assertThat((Object)strategy).isInstanceOf(ExponentialDelayRestartBackoffTimeStrategy.class);
        ExponentialDelayRestartBackoffTimeStrategy exponentialDelayStrategy = (ExponentialDelayRestartBackoffTimeStrategy)strategy;
        Assertions.assertThat((long)exponentialDelayStrategy.getInitialBackoffMS()).isEqualTo(((Duration)RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF.defaultValue()).toMillis());
        Assertions.assertThat((long)exponentialDelayStrategy.getMaxBackoffMS()).isEqualTo(((Duration)RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF.defaultValue()).toMillis());
        Assertions.assertThat((double)exponentialDelayStrategy.getBackoffMultiplier()).isEqualTo((Double)RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_BACKOFF_MULTIPLIER.defaultValue());
        Assertions.assertThat((long)exponentialDelayStrategy.getResetBackoffThresholdMS()).isEqualTo(((Duration)RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_RESET_BACKOFF_THRESHOLD.defaultValue()).toMillis());
        Assertions.assertThat((double)exponentialDelayStrategy.getJitterFactor()).isEqualTo((Double)RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_JITTER_FACTOR.defaultValue());
        Assertions.assertThat((int)exponentialDelayStrategy.getAttemptsBeforeResetBackoff()).isEqualTo(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_ATTEMPTS.defaultValue());
    }

    @Test
    void testNoStrategySpecifiedWhenCheckpointingDisabled() {
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((Configuration)new Configuration(), (Configuration)new Configuration(), (boolean)false);
        Assertions.assertThat((Object)factory).isInstanceOf(NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.class);
    }
}

