/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Path;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.TestingBlobUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BlobServerRangeTest {
    @TempDir
    private Path tempDir;

    BlobServerRangeTest() {
    }

    @Test
    void testOnEphemeralPort() throws IOException {
        Configuration conf = new Configuration();
        conf.set(BlobServerOptions.PORT, (Object)"0");
        BlobServer server = TestingBlobUtils.createServer(this.tempDir, conf);
        server.start();
        server.close();
    }

    @Test
    void testPortUnavailable() throws IOException {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception was thrown while preparing the test " + e.getMessage()));
        }
        Configuration conf = new Configuration();
        conf.set(BlobServerOptions.PORT, (Object)String.valueOf(socket.getLocalPort()));
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestingBlobUtils.createServer(this.tempDir, conf)).isInstanceOf(IOException.class)).hasMessageStartingWith("Unable to open BLOB Server in specified port range: ");
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testOnePortAvailable() throws IOException {
        int numAllocated = 2;
        ServerSocket[] sockets = new ServerSocket[numAllocated];
        for (int i = 0; i < numAllocated; ++i) {
            try {
                sockets[i] = new ServerSocket(0);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                Assertions.fail((String)("An exception was thrown while preparing the test " + e.getMessage()));
            }
        }
        Configuration conf = new Configuration();
        conf.set(BlobServerOptions.PORT, (Object)(sockets[0].getLocalPort() + "," + sockets[1].getLocalPort() + ",50000-50050"));
        try {
            BlobServer server = TestingBlobUtils.createServer(this.tempDir, conf);
            server.start();
            Assertions.assertThat((int)server.getPort()).isBetween(Integer.valueOf(50000), Integer.valueOf(50050));
            server.close();
        }
        finally {
            for (int i = 0; i < numAllocated; ++i) {
                sockets[i].close();
            }
        }
    }
}

