/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.classloading.SubmoduleClassLoader;
import org.apache.flink.runtime.rpc.CleanupOnCloseRpcSystem;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.RpcSystemLoader;
import org.apache.flink.runtime.rpc.exceptions.RpcLoaderException;
import org.apache.flink.util.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackPekkoRpcSystemLoader
implements RpcSystemLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FallbackPekkoRpcSystemLoader.class);
    private static final String MODULE_FLINK_RPC = "flink-rpc";
    private static final String MODULE_FLINK_RPC_PEKKO = "flink-rpc-akka";

    public int getLoadPriority() {
        return 1;
    }

    public RpcSystem loadRpcSystem(Configuration config) {
        try {
            LOG.debug("Using Fallback PekkoRpcSystemLoader; this loader will invoke maven to retrieve the dependencies of flink-rpc-akka.");
            ClassLoader flinkClassLoader = RpcSystem.class.getClassLoader();
            Path pekkoRpcModuleDirectory = FallbackPekkoRpcSystemLoader.findPekkoRpcModuleDirectory(FallbackPekkoRpcSystemLoader.getCurrentWorkingDirectory());
            Path pekkoRpcModuleClassesDirectory = pekkoRpcModuleDirectory.resolve(Paths.get("target", "classes"));
            Path pekkoRpcModuleDependenciesDirectory = pekkoRpcModuleDirectory.resolve(Paths.get("target", "dependencies"));
            if (!Files.exists(pekkoRpcModuleDependenciesDirectory, new LinkOption[0])) {
                int exitCode = FallbackPekkoRpcSystemLoader.downloadDependencies(pekkoRpcModuleDirectory, pekkoRpcModuleDependenciesDirectory);
                if (exitCode != 0) {
                    throw new RpcLoaderException("Could not download dependencies of flink-rpc-akka, please see the log output for details.");
                }
            } else {
                LOG.debug("Re-using previously downloaded flink-rpc-akka dependencies. If you are experiencing strange issues, try clearing '{}'.", (Object)pekkoRpcModuleDependenciesDirectory);
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(pekkoRpcModuleClassesDirectory.toUri().toURL());
            try (Stream<Path> files = Files.list(pekkoRpcModuleDependenciesDirectory);){
                List collect = files.filter(path -> path.getFileName().toString().endsWith(".jar")).collect(Collectors.toList());
                for (Path path2 : collect) {
                    urls.add(path2.toUri().toURL());
                }
            }
            SubmoduleClassLoader submoduleClassLoader = new SubmoduleClassLoader(urls.toArray(new URL[0]), flinkClassLoader);
            return new CleanupOnCloseRpcSystem(ServiceLoader.load(RpcSystem.class, (ClassLoader)submoduleClassLoader).iterator().next(), submoduleClassLoader, null);
        }
        catch (Exception e) {
            throw new RpcLoaderException(String.format("Could not initialize RPC system. Run '%s' on the command-line instead.", "mvn clean package -pl flink-rpc/flink-rpc-akka,flink-rpc/flink-rpc-akka-loader -DskipTests"), (Throwable)e);
        }
    }

    private static Path getCurrentWorkingDirectory() {
        return Paths.get("", new String[0]).toAbsolutePath();
    }

    private static Path findPekkoRpcModuleDirectory(Path currentParentCandidate) throws IOException {
        try (Stream<Path> directoryContents = Files.list(currentParentCandidate);){
            Optional<Path> flinkRpcModuleDirectory = directoryContents.filter(path -> path.getFileName().toString().equals(MODULE_FLINK_RPC)).findFirst();
            if (flinkRpcModuleDirectory.isPresent()) {
                Path path2 = flinkRpcModuleDirectory.map(path -> path.resolve(Paths.get(MODULE_FLINK_RPC_PEKKO, new String[0]))).get();
                return path2;
            }
        }
        return FallbackPekkoRpcSystemLoader.findPekkoRpcModuleDirectory(currentParentCandidate.getParent());
    }

    private static int downloadDependencies(Path workingDirectory, Path targetDirectory) throws IOException, InterruptedException {
        String mvnExecutable = OperatingSystem.isWindows() ? "mvn.bat" : "mvn";
        ProcessBuilder mvn = new ProcessBuilder(new String[0]).directory(workingDirectory.toFile()).command(mvnExecutable, "dependency:copy-dependencies", "-DincludeScope=runtime", "-DoutputDirectory=" + String.valueOf(targetDirectory)).redirectOutput(ProcessBuilder.Redirect.INHERIT);
        return mvn.start().waitFor();
    }
}

