/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.neeve.aep.AepBusConnectionStats;
import com.neeve.aep.AepConfig;
import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.AepSendCommitCompletionEvent;
import com.neeve.aep.AepSendEvent;
import com.neeve.aep.EAepException;
import com.neeve.aep.event.AepBusBindingDownEvent;
import com.neeve.aep.event.AepBusBindingOpenFailedEvent;
import com.neeve.aep.event.AepBusBindingOpenedEvent;
import com.neeve.aep.event.AepBusBindingOpeningEvent;
import com.neeve.aep.event.AepBusBindingUpEvent;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepDuplicateAcknowledgementAlertEvent;
import com.neeve.aep.event.AepSendExceptionEvent;
import com.neeve.config.Config;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxTimeoutException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxDispatcherRunCompletionChecker;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.log.RogMessageLog;
import com.neeve.root.RootConfig;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusBindingFactory;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.event.MessageBusBindingFailedEvent;
import com.neeve.sma.event.MessageEvent;
import com.neeve.sma.event.MessageStabilityEvent;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlDisruptor;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;

public final class AepBusConnection
extends UtlListElement
implements IEventHandler {
    private final MessageBusBinding.StatsListener statsListener = new MessageBusBinding.StatsListener(){

        public final void onAck() {
            ++((AepBusConnection)AepBusConnection.this).stats.numAcksSent;
        }
    };
    public static final String PROPNAME_USER_NAME = "user_name";
    public static final String PROPNAME_PROVIDER_DESCRIPTOR = "provider_descriptor";
    static final String PROPNAME_ADMINISTRATIVE = "administrative";
    static final boolean PROPNAME_ADMINISTRATIVE_DEFAULT = false;
    static final String PROPNAME_MANUAL_START = "manual_start";
    static final boolean PROPNAME_MANUAL_START_DEFAULT = false;
    public static final String PROPNAME_RECONNECT_ON_FAIL = "reconnect_on_fail";
    public static final boolean PROPNAME_RECONNECT_ON_FAIL_DEFAULT = false;
    public static final String PROPNAME_SEND_EXCEPTION_HANDLING_POLICY = "send_exception_handling_policy";
    public static final String PROPNAME_SEND_EXCEPTION_HANDLING_POLICY_DEFAULT = AepEngine.MessageSendExceptionHandlingPolicy.TreatAsStabilityFailure.toString();
    public static final String PROPNAME_BINDING_OPEN_RETRY_INTERVAL = "binding_open_retry_interval";
    public static final int PROPNAME_BINDING_OPEN_RETRY_INTERVAL_DEFAULT = 5;
    public static final String PROPNAME_DETACHED = "detachedCommit";
    public static final boolean PROPNAME_DETACHED_DEFAULT = false;
    public static final String PROPNAME_DETACHED_QUEUE_DEPTH = "queueDepth";
    public static final int PROPNAME_DETACHED_QUEUE_DEPTH_DEFAULT = 1024;
    public static final String PROPNAME_DETACHED_QUEUE_OFFER_STRATEGY = "queueOfferStrategy";
    public static final String PROPNAME_DETACHED_QUEUE_OFFER_STRATEGY_DEFAULT = "SingleThreaded";
    public static final String PROPNAME_DETACHED_QUEUE_WAIT_STRATEGY = "queueWaitStrategy";
    public static final String PROPNAME_DETACHED_QUEUE_WAIT_STRATEGY_DEFAULT = null;
    public static final String PROPNAME_DETACHED_QUEUE_DRAINER_AFFINITY_MASK = "queueDrainerCpuAffinityMask";
    public static final String PROPNAME_DETACHED_QUEUE_DRAINER_AFFINITY_MASK_DEFAULT = "0";
    public static final String PROPNAME_ENABLE_OUTBOUND_LOG = "enableOutboundLog";
    public static final boolean PROPNAME_ENABLE_OUTBOUND_LOG_DEFAULT = false;
    public static final String PROPNAME_OUTBOUND_LOG_DIRECTORY = "outboundLogDirectory";
    public static final String PROPNAME_OUTBOUND_LOG_NAME = "outboundLogName";
    public static final String PROPNAME_OUTBOUND_LOG_FLUSH_ON_COMMIT = "outboundLogFlushOnCommit";
    public static final String PROPNAME_OUTBOUND_LOG_FLUSH_USING_MAPPED_MEMORY = "outboundLogFlushUsingMappedMemory";
    public static final String PROPNAME_OUTBOUND_LOG_WRITE_BUFFER_SIZE = "outboundLogWriteBufferSize";
    public static final String PROPNAME_OUTBOUND_LOG_AUTO_REPAIR = "outboundLogAutoRepair";
    public static final String PROPNAME_OUTBOUND_LOG_INITIAL_LOG_LENGTH = "outboundLogInitialLogLength";
    public static final String PROPNAME_OUTBOUND_LOG_ZERO_OUT_INITIAL = "outboundLogZeroOutInitial";
    public static final String PROPNAME_OUTBOUND_LOG_PAGE_SIZE = "outboundLogPageSize";
    private final int id;
    private final String appName;
    private final String name;
    private final MessageBusDescriptor busDescriptor;
    private final Map<String, AepEngineDescriptor.ChannelConfig> channelsConfig;
    private final IEventHandler eventHandler;
    private final Map<String, MessageChannel> channels;
    private final OutboundQueue oq;
    private final BindingOpener bindingOpener;
    private final AepBusConnectionStats stats;
    private final boolean administrative;
    private final boolean manualStart;
    private final boolean reconnectOnFail;
    private final AepEngine.MessageSendExceptionHandlingPolicy sendExceptionHandlingPolicy;
    private final Tracer tracer;
    private final MessageTracer msgTracer;
    private final String tracePrefix;
    private final int openRetryInterval;
    private final String userName;
    private MessageBusBinding binding;
    private boolean acksRequireFlush;
    private State state;

    private AepBusConnection(String appName, int id, MessageBusDescriptor busDescriptor, Map<String, AepEngineDescriptor.ChannelConfig> channelsConfig, IEventHandler eventHandler, MessageBusBinding.SequenceNumberGenerator snoGenerator, Properties props, MessageTracer msgTracer, String tracePrefix) throws Exception {
        if (props == null) {
            props = new Properties();
        }
        this.appName = appName;
        this.name = appName + "." + busDescriptor.getName();
        this.userName = UtlProps.getValue((Properties)props, (String)PROPNAME_USER_NAME, (String)appName);
        this.id = id;
        this.busDescriptor = this.updateBusDescriptorWithAppChannelConfig(busDescriptor, channelsConfig);
        this.channelsConfig = this.updateChannelsConfigForCatchallChannel(busDescriptor, channelsConfig);
        String busProviderDescriptor = UtlProps.getValue((Properties)props, (String)PROPNAME_PROVIDER_DESCRIPTOR, null);
        if (busProviderDescriptor != null) {
            busDescriptor.setProviderConfig(busProviderDescriptor);
        }
        this.eventHandler = eventHandler;
        this.channels = new LinkedHashMap<String, MessageChannel>();
        this.administrative = UtlProps.getValue((Properties)props, (String)PROPNAME_ADMINISTRATIVE, (boolean)false);
        this.manualStart = UtlProps.getValue((Properties)props, (String)PROPNAME_MANUAL_START, (boolean)false);
        this.reconnectOnFail = UtlProps.getValue((Properties)props, (String)PROPNAME_RECONNECT_ON_FAIL, (boolean)false);
        this.sendExceptionHandlingPolicy = AepEngine.MessageSendExceptionHandlingPolicy.valueOf(UtlProps.getValue((Properties)props, (String)PROPNAME_SEND_EXCEPTION_HANDLING_POLICY, (String)PROPNAME_SEND_EXCEPTION_HANDLING_POLICY_DEFAULT));
        this.openRetryInterval = UtlProps.getValue((Properties)props, (String)PROPNAME_BINDING_OPEN_RETRY_INTERVAL, (int)5);
        this.tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)AepConfig.getConfig());
        this.msgTracer = msgTracer;
        this.tracePrefix = tracePrefix != null ? tracePrefix : "Bus Connection [" + appName + "]";
        this.oq = new OutboundQueue(snoGenerator, props);
        this.bindingOpener = new BindingOpener();
        this.bindingOpener.setDaemon(true);
        this.stats = new AepBusConnectionStats(this, this.name, "nv.aep.busconnection." + this.name + ".stats.interval");
        this.setState(State.CREATED, null);
    }

    private final MessageBusDescriptor updateBusDescriptorWithAppChannelConfig(MessageBusDescriptor busDescriptor, Map<String, AepEngineDescriptor.ChannelConfig> channelsConfig) {
        for (Map.Entry<String, AepEngineDescriptor.ChannelConfig> channelConfig : channelsConfig.entrySet()) {
            MessageChannelDescriptor channelDescriptor = busDescriptor.getChannel(channelConfig.getKey());
            if (channelConfig.getValue().getFilter() != null) {
                channelDescriptor.setChannelFilter(channelConfig.getValue().getFilter());
            }
            if (channelConfig.getValue().getPreserveJoinsOnClose() == null) continue;
            channelDescriptor.setPreserveJoinsOnClose(channelConfig.getValue().getPreserveJoinsOnClose());
        }
        return busDescriptor;
    }

    private final Map<String, AepEngineDescriptor.ChannelConfig> updateChannelsConfigForCatchallChannel(MessageBusDescriptor descriptor, Map<String, AepEngineDescriptor.ChannelConfig> channelsConfig) {
        if (this.busDescriptor.configuredToAutoAddCatchallChannel()) {
            channelsConfig.put("_CATCHALL_", new AepEngineDescriptor.ChannelConfig());
        }
        return channelsConfig;
    }

    private final void setState(State state, Object object) {
        if (this.state != state) {
            State previousState = this.state;
            this.state = state;
            try {
                switch (state) {
                    case CREATED: {
                        break;
                    }
                    case OPENING: {
                        this.onPassThroughEvent((Event)AepBusBindingOpeningEvent.create(this.busDescriptor.getName()));
                        break;
                    }
                    case OPEN: {
                        this.onPassThroughEvent((Event)AepBusBindingOpenedEvent.create(this.busDescriptor.getName()));
                        break;
                    }
                    case STARTED: {
                        break;
                    }
                    case FAILED: {
                        Exception e = (Exception)object;
                        if (previousState != State.OPENING) break;
                        this.onPassThroughEvent((Event)AepBusBindingOpenFailedEvent.create(this.busDescriptor.getName(), e, false));
                        break;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private final void scheduleOpen() {
        try {
            this.setState(State.OPENING, null);
            this.bindingOpener.scheduleOpen();
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Scheduled '" + this.busDescriptor.getName() + "' bus open.", Tracer.Level.DEBUG);
            }
        }
        catch (Exception e) {
            String error = e.getMessage() == null ? e.toString() : e.getMessage();
            this.tracer.log(this.tracePrefix + " Failed to scheduled '" + this.busDescriptor.getName() + "' bus open [" + error + "] Aborting binding open....", Tracer.Level.WARNING);
            this.setState(State.FAILED, e);
        }
    }

    private final void startCore() {
        try {
            this.binding.start();
            this.setState(State.STARTED, null);
        }
        catch (SmaException e) {
            throw new RuntimeException(e);
        }
    }

    private final void processChannels(MessageBusBinding binding) {
        if (this.channelsConfig.size() > 0) {
            for (String channelName : this.channelsConfig.keySet()) {
                boolean shouldJoin = this.channelsConfig.get(channelName).getShouldJoin();
                String s1 = "...channel '" + channelName + "' (join=" + shouldJoin + ")...";
                try {
                    MessageChannel channel = binding.getMessageChannel(channelName);
                    if (shouldJoin) {
                        try {
                            channel.join(0);
                        }
                        catch (SmaException smae) {
                            this.tracer.log(this.tracePrefix + " Failed to join channel '" + channelName + "' from bus '" + this.busDescriptor.getName() + "' [" + smae.getMessage() + "]", Tracer.Level.SEVERE);
                            throw new RuntimeException(smae);
                        }
                    }
                    this.channels.put(channelName, channel);
                    s1 = s1 + "ok.";
                    if (!this.tracer.debug) continue;
                    this.tracer.log(this.tracePrefix + " " + s1, Tracer.Level.DEBUG);
                }
                catch (SmaException e) {
                    String error;
                    String string = error = e.getMessage() == null ? e.toString() : e.getMessage();
                    if (this.tracer.debug) {
                        s1 = s1 + "failed [" + error + "].";
                        this.tracer.log(this.tracePrefix + " " + s1, Tracer.Level.DEBUG);
                        continue;
                    }
                    this.tracer.log(this.tracePrefix + " Failed to get channel '" + channelName + "' from bus '" + this.busDescriptor.getName() + "' [" + error + "]", Tracer.Level.WARNING);
                }
            }
        } else if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " ...no channels configured.", Tracer.Level.DEBUG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EAepException openCore(boolean start) {
        try {
            this.binding = MessageBusBindingFactory.getInstance().createBinding(this.userName, this.busDescriptor, (IEventHandler)this);
            this.binding.setStatsListener(this.statsListener);
            this.oq.configureBinding(this.binding);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Opened binding '" + this.busDescriptor.getName() + "' (provider='" + this.busDescriptor.getProviderConfig().getProperty("Provider") + "')", Tracer.Level.DEBUG);
            }
            this.acksRequireFlush = this.binding.acksRequireFlush();
            this.binding.setAttachment((Object)this);
            AepBusConnection aepBusConnection = this;
            synchronized (aepBusConnection) {
                this.processChannels(this.binding);
                this.setState(State.OPEN, null);
                if (start) {
                    try {
                        this.startCore();
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + " Started bus '" + this.busDescriptor.getName() + "' binding.", Tracer.Level.DEBUG);
                        }
                    }
                    catch (RuntimeException e) {
                        String error = e.getMessage() == null ? e.toString() : e.getMessage();
                        this.tracer.log(this.tracePrefix + " Failed to start bus '" + this.busDescriptor.getName() + "' binding [" + error + "]", Tracer.Level.SEVERE);
                        throw e;
                    }
                }
                for (MessageChannel channel : this.channels.values()) {
                    try {
                        this.onEvent((Event)AepChannelUpEvent.create(this.binding, channel));
                    }
                    catch (Throwable e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Channel UP event processing faulted with error [" + e.toString() + "] with the following stack trace:\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                        sb.append("Ignoring...");
                        this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    }
                }
                try {
                    this.onEvent((Event)AepBusBindingUpEvent.create(this.binding));
                }
                catch (Throwable e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Bus binding UP event processing faulted with error [" + e.toString() + "] with the following stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    sb.append("Ignoring...");
                    this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                }
                return null;
            }
        }
        catch (SmaException e) {
            String error = e.getMessage() == null ? e.toString() : e.getMessage();
            this.tracer.log(this.tracePrefix + " Failed (temporary) to open bus '" + this.busDescriptor.getName() + "' (provider='" + this.busDescriptor.getProviderConfig().getProperty("Provider") + "') [" + error + "]", Tracer.Level.WARNING);
            this.onPassThroughEvent((Event)AepBusBindingOpenFailedEvent.create(this.busDescriptor.getName(), (Exception)((Object)e), true));
            return new EAepException(e);
        }
        catch (RuntimeException e) {
            this.tracer.log(this.tracePrefix + " Failed (permanent) to open bus '" + this.busDescriptor.getName() + "' (provider='" + this.busDescriptor.getProviderConfig().getProperty("Provider") + "') [" + e.toString() + "]", Tracer.Level.WARNING);
            this.setState(State.FAILED, e);
            return new EAepException(e);
        }
    }

    private final EAepException open(boolean start) {
        if (this.state == State.CREATED) {
            this.bindingOpener.start();
            this.oq.open();
            this.setState(State.OPENING, null);
            return this.openCore(start);
        }
        throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
    }

    private final void dispatchToEventHandler(Event event) {
        this.eventHandler.onEvent(event);
    }

    private final void onBindingFailure(Exception cause) {
        String error = cause.getMessage() == null ? cause.toString() : cause.getMessage();
        this.tracer.log(this.tracePrefix + " Binding to bus '" + this.busDescriptor.getName() + "' has failed [cause=" + error + "].", Tracer.Level.SEVERE);
        try {
            this.binding.close();
        }
        catch (Exception e) {
            this.tracer.log(this.tracePrefix + " Failed to close binding in cleaning up after binding failure [" + e.toString() + "].", Tracer.Level.WARNING);
        }
        ++this.stats.numBindingFailures;
        for (MessageChannel channel : this.channels.values()) {
            try {
                this.dispatchToEventHandler((Event)AepChannelDownEvent.create(this.binding, channel));
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Channel DOWN event processing faulted with error [" + e.toString() + "] with the following stack trace:\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                sb.append("Ignoring...");
                this.tracer.log(sb.toString(), Tracer.Level.WARNING);
            }
        }
        try {
            this.dispatchToEventHandler((Event)AepBusBindingDownEvent.create(this.binding, cause));
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Bus binding DOWN event processing faulted with error [" + e.toString() + "] with the following stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            sb.append("Ignoring...");
            this.tracer.log(sb.toString(), Tracer.Level.WARNING);
        }
        this.setState(State.FAILED, cause);
        if (this.reconnectOnFail) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Scheduling binding reopen.", Tracer.Level.DEBUG);
            }
            this.scheduleOpen();
        } else if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Not configured to recopen binding on failure.", Tracer.Level.DEBUG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onPassThroughEvent(Event event) {
        if (this.state == State.OPENING) {
            AepBusConnection aepBusConnection = this;
            synchronized (aepBusConnection) {
                this.dispatchToEventHandler(event);
            }
        } else {
            this.dispatchToEventHandler(event);
        }
    }

    public static final AepBusConnection create(String appName, int id, MessageBusDescriptor busDescriptor, Map<String, AepEngineDescriptor.ChannelConfig> channelsConfig, IEventHandler eventHandler, MessageBusBinding.SequenceNumberGenerator snoGenerator, Properties props, MessageTracer msgTracer, String tracePrefix) throws Exception {
        if (appName == null) {
            throw new IllegalArgumentException("app name cannot be null");
        }
        if (busDescriptor == null) {
            throw new IllegalArgumentException("bus descriptor cannot be null");
        }
        if (channelsConfig == null) {
            throw new IllegalArgumentException("channels config cannot be null");
        }
        if (eventHandler == null) {
            throw new IllegalArgumentException("event handler cannot be null");
        }
        return new AepBusConnection(appName, id, busDescriptor, channelsConfig, eventHandler, snoGenerator, props, msgTracer, tracePrefix);
    }

    public static final AepBusConnection create(String appName, MessageBusDescriptor busDescriptor, Map<String, AepEngineDescriptor.ChannelConfig> channelsConfig, IEventHandler eventHandler, Properties props) throws Exception {
        return AepBusConnection.create(appName, 0, busDescriptor, channelsConfig, eventHandler, null, props, null, null);
    }

    public final String getName() {
        return this.name;
    }

    public final String getAppName() {
        return this.appName;
    }

    public final String getUserName() {
        return this.userName;
    }

    public final int getId() {
        return this.id;
    }

    public final State getState() {
        return this.state;
    }

    public final AepBusConnectionStats getStats() {
        return this.stats;
    }

    public final MessageBusDescriptor getBusDescriptor() {
        return this.busDescriptor;
    }

    public final boolean isInternal() {
        return AepEngine.isBusBindingInternal(this.busDescriptor.getName());
    }

    final boolean isManualStart() {
        return this.manualStart;
    }

    public final boolean isReconnectOnFail() {
        return this.reconnectOnFail;
    }

    public final boolean isAcksRequireFlush() {
        return this.acksRequireFlush;
    }

    public final boolean isDetachedCommit() {
        return this.oq.isDetachedCommit();
    }

    public final int getDisruptorCapacity() {
        return this.oq.getDisruptorCapacity();
    }

    public final int getDisruptorRemaining() {
        return this.oq.getDisruptorRemaining();
    }

    public final String getDisruptorClaimStrategy() {
        return this.oq.getDisruptorClaimStrategy();
    }

    public final String getDisruptorWaitStrategy() {
        return this.oq.getDisruptorWaitStrategy();
    }

    public final MessageBusBinding getBusBinding() {
        return this.binding;
    }

    public final MessageChannel getChannel(String channelName) {
        return this.channels.get(channelName);
    }

    public final void open() throws EAepException {
        EAepException ret = this.open(true);
        if (ret != null) {
            throw ret;
        }
    }

    public final EAepException openNoStart() {
        return this.open(false);
    }

    public final void start() {
        switch (this.state) {
            case OPENING: {
                this.scheduleOpen();
                break;
            }
            case OPEN: {
                this.startCore();
                break;
            }
            case FAILED: {
                break;
            }
            default: {
                throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
            }
        }
    }

    public final void enque(MessageChannel channel, IRogMessage message, int flags) {
        this.oq.enque(channel, message, flags);
        ++this.stats.numMsgsEnqueued;
    }

    public final OutboundQueue.Slice complete(OutboundQueue.Slice slice) {
        return this.oq.complete(slice);
    }

    public final void commit(OutboundQueue.Slice slice, AepSendCommitCompletionEvent event, long sendTs) {
        this.oq.commit(slice, event, sendTs);
    }

    public final void commit(AepSendCommitCompletionEvent event, long sendTs) {
        this.commit(null, event, sendTs);
    }

    public final void setSavepoint(int savepoint) {
        this.oq.setCurrentSavepoint(savepoint);
    }

    public final void resetSavepoint() {
        this.oq.currentSavepoint = 0;
    }

    public final void rollback() {
        this.oq.rollback();
    }

    public final void rollback(int savepoint) {
        this.oq.rollback(savepoint);
    }

    public final void send(MessageChannel channel, IRogMessage message, int flags) throws SmaException {
        this.oq.send(channel, message, flags, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(Exception cause, boolean preserveChannelJoins) {
        if (this.state != State.CLOSED) {
            try {
                this.bindingOpener.shutdown();
                if (this.state != State.FAILED && (this.state == State.OPEN || this.state == State.STARTED)) {
                    try {
                        int closeFlags;
                        int n = closeFlags = preserveChannelJoins ? 1 : 0;
                        if (cause == null || !this.binding.canFail()) {
                            this.binding.close(closeFlags);
                        } else {
                            this.binding.fail(cause, false);
                        }
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + " Closed bus '" + this.busDescriptor.getName() + "'.", Tracer.Level.DEBUG);
                        }
                    }
                    catch (SmaException e) {
                        String error = e.getMessage() == null ? e.toString() : e.getMessage();
                        this.tracer.log(this.tracePrefix + " Failed to close bus '" + this.busDescriptor.getName() + "' [" + error + "]", Tracer.Level.WARNING);
                    }
                }
                this.oq.close();
                this.stats.close();
            }
            finally {
                this.setState(State.CLOSED, null);
            }
        }
    }

    public final void onEvent(Event event) {
        switch (event.getType()) {
            case 105: {
                ++this.stats.numMsgsRcvd;
                this.onPassThroughEvent(event);
                break;
            }
            case 102: {
                MessageBusBindingFailedEvent bindingFailedEvent = (MessageBusBindingFailedEvent)event;
                this.onBindingFailure(bindingFailedEvent.getCause());
                break;
            }
            case 104: {
                MessageStabilityEvent stabilityEvent = (MessageStabilityEvent)event;
                if (this.oq.onStability(stabilityEvent)) break;
                this.onPassThroughEvent(event);
                break;
            }
            default: {
                this.onPassThroughEvent(event);
            }
        }
    }

    public final String toString() {
        return "AEPBusConnection [app=" + this.appName + ", bus=" + this.busDescriptor.getName() + ", state=" + (Object)((Object)this.state) + "]";
    }

    public static interface MessageTracer {
        public boolean debug();

        public void trace(String var1, IRogMessage var2);
    }

    final class OutboundQueue {
        private final String claimStrategyStr;
        private final String waitStrategyStr;
        private final Disruptor<CarrierEvent> disruptor;
        private final RingBuffer<CarrierEvent> ringBuffer;
        private final Logger logger;
        private final boolean detachedCommit;
        private final long writerCpuAffinityMask;
        private WriterThread writerThread;
        private Slice uncommitted;
        private int currentSavepoint;

        OutboundQueue(MessageBusBinding.SequenceNumberGenerator snoGenerator, Properties props) {
            if (((AepBusConnection)AepBusConnection.this).tracer.debug) {
                AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " Creating outbound queue for bus connection '" + AepBusConnection.this.name + "...", Tracer.Level.DEBUG);
            }
            this.logger = new Logger(snoGenerator, props);
            this.uncommitted = new Slice();
            boolean bl = this.detachedCommit = UtlProps.getValue((Properties)props, (String)AepBusConnection.PROPNAME_DETACHED, (String)UtlProps.getValue((Properties)props, (String)"detachedSend", null)) == null && (Config.compatibleWith3x() && Config.tuneForLatency() || Config.tuneForThroughput()) && !AepBusConnection.this.administrative ? true : UtlProps.getValue((Properties)props, (String)AepBusConnection.PROPNAME_DETACHED, (boolean)UtlProps.getValue((Properties)props, (String)"detachedSend", (boolean)false));
            if (this.detachedCommit) {
                int queueDepth = UtlProps.getValue((Properties)props, (String)AepBusConnection.PROPNAME_DETACHED_QUEUE_DEPTH, (int)1024);
                ProducerType producerType = UtlDisruptor.legacyClaimStrategyStrToProducerType((String)(Config.tuneForLatency() || Config.tuneForThroughput() ? AepBusConnection.PROPNAME_DETACHED_QUEUE_OFFER_STRATEGY_DEFAULT : UtlProps.getValue((Properties)props, (String)AepBusConnection.PROPNAME_DETACHED_QUEUE_OFFER_STRATEGY, (String)AepBusConnection.PROPNAME_DETACHED_QUEUE_OFFER_STRATEGY_DEFAULT)));
                this.claimStrategyStr = UtlDisruptor.toProducerTypeStr((ProducerType)producerType);
                WaitStrategy waitStrategy = UtlDisruptor.getWaitStrategy((String)UtlProps.getValue((Properties)props, (String)AepBusConnection.PROPNAME_DETACHED_QUEUE_WAIT_STRATEGY, (String)PROPNAME_DETACHED_QUEUE_WAIT_STRATEGY_DEFAULT), (!AepBusConnection.this.administrative ? 1 : 0) != 0);
                this.waitStrategyStr = UtlDisruptor.waitStrategyToStr((WaitStrategy)waitStrategy);
                this.writerCpuAffinityMask = UtlThread.parseAffinityMask((String)UtlProps.getValue((Properties)props, (String)AepBusConnection.PROPNAME_DETACHED_QUEUE_DRAINER_AFFINITY_MASK, (String)UtlThread.getDefaultCPUAffinityMask()));
                if (((AepBusConnection)AepBusConnection.this).tracer.debug) {
                    AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " ...operating in detached mode (background sends)...", Tracer.Level.DEBUG);
                    AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " ......queue depth=" + queueDepth + ".", Tracer.Level.DEBUG);
                    AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " ......queue offer strategy=" + this.claimStrategyStr + ".", Tracer.Level.DEBUG);
                    AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " ......queue wait strategy=" + this.waitStrategyStr + ".", Tracer.Level.DEBUG);
                    AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " ......queue drainer cpu affinity=" + this.writerCpuAffinityMask + ".", Tracer.Level.DEBUG);
                }
                this.disruptor = UtlDisruptor.createSingleConsumerDisruptor((EventFactory)new CarrierEventFactory(), (int)queueDepth, (ThreadFactory)new WriterThreadFactory(), (ProducerType)producerType, (WaitStrategy)waitStrategy, (EventHandler)new CarrierEventProcessor());
                this.ringBuffer = this.disruptor.getRingBuffer();
            } else {
                if (((AepBusConnection)AepBusConnection.this).tracer.debug) {
                    AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " ...operating in attached mode (foreground sends)...", Tracer.Level.DEBUG);
                }
                this.claimStrategyStr = "N/A";
                this.waitStrategyStr = "N/A";
                this.writerCpuAffinityMask = 0L;
                this.disruptor = null;
                this.ringBuffer = null;
            }
        }

        private final void commit(Slice completed) {
            try {
                if (!completed.send()) {
                    AepBusConnection.this.binding.flush();
                }
            }
            catch (SmaException smaException) {
                // empty catch block
            }
        }

        final void open() {
            this.logger.open();
            if (this.detachedCommit) {
                this.disruptor.start();
            }
        }

        final void configureBinding(MessageBusBinding binding) {
            binding.setSequenceNumberGenerator((MessageBusBinding.SequenceNumberGenerator)this.logger);
            binding.setPostMessagePrepProcessor((MessageBusBinding.PostMessagePrepProcessor)this.logger);
        }

        final boolean isDetachedCommit() {
            return this.detachedCommit;
        }

        final int getDisruptorCapacity() {
            return this.detachedCommit ? this.ringBuffer.getBufferSize() : 0;
        }

        final int getDisruptorRemaining() {
            return this.detachedCommit ? (int)this.ringBuffer.remainingCapacity() : 0;
        }

        final String getDisruptorClaimStrategy() {
            return this.claimStrategyStr;
        }

        final String getDisruptorWaitStrategy() {
            return this.waitStrategyStr;
        }

        final boolean send(MessageChannel channel, IRogMessage message, int flags, long sendTs) throws SmaException {
            if (sendTs > 0L) {
                if (message.getSendTs() == 0L) {
                    message.setSendTs(sendTs);
                }
                if (message.getSendStartTs() == 0L) {
                    message.setSendStartTs(UtlTime.now());
                }
            }
            MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.o, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)message);
            boolean flushed = channel.sendMessage((MessageView)message, flags);
            if (AepBusConnection.this.msgTracer != null && AepBusConnection.this.msgTracer.debug()) {
                AepBusConnection.this.msgTracer.trace("[MSG-OUT]", message);
            }
            ++((AepBusConnection)AepBusConnection.this).stats.numMsgsSent;
            return flushed;
        }

        final Slice enque(MessageChannel channel, IRogMessage message, int flags, Slice slice) {
            if (message.getMessageBusAsRaw() == null) {
                message.setMessageBusAsRaw(channel.getMessageBusBinding().getNameAsRaw());
            }
            if (message.getMessageChannelAsRaw() == null) {
                message.setMessageChannelAsRaw(channel.getNameAsRaw());
            }
            SliceElement sliceElement = slice.allocElement(channel, message, flags, this.currentSavepoint);
            if (message.getIsPriority()) {
                slice.priorityAppend(sliceElement);
            } else {
                slice.append(sliceElement);
            }
            return slice;
        }

        final Slice enque(MessageChannel channel, IRogMessage message, int flags) {
            return this.enque(channel, message, flags, this.uncommitted);
        }

        final Slice complete(Slice slice) {
            Slice completed = this.uncommitted;
            this.uncommitted = slice != null ? slice.reset() : new Slice();
            this.currentSavepoint = 0;
            return completed;
        }

        final void commit(Slice slice, AepSendCommitCompletionEvent event, long sendTs) {
            ++((AepBusConnection)AepBusConnection.this).stats.numCommits;
            Slice completed = slice.setCommitCompletionEvent(event).setSendTs(sendTs);
            if (((AepBusConnection)AepBusConnection.this).tracer.debug) {
                if (slice == null) {
                    AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " Committing uncommitted queue (size=" + completed.elements.count() + ")...", Tracer.Level.DEBUG);
                } else {
                    AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " Committing completed queue (size=" + completed.elements.count() + ")...", Tracer.Level.DEBUG);
                }
            }
            if (this.detachedCommit) {
                long sequence = this.ringBuffer.next();
                CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
                carrierEvent.type = 1;
                carrierEvent.completed = completed;
                carrierEvent.publishTs = UtlTime.now();
                this.ringBuffer.publish(sequence);
            } else {
                this.commit(completed);
            }
        }

        final void setCurrentSavepoint(int savepoint) {
            if (savepoint < 0) {
                throw new IllegalArgumentException("Bus connection savepoints must be greater than or equal to 0");
            }
            if (savepoint < this.currentSavepoint) {
                throw new IllegalArgumentException("Bus connection savepoint cannot be set lower than current savepoint (cur=" + this.currentSavepoint + ", new=" + savepoint);
            }
            this.currentSavepoint = savepoint;
        }

        final void rollback() {
            this.rollback(-1);
        }

        final void rollback(int savepoint) {
            if (savepoint < 0) {
                ++((AepBusConnection)AepBusConnection.this).stats.numRollbacks;
                this.uncommitted.rollback(savepoint);
                this.currentSavepoint = 0;
            } else if (savepoint >= this.currentSavepoint) {
                ++((AepBusConnection)AepBusConnection.this).stats.numPartialRollbacks;
                this.uncommitted.rollback(savepoint);
                this.currentSavepoint = savepoint;
            } else {
                throw new IllegalArgumentException("Invalid rollback savepoint '" + savepoint + "' (current savepoint is '" + this.currentSavepoint + "')");
            }
        }

        final boolean onStability(MessageStabilityEvent stabilityEvent) {
            MessageView view = stabilityEvent.getMessageView();
            Object object = view.getTag(2);
            if (object != null && object instanceof SliceElement) {
                ++((AepBusConnection)AepBusConnection.this).stats.numStabilityRcvd;
                if (((AepBusConnection)AepBusConnection.this).tracer.debug) {
                    AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + "message stabilized type=" + view.getClass().getSimpleName() + ", channel=" + view.getMessageChannel() + ", sno=" + view.getMessageSequenceNumber(), Tracer.Level.DEBUG);
                }
                SliceElement element = (SliceElement)((Object)object);
                if (element.slice != null) {
                    element.slice.onStability(element, stabilityEvent);
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("\nEncountered orphan slice element on stability (duplicate ack?)").append("\n");
                    sb.append("Stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)new Exception()));
                    sb.append("Logging exception and continuing...\n");
                    AepBusConnection.this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                    try {
                        view.acquire();
                        sb.append("Acknowledged message:\n");
                        sb.append(view.toString()).append("\n");
                    }
                    catch (Throwable e) {
                        sb.append("*** Failed to acquire a reference to the message to dump its contents [" + e.toString() + "] ***").append("\n");
                    }
                    try {
                        AepBusConnection.this.onEvent((Event)AepDuplicateAcknowledgementAlertEvent.create());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
            if (((AepBusConnection)AepBusConnection.this).tracer.debug) {
                AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + "message stabilized (no slice) type=" + view.getClass().getSimpleName() + ", channel=" + view.getMessageChannel() + ", sno=" + view.getMessageSequenceNumber(), Tracer.Level.DEBUG);
            }
            return false;
        }

        final void close() {
            if (this.detachedCommit && this.writerThread != null) {
                while (this.writerThread.isAlive()) {
                    try {
                        this.disruptor.halt();
                        this.writerThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                UtlThread.deregister((Thread)this.writerThread);
            }
            this.logger.close();
        }

        private final class WriterThreadFactory
        implements ThreadFactory {
            private WriterThreadFactory() {
            }

            @Override
            public final Thread newThread(Runnable r) {
                return OutboundQueue.this.writerThread = new WriterThread("X-AEP-BusConnection-IO-" + AepBusConnection.this.name, r);
            }
        }

        private final class WriterThread
        extends Thread {
            private final Runnable r;

            WriterThread(String name, Runnable r) {
                this.setDaemon(true);
                this.setName(name);
                this.r = r;
            }

            @Override
            public final void run() {
                UtlThread.setCPUAffinityMask((long)OutboundQueue.this.writerCpuAffinityMask);
                try {
                    this.r.run();
                }
                catch (RuntimeException thrown) {
                    AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + "Uncaught bus connection writer event loop exception: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                    throw thrown;
                }
                catch (Error thrown) {
                    AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + "Uncaught bus connection writer event loop error: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                    throw thrown;
                }
            }
        }

        private final class CarrierEventProcessor
        implements EventHandler<CarrierEvent> {
            private CarrierEventProcessor() {
            }

            public final void onEvent(CarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
                ((AepBusConnection)AepBusConnection.this).stats.o2p.add((double)(UtlTime.now() - event.publishTs));
                switch (event.type) {
                    case 1: {
                        OutboundQueue.this.commit(event.completed);
                    }
                }
            }
        }

        private final class CarrierEventFactory
        implements EventFactory<CarrierEvent> {
            private CarrierEventFactory() {
            }

            public final CarrierEvent newInstance() {
                return new CarrierEvent();
            }
        }

        private final class CarrierEvent {
            static final int COMMIT = 1;
            long publishTs;
            int type;
            Slice completed;

            private CarrierEvent() {
            }
        }

        final class Slice {
            private final UtlList elements = UtlList.create();
            private final UtlList pool = UtlList.create();
            private SliceElement priorityTail;
            private int numPendingStability;
            private long sendTs;
            private AepSendCommitCompletionEvent commitCompletionEvent;

            Slice() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Exception processSendException(MessageChannel channel, IRogMessage message, SliceElement element, Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Failed to send message through channel '" + channel.getName() + "' [" + e.toString() + "].\n");
                sb.append("Stack trace:\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                try {
                    sb.append("Message:\n");
                    sb.append(message.metadataToString()).append("\n");
                    sb.append(message.toString()).append("\n");
                    Exception status = null;
                    switch (AepBusConnection.this.sendExceptionHandlingPolicy) {
                        case LogExceptionAndContinue: {
                            sb.append("Logging exception and continuing...\n");
                            try {
                                Event[] inboundEvents;
                                AepEngine.Transaction.CommitContext context;
                                SmaException sendException = new SmaException("Send commit exception: " + e.getMessage(), e);
                                AepSendExceptionEvent sendExceptionEvent = AepSendExceptionEvent.create(AepBusConnection.this.getBusBinding(), channel, (MessageView)message, (Exception)sendException);
                                if (this.commitCompletionEvent != null && (context = (AepEngine.Transaction.CommitContext)this.commitCompletionEvent.getAttachment()) != null && (inboundEvents = context.getInboundEvents()) != null) {
                                    for (int i = 0; i < inboundEvents.length; ++i) {
                                        Event event = inboundEvents[i];
                                        if (event instanceof MessageEvent) {
                                            MessageView sourceMessage = ((MessageEvent)event).getMessageView();
                                            if (!(sourceMessage instanceof IRogMessage) || ((IRogMessage)sourceMessage).getTransactionInSequenceNumber() != message.getTransactionInSequenceNumber()) continue;
                                            sendExceptionEvent.setTriggeringMessage(sourceMessage);
                                            continue;
                                        }
                                        if (!(event instanceof AepSendEvent) || ((AepSendEvent)event).getMessage() != message) continue;
                                        AepSendEvent.Acknowledger acknowledger = (AepSendEvent.Acknowledger)((AepSendEvent)event).getAcknowledger();
                                        acknowledger.setStatus((Exception)sendException);
                                    }
                                }
                                AepBusConnection.this.onEvent((Event)sendExceptionEvent);
                            }
                            catch (Throwable throwable) {}
                            break;
                        }
                        case TreatAsStabilityFailure: {
                            sb.append("Converting to stability failure...\n");
                            status = e instanceof Error ? new Exception(e) : (Exception)e;
                        }
                    }
                    Exception exception = status;
                    return exception;
                }
                finally {
                    if (channel.getState() == MessageChannel.State.Open) {
                        AepBusConnection.this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                    } else if (((AepBusConnection)AepBusConnection.this).tracer.fine) {
                        AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + "Failed to send message (channel '" + channel.getName() + " is in state " + channel.getState() + ")", Tracer.Level.FINE);
                    }
                }
            }

            private final void freeElement(SliceElement element) {
                if (element.isLinked()) {
                    throw new InternalError("attempt to free an active slice element");
                }
                this.pool.append((UtlListElement)element.reset());
            }

            final Slice reset() {
                if (this.elements.count() > 0) {
                    throw new IllegalStateException("slice cannot be reset with messages pending to be sent");
                }
                this.priorityTail = null;
                this.numPendingStability = 0;
                this.sendTs = 0L;
                this.commitCompletionEvent = null;
                return this;
            }

            final SliceElement allocElement(MessageChannel channel, IRogMessage message, int flags, int savepoint) {
                SliceElement element;
                if (this.pool.count() > 0) {
                    element = (SliceElement)this.pool.first();
                    element.unlink();
                } else {
                    element = new SliceElement(this);
                }
                return element.init(channel, message, flags, savepoint);
            }

            final void append(SliceElement element) {
                this.elements.append((UtlListElement)element);
                ++this.numPendingStability;
            }

            final void priorityAppend(SliceElement element) {
                if (this.priorityTail == null) {
                    this.elements.prepend((UtlListElement)element);
                    this.priorityTail = element;
                } else {
                    this.priorityTail.insertAfter(element);
                    this.priorityTail = element;
                }
                ++this.numPendingStability;
            }

            final void rollback(int savepoint) {
                if (savepoint < 0) {
                    SliceElement element;
                    while ((element = (SliceElement)this.elements.first()) != null) {
                        element.unlink();
                        this.freeElement(element);
                    }
                    this.numPendingStability = 0;
                    this.priorityTail = null;
                    this.sendTs = 0L;
                } else {
                    SliceElement element = (SliceElement)this.elements.last();
                    while (element != null) {
                        SliceElement prev = (SliceElement)element.previous();
                        if (element.savepoint < savepoint) {
                            if (this.priorityTail == null || this.priorityTail.savepoint < savepoint) break;
                            element = this.priorityTail;
                            continue;
                        }
                        if (element == this.priorityTail) {
                            this.priorityTail = prev != null && prev.message.getIsPriority() ? prev : null;
                        }
                        if (AepBusConnection.this.msgTracer != null && AepBusConnection.this.msgTracer.debug()) {
                            AepBusConnection.this.msgTracer.trace("[MSG-OUT-ROLLBACK]", element.message);
                        }
                        --this.numPendingStability;
                        element.unlink();
                        this.freeElement(element);
                        element = prev;
                    }
                }
            }

            final UtlList elements() {
                return this.elements;
            }

            final boolean send() throws SmaException {
                SliceElement element;
                boolean first = true;
                boolean flushed = true;
                while ((element = (SliceElement)this.elements.first()) != null) {
                    element.unlink();
                    element.commitStart = first;
                    element.commitEnd = this.elements.count() == 0;
                    first = false;
                    if (element == this.priorityTail) {
                        this.priorityTail = null;
                    }
                    MessageChannel channel = element.channel;
                    IRogMessage message = element.message;
                    int flags = element.flags;
                    boolean stabilityEventDispatched = false;
                    try {
                        if (!message.getIsInternal()) {
                            flushed = OutboundQueue.this.send(channel, message, flags, this.sendTs);
                            if (this.commitCompletionEvent != null) {
                                this.commitCompletionEvent.onMessageSend(message);
                            }
                            if (channel.getQos() != MessageChannel.Qos.BestEffort) continue;
                            this.onStability(element, null);
                            stabilityEventDispatched = true;
                            continue;
                        }
                        this.onStability(element, null);
                        stabilityEventDispatched = true;
                    }
                    catch (Throwable e) {
                        Exception status = this.processSendException(channel, message, element, e);
                        if (stabilityEventDispatched) continue;
                        this.onStability(element, MessageStabilityEvent.create((MessageBusBinding)AepBusConnection.this.getBusBinding(), (MessageChannel)channel, (MessageView)message, (Exception)status));
                    }
                }
                return flushed;
            }

            final Slice setSendTs(long ts) {
                this.sendTs = ts;
                return this;
            }

            final Slice setCommitCompletionEvent(AepSendCommitCompletionEvent event) {
                this.commitCompletionEvent = event;
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void onStability(SliceElement element, MessageStabilityEvent stabilityEvent) {
                boolean complete;
                Slice slice = this;
                synchronized (slice) {
                    if (this.commitCompletionEvent != null) {
                        this.commitCompletionEvent.onMessageStability(stabilityEvent);
                    }
                    complete = --this.numPendingStability == 0;
                }
                this.freeElement(element);
                if (complete && this.commitCompletionEvent != null) {
                    AepBusConnection.this.dispatchToEventHandler(this.commitCompletionEvent);
                }
            }
        }

        final class SliceElement
        extends UtlListElement {
            final Slice slice;
            MessageChannel channel;
            IRogMessage message;
            int flags;
            int savepoint;
            boolean commitStart;
            boolean commitEnd;

            SliceElement(Slice slice) {
                this.slice = slice;
            }

            public final SliceElement reset() {
                if (this.message != null) {
                    this.message.setTag(2, null);
                    this.message.dispose();
                    this.message = null;
                }
                return this;
            }

            final SliceElement init(MessageChannel channel, IRogMessage message, int flags, int savepoint) {
                this.channel = channel;
                this.flags = flags;
                this.savepoint = savepoint;
                this.message = message;
                this.message.acquire();
                this.message.setTag(2, (Object)this);
                return this;
            }
        }

        private final class Logger
        implements MessageBusBinding.SequenceNumberGenerator,
        MessageBusBinding.PostMessagePrepProcessor {
            private final MessageBusBinding.SequenceNumberGenerator snoGenerator;
            private final RogMessageLog log;
            private long nextSno;
            private long stableSno;

            Logger(MessageBusBinding.SequenceNumberGenerator snoGenerator, Properties props) {
                this.snoGenerator = snoGenerator;
                this.log = this.createLog(props);
                this.nextSno = 0L;
                this.stableSno = -1L;
            }

            private final RogMessageLog createLog(Properties props) {
                RogMessageLog log = null;
                if (UtlProps.getValue((Properties)props, (String)AepBusConnection.PROPNAME_ENABLE_OUTBOUND_LOG, (boolean)false)) {
                    if (((AepBusConnection)AepBusConnection.this).tracer.debug) {
                        AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " ...outbound message logging is enabled", Tracer.Level.DEBUG);
                    }
                    try {
                        Properties logProps = new Properties();
                        String logName = UtlProps.getValue((Properties)props, (String)AepBusConnection.PROPNAME_OUTBOUND_LOG_NAME, (String)(AepBusConnection.this.getAppName() + ".out"));
                        if (props.containsKey(AepBusConnection.PROPNAME_OUTBOUND_LOG_DIRECTORY)) {
                            logProps.setProperty("storeRoot", props.getProperty(AepBusConnection.PROPNAME_OUTBOUND_LOG_DIRECTORY));
                        }
                        if (props.containsKey(AepBusConnection.PROPNAME_OUTBOUND_LOG_FLUSH_ON_COMMIT)) {
                            logProps.setProperty("flushOnCommit", props.getProperty(AepBusConnection.PROPNAME_OUTBOUND_LOG_FLUSH_ON_COMMIT));
                        }
                        if (props.containsKey(AepBusConnection.PROPNAME_OUTBOUND_LOG_FLUSH_USING_MAPPED_MEMORY)) {
                            logProps.setProperty("flushUsingMappedMemory", props.getProperty(AepBusConnection.PROPNAME_OUTBOUND_LOG_FLUSH_USING_MAPPED_MEMORY));
                        }
                        if (props.containsKey(AepBusConnection.PROPNAME_OUTBOUND_LOG_WRITE_BUFFER_SIZE)) {
                            logProps.setProperty("writeBufferSize", props.getProperty(AepBusConnection.PROPNAME_OUTBOUND_LOG_WRITE_BUFFER_SIZE));
                        }
                        if (props.containsKey(AepBusConnection.PROPNAME_OUTBOUND_LOG_AUTO_REPAIR)) {
                            logProps.setProperty("autoRepair", props.getProperty(AepBusConnection.PROPNAME_OUTBOUND_LOG_AUTO_REPAIR));
                        }
                        if (props.containsKey(AepBusConnection.PROPNAME_OUTBOUND_LOG_INITIAL_LOG_LENGTH)) {
                            logProps.setProperty("initialLogLength", props.getProperty(AepBusConnection.PROPNAME_OUTBOUND_LOG_INITIAL_LOG_LENGTH));
                        }
                        if (props.containsKey(AepBusConnection.PROPNAME_OUTBOUND_LOG_ZERO_OUT_INITIAL)) {
                            logProps.setProperty("zeroOutInitial", props.getProperty(AepBusConnection.PROPNAME_OUTBOUND_LOG_ZERO_OUT_INITIAL));
                        }
                        if (props.containsKey(AepBusConnection.PROPNAME_OUTBOUND_LOG_PAGE_SIZE)) {
                            logProps.setProperty("pageSize", props.getProperty(AepBusConnection.PROPNAME_OUTBOUND_LOG_PAGE_SIZE));
                        }
                        logProps.setProperty("detachedPersist", "false");
                        log = RogMessageLog.create((String)logName, (Properties)logProps);
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                } else if (((AepBusConnection)AepBusConnection.this).tracer.debug) {
                    AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " ...outbound message logging is disabled", Tracer.Level.DEBUG);
                }
                return log;
            }

            final boolean enabled() {
                return this.log != null;
            }

            final void open() {
                if (!this.enabled()) {
                    return;
                }
                try {
                    this.log.open();
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }

            final void close() {
                if (!this.enabled()) {
                    return;
                }
                this.log.close();
            }

            public final long nextSno(MessageView view) {
                long l;
                if (this.snoGenerator != null) {
                    l = this.snoGenerator.nextSno(view);
                } else {
                    long l2 = this.nextSno;
                    l = l2;
                    this.nextSno = l2 + 1L;
                }
                return l;
            }

            public final void onSendPrepComplete(MessageView view) {
                if (!this.enabled()) {
                    return;
                }
                SliceElement element = (SliceElement)((Object)view.getTag(2));
                boolean commitStart = element != null ? element.commitStart : true;
                boolean commitEnd = element != null ? element.commitEnd : true;
                this.log.log((IRogMessage)view, commitStart, commitEnd);
            }
        }
    }

    private final class BindingOpener
    extends Thread
    implements IEmxDispatcherRunCompletionChecker {
        private final IEmxDispatcher dispatcher;
        private final OpenStartEventHandler openStartEventHandler;
        private final OpenRetryEventHandler openRetryEventHandler;
        private final ShutdownEventHandler shutdownEventHandler;
        private IEmxAlarmEvent openRetryAlarmEvent;
        private boolean done;
        private boolean ready;

        BindingOpener() throws Exception {
            this.setName("X-AEP-BusConnection-BindingOpener-" + AepBusConnection.this.name);
            this.shutdownEventHandler = new ShutdownEventHandler();
            this.openStartEventHandler = new OpenStartEventHandler();
            this.openRetryEventHandler = new OpenRetryEventHandler();
            this.dispatcher = EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, this.getName(), IEmxDispatcher.Params.create((boolean)false, (boolean)true));
        }

        final void scheduleOpen() throws EEmxException {
            this.dispatcher.schedUserEv(EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.openStartEventHandler));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void start() {
            super.start();
            BindingOpener bindingOpener = this;
            synchronized (bindingOpener) {
                while (!this.ready) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            UtlThread.setDefaultCPUAffinityMask();
            this.dispatcher.setOwner();
            BindingOpener bindingOpener = this;
            synchronized (bindingOpener) {
                this.ready = true;
                this.notifyAll();
            }
            try {
                this.dispatcher.run(-1, (IEmxDispatcherRunCompletionChecker)this);
            }
            catch (EEmxTimeoutException e) {
                throw new InternalError("Received a timeout exception from dispatcher when timeout was specified as -1!");
            }
            catch (Exception e) {
                AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " Failure encountered in binding opener thread dispatch loop [" + e.toString() + "]. Shutting down thread.", Tracer.Level.SEVERE);
            }
            if (this.openRetryAlarmEvent != null) {
                this.dispatcher.unschedAlarmEv(this.openRetryAlarmEvent);
            }
            try {
                this.dispatcher.close(false);
            }
            catch (EEmxException e) {
                AepBusConnection.this.tracer.log(AepBusConnection.this.tracePrefix + " Failure encountered while closing the binding opener dispatcher [" + e.toString() + "]. Ignoring...", Tracer.Level.WARNING);
            }
        }

        public final boolean isDone() {
            return this.done;
        }

        public final Object getCompletion() {
            return null;
        }

        final void shutdown() {
            this.done = true;
            this.dispatcher.schedUserEv(EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.shutdownEventHandler));
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private final class ShutdownEventHandler
        implements IEmxEventHandler {
            private ShutdownEventHandler() {
            }

            public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
                return false;
            }
        }

        private final class OpenRetryEventHandler
        implements IEmxEventHandler {
            private OpenRetryEventHandler() {
            }

            public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
                if (null == AepBusConnection.this.openCore(true)) {
                    BindingOpener.this.openRetryAlarmEvent = null;
                    return false;
                }
                return true;
            }
        }

        private final class OpenStartEventHandler
        implements IEmxEventHandler {
            private OpenStartEventHandler() {
            }

            public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
                if (null != AepBusConnection.this.openCore(true)) {
                    dispatcher.schedAlarmEv(BindingOpener.this.openRetryAlarmEvent = EmxFactory.getInstance().createAlarmEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)BindingOpener.this.openRetryEventHandler, AepBusConnection.this.openRetryInterval * 1000));
                }
                return false;
            }
        }
    }

    public static enum State {
        CREATED,
        OPENING,
        OPEN,
        STARTED,
        FAILED,
        CLOSED;

    }
}

