/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solace;

import com.neeve.io.IOBuffer;
import com.neeve.sma.SmaException;

final class SolaceProtobufUtil {
    SolaceProtobufUtil() {
    }

    static final int primitiveFieldSerializedLength(int fieldId, short fieldVal) {
        return IOBuffer.varint32SerializedLength((int)(fieldId << 3 | 0)) + IOBuffer.varint32SerializedLength((int)fieldVal);
    }

    static final int syncVarint32(int value, IOBuffer buffer, int offset) {
        int len = 0;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                buffer.putByte(offset + len, (byte)value);
                return ++len;
            }
            buffer.putByte(offset + len, (byte)(value & 0x7F | 0x80));
            value >>>= 7;
            ++len;
        }
    }

    static final int desyncVarint32(IOBuffer buffer, int offset, VarintDesyncLength desyncLength) {
        byte tmp;
        desyncLength.value = 0;
        if ((tmp = buffer.getByte(offset + desyncLength.value++)) >= 0) {
            return tmp;
        }
        int value = tmp & 0x7F;
        if ((tmp = buffer.getByte(offset + desyncLength.value++)) >= 0) {
            value |= tmp << 7;
        } else {
            value |= (tmp & 0x7F) << 7;
            if ((tmp = buffer.getByte(offset + desyncLength.value++)) >= 0) {
                value |= tmp << 14;
            } else {
                value |= (tmp & 0x7F) << 14;
                if ((tmp = buffer.getByte(offset + desyncLength.value++)) >= 0) {
                    value |= tmp << 21;
                } else {
                    value |= (tmp & 0x7F) << 21;
                    tmp = buffer.getByte(offset + desyncLength.value++);
                    value |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (buffer.getByte(offset + desyncLength.value++) < 0) continue;
                            return value;
                        }
                        throw new RuntimeException("malformed serialized varint in buffer");
                    }
                }
            }
        }
        return value;
    }

    static final int desyncVarint32(long addr, int offset, int len, VarintDesyncLength desyncLength) throws SmaException {
        byte tmp;
        desyncLength.value = 0;
        if ((tmp = IOBuffer.getByte((long)addr, (int)(offset + desyncLength.value++))) >= 0) {
            return tmp;
        }
        if (desyncLength.value == len) {
            throw new SmaException("insufficient space");
        }
        int value = tmp & 0x7F;
        if ((tmp = IOBuffer.getByte((long)addr, (int)(offset + desyncLength.value++))) >= 0) {
            value |= tmp << 7;
        } else {
            if (desyncLength.value == len) {
                throw new SmaException("insufficient space");
            }
            value |= (tmp & 0x7F) << 7;
            if ((tmp = IOBuffer.getByte((long)addr, (int)(offset + desyncLength.value++))) >= 0) {
                value |= tmp << 14;
            } else {
                if (desyncLength.value == len) {
                    throw new SmaException("insufficient space");
                }
                value |= (tmp & 0x7F) << 14;
                if ((tmp = IOBuffer.getByte((long)addr, (int)(offset + desyncLength.value++))) >= 0) {
                    value |= tmp << 21;
                } else {
                    if (desyncLength.value == len) {
                        throw new SmaException("insufficient space");
                    }
                    value |= (tmp & 0x7F) << 21;
                    tmp = IOBuffer.getByte((long)addr, (int)(offset + desyncLength.value++));
                    value |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (desyncLength.value == len) {
                                throw new SmaException("insufficient space");
                            }
                            if (IOBuffer.getByte((long)addr, (int)(offset + desyncLength.value++)) < 0) continue;
                            return value;
                        }
                        throw new RuntimeException("malformed serialized varint in buffer");
                    }
                }
            }
        }
        return value;
    }

    static final short fieldId(int tag) {
        return (short)(tag >>> 3);
    }

    static final class VarintDesyncLength {
        public int value;

        VarintDesyncLength() {
        }
    }
}

