/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.server;

import com.neeve.ci.XRuntime;
import com.neeve.link.ELnkException;
import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkClientEndpointCore;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkClientEndpoint;
import com.neeve.link.LnkHandshaker;
import com.neeve.link.LnkLayeredClientEndpoint;
import com.neeve.link.server.LnkSrvConfig;
import com.neeve.link.server.LnkSrvPeerEndpoint;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyServerClientConnectReply;
import com.neeve.pkt.types.PktBodyServerClientConnectRequest;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlProps;
import java.util.Map;

public class LnkSrvClientEndpoint
extends LnkLayeredClientEndpoint
implements ILnkClientEndpointCore {
    private final PktPacket request;

    private LnkSrvClientEndpoint(UtlAddressDescriptor descriptor) throws ELnkException {
        super(LnkSrvConfig.getConfig(), descriptor);
        try {
            this.request = PktFactory.getInstance().createPacket(556);
            PktBodyServerClientConnectRequest pktBody = (PktBodyServerClientConnectRequest)this.request.getBody();
            pktBody.setAppName(descriptor.address);
            pktBody.setAppVersion(UtlProps.getValue((Map)descriptor.props, (String)"appver", (short)0));
            pktBody.setClientName(UtlProps.getValue((Map)descriptor.props, (String)"clientname", (String)XRuntime.getAppName()));
            pktBody.setClientGroup(UtlProps.getValue((Map)descriptor.props, (String)"clientgroup", (String)"default"));
            pktBody.setThreadAffinity(UtlProps.getValue((Map)descriptor.props, (String)"threadaff", (short)-1));
        }
        catch (Exception e) {
            this.closeFinal();
            throw new ELnkException((Throwable)e);
        }
    }

    public static ILnkClientEndpoint create(UtlAddressDescriptor descriptor) throws ELnkException {
        if (descriptor == null) {
            throw new IllegalArgumentException("server link client endpoint descriptor parameter cannot be null");
        }
        return LnkClientEndpoint.create((RootConfig.ObjectConfig)LnkSrvConfig.getConfig(), (ILnkClientEndpointCore)new LnkSrvClientEndpoint(descriptor));
    }

    protected final PktPacket getRequest() {
        return this.request;
    }

    protected final short getExpectedReplyType() {
        return 557;
    }

    protected final ILnkPeerEndpoint createPeerEndpoint(LnkHandshaker.CompletionData completionData) throws Exception {
        String peerName;
        short peerLtp;
        String clientName;
        switch (completionData.reply.getBody().getType()) {
            case 557: {
                PktHeader replyHeader = completionData.reply.getHeader();
                PktBodyServerClientConnectRequest requestBody = (PktBodyServerClientConnectRequest)completionData.request.getBody();
                PktBodyServerClientConnectReply replyBody = (PktBodyServerClientConnectReply)completionData.reply.getBody();
                clientName = requestBody.getClientName();
                peerLtp = replyBody.getServerLtp();
                peerName = replyBody.getServerName();
                break;
            }
            default: {
                throw new InternalError("Invalid handshake reply packet type after successful handshake!");
            }
        }
        try {
            return LnkSrvPeerEndpoint.create(LnkSrvConfig.getConfig(), this.pep, clientName, this.ltp, peerName, peerLtp, completionData.overflowPacketList, this.descriptor);
        }
        catch (Exception e) {
            this.tracer.log("Error in creating a server link peer endpoint upon successful establishment of a server link [" + e.toString() + "].", Tracer.Level.DIAGNOSE);
            throw e;
        }
    }
}

