/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import java.io.PrintStream;

public abstract class Command {
    private Console console = DefaultConsole.access$000();

    public abstract void run(String[] var1);

    public abstract void help();

    public abstract String[] keywords();

    public final void error(String error, Throwable cause) {
        this.console.error(error, cause);
    }

    public final void error(String error) {
        this.console.error(error, null);
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public boolean hidden() {
        return false;
    }

    protected Console console() {
        return this.console;
    }

    public boolean interruptable() {
        return true;
    }

    public void interrupt(Thread commandThread) {
        commandThread.interrupt();
    }

    private static final class DefaultConsole
    implements Console {
        static DefaultConsole instance;

        private DefaultConsole() {
        }

        private static Console get() {
            if (instance == null) {
                instance = new DefaultConsole();
            }
            return instance;
        }

        @Override
        public void error(String error, Throwable cause) {
            System.err.println(error);
            if (cause != null) {
                cause.printStackTrace();
            }
        }

        @Override
        public void error(String error) {
            this.error(error, null);
        }

        @Override
        public void info(String message) {
            System.out.println(message);
        }

        @Override
        public PrintStream err() {
            return System.err;
        }

        @Override
        public PrintStream out() {
            return System.out;
        }

        static /* synthetic */ Console access$000() {
            return DefaultConsole.get();
        }
    }

    public static interface Console {
        public void error(String var1);

        public void error(String var1, Throwable var2);

        public void info(String var1);

        public PrintStream err();

        public PrintStream out();
    }
}

