/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.lang.XStringIterator;
import java.util.NoSuchElementException;

public final class XStringSequence
implements XStringIterator {
    private static final byte FLG_INITIALIZED = 1;
    private static final byte FLG_OWNED = 2;
    private byte _flags;
    private long _addr;
    private int _offset;
    private int _len;
    private int _index;

    private XStringSequence() {
    }

    public static final XStringSequence create() {
        return new XStringSequence();
    }

    private final XStringSequence setInitialized(boolean val) {
        this._flags = val ? (byte)(this._flags | 1) : (byte)(this._flags & 0xFFFFFFFE);
        return this;
    }

    public final boolean isInitialized() {
        return (this._flags & 1) != 0;
    }

    private final XStringSequence setOwned(boolean val) {
        this._flags = val ? (byte)(this._flags | 2) : (byte)(this._flags & 0xFFFFFFFD);
        return this;
    }

    public final boolean isOwned() {
        return (this._flags & 2) != 0;
    }

    public XStringIterator toFirst() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        this._index = 0;
        return this;
    }

    @Override
    public final boolean hasNext() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._index < this._len;
    }

    @Override
    public final String next() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._len) {
            throw new NoSuchElementException("no more elements");
        }
        StringBuilder sb = new StringBuilder();
        int len = IOBuffer.getShort(this._addr, this._index);
        short strSerializedLength = (short)(len + 2);
        for (int i = 0; i < len; ++i) {
            sb.append((char)IOBuffer.getByte(this._addr, this._index + 2 + i));
        }
        this._index += strSerializedLength;
        return sb.toString();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int nextLength(boolean advance) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._len) {
            throw new NoSuchElementException("no more elements");
        }
        short len = IOBuffer.getShort(this._addr, this._index);
        if (advance) {
            short strSerializedLength = (short)(len + 2);
            this._index += strSerializedLength;
        }
        return len;
    }

    @Override
    public final int nextLength() {
        return this.nextLength(true);
    }

    @Override
    public final short nextInto(XString to) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._len) {
            throw new NoSuchElementException("no more elements");
        }
        short len = IOBuffer.getShort(this._addr, this._index);
        short strSerializedLength = (short)(len + 2);
        to.setFrom(this._addr, this._index + 2, (int)len);
        this._index += strSerializedLength;
        return len;
    }

    @Override
    public final short nextInto(long addr, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._len) {
            throw new NoSuchElementException("no more elements");
        }
        short len = IOBuffer.getShort(this._addr, this._index);
        short strSerializedLength = (short)(len + 2);
        IOBuffer.copy(this._addr, this._index + 2, addr, offset, len);
        this._index += strSerializedLength;
        return len;
    }

    public final XStringSequence wrap(long addr, int offset, int len) {
        this.reset();
        this._addr = addr;
        this._offset = offset;
        this._len = len;
        this._index = 0;
        this.setInitialized(true).setOwned(false);
        return this;
    }

    public final XStringSequence wrap(IOBuffer buffer, int offset, int len) {
        return this.wrap(buffer.getNativeAddress(), offset, len);
    }

    public final XStringSequence setFrom(long addr, int offset, int len) {
        this.reset();
        this._addr = IOBuffer.allocateMemoryBlock(len, false);
        IOBuffer.copy(addr, offset, this._addr, 0, len);
        this._len = len;
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final XStringSequence setFrom(IOBuffer buffer, int offset, int len) {
        this.reset();
        this._addr = IOBuffer.allocateMemoryBlock(len, false);
        IOBuffer.copy(buffer.getNativeAddress(), offset, this._addr, 0, len);
        this._len = len;
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final XStringSequence setFrom(XStringSequence sequence) {
        this.reset();
        if (sequence.isInitialized()) {
            int serializedLength = sequence.serializedLength();
            this._addr = IOBuffer.allocateMemoryBlock(serializedLength, false);
            IOBuffer.copy(sequence._addr, sequence._offset, this._addr, 0, serializedLength);
            this._len = sequence.serializedLength();
            this._offset = 0;
            this._index = 0;
            this.setInitialized(true).setOwned(true);
        }
        return this;
    }

    public final XStringSequence setFrom(XStringIterator iterator) {
        this.reset();
        if (iterator instanceof XStringSequence) {
            return this.setFrom((XStringSequence)iterator);
        }
        throw new IllegalArgumentException("iterator implementations other than XStringSequence are not currently supported");
    }

    public final int serializedLength() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._len;
    }

    public final int getTo(byte[] val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        IOBuffer.getTo(this._addr, this._offset, val, offset, this._len);
        return this._len;
    }

    public final int getTo(long addr, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        IOBuffer.copy(this._addr, this._offset, addr, offset, this._len);
        return this._len;
    }

    public final int getTo(IOBuffer val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        val.putFrom(offset, this._addr, this._offset, this._len);
        return this._len;
    }

    public final XStringIterator iterator() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this.toFirst();
    }

    public final XStringSequence reset() {
        if (this.isInitialized()) {
            if (this.isOwned() && this._addr != 0L) {
                IOBuffer.freeMemoryBlock(this._addr, this.serializedLength());
            }
            this.setInitialized(false);
        }
        return this;
    }
}

