/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XCharIterator;
import com.neeve.lang.XString;
import java.util.NoSuchElementException;

public final class XStringDeserializer
implements XCharIterator {
    private long _addr;
    private int _offset;
    private int _len;
    private int _index;

    private XStringDeserializer() {
    }

    public static final XStringDeserializer create() {
        return new XStringDeserializer();
    }

    @Override
    public final boolean hasNext() {
        return this._index < this._len;
    }

    @Override
    public final char next() {
        if (this._index == this._len) {
            throw new NoSuchElementException("no more elements");
        }
        return (char)IOBuffer.getByte(this._addr, this._offset + this._index++);
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public XCharIterator toFirst() {
        this._index = 0;
        return this;
    }

    public final XStringDeserializer init(long addr, int offset, int len) {
        this._addr = addr;
        this._offset = offset;
        this._len = len;
        return this;
    }

    public final boolean isInitialized() {
        return this._addr != 0L;
    }

    public final int serializedLength() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
        return this._len;
    }

    public final int getTo(byte[] val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
        IOBuffer.getTo(this._addr, this._offset, val, offset, this._len);
        return this._len;
    }

    public final int getTo(long addr, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
        IOBuffer.copy(this._addr, this._offset, addr, offset, this._len);
        return this._len;
    }

    public final int getTo(IOBuffer val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
        val.putFrom(offset, this._addr, this._offset, this._len);
        return this._len;
    }

    public final int getTo(XString val) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
        val.setFrom(this._addr, this._offset, this._len);
        return this._len;
    }

    public final String toASCIIString() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
        return IOBuffer.getASCIICharSequence(this._addr, this._offset, this._len);
    }

    public final String toUTF8String() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
        return IOBuffer.getUTF8CharSequence(this._addr, this._offset, this._len);
    }

    public final XCharIterator iterator() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
        return this.toFirst();
    }

    public final boolean equals(Object object) {
        CharSequence other;
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
        if (object == null) {
            return false;
        }
        if (object instanceof XStringDeserializer) {
            XStringDeserializer other2 = (XStringDeserializer)object;
            if (other2.isInitialized() && other2._len == this._len) {
                for (int i = 0; i < this._len; ++i) {
                    if (IOBuffer.getASCIIChar(this._addr, this._offset + i) == IOBuffer.getASCIIChar(other2._addr, other2._offset + i)) continue;
                    return false;
                }
                return true;
            }
        } else if (object instanceof CharSequence && (other = (CharSequence)object).length() == this._len) {
            for (int i = 0; i < this._len; ++i) {
                if (IOBuffer.getASCIIChar(this._addr, this._offset + i) == other.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
        if (this._len == 0) {
            return 0;
        }
        int h = 1;
        for (int i = 0; i < this._len; ++i) {
            h = 31 * h + IOBuffer.getByte(this._addr, this._offset + i);
        }
        return h;
    }
}

