/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.io;

import cern.colt.map.OpenIntIntHashMap;
import com.neeve.config.Config;
import com.neeve.memory.MemoryStats;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlPool;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Unsafe;

public class IOBuffer
implements UtlPool.Item<IOBuffer> {
    private static final int BYTES_OFFSET;
    private static final int SHORTS_OFFSET;
    private static final int CHARS_OFFSET;
    private static final int INTS_OFFSET;
    private static final int FLOATS_OFFSET;
    private static final int LONGS_OFFSET;
    private static final int DOUBLES_OFFSET;
    private static final Unsafe UNSAFE;
    private static final ByteBuffer WIPE_BUFFER;
    private static final int WIPE_BUFFER_SIZE;
    private static final long WIPE_BUFFER_ADDRESS;
    private static final boolean isNativeAndIOByteOrderDifferent;
    private static final PoolEvictedItemReceiver evictedItemReceiver;
    private static final long gb = 0x40000000L;
    private static final long mb = 0x100000L;
    private static final long kb = 1024L;
    private static final int SMALLEST_SLAB_SIZE = 32;
    private static final Factory[] poolFactories;
    private static final UtlPool<IOBuffer>[] pools;
    private static final OpenIntIntHashMap slabTable;
    private static final ThreadLocal<byte[]> numByteArray;
    private static final long[] TENS;
    private static final byte[] Infinity;
    private static final byte[] NaN;
    private static final long MAX_VALUE_DIVIDE_5 = 0x1999999999999999L;
    private static final long MAX_VALUE_DIVIDE_10 = 0xCCCCCCCCCCCCCCCL;
    private static final ThreadLocal<StringBuilder> STRING_BUILDER;
    private static final byte FLG_NOWIPE = 1;
    private static final byte FLG_TAKEN = 2;
    private static final byte FLG_FROMPOOL = 4;
    private static final byte FLG_WRAPPED = 8;
    private static final MemoryStats stats;
    private final ByteBuffer buffer;
    private final AtomicInteger ownershipCount;
    private int length;
    private int highwater;
    private UtlPool<IOBuffer> pool;
    private byte flags;

    private IOBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.buffer.order(IOBuffer.getByteOrder());
        this.ownershipCount = new AtomicInteger(0);
        this.highwater = this.length = buffer.capacity();
        this.setWrapped(true);
    }

    private IOBuffer(int capacity) {
        this.buffer = IOBuffer.allocateByteBuffer(capacity, true);
        this.ownershipCount = new AtomicInteger(0);
        stats.onIOBufferAllocated(false, capacity);
    }

    private static final StringBuilder getStringBuilder(int length) {
        StringBuilder sb = STRING_BUILDER.get();
        if (sb == null) {
            sb = new StringBuilder(Math.max(32, length));
            STRING_BUILDER.set(sb);
        } else {
            sb.setLength(0);
        }
        return sb;
    }

    private final void setNoWipe(boolean val) {
        this.flags = val ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    private final boolean isNoWipe() {
        return (this.flags & 1) != 0;
    }

    private final void setTaken(boolean val) {
        this.flags = val ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    private final boolean isTaken() {
        return (this.flags & 2) != 0;
    }

    private final void setFromPool(boolean val) {
        this.flags = val ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    private final boolean isFromPool() {
        return (this.flags & 4) != 0;
    }

    private final void setWrapped(boolean val) {
        this.flags = val ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
    }

    private final boolean isWrapped() {
        return (this.flags & 8) != 0;
    }

    private static final int pow2(int exp) {
        int ret = 1;
        for (int i = 0; i < exp; ++i) {
            ret *= 2;
        }
        return ret;
    }

    private static final long power10(int n) {
        if (n < 0 || n >= TENS.length) {
            return -1L;
        }
        return TENS[n];
    }

    private static final String memToStr(long val) {
        if (val >= 0x40000000L) {
            if (val % 0x40000000L == 0L) {
                return String.format("%d", val / 0x40000000L) + "G";
            }
            return String.format("%.1f", Float.valueOf((float)val / 1.0737418E9f)) + "G";
        }
        if (val >= 0x100000L) {
            if (val % 0x100000L == 0L) {
                return String.format("%d", val / 0x100000L) + "M";
            }
            return String.format("%.1f", Float.valueOf((float)val / 1048576.0f)) + "M";
        }
        if (val >= 1024L) {
            if (val % 1024L == 0L) {
                return String.format("%d", val / 1024L) + "K";
            }
            return String.format("%.1f", Float.valueOf((float)val / 1024.0f)) + "K";
        }
        return String.format("%d", val);
    }

    private static final int nextHighestPowerOfTwo(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return ++x;
    }

    private static final int toByteArray(long val, byte[] out, boolean mock) {
        boolean negative;
        boolean bl = negative = val < 0L;
        if (!mock) {
            out[19] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[18] = 45;
                }
                return 18;
            }
            return 19;
        }
        if (!mock) {
            out[18] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[17] = 45;
                }
                return 17;
            }
            return 18;
        }
        if (!mock) {
            out[17] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[16] = 45;
                }
                return 16;
            }
            return 17;
        }
        if (!mock) {
            out[16] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[15] = 45;
                }
                return 15;
            }
            return 16;
        }
        if (!mock) {
            out[15] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[14] = 45;
                }
                return 14;
            }
            return 15;
        }
        if (!mock) {
            out[14] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[13] = 45;
                }
                return 13;
            }
            return 14;
        }
        if (!mock) {
            out[13] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[12] = 45;
                }
                return 12;
            }
            return 13;
        }
        if (!mock) {
            out[12] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[11] = 45;
                }
                return 11;
            }
            return 12;
        }
        if (!mock) {
            out[11] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[10] = 45;
                }
                return 10;
            }
            return 11;
        }
        if (!mock) {
            out[10] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[9] = 45;
                }
                return 9;
            }
            return 10;
        }
        if (!mock) {
            out[9] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[8] = 45;
                }
                return 8;
            }
            return 9;
        }
        if (!mock) {
            out[8] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[7] = 45;
                }
                return 7;
            }
            return 8;
        }
        if (!mock) {
            out[7] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[6] = 45;
                }
                return 6;
            }
            return 7;
        }
        if (!mock) {
            out[6] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[5] = 45;
                }
                return 5;
            }
            return 6;
        }
        if (!mock) {
            out[5] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[4] = 45;
                }
                return 4;
            }
            return 5;
        }
        if (!mock) {
            out[4] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[3] = 45;
                }
                return 3;
            }
            return 4;
        }
        if (!mock) {
            out[3] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[2] = 45;
                }
                return 2;
            }
            return 3;
        }
        if (!mock) {
            out[2] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (Math.abs(val /= 10L) == 0L) {
            if (negative) {
                if (!mock) {
                    out[1] = 45;
                }
                return 1;
            }
            return 2;
        }
        if (!mock) {
            out[1] = (byte)(Math.abs(val % 10L) + 48L);
        }
        if (negative) {
            if (!mock) {
                out[0] = 45;
            }
            return 0;
        }
        return 1;
    }

    private static final int toByteArray(long val, int precision, byte[] out, boolean mock) {
        int endIndex = out.length;
        int maxEnd = out.length - precision - 2;
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 1) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 2) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 3) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 4) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 5) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 6) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 7) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 8) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 9) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 10) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 11) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 12) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 13) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 14) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 15) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 16) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 17) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        if ((val /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 18) {
            --endIndex;
            if (!mock) {
                out[endIndex] = 46;
            }
        }
        --endIndex;
        if (!mock) {
            out[endIndex] = (byte)(val % 10L + 48L);
        }
        return endIndex;
    }

    private static final double toDouble(long value, int exp, boolean negative, int decimalPlaces) {
        if (decimalPlaces > 0 && value < 0x3FFFFFFFFFFFFFFFL) {
            if (value < Integer.MAX_VALUE) {
                exp -= 32;
                value <<= 32;
            }
            if (value < 0x7FFFFFFFFFFFL) {
                exp -= 16;
                value <<= 16;
            }
            if (value < 0x7FFFFFFFFFFFFFL) {
                exp -= 8;
                value <<= 8;
            }
            if (value < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
            }
        }
        while (decimalPlaces > 0) {
            --exp;
            long mod = value % 5L;
            int modDiv = 1;
            if ((value /= 5L) < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
                modDiv <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
                modDiv <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
                modDiv <<= 1;
            }
            value = decimalPlaces > 1 ? (value += (long)modDiv * mod / 5L) : (value += ((long)modDiv * mod + 4L) / 5L);
            --decimalPlaces;
        }
        double d = Math.scalb((double)value, exp);
        return negative ? -d : d;
    }

    private static final int calcLongAsASCIICharSequenceLengthCore(long val) {
        if (val == Long.MIN_VALUE) {
            return 20;
        }
        int sign = val < 0L ? 1 : 0;
        val = Math.abs(val);
        if ((val /= 10L) == 0L) {
            return sign + 1;
        }
        if ((val /= 10L) == 0L) {
            return sign + 2;
        }
        if ((val /= 10L) == 0L) {
            return sign + 3;
        }
        if ((val /= 10L) == 0L) {
            return sign + 4;
        }
        if ((val /= 10L) == 0L) {
            return sign + 5;
        }
        if ((val /= 10L) == 0L) {
            return sign + 6;
        }
        if ((val /= 10L) == 0L) {
            return sign + 7;
        }
        if ((val /= 10L) == 0L) {
            return sign + 8;
        }
        if ((val /= 10L) == 0L) {
            return sign + 9;
        }
        if ((val /= 10L) == 0L) {
            return sign + 10;
        }
        if ((val /= 10L) == 0L) {
            return sign + 11;
        }
        if ((val /= 10L) == 0L) {
            return sign + 12;
        }
        if ((val /= 10L) == 0L) {
            return sign + 13;
        }
        if ((val /= 10L) == 0L) {
            return sign + 14;
        }
        if ((val /= 10L) == 0L) {
            return sign + 15;
        }
        if ((val /= 10L) == 0L) {
            return sign + 16;
        }
        if ((val /= 10L) == 0L) {
            return sign + 17;
        }
        if ((val /= 10L) == 0L) {
            return sign + 18;
        }
        return sign + 19;
    }

    private static final int putLongAsASCIICharSequenceCore(long addr, int offset, long val, byte[] tmp, boolean mock) {
        int idx = IOBuffer.toByteArray(val, tmp, mock);
        int len = tmp.length - idx;
        if (!mock) {
            IOBuffer.putFrom(addr, offset, tmp, idx, len);
        }
        return len;
    }

    private static final int putDoubleAsASCIICharSequenceCore(long addr, int offset, double val, byte[] tmp, boolean mock) {
        int shift;
        int len = 0;
        long lval = Double.doubleToRawLongBits(val);
        int sign = (int)(lval >>> 63);
        int exp = (int)(lval >>> 52 & 0x7FFL);
        long mantissa = lval & 0xFFFFFFFFFFFFFL;
        if (sign != 0) {
            if (!mock) {
                IOBuffer.putASCIIChar(addr, offset + len, '-');
            }
            ++len;
        }
        if (exp == 0 && mantissa == 0L) {
            if (!mock) {
                IOBuffer.putASCIIChar(addr, offset + len, '0');
            }
            return ++len;
        }
        if (exp == 2047) {
            if (mantissa == 0L) {
                if (!mock) {
                    IOBuffer.putFrom(addr, offset + len, Infinity, 0, Infinity.length);
                }
                len += Infinity.length;
            } else {
                if (!mock) {
                    IOBuffer.putFrom(addr, offset + len, NaN, 0, NaN.length);
                }
                len += NaN.length;
            }
            return len;
        }
        if (exp > 0) {
            mantissa += 0x10000000000000L;
        }
        if ((shift = 1075 - exp) > 0) {
            if (shift < 53) {
                long intValue = mantissa >> shift;
                len += IOBuffer.putLongAsASCIICharSequenceCore(addr, offset + len, intValue, tmp, mock);
                if ((mantissa -= intValue << shift) > 0L) {
                    if (!mock) {
                        IOBuffer.putASCIIChar(addr, offset + len, '.');
                    }
                    ++len;
                    mantissa <<= 1;
                    ++mantissa;
                    int precision = shift + 1;
                    long error = 1L;
                    long value = intValue;
                    int decimalPlaces = 0;
                    while (mantissa > error) {
                        error *= 5L;
                        long num = (mantissa *= 5L) >> --precision;
                        value = value * 10L + num;
                        if (!mock) {
                            IOBuffer.putASCIIChar(addr, offset + len, (char)(48L + num));
                        }
                        ++len;
                        mantissa -= num << precision;
                        double parsedValue = IOBuffer.toDouble(value, 0, sign != 0, ++decimalPlaces);
                        if (parsedValue != val) continue;
                        break;
                    }
                }
                return len;
            }
            if (!mock) {
                IOBuffer.putASCIIChar(addr, offset + len, '0');
            }
            ++len;
            if (!mock) {
                IOBuffer.putASCIIChar(addr, offset + len, '.');
            }
            ++len;
            mantissa <<= 6;
            mantissa += 32L;
            int precision = shift + 6;
            long error = 32L;
            long value = 0L;
            int decimalPlaces = 0;
            while (mantissa > error) {
                while (mantissa > 0x1999999999999999L) {
                    mantissa >>>= 1;
                    error = error + 1L >>> 1;
                    --precision;
                }
                mantissa *= 5L;
                error *= 5L;
                if (--precision >= 64) {
                    ++decimalPlaces;
                    if (!mock) {
                        IOBuffer.putASCIIChar(addr, offset + len, '0');
                    }
                    ++len;
                    continue;
                }
                long num = mantissa >>> precision;
                value = value * 10L + num;
                char c = (char)(48L + num);
                assert (c >= '0' && c <= '9');
                if (!mock) {
                    IOBuffer.putASCIIChar(addr, offset + len, c);
                }
                ++len;
                mantissa -= num << precision;
                double parsedValue = IOBuffer.toDouble(value, 0, sign != 0, ++decimalPlaces);
                if (parsedValue != val) continue;
                break;
            }
            return len;
        }
        mantissa <<= 10;
        int precision = -10 - shift;
        int digits = 0;
        while ((precision > 53 || mantissa > Long.MAX_VALUE >> precision) && precision > 0) {
            ++digits;
            --precision;
            long mod = mantissa % 5L;
            mantissa /= 5L;
            int modDiv = 1;
            while (mantissa < 0x1999999999999999L && precision > 1) {
                --precision;
                mantissa <<= 1;
                modDiv <<= 1;
            }
            mantissa += (long)modDiv * mod / 5L;
        }
        long val2 = precision > 0 ? mantissa << precision : mantissa >>> -precision;
        len += IOBuffer.putLongAsASCIICharSequenceCore(addr, offset + len, val2, tmp, mock);
        for (int i = 0; i < digits; ++i) {
            if (!mock) {
                IOBuffer.putASCIIChar(addr, offset + len, '0');
            }
            ++len;
        }
        return len;
    }

    private static final int putDoubleAsASCIICharSequenceCore(long addr, int offset, long val, int precision, byte[] tmp, boolean mock) {
        int idx = IOBuffer.toByteArray(val, precision, tmp, mock);
        int len = tmp.length - idx;
        if (!mock) {
            IOBuffer.putFrom(addr, offset, tmp, idx, len);
        }
        return len;
    }

    private final IOBuffer undispose(int length) {
        this.highwater = this.length = length;
        this.buffer.limit(this.length);
        int val = this.ownershipCount.getAndSet(1);
        if (val != 0 && this.pool != null) {
            throw new IllegalStateException("attempt to undispose an IO buffer that's not disposed (val=" + val + ", pool=" + this.pool + ")");
        }
        if (this.isFromPool()) {
            stats.onIOBufferAllocated(true, this.buffer.capacity());
            this.setFromPool(false);
        }
        return this;
    }

    public static IOBuffer create(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        int slab = IOBuffer.slab(length);
        IOBuffer buffer = slab < 0 ? new IOBuffer(length) : pools[slab].get(null);
        return buffer.undispose(length);
    }

    @Deprecated
    public static IOBuffer createNative(int length) {
        return IOBuffer.create(length);
    }

    public static IOBuffer wrap(ByteBuffer buffer) {
        return new IOBuffer(buffer).acquire();
    }

    public static final ByteBuffer allocateByteBuffer(int capacity, boolean direct) {
        return (direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity)).order(IOBuffer.getByteOrder());
    }

    public static final ByteBuffer wrapByteBuffer(byte[] array, int offset, int length) {
        return ByteBuffer.wrap(array, offset, length).order(IOBuffer.getByteOrder());
    }

    public static final ByteBuffer wrapByteBuffer(byte[] array) {
        return IOBuffer.wrapByteBuffer(array, 0, array.length);
    }

    public static final ByteOrder getByteOrder() {
        ByteOrder nativeOrder = ByteOrder.nativeOrder();
        if (isNativeAndIOByteOrderDifferent) {
            if (nativeOrder == ByteOrder.LITTLE_ENDIAN) {
                return ByteOrder.BIG_ENDIAN;
            }
            if (nativeOrder == ByteOrder.BIG_ENDIAN) {
                return ByteOrder.LITTLE_ENDIAN;
            }
            throw new IllegalArgumentException("unknown byte order [" + nativeOrder + "]");
        }
        return nativeOrder;
    }

    public static final IOBuffer ensureCapacity(IOBuffer buffer, int val, boolean initFromExisting) {
        if (buffer == null) {
            return IOBuffer.create(val);
        }
        if (buffer.getCapacity() >= val) {
            buffer.highwater = buffer.length = Math.max(buffer.length, val);
            buffer.buffer.limit(buffer.length);
            return buffer;
        }
        IOBuffer newBuffer = IOBuffer.create(val);
        newBuffer.setNoWipe(buffer.isNoWipe());
        if (initFromExisting) {
            buffer.getTo(0, newBuffer, 0, buffer.length);
        }
        stats.onIOBufferReallocated(newBuffer.getCapacity() - buffer.getCapacity());
        buffer.dispose();
        return newBuffer;
    }

    public static final int slab(int val) {
        int x = IOBuffer.nextHighestPowerOfTwo(Math.max(32, val));
        if (x > 32) {
            int subBucketSize;
            int remainderAfter = val - (x /= 2);
            int numWholeSubBuckets = remainderAfter % (subBucketSize = (x * 2 - x) / 8) == 0 ? remainderAfter / subBucketSize : remainderAfter / subBucketSize + 1;
            x += numWholeSubBuckets * subBucketSize;
        }
        return slabTable.containsKey(x) ? slabTable.get(x) : -1;
    }

    public static final int slabSize(int val) {
        int slab = IOBuffer.slab(val);
        return slab >= 0 ? IOBuffer.poolFactories[slab].slabSize : val;
    }

    public static final int smallestSlabSize() {
        return 32;
    }

    public static final int numSlabs() {
        return slabTable.size();
    }

    public static final long allocateMemoryBlock(long length, boolean zeroout) {
        long addr = UNSAFE.allocateMemory(length);
        if (zeroout) {
            UNSAFE.setMemory(addr, length, (byte)0);
        }
        stats.onNativeMemoryAllocated(length);
        return addr;
    }

    public static final long allocateMemoryBlock(long length) {
        return IOBuffer.allocateMemoryBlock(length, true);
    }

    public static final long ensureMemoryBlockCapacity(long addr, long length, int newlength, boolean zeroout) {
        if (addr == 0L) {
            return IOBuffer.allocateMemoryBlock(newlength, zeroout);
        }
        if (length < (long)newlength) {
            long newaddr = UNSAFE.reallocateMemory(addr, newlength);
            if (zeroout) {
                UNSAFE.setMemory(newaddr + length, (long)newlength - length, (byte)0);
            }
            stats.onNativeMemoryReallocated((long)newlength - length);
            return newaddr;
        }
        return addr;
    }

    public static final long ensureMemoryBlockCapacity(long addr, long length, int newlength) {
        return IOBuffer.ensureMemoryBlockCapacity(addr, length, newlength, true);
    }

    public static final void freeMemoryBlock(long addr, int length) {
        UNSAFE.freeMemory(addr);
        stats.onNativeMemoryFreed(length);
    }

    public static final int calculateUTF8Length(char c) {
        if (c >= '\u0001' && c <= '\u007f') {
            return 1;
        }
        if (c <= '\u07ff') {
            return 2;
        }
        if (!Character.isSurrogate(c)) {
            return 3;
        }
        return 0;
    }

    public static final int calculateUTF8Length(CharSequence str) {
        if (str == null) {
            return 0;
        }
        int strlen = str.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            int cutflen = IOBuffer.calculateUTF8Length(str.charAt(i));
            if (cutflen == 0) {
                if (i == strlen - 1) {
                    throw new IllegalArgumentException("supplied char sequence has an incomplete surrogate character pair");
                }
                utflen += 4;
                ++i;
                continue;
            }
            utflen += cutflen;
        }
        return utflen;
    }

    public static final void putByte(long addr, int offset, byte val) {
        UNSAFE.putByte(null, addr + (long)offset, val);
    }

    public static final byte getByte(long addr, int offset) {
        return UNSAFE.getByte(null, addr + (long)offset);
    }

    public static final int getUnsignedByte(long addr, int offset) {
        return IOBuffer.getByte(addr, offset) & 0xFF;
    }

    public static final void putShort(long addr, int offset, short val) {
        short v = isNativeAndIOByteOrderDifferent ? Short.reverseBytes(val) : val;
        UNSAFE.putShort(null, addr + (long)offset, v);
    }

    public static final short getShort(long addr, int offset) {
        short val = UNSAFE.getShort(null, addr + (long)offset);
        return isNativeAndIOByteOrderDifferent ? Short.reverseBytes(val) : val;
    }

    public static final int getUnsignedShort(long addr, int offset) {
        return IOBuffer.getShort(addr, offset) & 0xFFFF;
    }

    public static final void putChar(long addr, int offset, char val) {
        char v = isNativeAndIOByteOrderDifferent ? Character.reverseBytes(val) : val;
        UNSAFE.putChar(null, addr + (long)offset, v);
    }

    public static final int putASCIIChar(long addr, int offset, char val) {
        if (val < '\u0001' || val > '\u007f') {
            throw new IllegalArgumentException("character (" + val + ") a non-ASCII character");
        }
        IOBuffer.putByte(addr, offset, (byte)val);
        return 1;
    }

    public static final int putUTF8Char(long addr, int offset, char val) {
        int utflen = IOBuffer.calculateUTF8Length(val);
        if (utflen == 0) {
            throw new IllegalArgumentException(val + " is a surrogate character");
        }
        if (val >= '\u0001' && val <= '\u007f') {
            IOBuffer.putByte(addr, offset, (byte)val);
            return 1;
        }
        if (val <= '\u07ff') {
            IOBuffer.putByte(addr, offset, (byte)(0xC0 | val >> 6 & 0x1F));
            IOBuffer.putByte(addr, offset + 1, (byte)(0x80 | val & 0x3F));
            return 2;
        }
        IOBuffer.putByte(addr, offset, (byte)(0xE0 | val >> 12 & 0xF));
        IOBuffer.putByte(addr, offset + 1, (byte)(0x80 | val >> 6 & 0x3F));
        IOBuffer.putByte(addr, offset + 2, (byte)(0x80 | val & 0x3F));
        return 3;
    }

    public static final char getChar(long addr, int offset) {
        char val = UNSAFE.getChar(null, addr + (long)offset);
        return isNativeAndIOByteOrderDifferent ? Character.reverseBytes(val) : val;
    }

    public static final char getASCIIChar(long addr, int offset) {
        return (char)UNSAFE.getByte(null, addr + (long)offset);
    }

    public static final void putInt(long addr, int offset, int val) {
        int v = isNativeAndIOByteOrderDifferent ? Integer.reverseBytes(val) : val;
        UNSAFE.putInt(null, addr + (long)offset, v);
    }

    public static final int getInt(long addr, int offset) {
        int val = UNSAFE.getInt(null, addr + (long)offset);
        return isNativeAndIOByteOrderDifferent ? Integer.reverseBytes(val) : val;
    }

    public static final long getUnsignedInt(long addr, int offset) {
        return (long)IOBuffer.getInt(addr, offset) & 0xFFFFFFFFL;
    }

    public static final void putFloat(long addr, int offset, float val) {
        if (isNativeAndIOByteOrderDifferent) {
            UNSAFE.putInt(null, addr + (long)offset, Integer.reverseBytes(Float.floatToRawIntBits(val)));
        } else {
            UNSAFE.putFloat(null, addr + (long)offset, val);
        }
    }

    public static final float getFloat(long addr, int offset) {
        if (isNativeAndIOByteOrderDifferent) {
            return Float.intBitsToFloat(Integer.reverseBytes(UNSAFE.getInt(null, addr + (long)offset)));
        }
        return UNSAFE.getFloat(null, addr + (long)offset);
    }

    public static final void putLong(long addr, int offset, long val) {
        long v = isNativeAndIOByteOrderDifferent ? Long.reverseBytes(val) : val;
        UNSAFE.putLong(null, addr + (long)offset, v);
    }

    public static final int calcLongAsASCIICharSequenceLength(long val) {
        return IOBuffer.calcLongAsASCIICharSequenceLengthCore(val);
    }

    public static final int putLongAsASCIICharSequence(long addr, int offset, long val, boolean mock) {
        return IOBuffer.putLongAsASCIICharSequenceCore(addr, offset, val, numByteArray.get(), mock);
    }

    public static final int putLongAsASCIICharSequence(long addr, int offset, long val) {
        return IOBuffer.putLongAsASCIICharSequence(addr, offset, val, false);
    }

    public static final long getLong(long addr, int offset) {
        long val = UNSAFE.getLong(null, addr + (long)offset);
        return isNativeAndIOByteOrderDifferent ? Long.reverseBytes(val) : val;
    }

    public static final long getLongFromASCIICharSequence(long addr, int offset, char terminationMarker, int limit, ParsedCount parsedCount) {
        long num = 0L;
        boolean negative = false;
        boolean successfulParse = false;
        parsedCount.value = 0;
        while (offset + parsedCount.value < limit) {
            int b;
            if ((b = IOBuffer.getUnsignedByte(addr, offset + parsedCount.value++)) - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b == 45) {
                negative = true;
                continue;
            }
            if (b == terminationMarker) {
                successfulParse = true;
                break;
            }
            throw new RuntimeException("encountered illegal character '" + (char)b + "'");
        }
        if (successfulParse) {
            return negative ? -num : num;
        }
        throw new RuntimeException("missing termination character '" + terminationMarker + "'");
    }

    public static final void putDouble(long addr, int offset, double val) {
        if (isNativeAndIOByteOrderDifferent) {
            UNSAFE.putLong(null, addr + (long)offset, Long.reverseBytes(Double.doubleToRawLongBits(val)));
        } else {
            UNSAFE.putDouble(null, addr + (long)offset, val);
        }
    }

    public static final int putDoubleAsASCIICharSequence(long addr, int offset, double val, int precision, boolean mock) {
        double valf;
        long power10;
        byte[] tmp = numByteArray.get();
        int len = 0;
        if (precision < 0) {
            precision = 0;
        }
        if ((power10 = IOBuffer.power10(precision)) < 0L) {
            throw new RuntimeException("unsupported precision '" + precision + "'");
        }
        if (val < 0.0) {
            val = -val;
            if (!mock) {
                IOBuffer.putASCIIChar(addr, offset + len, '-');
            }
            ++len;
        }
        if ((valf = val * (double)power10) > 9.223372036854776E18 || valf < -9.223372036854776E18) {
            len += IOBuffer.putDoubleAsASCIICharSequenceCore(addr, offset + len, val, tmp, mock);
        } else {
            long l = (long)(valf + 0.5);
            while (precision > 1 && l % 10L == 0L) {
                l /= 10L;
                --precision;
            }
            if (precision > 0 && l % 10L == 0L) {
                l = (l + 5L) / 10L;
                --precision;
            }
            len = precision > 0 ? (len += IOBuffer.putDoubleAsASCIICharSequenceCore(addr, offset + len, l, precision, tmp, mock)) : (len += IOBuffer.putLongAsASCIICharSequenceCore(addr, offset + len, l, tmp, mock));
        }
        return len;
    }

    public static final int putDoubleAsASCIICharSequence(long addr, int offset, double val, int precision) {
        return IOBuffer.putDoubleAsASCIICharSequence(addr, offset, val, precision, false);
    }

    public static final double getDouble(long addr, int offset) {
        if (isNativeAndIOByteOrderDifferent) {
            return Double.longBitsToDouble(Long.reverseBytes(UNSAFE.getLong(null, addr + (long)offset)));
        }
        return UNSAFE.getDouble(null, addr + (long)offset);
    }

    public static final double getDoubleFromASCIICharSequence(long addr, int offset, char terminationMarker, int limit, ParsedCount parsedCount) {
        int ch;
        long value = 0L;
        int exp = 0;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        boolean successfulParse = false;
        parsedCount.value = 0;
        if (IOBuffer.getUnsignedByte(addr, offset) == 45) {
            negative = true;
            ++parsedCount.value;
        }
        while (true) {
            if ((ch = IOBuffer.getUnsignedByte(addr, offset + parsedCount.value++)) >= 48 && ch <= 57) {
                while (value >= 0xCCCCCCCCCCCCCCCL) {
                    value >>>= 1;
                    ++exp;
                }
                value = value * 10L + (long)(ch - 48);
                ++decimalPlaces;
                continue;
            }
            if (ch != 46) break;
            decimalPlaces = 0;
        }
        if (ch != terminationMarker) {
            throw new RuntimeException("encountered illegal character '" + (char)ch + "'");
        }
        successfulParse = true;
        if (successfulParse) {
            return IOBuffer.toDouble(value, exp, negative, decimalPlaces);
        }
        throw new RuntimeException("missing termination character '" + terminationMarker + "'");
    }

    public static final int putASCIICharSequence(long addr, int offset, CharSequence val, int start, int end) {
        if (end - start == 0) {
            return 0;
        }
        int pos = offset;
        for (int i = start; i < end; ++i) {
            char c = val.charAt(i);
            if (c < '\u0001' || c > '\u007f') {
                throw new IllegalArgumentException("character sequence contains a non-ASCII character (idx=" + i + ", val=" + c + ")");
            }
            IOBuffer.putByte(addr, pos++, (byte)c);
        }
        return end - start;
    }

    public static final int putASCIICharSequence(long addr, int offset, CharSequence val) {
        if (val == null) {
            return 0;
        }
        return IOBuffer.putASCIICharSequence(addr, offset, val, 0, val.length());
    }

    public static final String getASCIICharSequence(long addr, int offset, int len) {
        StringBuilder sb = IOBuffer.getStringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)IOBuffer.getByte(addr, offset + i));
        }
        return sb.toString();
    }

    static final int putUTF8CharSequence(long addr, int offset, CharSequence val, int utflen, int start, int end) {
        char c;
        int i;
        if (utflen == 0) {
            return 0;
        }
        int pos = offset;
        for (i = start; i < end && (c = val.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            IOBuffer.putByte(addr, pos++, (byte)c);
        }
        while (i < end) {
            c = val.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                IOBuffer.putByte(addr, pos++, (byte)c);
            } else if (c <= '\u07ff') {
                IOBuffer.putByte(addr, pos++, (byte)(0xC0 | c >> 6 & 0x1F));
                IOBuffer.putByte(addr, pos++, (byte)(0x80 | c & 0x3F));
            } else if (Character.isSurrogate(c)) {
                if (i == end - 1) {
                    throw new IllegalArgumentException("supplied char sequence has an incomplete surrogate character pair");
                }
                int uc = Character.toCodePoint(c, val.charAt(++i));
                IOBuffer.putByte(addr, pos++, (byte)(0xF0 | uc >> 18 & 7));
                IOBuffer.putByte(addr, pos++, (byte)(0x80 | uc >> 12 & 0x3F));
                IOBuffer.putByte(addr, pos++, (byte)(0x80 | uc >> 6 & 0x3F));
                IOBuffer.putByte(addr, pos++, (byte)(0x80 | uc & 0x3F));
            } else {
                IOBuffer.putByte(addr, pos++, (byte)(0xE0 | c >> 12 & 0xF));
                IOBuffer.putByte(addr, pos++, (byte)(0x80 | c >> 6 & 0x3F));
                IOBuffer.putByte(addr, pos++, (byte)(0x80 | c & 0x3F));
            }
            ++i;
        }
        return utflen;
    }

    public static final int putUTF8CharSequence(long addr, int offset, CharSequence val, int start, int end) {
        return IOBuffer.putUTF8CharSequence(addr, offset, val, IOBuffer.calculateUTF8Length(val), start, end);
    }

    public static final int putUTF8CharSequence(long addr, int offset, CharSequence val) {
        return IOBuffer.putUTF8CharSequence(addr, offset, val, IOBuffer.calculateUTF8Length(val), 0, val.length());
    }

    public static final String getUTF8CharSequence(long addr, int offset, int len) {
        StringBuilder sb = IOBuffer.getStringBuilder(len);
        try {
            byte c;
            int pos;
            for (pos = 0; pos < len && (c = IOBuffer.getByte(addr, offset + pos)) >= 0; ++pos) {
                sb.append((char)c);
            }
            block9: while (pos < len) {
                int c1 = IOBuffer.getUnsignedByte(addr, offset + pos++);
                switch (c1 >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        sb.append((char)c1);
                        continue block9;
                    }
                    case 12: 
                    case 13: {
                        int c2;
                        if (pos == len) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        if (((c2 = IOBuffer.getUnsignedByte(addr, offset + pos++)) & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + pos);
                        }
                        sb.append((char)((c1 & 0x1F) << 6 | c2 & 0x3F));
                        continue block9;
                    }
                    case 14: {
                        if (pos == len) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        int c2 = IOBuffer.getUnsignedByte(addr, offset + pos++);
                        if (pos == len) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        int c3 = IOBuffer.getByte(addr, offset + pos++);
                        if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (pos - 1));
                        }
                        sb.append((char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F));
                        continue block9;
                    }
                    case 15: {
                        if (pos == len) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        int c2 = IOBuffer.getUnsignedByte(addr, offset + pos++);
                        if (pos == len) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        int c3 = IOBuffer.getUnsignedByte(addr, offset + pos++);
                        if (pos == len) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte c4 = IOBuffer.getByte(addr, offset + pos++);
                        if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (pos - 1));
                        }
                        int c5 = (c1 & 7) << 18 | (c2 & 0x3F) << 12 | (c3 & 0x3F) << 6 | c4 & 0x3F;
                        sb.append(Character.highSurrogate(c5));
                        sb.append(Character.lowSurrogate(c5));
                        continue block9;
                    }
                }
                throw new UTFDataFormatException("malformed input around byte " + --pos);
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final int varint32SerializedLength(int val) {
        if ((val & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((val & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((val & 0xFFE00000) == 0) {
            return 3;
        }
        if ((val & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static final int putVarint32(long addr, int offset, int val) {
        int len = 0;
        while (true) {
            if ((val & 0xFFFFFF80) == 0) {
                IOBuffer.putByte(addr, offset + len, (byte)val);
                return ++len;
            }
            IOBuffer.putByte(addr, offset + len, (byte)(val & 0x7F | 0x80));
            val >>>= 7;
            ++len;
        }
    }

    public static final int getVarint32(long addr, int offset, VarintDeserializeLength deserializeLength) {
        byte tmp;
        deserializeLength.value = 0;
        if ((tmp = IOBuffer.getByte(addr, offset + deserializeLength.value++)) >= 0) {
            return tmp;
        }
        int value = tmp & 0x7F;
        if ((tmp = IOBuffer.getByte(addr, offset + deserializeLength.value++)) >= 0) {
            value |= tmp << 7;
        } else {
            value |= (tmp & 0x7F) << 7;
            if ((tmp = IOBuffer.getByte(addr, offset + deserializeLength.value++)) >= 0) {
                value |= tmp << 14;
            } else {
                value |= (tmp & 0x7F) << 14;
                if ((tmp = IOBuffer.getByte(addr, offset + deserializeLength.value++)) >= 0) {
                    value |= tmp << 21;
                } else {
                    value |= (tmp & 0x7F) << 21;
                    tmp = IOBuffer.getByte(addr, offset + deserializeLength.value++);
                    value |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (IOBuffer.getByte(addr, offset + deserializeLength.value++) < 0) continue;
                            return value;
                        }
                        throw new IllegalArgumentException("address does not contain a serialized varint");
                    }
                }
            }
        }
        return value;
    }

    public static final int varint64SerializedLength(long val) {
        if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (val < 0L) {
            return 10;
        }
        int n = 2;
        if ((val & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            val >>>= 28;
        }
        if ((val & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            val >>>= 14;
        }
        if ((val & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static final int putVarint64(long addr, int offset, long val) {
        int len = 0;
        while (true) {
            if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) {
                IOBuffer.putByte(addr, offset + len, (byte)val);
                return ++len;
            }
            IOBuffer.putByte(addr, offset + len, (byte)((int)val & 0x7F | 0x80));
            val >>>= 7;
            ++len;
        }
    }

    public static final long getVarint64(long addr, int offset, VarintDeserializeLength deserializeLength) {
        deserializeLength.value = 0;
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = IOBuffer.getByte(addr, offset + deserializeLength.value++);
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IllegalArgumentException("address does not contain a serialized varint");
    }

    public static final void putFrom(long addr, int offset, byte[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        UNSAFE.copyMemory(array, BYTES_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 1);
    }

    public static final void getTo(long addr, int offset, byte[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        UNSAFE.copyMemory(null, addr + (long)offset, array, BYTES_OFFSET + arrayoffset, numelem * 1);
    }

    public static final void putFrom(long addr, int offset, short[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                IOBuffer.putShort(addr, offset + i * 2, array[arrayoffset + i]);
            }
        } else {
            UNSAFE.copyMemory(array, SHORTS_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 2);
        }
    }

    public static final void getTo(long addr, int offset, short[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                array[arrayoffset + i] = IOBuffer.getShort(addr, offset + i * 2);
            }
        } else {
            UNSAFE.copyMemory(null, addr + (long)offset, array, SHORTS_OFFSET + arrayoffset, numelem * 2);
        }
    }

    public static final void putFrom(long addr, int offset, char[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                IOBuffer.putChar(addr, offset + i * 2, array[arrayoffset + i]);
            }
        } else {
            UNSAFE.copyMemory(array, CHARS_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 2);
        }
    }

    public static final void getTo(long addr, int offset, char[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                array[arrayoffset + i] = IOBuffer.getChar(addr, offset + i * 2);
            }
        } else {
            UNSAFE.copyMemory(null, addr + (long)offset, array, CHARS_OFFSET + arrayoffset, numelem * 2);
        }
    }

    public static final void putFrom(long addr, int offset, int[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                IOBuffer.putInt(addr, offset + i * 4, array[arrayoffset + i]);
            }
        } else {
            UNSAFE.copyMemory(array, INTS_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 4);
        }
    }

    public static final void getTo(long addr, int offset, int[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                array[arrayoffset + i] = IOBuffer.getInt(addr, offset + i * 4);
            }
        } else {
            UNSAFE.copyMemory(null, addr + (long)offset, array, INTS_OFFSET + arrayoffset, numelem * 4);
        }
    }

    public static final void putFrom(long addr, int offset, float[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                IOBuffer.putFloat(addr, offset + i * 4, array[arrayoffset + i]);
            }
        } else {
            UNSAFE.copyMemory(array, FLOATS_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 4);
        }
    }

    public static final void getTo(long addr, int offset, float[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                array[arrayoffset + i] = IOBuffer.getFloat(addr, offset + i * 4);
            }
        } else {
            UNSAFE.copyMemory(null, addr + (long)offset, array, FLOATS_OFFSET + arrayoffset, numelem * 4);
        }
    }

    public static final void putFrom(long addr, int offset, long[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                IOBuffer.putLong(addr, offset + i * 8, array[arrayoffset + i]);
            }
        } else {
            UNSAFE.copyMemory(array, LONGS_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 8);
        }
    }

    public static final void getTo(long addr, int offset, long[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                array[arrayoffset + i] = IOBuffer.getLong(addr, offset + i * 8);
            }
        } else {
            UNSAFE.copyMemory(null, addr + (long)offset, array, LONGS_OFFSET + arrayoffset, numelem * 8);
        }
    }

    public static final void putFrom(long addr, int offset, double[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                IOBuffer.putDouble(addr, offset + i * 8, array[arrayoffset + i]);
            }
        } else {
            UNSAFE.copyMemory(array, DOUBLES_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 8);
        }
    }

    public static final void getTo(long addr, int offset, double[] array, int arrayoffset, int numelem) {
        if (numelem == 0) {
            return;
        }
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                array[arrayoffset + i] = IOBuffer.getDouble(addr, offset + i * 8);
            }
        } else {
            UNSAFE.copyMemory(null, addr + (long)offset, array, DOUBLES_OFFSET + arrayoffset, numelem * 8);
        }
    }

    public static final void putFrom(long addr, int offset, ByteBuffer buffer, int bufferOffset, int len) {
        if (len == 0) {
            return;
        }
        long bufaddr = buffer.isDirect() ? UtlBuffer.getNativeBufferAddress(buffer) : (long)BYTES_OFFSET;
        byte[] bufobj = buffer.isDirect() ? null : buffer.array();
        UNSAFE.copyMemory(bufobj, bufaddr + (long)bufferOffset, null, addr + (long)offset, len);
    }

    public static final void putFrom(long addr, int offset, ByteBuffer buffer) {
        IOBuffer.putFrom(addr, offset, buffer, buffer.position(), buffer.remaining());
    }

    public static final void getTo(long addr, int offset, ByteBuffer buffer, int bufferOffset, int len) {
        if (len == 0) {
            return;
        }
        long bufaddr = buffer.isDirect() ? UtlBuffer.getNativeBufferAddress(buffer) : (long)BYTES_OFFSET;
        byte[] bufobj = buffer.isDirect() ? null : buffer.array();
        UNSAFE.copyMemory(null, addr + (long)offset, bufobj, bufaddr + (long)bufferOffset, len);
    }

    public static final void getTo(long addr, int offset, ByteBuffer buffer, int len) {
        IOBuffer.getTo(addr, offset, buffer, buffer.position(), len);
    }

    public static final void copy(long src, int srcoff, long dest, int destoff, int len) {
        if (len == 0) {
            return;
        }
        UNSAFE.copyMemory(null, src + (long)srcoff, null, dest + (long)destoff, len);
    }

    public static final void wipe(long addr, int addroff, int len) {
        if (len < WIPE_BUFFER_SIZE) {
            UNSAFE.copyMemory(WIPE_BUFFER_ADDRESS, addr + (long)addroff, len);
        } else {
            for (int wiped = 0; wiped > 0; wiped += WIPE_BUFFER_SIZE) {
                UNSAFE.copyMemory(WIPE_BUFFER_ADDRESS, addr + (long)addroff + (long)wiped, Math.min(WIPE_BUFFER_SIZE, len - wiped));
            }
        }
    }

    public static final String dump(long addr, int offset, int len) {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(addr);
        str.append("]");
        str.append("<");
        if (addr != 0L) {
            for (int i = offset; i < offset + len; ++i) {
                String hexStr = Integer.toHexString(0xFF & IOBuffer.getByte(addr, i));
                str.append(hexStr.length() == 1 ? "0" + hexStr : hexStr);
                if ((i - offset + 1) % 4 != 0 || i >= offset + len - 1) continue;
                str.append(" ");
            }
        }
        str.append(">");
        return str.toString();
    }

    public final IOBuffer copy() {
        IOBuffer copy = IOBuffer.create(this.length);
        IOBuffer.copy(this.getNativeAddress(), 0, copy.getNativeAddress(), 0, this.length);
        return copy;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getCapacity() {
        return this.buffer.capacity();
    }

    public final ByteBuffer takeBuffer() {
        if (this.isTaken()) {
            throw new IllegalStateException("buffer already taken");
        }
        this.setTaken(true);
        return this.buffer;
    }

    public final IOBuffer releaseBuffer() {
        if (!this.isTaken()) {
            throw new IllegalStateException("buffer not taken");
        }
        this.setTaken(false);
        this.buffer.position(0).limit(this.length);
        return this;
    }

    public final ByteBuffer getBufferUnsafe() {
        if (this.isTaken()) {
            throw new IllegalStateException("operation not permitted while buffer is taken");
        }
        return this.buffer;
    }

    @Deprecated
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Deprecated
    public final IOBuffer getIOBuffer() {
        return this;
    }

    public final long getNativeAddress() {
        return UtlBuffer.getNativeBufferAddress(this.buffer);
    }

    public final IOBuffer setNoWipe() {
        this.setNoWipe(true);
        return this;
    }

    public final void putByte(int offset, byte val) {
        IOBuffer.putByte(this.getNativeAddress(), offset, val);
    }

    public final byte getByte(int offset) {
        return IOBuffer.getByte(this.getNativeAddress(), offset);
    }

    public final int getUnsignedByte(int offset) {
        return IOBuffer.getUnsignedByte(this.getNativeAddress(), offset);
    }

    public final void putShort(int offset, short val) {
        IOBuffer.putShort(this.getNativeAddress(), offset, val);
    }

    public final short getShort(int offset) {
        return IOBuffer.getShort(this.getNativeAddress(), offset);
    }

    public final int getUnsignedShort(int offset) {
        return IOBuffer.getUnsignedShort(this.getNativeAddress(), offset);
    }

    public final void putChar(int offset, char val) {
        IOBuffer.putChar(this.getNativeAddress(), offset, val);
    }

    public final int putASCIIChar(int offset, char val) {
        return IOBuffer.putASCIIChar(this.getNativeAddress(), offset, val);
    }

    public final int putUTF8Char(int offset, char val) {
        return IOBuffer.putUTF8Char(this.getNativeAddress(), offset, val);
    }

    public final char getChar(int offset) {
        return IOBuffer.getChar(this.getNativeAddress(), offset);
    }

    public final char getASCIIChar(int offset) {
        return IOBuffer.getASCIIChar(this.getNativeAddress(), offset);
    }

    public final void putInt(int offset, int val) {
        IOBuffer.putInt(this.getNativeAddress(), offset, val);
    }

    public final int getInt(int offset) {
        return IOBuffer.getInt(this.getNativeAddress(), offset);
    }

    public final long getUnsignedInt(int offset) {
        return IOBuffer.getUnsignedInt(this.getNativeAddress(), offset);
    }

    public final void putFloat(int offset, float val) {
        IOBuffer.putFloat(this.getNativeAddress(), offset, val);
    }

    public final float getFloat(int offset) {
        return IOBuffer.getFloat(this.getNativeAddress(), offset);
    }

    public final void putLong(int offset, long val) {
        IOBuffer.putLong(this.getNativeAddress(), offset, val);
    }

    public final int putLongAsASCIICharSequence(int offset, long val) {
        return IOBuffer.putLongAsASCIICharSequence(this.getNativeAddress(), offset, val);
    }

    public final long getLong(int offset) {
        return IOBuffer.getLong(this.getNativeAddress(), offset);
    }

    public final long getLongFromASCIICharSequence(int offset, char terminationMarker, int limit, ParsedCount parsedCount) {
        return IOBuffer.getLongFromASCIICharSequence(this.getNativeAddress(), offset, terminationMarker, limit, parsedCount);
    }

    public final void putDouble(int offset, double val) {
        IOBuffer.putDouble(this.getNativeAddress(), offset, val);
    }

    public final int putDoubleAsASCIICharSequence(int offset, double val, int precision) {
        return IOBuffer.putDoubleAsASCIICharSequence(this.getNativeAddress(), offset, val, precision);
    }

    public final double getDouble(int offset) {
        return IOBuffer.getDouble(this.getNativeAddress(), offset);
    }

    public final double getDoubleFromASCIICharSequence(int offset) {
        return IOBuffer.getDouble(this.getNativeAddress(), offset);
    }

    public final int putASCIICharSequence(int offset, CharSequence val, int start, int end) {
        return IOBuffer.putASCIICharSequence(this.getNativeAddress(), offset, val, start, end);
    }

    public final int putASCIICharSequence(int offset, CharSequence val) {
        return IOBuffer.putASCIICharSequence(this.getNativeAddress(), offset, val);
    }

    public final String getASCIICharSequence(int offset, int len) {
        return IOBuffer.getASCIICharSequence(this.getNativeAddress(), offset, len);
    }

    public final int putUTF8CharSequence(int offset, CharSequence val, int utflen, int start, int end) {
        return IOBuffer.putUTF8CharSequence(this.getNativeAddress(), offset, val, utflen, start, end);
    }

    public final int putUTF8CharSequence(int offset, CharSequence val, int start, int end) {
        return IOBuffer.putUTF8CharSequence(this.getNativeAddress(), offset, val, start, end);
    }

    public final int putUTF8CharSequence(int offset, CharSequence val) {
        return IOBuffer.putUTF8CharSequence(this.getNativeAddress(), offset, val);
    }

    public final String getUTF8CharSequence(int offset, int len) {
        return IOBuffer.getUTF8CharSequence(this.getNativeAddress(), offset, len);
    }

    public final void putVarint32(int offset, int val) {
        IOBuffer.putVarint32(this.getNativeAddress(), offset, val);
    }

    public final int getVarint32(int offset, VarintDeserializeLength deserializeLength) {
        return IOBuffer.getVarint32(this.getNativeAddress(), offset, deserializeLength);
    }

    public final void putVarint64(int offset, long val) {
        IOBuffer.putVarint64(this.getNativeAddress(), offset, val);
    }

    public final long getVarint64(int offset, VarintDeserializeLength deserializeLength) {
        return IOBuffer.getVarint64(this.getNativeAddress(), offset, deserializeLength);
    }

    public final void putFrom(int offset, byte[] array, int arrayoffset, int numelem) {
        IOBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, byte[] array, int arrayoffset, int numelem) {
        IOBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, short[] array, int arrayoffset, int numelem) {
        IOBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, short[] array, int arrayoffset, int numelem) {
        IOBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, char[] array, int arrayoffset, int numelem) {
        IOBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, char[] array, int arrayoffset, int numelem) {
        IOBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, int[] array, int arrayoffset, int numelem) {
        IOBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, int[] array, int arrayoffset, int numelem) {
        IOBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, float[] array, int arrayoffset, int numelem) {
        IOBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, float[] array, int arrayoffset, int numelem) {
        IOBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, long[] array, int arrayoffset, int numelem) {
        IOBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, long[] array, int arrayoffset, int numelem) {
        IOBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, double[] array, int arrayoffset, int numelem) {
        IOBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, double[] array, int arrayoffset, int numelem) {
        IOBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, long addr, int addroffset, int len) {
        IOBuffer.copy(addr, addroffset, this.getNativeAddress(), offset, len);
    }

    public final void getTo(int offset, long addr, int addroffset, int len) {
        IOBuffer.copy(this.getNativeAddress(), offset, addr, addroffset, len);
    }

    public final void putFrom(int offset, ByteBuffer src, int bufferOffset, int len) {
        IOBuffer.putFrom(this.getNativeAddress(), offset, src, bufferOffset, len);
    }

    public final void putFrom(int offset, ByteBuffer src) {
        IOBuffer.putFrom(this.getNativeAddress(), offset, src);
    }

    public final void getTo(int offset, ByteBuffer dest, int bufferOffset, int len) {
        IOBuffer.getTo(this.getNativeAddress(), offset, dest, bufferOffset, len);
    }

    public final void getTo(int offset, ByteBuffer dest, int len) {
        IOBuffer.getTo(this.getNativeAddress(), offset, dest, len);
    }

    public final void putFrom(int offset, IOBuffer src, int srcoff, int len) {
        IOBuffer.copy(src.getNativeAddress(), srcoff, this.getNativeAddress(), offset, len);
    }

    public final void getTo(int offset, IOBuffer dest, int destoff, int len) {
        IOBuffer.copy(this.getNativeAddress(), offset, dest.getNativeAddress(), destoff, len);
    }

    public final IOBuffer acquire() {
        int val = this.ownershipCount.incrementAndGet();
        if (val <= 1 && this.pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed IO buffer");
        }
        return this;
    }

    public final int getOwnerCount() {
        return this.ownershipCount.get();
    }

    public final void dispose(int highwater) {
        if (this.isTaken()) {
            throw new IllegalStateException("operation not permitted while buffer is taken");
        }
        int val = this.ownershipCount.decrementAndGet();
        if (val < 0 && this.pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed IO buffer");
        }
        if (val == 0) {
            if (this.pool != null) {
                stats.onIOBufferDisposed(true, this.buffer.capacity());
                this.setFromPool(true);
                this.highwater = highwater;
                this.pool.put(this);
            } else if (this.isWrapped()) {
                if (this.buffer instanceof MappedByteBuffer) {
                    UtlBuffer.releaseBuffer(this.buffer);
                }
            } else {
                stats.onIOBufferDisposed(false, this.buffer.capacity());
            }
        }
    }

    public final void dispose() {
        this.dispose(this.highwater);
    }

    @Override
    public final IOBuffer init() {
        this.buffer.clear();
        if (!this.isNoWipe()) {
            IOBuffer.wipe(this.getNativeAddress(), 0, this.highwater);
            this.setNoWipe(false);
        }
        return this;
    }

    @Override
    public final IOBuffer setPool(UtlPool<IOBuffer> pool) {
        this.pool = pool;
        return this;
    }

    @Override
    public final UtlPool<IOBuffer> getPool() {
        return this.pool;
    }

    public final String toString() {
        return "[ownerCount=" + this.ownershipCount.get() + ", buf=" + UtlBuffer.toString(this.buffer) + ", highwater=" + this.highwater + "]";
    }

    static {
        int i;
        isNativeAndIOByteOrderDifferent = !ByteOrder.nativeOrder().toString().equalsIgnoreCase(Config.getValue((String)"nv.io.byteorder", (String)(Config.compatibleWith3x() ? ByteOrder.BIG_ENDIAN.toString() : ByteOrder.LITTLE_ENDIAN.toString())));
        Field theUnsafe = null;
        try {
            theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
            BYTES_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            SHORTS_OFFSET = UNSAFE.arrayBaseOffset(short[].class);
            CHARS_OFFSET = UNSAFE.arrayBaseOffset(char[].class);
            INTS_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
            FLOATS_OFFSET = UNSAFE.arrayBaseOffset(float[].class);
            LONGS_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
            DOUBLES_OFFSET = UNSAFE.arrayBaseOffset(double[].class);
        }
        catch (Throwable thrown) {
            throw new RuntimeException(thrown);
        }
        WIPE_BUFFER = ByteBuffer.allocateDirect(UNSAFE.pageSize());
        WIPE_BUFFER_SIZE = WIPE_BUFFER.capacity();
        WIPE_BUFFER_ADDRESS = UtlBuffer.getNativeBufferAddress(WIPE_BUFFER);
        STRING_BUILDER = new ThreadLocal();
        numByteArray = new ThreadLocal<byte[]>(){

            @Override
            protected final byte[] initialValue() {
                return new byte[20];
            }
        };
        TENS = new long[19];
        IOBuffer.TENS[0] = 1L;
        for (int i2 = 1; i2 < TENS.length; ++i2) {
            IOBuffer.TENS[i2] = TENS[i2 - 1] * 10L;
        }
        Infinity = "Infinity".getBytes();
        NaN = "NaN".getBytes();
        stats = MemoryStats.getInstance();
        evictedItemReceiver = new PoolEvictedItemReceiver();
        ArrayList<Factory> factories = new ArrayList<Factory>();
        for (i = 0; i < 20; ++i) {
            for (int j = 0; j < 8; ++j) {
                factories.add(new Factory(32 * IOBuffer.pow2(i) + 32 * (IOBuffer.pow2(i + 1) - IOBuffer.pow2(i)) * j / 8));
            }
        }
        poolFactories = factories.toArray(new Factory[factories.size()]);
        pools = UtlPool.createPoolArray(poolFactories.length);
        for (i = 0; i < poolFactories.length; ++i) {
            IOBuffer.pools[i] = UtlPool.create("iobuf", "native-" + IOBuffer.memToStr(IOBuffer.poolFactories[i].slabSize), poolFactories[i], UtlPool.Params.create().setThreaded(true).setDetachedWash(true).setPreallocate(false)).setEvictedItemReceiver(evictedItemReceiver);
        }
        slabTable = new OpenIntIntHashMap();
        for (i = 0; i < poolFactories.length; ++i) {
            slabTable.put(IOBuffer.poolFactories[i].slabSize, i);
        }
        if (Config.getValue((String)"nv.io.configtrace", (boolean)false)) {
            System.out.println("NATIVE BYTE ORDER IS " + ByteOrder.nativeOrder());
            System.out.println("IO BUFFER BYTE ORDER IS " + IOBuffer.getByteOrder());
        }
    }

    public static final class ParsedCount {
        public int value;
    }

    public static final class VarintDeserializeLength {
        public int value;
    }

    private static final class PoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<IOBuffer> {
        private PoolEvictedItemReceiver() {
        }

        @Override
        public final void process(IOBuffer evictedItem) {
            stats.onIOBufferLeaked(evictedItem.getCapacity());
        }
    }

    private static final class Factory
    implements UtlPool.Factory<IOBuffer> {
        final int slabSize;

        Factory(int slabSize) {
            this.slabSize = slabSize;
        }

        @Override
        public final IOBuffer createItem(Object object) {
            return new IOBuffer(this.slabSize);
        }

        public final IOBuffer[] createItemArray(int size) {
            return new IOBuffer[size];
        }
    }
}

