/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import java.nio.ByteBuffer;

public final class StoDoubleField
extends StoField {
    private double val;

    private StoDoubleField(String name) {
        super(StoField.Type.DOUBLE, name);
    }

    private StoDoubleField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final void doSyncToBuffer(ByteBuffer buffer, int bufferOffset) {
        StoDoubleField.put(buffer, bufferOffset, this.val);
    }

    @Override
    protected final void onBackingBufferAttach() {
        StoDoubleField.put(this.buffer, this.bodyOffset, this.val);
    }

    @Override
    protected final void onBackingBufferDetach() {
        if (this.val == 0.0) {
            this.val = StoDoubleField.get(this.buffer, this.bodyOffset);
        }
    }

    @Override
    protected final void onBackingBufferChange() {
        this.val = 0.0;
    }

    @Override
    protected final int getSerializedLength() {
        return 8;
    }

    @Override
    protected final String getValueString() {
        return String.valueOf(this.getValue());
    }

    @Override
    protected final boolean bodyContentsEquals(StoField other) {
        return this.getValue() == ((StoDoubleField)other).getValue();
    }

    @Override
    protected final void cloneBody(StoField clonee) {
        ((StoDoubleField)clonee).setValue(this.getValue());
    }

    public static StoDoubleField create(String name) {
        return new StoDoubleField(name);
    }

    public static StoDoubleField create(ByteBuffer buffer, int bufferOffset) {
        return new StoDoubleField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        return 8;
    }

    public static void put(ByteBuffer buffer, int offset, double val) {
        buffer.putDouble(offset, val);
    }

    public static double get(ByteBuffer buffer, int offset) {
        return buffer.getDouble(offset);
    }

    @Override
    public final boolean isVariableLength() {
        return false;
    }

    @Override
    public final void reset() {
        this.setValue(0.0);
    }

    public final void setValue(double val) {
        this.val = val;
        if (this.buffer != null) {
            StoDoubleField.put(this.buffer, this.bodyOffset, val);
        }
    }

    public final double getValue() {
        if (this.val == 0.0 && this.buffer != null) {
            this.val = StoDoubleField.get(this.buffer, this.bodyOffset);
        }
        return this.val;
    }
}

