/*
 * Decompiled with CFR 0.152.
 */
package com.neeve;

import com.neeve.NativeKernel;

public final class NativeRdma {
    private static final boolean DEBUG = Boolean.getBoolean("nv.native.debug");

    public static final native void initialize();

    static {
        if (DEBUG) {
            System.err.println("[nv.native.rdma] Initializing native RDMA runtime...");
        }
        boolean success = false;
        try {
            if (DEBUG) {
                System.err.println("[nv.native.rdma] ...initializing the native kernel.");
            }
            try {
                NativeKernel.initialize();
            }
            catch (RuntimeException re) {
                if (DEBUG) {
                    System.err.println("[nv.native.rdma] ...failed to initialize the native kernel [" + re.getMessage() + "].");
                }
                throw re;
            }
            catch (Error e) {
                if (DEBUG) {
                    System.err.println("[nv.native.rdma] ...failed to initialize the native kernel [" + e.getMessage() + "].");
                }
                throw e;
            }
            if (DEBUG) {
                System.err.println("[nv.native.rdma] ...attempting to load native RDMA library.");
            }
            try {
                System.loadLibrary("nvrdmajni");
            }
            catch (RuntimeException re) {
                if (DEBUG) {
                    System.err.println("[nv.native.rdma] ...failed to load native RDMA libraries [" + re.getMessage() + "].");
                }
                throw re;
            }
            catch (Error e) {
                if (DEBUG) {
                    System.err.println("[nv.native.rdma] ...failed to load native RDMA libraries [" + e.getMessage() + "].");
                }
                throw e;
            }
            if (DEBUG) {
                System.err.println("[nv.native.rdma] ...native RDMA libraries loaded");
            }
            try {
                NativeRdma.initialize();
            }
            catch (RuntimeException re) {
                if (DEBUG) {
                    System.err.println("[nv.native.rdma] ...failed to initialize native RDMA runtime [" + re.getMessage() + "].");
                }
                throw re;
            }
            catch (Error e) {
                if (DEBUG) {
                    System.err.println("[nv.native.rdma] ...failed to initialize native RDMA runtime [" + e.getMessage() + "].");
                }
                throw e;
            }
            success = true;
            if (DEBUG) {
                System.err.println("[nv.native.rdma] ...initialization complete: native RDMA runtime is " + (success ? "AVAILABLE" : "UNAVAILABLE") + ".");
            }
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                System.err.println("[nv.native.rdma] ...initialization complete: native RDMA runtime is " + (success ? "AVAILABLE" : "UNAVAILABLE") + ".");
            }
            throw throwable;
        }
    }
}

