/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.nio;

import com.neeve.emx.nio.EmxNioNwAcceptReadyEvent;
import com.neeve.emx.nio.EmxNioNwConnectReadyEvent;
import com.neeve.emx.nio.EmxNioNwEvent;
import com.neeve.emx.nio.EmxNioNwReadReadyEvent;
import com.neeve.emx.nio.EmxNioNwWriteReadyEvent;
import com.neeve.emx.nio.EmxNioObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Iterator;

final class EmxNioDispatcherWaitQueueNetwork
extends EmxNioObject {
    private Selector selector;
    private HashMap<SelectableChannel, ChannelInterest> table;
    private UtlList closeq;
    private int critCount;
    private int count;

    EmxNioDispatcherWaitQueueNetwork(Selector selector) {
        this.selector = selector;
        this.table = new HashMap();
        this.closeq = UtlList.create();
    }

    private final ChannelInterest getInterest(EmxNioNwEvent event) {
        ChannelInterest interest = (ChannelInterest)((Object)event.getTag());
        if (interest != null && interest.key != null && interest.key.selector() != this.selector) {
            if (this.tracer.debug) {
                this.tracer.log("Interest tagged to event " + event + " is of another dispatcher. Removing tag.", Tracer.Level.DEBUG);
            }
            event.setTag(null);
        }
        if (this.tracer.debug) {
            this.tracer.log("Getting interest for event " + event, Tracer.Level.DEBUG);
        }
        SelectableChannel channel = event.getChannel();
        interest = (ChannelInterest)((Object)event.getTag());
        if (interest == null || interest.key != null && interest.key.selector() != this.selector) {
            interest = this.table.get(channel);
            if (interest == null) {
                interest = new ChannelInterest(channel);
                if (this.tracer.debug) {
                    this.tracer.log("Interest " + (Object)((Object)interest) + " not attached or in table. Created fresh.", Tracer.Level.DEBUG);
                }
            } else if (this.tracer.debug) {
                this.tracer.log("Interest " + (Object)((Object)interest) + " not attached but found in table.", Tracer.Level.DEBUG);
            }
        }
        if (interest.channel != channel) {
            throw new InternalError("Event is associated with a channel different from associated interests channel");
        }
        if (interest.key == null) {
            if (interest.state != 0) {
                throw new InternalError("Interest key is null for a channel interest that is not closed!");
            }
            try {
                interest.key = channel.register(this.selector, 0, (Object)interest);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to register channel with selector [" + e.toString() + "]");
            }
        }
        if (interest.state == 0) {
            if (this.tracer.debug) {
                this.tracer.log("Adding interest " + (Object)((Object)interest) + " to interest table.", Tracer.Level.DEBUG);
            }
            this.table.put(interest.channel, interest);
        } else if (interest.state == 2) {
            if (this.tracer.debug) {
                this.tracer.log("Removing interest " + (Object)((Object)interest) + " from close queue.", Tracer.Level.DEBUG);
            }
            interest.unlink();
        }
        event.setTag((Object)interest);
        interest.state = 1;
        if (this.tracer.debug) {
            this.tracer.log("Returning interest " + (Object)((Object)interest), Tracer.Level.DEBUG);
        }
        return interest;
    }

    private final void checkNProcessEmptyInterest(ChannelInterest interest) {
        if (this.tracer.debug) {
            this.tracer.log("Checking interest " + (Object)((Object)interest) + " for emptiness", Tracer.Level.DEBUG);
        }
        if (interest.key.interestOps() == 0) {
            if (interest.acceptReadyEvent != null || interest.connectReadyEvent != null || interest.readReadyEvent != null || interest.writeReadyEvent != null) {
                throw new InternalError("interestOps is zero while one or more events are scheduled");
            }
            if (this.tracer.debug) {
                this.tracer.log("Interest " + (Object)((Object)interest) + " is empty. Scheduling for close.", Tracer.Level.DEBUG);
            }
            this.closeq.append((UtlListElement)interest);
            interest.state = 2;
        }
    }

    private final void updateCounts(EmxNioNwEvent event, boolean add) {
        if (add) {
            ++this.count;
            if (event.getCritical()) {
                ++this.critCount;
            }
        } else {
            --this.count;
            if (event.getCritical()) {
                --this.critCount;
            }
        }
    }

    final void add(EmxNioNwAcceptReadyEvent event) {
        if (this.tracer.debug) {
            this.tracer.log("Network accept ready event " + event + " add.", Tracer.Level.DEBUG);
        }
        ChannelInterest interest = this.getInterest(event);
        if (interest.acceptReadyEvent != null) {
            throw new InternalError("Duplicate registration of interest in the accept ready event!");
        }
        try {
            interest.key.interestOps(interest.key.interestOps() | 0x10);
            interest.acceptReadyEvent = event;
            this.updateCounts(event, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add ACCEPT READY interest in selection key (Exception = " + e.toString() + ")");
        }
        if (this.tracer.debug) {
            this.tracer.log("Interest after add " + (Object)((Object)interest), Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log("Counts after add <count=" + this.count() + " critCount=" + this.critCount() + ">", Tracer.Level.DEBUG);
        }
    }

    final boolean remove(EmxNioNwAcceptReadyEvent event) {
        ChannelInterest interest;
        if (this.tracer.debug) {
            this.tracer.log("Network accept ready event " + event + " remove.", Tracer.Level.DEBUG);
        }
        if ((interest = (ChannelInterest)((Object)event.getTag())) != null) {
            if (interest.acceptReadyEvent == event) {
                try {
                    interest.key.interestOps(interest.key.interestOps() & 0xFFFFFFEF);
                    if (this.tracer.debug) {
                        this.tracer.log("Deregistered ACCEPT_READY interest from channel.", Tracer.Level.DEBUG);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to remove ACCEPT READY interest in selection key (Exception = " + e.toString() + ")");
                }
                interest.acceptReadyEvent = null;
                this.checkNProcessEmptyInterest(interest);
                this.updateCounts(event, false);
                if (this.tracer.debug) {
                    this.tracer.log("Interest after remove " + (Object)((Object)interest), Tracer.Level.DEBUG);
                }
                if (this.tracer.debug) {
                    this.tracer.log("Counts after remove <count=" + this.count() + " critCount=" + this.critCount() + ">", Tracer.Level.DEBUG);
                }
                return true;
            }
            if (this.tracer.debug) {
                this.tracer.log("Interest is tagged to event but ACCEPT_READY interest is not registered with channel.", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log("Interest is not tagged to the event!", Tracer.Level.DEBUG);
        }
        return false;
    }

    final void add(EmxNioNwConnectReadyEvent event) {
        if (this.tracer.debug) {
            this.tracer.log("Network connect ready event " + event + " add.", Tracer.Level.DEBUG);
        }
        ChannelInterest interest = this.getInterest(event);
        if (interest.connectReadyEvent != null) {
            throw new InternalError("Duplicate registration of interest in the connect ready event!");
        }
        try {
            interest.key.interestOps(interest.key.interestOps() | 8);
            interest.connectReadyEvent = event;
            this.updateCounts(event, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add CONNECT READY interest in selection key (Exception = " + e.toString() + ")");
        }
        if (this.tracer.debug) {
            this.tracer.log("Interest after add " + (Object)((Object)interest), Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log("Counts after add <count=" + this.count() + " critCount=" + this.critCount() + ">", Tracer.Level.DEBUG);
        }
    }

    final boolean remove(EmxNioNwConnectReadyEvent event) {
        ChannelInterest interest;
        if (this.tracer.debug) {
            this.tracer.log("Network connect ready event " + event + " remove.", Tracer.Level.DEBUG);
        }
        if ((interest = (ChannelInterest)((Object)event.getTag())) != null) {
            if (interest.connectReadyEvent == event) {
                try {
                    interest.key.interestOps(interest.key.interestOps() & 0xFFFFFFF7);
                    if (this.tracer.debug) {
                        this.tracer.log("Deregistered CONNECT_READY interest from channel.", Tracer.Level.DEBUG);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to remove CONNECT READY interest in selection key (Exception = " + e.toString() + ")");
                }
                interest.connectReadyEvent = null;
                this.checkNProcessEmptyInterest(interest);
                this.updateCounts(event, false);
                if (this.tracer.debug) {
                    this.tracer.log("Interest after remove " + (Object)((Object)interest), Tracer.Level.DEBUG);
                }
                if (this.tracer.debug) {
                    this.tracer.log("Counts after remove <count=" + this.count() + " critCount=" + this.critCount() + ">", Tracer.Level.DEBUG);
                }
                return true;
            }
            if (this.tracer.debug) {
                this.tracer.log("Interest is tagged to event but CONNECT_READY interest is not registered with channel.", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log("Interest is not tagged to the event!", Tracer.Level.DEBUG);
        }
        return false;
    }

    final void add(EmxNioNwReadReadyEvent event) {
        if (this.tracer.debug) {
            this.tracer.log("Network read ready event " + event + " add.", Tracer.Level.DEBUG);
        }
        ChannelInterest interest = this.getInterest(event);
        if (interest.readReadyEvent != null) {
            throw new InternalError("Duplicate registration of interest in the read ready event!");
        }
        try {
            interest.key.interestOps(interest.key.interestOps() | 1);
            interest.readReadyEvent = event;
            this.updateCounts(event, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add READ READY interest in selection key (Exception = " + e.toString() + ")");
        }
        if (this.tracer.debug) {
            this.tracer.log("Interest after add " + (Object)((Object)interest), Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log("Counts after add <count=" + this.count() + " critCount=" + this.critCount() + ">", Tracer.Level.DEBUG);
        }
    }

    final boolean remove(EmxNioNwReadReadyEvent event) {
        ChannelInterest interest;
        if (this.tracer.debug) {
            this.tracer.log("Network read ready event " + event + " remove.", Tracer.Level.DEBUG);
        }
        if ((interest = (ChannelInterest)((Object)event.getTag())) != null) {
            if (interest.readReadyEvent == event) {
                try {
                    interest.key.interestOps(interest.key.interestOps() & 0xFFFFFFFE);
                    if (this.tracer.debug) {
                        this.tracer.log("Deregistered READ_READY interest from channel.", Tracer.Level.DEBUG);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to remove READ READY interest in selection key (Exception = " + e.toString() + ")");
                }
                interest.readReadyEvent = null;
                this.checkNProcessEmptyInterest(interest);
                this.updateCounts(event, false);
                if (this.tracer.debug) {
                    this.tracer.log("Interest after remove " + (Object)((Object)interest), Tracer.Level.DEBUG);
                }
                if (this.tracer.debug) {
                    this.tracer.log("Counts after remove <count=" + this.count() + " critCount=" + this.critCount() + ">", Tracer.Level.DEBUG);
                }
                return true;
            }
            if (this.tracer.debug) {
                this.tracer.log("Interest is tagged to event but READ_READY interest is not registered with channel.", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log("Interest is not tagged to the event!", Tracer.Level.DEBUG);
        }
        return false;
    }

    final void add(EmxNioNwWriteReadyEvent event) {
        if (this.tracer.debug) {
            this.tracer.log("Network write ready event " + event + " add.", Tracer.Level.DEBUG);
        }
        ChannelInterest interest = this.getInterest(event);
        if (interest.writeReadyEvent != null) {
            throw new InternalError("Duplicate registration of interest in the write ready event!");
        }
        try {
            interest.key.interestOps(interest.key.interestOps() | 4);
            interest.writeReadyEvent = event;
            this.updateCounts(event, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add WRITE READY interest in selection key (Exception = " + e.toString() + ")");
        }
        if (this.tracer.debug) {
            this.tracer.log("Interest after add " + (Object)((Object)interest), Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log("Counts after add <count=" + this.count() + " critCount=" + this.critCount() + ">", Tracer.Level.DEBUG);
        }
    }

    final boolean remove(EmxNioNwWriteReadyEvent event) {
        ChannelInterest interest;
        if (this.tracer.debug) {
            this.tracer.log("Network write ready event " + event + " remove.", Tracer.Level.DEBUG);
        }
        if ((interest = (ChannelInterest)((Object)event.getTag())) != null) {
            if (interest.writeReadyEvent == event) {
                try {
                    interest.key.interestOps(interest.key.interestOps() & 0xFFFFFFFB);
                    if (this.tracer.debug) {
                        this.tracer.log("Deregistered WRITE_READY interest from channel.", Tracer.Level.DEBUG);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to remove WRITE READY interest in selection key (Exception = " + e.toString() + ")");
                }
                interest.writeReadyEvent = null;
                this.checkNProcessEmptyInterest(interest);
                this.updateCounts(event, false);
                if (this.tracer.debug) {
                    this.tracer.log("Interest after remove " + (Object)((Object)interest), Tracer.Level.DEBUG);
                }
                if (this.tracer.debug) {
                    this.tracer.log("Counts after remove <count=" + this.count() + " critCount=" + this.critCount() + ">", Tracer.Level.DEBUG);
                }
                return true;
            }
            if (this.tracer.debug) {
                this.tracer.log("Interest is tagged to event but WRITE_READY interest is not registered with channel.", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log("Interest is not tagged to the event!", Tracer.Level.DEBUG);
        }
        return false;
    }

    final boolean flush() {
        if (this.tracer.debug) {
            this.tracer.log("Flushing network wait close queue [size=" + this.closeq.count() + "].", Tracer.Level.DEBUG);
        }
        if (this.closeq.count() > 0) {
            ChannelInterest interest;
            while ((interest = (ChannelInterest)this.closeq.next()) != null) {
                if (interest.state == 2 && this.table.remove(interest.channel) == interest) {
                    if (this.tracer.debug) {
                        this.tracer.log("Flushing interest " + (Object)((Object)interest) + ".", Tracer.Level.DEBUG);
                    }
                    interest.state = 0;
                    interest.unlink();
                    interest.key.cancel();
                    interest.key = null;
                    continue;
                }
                throw new InternalError("Interest close queue and interest table out of sync!");
            }
            return true;
        }
        return false;
    }

    final UtlList get(Iterator<?> iterator, UtlList list) {
        UtlList retval = list;
        if (this.tracer.debug) {
            this.tracer.log("Triggered network event ready list get.", Tracer.Level.DEBUG);
        }
        while (iterator.hasNext()) {
            EmxNioNwEvent event;
            SelectionKey key = (SelectionKey)iterator.next();
            ChannelInterest interest = (ChannelInterest)((Object)key.attachment());
            if (interest.isAcceptReady()) {
                event = interest.acceptReadyEvent;
                if (this.remove((EmxNioNwAcceptReadyEvent)event)) {
                    if (this.tracer.debug) {
                        this.tracer.log("Adding event " + event + " to triggered event list.", Tracer.Level.DEBUG);
                    }
                    list.append((UtlListElement)event);
                } else {
                    throw new InternalError("Interest object obtained from selected selection key could not be removed from wait queue!");
                }
            }
            if (interest.isConnectReady()) {
                event = interest.connectReadyEvent;
                if (this.remove((EmxNioNwConnectReadyEvent)event)) {
                    if (this.tracer.debug) {
                        this.tracer.log("Adding event " + event + " to triggered event list.", Tracer.Level.DEBUG);
                    }
                    list.append((UtlListElement)event);
                } else {
                    throw new InternalError("Interest object obtained from selected selection key could not be removed from wait queue!");
                }
            }
            if (interest.isReadReady()) {
                event = interest.readReadyEvent;
                if (this.remove((EmxNioNwReadReadyEvent)event)) {
                    if (this.tracer.debug) {
                        this.tracer.log("Adding event " + event + " to triggered event list.", Tracer.Level.DEBUG);
                    }
                    list.append((UtlListElement)event);
                } else {
                    throw new InternalError("Interest object obtained from selected selection key could not be removed from wait queue!");
                }
            }
            if (interest.isWriteReady()) {
                event = interest.writeReadyEvent;
                if (this.remove((EmxNioNwWriteReadyEvent)event)) {
                    if (this.tracer.debug) {
                        this.tracer.log("Adding event " + event + " to triggered event list.", Tracer.Level.DEBUG);
                    }
                    list.append((UtlListElement)event);
                } else {
                    throw new InternalError("Interest object obtained from selected selection key could not be removed from wait queue!");
                }
            }
            iterator.remove();
        }
        if (this.tracer.debug) {
            this.tracer.log("Returning " + retval.count() + " triggered network events.", Tracer.Level.DEBUG);
        }
        return retval;
    }

    final int critCount() {
        return this.critCount;
    }

    final int count() {
        return this.count;
    }

    private final class ChannelInterest
    extends UtlListElement {
        int state;
        SelectableChannel channel;
        SelectionKey key;
        EmxNioNwAcceptReadyEvent acceptReadyEvent;
        EmxNioNwConnectReadyEvent connectReadyEvent;
        EmxNioNwReadReadyEvent readReadyEvent;
        EmxNioNwWriteReadyEvent writeReadyEvent;
        static final int STATE_CLOSED = 0;
        static final int STATE_OPEN = 1;
        static final int STATE_PENDING_CLOSE = 2;

        ChannelInterest(SelectableChannel channel) {
            this.channel = channel;
            this.state = 0;
        }

        final boolean isAcceptReady() {
            return this.acceptReadyEvent != null && this.key.isAcceptable();
        }

        final boolean isConnectReady() {
            return this.connectReadyEvent != null && this.key.isConnectable();
        }

        final boolean isReadReady() {
            return this.readReadyEvent != null && this.key.isReadable();
        }

        final boolean isWriteReady() {
            return this.writeReadyEvent != null && this.key.isWritable();
        }

        public final String toString() {
            return "[state=" + this.state + " acceptReadyEv=" + (this.acceptReadyEvent != null) + " connectReadyEv=" + (this.connectReadyEvent != null) + " readReadyEv=" + (this.readReadyEvent != null) + " writeReadyEv=" + (this.writeReadyEvent != null) + "]";
        }
    }
}

