/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.root;

import com.neeve.config.Config;
import com.neeve.trace.Tracer;
import java.util.HashMap;
import java.util.Hashtable;

public class RootConfig {
    private static final Hashtable<String, Boolean> threadedTable;
    private static final Hashtable<String, Boolean> checkedTable;
    private static final HashMap<String, ObjectConfig> objectConfigs;
    private static ObjectConfig defaultObjectConfig;

    private static final synchronized ObjectConfig defaultObjectConfig() {
        if (defaultObjectConfig == null) {
            defaultObjectConfig = new ObjectConfig("default", false, Config.checked());
        }
        return defaultObjectConfig;
    }

    public static void setThreaded(String name, boolean val) {
        if (name == null) {
            RootConfig.defaultObjectConfig().threaded = val;
        } else {
            threadedTable.put(name, new Boolean(val));
            RootConfig.flushObjectConfig(name);
        }
    }

    public static boolean getThreaded(String name) {
        if (name == null) {
            return RootConfig.defaultObjectConfig().threaded;
        }
        Boolean val = threadedTable.get(name);
        return val == null ? RootConfig.defaultObjectConfig().threaded : val;
    }

    public static void setChecked(String name, boolean val) {
        if (name == null) {
            RootConfig.defaultObjectConfig().checked = val;
        } else {
            checkedTable.put(name, new Boolean(val));
            RootConfig.flushObjectConfig(name);
        }
    }

    public static boolean getChecked(String name) {
        if (name == null) {
            return RootConfig.defaultObjectConfig().checked;
        }
        Boolean val = checkedTable.get(name);
        return val == null ? RootConfig.defaultObjectConfig().checked : val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectConfig getObjectConfig(String name) {
        HashMap<String, ObjectConfig> hashMap = objectConfigs;
        synchronized (hashMap) {
            ObjectConfig config = objectConfigs.get(name);
            if (config == null) {
                config = new ObjectConfig(name);
                objectConfigs.put(name, config);
            }
            return config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushObjectConfig(String name) {
        HashMap<String, ObjectConfig> hashMap = objectConfigs;
        synchronized (hashMap) {
            if (name == null) {
                defaultObjectConfig = null;
                objectConfigs.clear();
            } else {
                objectConfigs.remove(name);
            }
        }
    }

    static {
        checkedTable = new Hashtable();
        threadedTable = new Hashtable();
        objectConfigs = new HashMap();
    }

    public static class ObjectConfig {
        public String name;
        public boolean threaded;
        public boolean checked;

        private ObjectConfig(String name, boolean threaded, boolean checked) {
            this.name = name;
            this.threaded = threaded;
            this.checked = checked;
        }

        private ObjectConfig(String name) {
            this(name, RootConfig.getThreaded(name), RootConfig.getChecked(name));
        }

        public static Tracer createTracer(ObjectConfig config) {
            return config != null ? Tracer.get(config.name) : Tracer.create();
        }

        public final String toString() {
            return "[name=" + this.name + " thr=" + this.threaded + " chkd=" + this.checked + "]";
        }
    }
}

