/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.event;

import com.neeve.event.Event;
import com.neeve.event.EventObject;
import com.neeve.event.IEventDispatcher;
import com.neeve.event.IEventHandler;
import com.neeve.trace.Tracer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public abstract class EventDispatcher
extends EventObject
implements IEventDispatcher {
    private final HashMap<Class<? extends Event>, HashSet<IEventHandler>> handlers = new HashMap();

    protected EventDispatcher() {
        super(null);
    }

    private final HashSet<IEventHandler> getHandlerSet(Class<? extends Event> type) {
        HashSet<IEventHandler> set = this.handlers.get(type);
        if (set == null) {
            set = new HashSet();
            this.handlers.put(type, set);
        }
        return set;
    }

    protected abstract boolean doDispatch(Event var1);

    @Override
    public final void addEventHandler(Class<? extends Event> type, IEventHandler handler) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        this.getHandlerSet(type).add(handler);
    }

    @Override
    public final void removeEventHandler(Class<? extends Event> type, IEventHandler handler) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        this.getHandlerSet(type).remove(handler);
    }

    @Override
    public void onEvent(Event event) {
        HashSet<IEventHandler> set;
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("[Event Dispatcher] Received event for dispatch.", Tracer.Level.DEBUG);
        }
        if (!this.doDispatch(event) && (set = this.handlers.get(event.getClass())) != null) {
            Iterator<IEventHandler> iterator = set.iterator();
            while (iterator.hasNext()) {
                iterator.next().onEvent(event);
            }
        }
    }
}

