/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.neeve.config.Config;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XStringDeserializer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class XString
implements Appendable,
CharSequence {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final String MIN_LONG_STRING = "-9223372036854775808";
    private static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    private static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    private static final CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
    private static final byte FLG_MUTABLE = 1;
    private static final byte FLG_HASVALUE = 2;
    private long addr;
    private short capacity;
    private short length;
    private byte flags;

    protected XString(boolean mutable, short initialCapacity) {
        this.setMutable(mutable);
        this.capacity = initialCapacity;
    }

    public static XString create(short initialCapacity, boolean mutable) {
        return mutable ? new XString(mutable, initialCapacity) : new ImmutableExtension(initialCapacity);
    }

    public static XString create(short initialCapacity) {
        return XString.create(initialCapacity, true);
    }

    public static XString create(int initialCapacity, boolean mutable) {
        if (initialCapacity > Short.MAX_VALUE) {
            throw new IllegalArgumentException("initial capacity cannot be greater than 32767");
        }
        return XString.create((short)initialCapacity, mutable);
    }

    @Deprecated
    public static XString create(boolean mutable, int initialCapacity) {
        return XString.create(initialCapacity, mutable);
    }

    public static XString create(int initialCapacity) {
        return XString.create(initialCapacity, true);
    }

    public static XString create() {
        return XString.create((short)0, true);
    }

    public static XString create(String value, boolean mutable) {
        XString ret = mutable ? new XString(true, (short)(value == null ? 0 : value.length())) : new ImmutableExtension(value);
        ret.setFrom(value);
        return ret;
    }

    public static XString create(String value) {
        return XString.create(value, false);
    }

    private static final boolean equalsCharSequence(CharSequence c1, CharSequence c2) {
        if (c1.length() != c2.length()) {
            return false;
        }
        for (int p = 0; p < c1.length(); ++p) {
            if (c1.charAt(p) == c2.charAt(p)) continue;
            return false;
        }
        return true;
    }

    public static final int stringSize(long val) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (val < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    private final void setHasValue(boolean val) {
        this.flags = val ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    private final void clearCore(boolean freeMemory) {
        if (freeMemory && this.addr != 0L) {
            IOBuffer.freeMemoryBlock(this.addr, this.capacity);
            this.addr = 0L;
            this.capacity = 0;
        }
        this.length = 0;
        this.setHasValue(false);
    }

    final void setMutable(boolean val) {
        this.flags = val ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    final void checkCanMutate() {
        if (!this.canMutate()) {
            throw new IllegalStateException("cannot mutate");
        }
    }

    final void setLength(short val) {
        this.length = val;
        this.setHasValue(true);
    }

    final short checkLengthAndEnsureCapacity(int val) {
        if (val > Short.MAX_VALUE) {
            throw new IllegalArgumentException("maximum length supported by an XString is 32767");
        }
        this.ensureCapacity((short)val);
        return (short)val;
    }

    public final void ensureCapacity(short val) {
        if (this.addr == 0L || val > this.capacity) {
            short newCapacity = (short)Math.max(val, this.capacity);
            this.addr = IOBuffer.ensureMemoryBlockCapacity(this.addr, this.capacity, newCapacity);
            this.capacity = newCapacity;
        }
    }

    public final boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    public final boolean startsWith(CharSequence prefix, int offset) {
        if (this.isNull()) {
            return false;
        }
        if (prefix == null || prefix instanceof XString && ((XString)prefix).isNull()) {
            return false;
        }
        if (offset < 0 || offset > this.length || this.length - offset + 1 < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (this.charAt(i + offset) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public final int indexOf(CharSequence str) {
        return this.indexOf(str, 0);
    }

    public final int indexOf(CharSequence str, int offset) {
        if (this.isNull()) {
            return -1;
        }
        if (str == null || str instanceof XString && ((XString)str).isNull()) {
            return -1;
        }
        if (offset < 0 || offset >= this.length) {
            return -1;
        }
        if (this.length - offset == 0 && str.length() == 0) {
            return 0;
        }
        for (int i = offset; i < this.length; ++i) {
            if (this.startsWith(str, i)) {
                return i;
            }
            if (this.length - i >= str.length()) continue;
            return -1;
        }
        return -1;
    }

    public final int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public final int indexOf(char c, int offset) {
        if (this.isNull()) {
            return -1;
        }
        if (offset < 0 || offset >= this.length) {
            return -1;
        }
        for (int i = offset; i < this.length; ++i) {
            if (this.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public final int compareTo(CharSequence other) {
        if (other instanceof XString) {
            XString x = (XString)other;
            if (x.isNull() && this.isNull()) {
                return 0;
            }
            if (this.isNull()) {
                return -1;
            }
            if (x.isNull()) {
                return 1;
            }
        }
        if (this.isNull()) {
            if (other == null) {
                return 0;
            }
            return -1;
        }
        short len1 = this.length;
        int len2 = other.length();
        int lim = Math.min(len1, len2);
        for (int i = 0; i < lim; ++i) {
            char c2;
            char c1 = this.charAt(i);
            if (c1 == (c2 = other.charAt(i))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public final boolean isMutable() {
        return (this.flags & 1) != 0;
    }

    @Deprecated
    public final boolean isInitialized() {
        return this.hasValue();
    }

    public final boolean hasValue() {
        return (this.flags & 2) != 0;
    }

    public final boolean canMutate() {
        return this.isMutable() || !this.hasValue();
    }

    public final boolean isImmutable() {
        return !this.canMutate();
    }

    @Override
    public final boolean isEmpty() {
        return !this.hasValue() || this.length == 0;
    }

    public final boolean isNull() {
        return !this.hasValue();
    }

    public final void clear(boolean freeMemory) throws IllegalStateException {
        this.checkCanMutate();
        this.clearCore(freeMemory);
    }

    public final void clear() throws IllegalStateException {
        this.clear(Config.conserveMemory());
    }

    @Deprecated
    public final void reset() throws IllegalStateException {
        this.clear();
    }

    public final void setCharAt(int position, char value) {
        this.checkCanMutate();
        if (this.isNull()) {
            throw new NumberFormatException("null");
        }
        if (position < 0 || position >= this.length) {
            throw new IndexOutOfBoundsException("Invalid position: " + position + " valid range is [0, " + this.length + "]");
        }
        if (!asciiEncoder.canEncode(value)) {
            throw new IllegalArgumentException("'" + value + "' is not an ascii character. XString currently only supports setting ascii encodable characters");
        }
        IOBuffer.putByte(this.addr, position, (byte)value);
        this.setHasValue(true);
    }

    public final void initialize(String value) {
        if (this.hasValue()) {
            throw new IllegalStateException("Already inialized");
        }
        this.setFrom(value);
    }

    public final void initializeFrom(XString value) {
        if (this.hasValue()) {
            throw new IllegalStateException("Already inialized");
        }
        this.setFrom(value);
    }

    public final void setFrom(long value) {
        this.checkCanMutate();
        this.clear(false);
        this.append(value);
    }

    public final void setFrom(byte[] value) {
        this.setFrom(value, 0, value != null ? value.length : 0);
    }

    public final void setFrom(byte[] value, int valueOffset, int valueLength) {
        this.checkCanMutate();
        this.clear(false);
        this.append(value, valueOffset, valueLength);
    }

    public void setFrom(char[] value) {
        this.setFrom(value, 0, value != null ? value.length : 0);
    }

    public void setFrom(char[] value, int valueOffset, int valueLength) {
        this.checkCanMutate();
        this.clear(false);
        this.append(value, valueOffset, valueLength);
    }

    public void setFrom(CharSequence value) {
        this.checkCanMutate();
        this.clear(false);
        this.append(value);
    }

    public final void setFrom(String val) {
        this.checkCanMutate();
        if (val != null) {
            short valLength = this.checkLengthAndEnsureCapacity(val.length());
            IOBuffer.putASCIICharSequence(this.addr, 0, val);
            this.setLength(valLength);
        } else {
            this.clear(false);
        }
    }

    public final void setFrom(XString value) {
        if (value == this) {
            return;
        }
        this.checkCanMutate();
        this.clear(false);
        this.append(value);
    }

    public final void setFrom(XStringDeserializer value) {
        value.getTo(this);
    }

    public final void setFrom(long addr, int offset, int len) {
        this.checkCanMutate();
        if (addr > 0L) {
            short valLength = this.checkLengthAndEnsureCapacity(len);
            IOBuffer.copy(addr, offset, this.addr, 0, valLength);
            this.setLength(valLength);
        } else {
            this.clear(false);
        }
    }

    public final void setFrom(ByteBuffer source, int offset, int len) {
        this.checkCanMutate();
        this.clear(false);
        this.append(source, offset, len);
    }

    public final void setFrom(ByteBuffer source) {
        this.checkCanMutate();
        if (source != null) {
            this.setFrom(source, source.position(), source.remaining());
        } else {
            this.clear(false);
        }
    }

    public final void setFrom(IOBuffer source, int offset, int len) {
        this.checkCanMutate();
        if (source != null) {
            short valLength = this.checkLengthAndEnsureCapacity(len);
            IOBuffer.copy(source.getNativeAddress(), offset, this.addr, 0, valLength);
            this.setLength(valLength);
        } else {
            this.clear(false);
        }
    }

    public final void setFrom(IOElasticBuffer source, int offset, int len) {
        this.checkCanMutate();
        if (source != null) {
            short valLength = this.checkLengthAndEnsureCapacity(len);
            source.getTo(offset, this.addr, 0, (int)valLength);
            this.setLength(valLength);
        } else {
            this.clear(false);
        }
    }

    public final void setValue(long value) {
        this.setFrom(value);
    }

    public final void setValue(byte[] value) {
        this.setFrom(value);
    }

    public final void setValue(byte[] value, int valueOffset, int valueLength) {
        this.setFrom(value, valueOffset, valueLength);
    }

    public final void setValue(char[] value) {
        this.setFrom(value);
    }

    public final void setValue(char[] value, int valueOffset, int valueLength) {
        this.setFrom(value, valueOffset, valueLength);
    }

    @JsonIgnore
    public final void setValue(CharSequence value) {
        this.setFrom(value);
    }

    public final void setValue(String value) {
        this.setFrom(value);
    }

    @JsonIgnore
    public final void setValue(XString value) {
        this.setFrom(value);
    }

    public final void setValue(ByteBuffer value, int offset, int len) {
        this.setFrom(value, offset, len);
    }

    public final void setValue(ByteBuffer value) {
        this.setFrom(value);
    }

    public final void setValue(IOBuffer value, int offset, int len) {
        this.setFrom(value, offset, len);
    }

    public final void setValue(IOElasticBuffer value, int offset, int len) {
        this.setFrom(value, offset, len);
    }

    public final void setValue(long addr, int offset, int len) {
        this.setFrom(addr, offset, len);
    }

    public final void setValueFromMemory(long addr, int len) {
        this.setFrom(addr, 0, len);
    }

    public final void copyFrom(char[] val) {
        this.setFrom(val);
    }

    public final void copyFrom(XString value) {
        this.setFrom(value);
    }

    public final void copyFromNative(long addr, int len) {
        this.setFrom(addr, 0, len);
    }

    public final void copyFromMemory(long addr, int len) {
        this.setFrom(addr, 0, len);
    }

    public final XString append(boolean value) {
        this.append(value ? "true" : "false");
        return this;
    }

    @Override
    public final XString append(char value) throws IllegalArgumentException {
        this.checkCanMutate();
        if (!asciiEncoder.canEncode(value)) {
            throw new IllegalArgumentException("'" + value + "' is not an ascii character. XString currently only supports appending ascii encodable characters");
        }
        short newLength = this.checkLengthAndEnsureCapacity(this.length + 1);
        IOBuffer.putByte(this.addr, this.length, (byte)value);
        this.setLength(newLength);
        return this;
    }

    public final XString append(long value) {
        int q2;
        int r;
        if (value == Long.MIN_VALUE) {
            this.append(MIN_LONG_STRING);
            return this;
        }
        this.checkCanMutate();
        int strSize = value < 0L ? XString.stringSize(-value) + 1 : XString.stringSize(value);
        short s = this.checkLengthAndEnsureCapacity(this.length + strSize);
        int charPos = s;
        int sign = 0;
        if (value < 0L) {
            sign = 45;
            value = -value;
        }
        while (value > Integer.MAX_VALUE) {
            long q = value / 100L;
            r = (int)(value - ((q << 6) + (q << 5) + (q << 2)));
            value = q;
            IOBuffer.putByte(this.addr, --charPos, (byte)DigitOnes[r]);
            IOBuffer.putByte(this.addr, --charPos, (byte)DigitTens[r]);
        }
        int i2 = (int)value;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            IOBuffer.putByte(this.addr, --charPos, (byte)DigitOnes[r]);
            IOBuffer.putByte(this.addr, --charPos, (byte)DigitTens[r]);
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            IOBuffer.putByte(this.addr, --charPos, (byte)digits[r]);
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            IOBuffer.putByte(this.addr, --charPos, (byte)sign);
        }
        this.setLength(s);
        return this;
    }

    public final XString append(byte[] value) {
        return this.append(value, 0, value != null ? value.length : 0);
    }

    public final XString append(byte[] value, int valueOffset, int valueLength) {
        this.checkCanMutate();
        if (value == null) {
            return this;
        }
        if (valueOffset < 0 || valueOffset >= value.length) {
            throw new IllegalArgumentException("offset " + valueOffset + " is out of bounds for array of length " + value.length);
        }
        if (valueLength < 0 || valueLength + valueOffset > value.length) {
            throw new IllegalArgumentException("offset " + valueOffset + " and length " + valueLength + " are out of bounds for array of length " + value.length);
        }
        short newLength = this.checkLengthAndEnsureCapacity(this.length + valueLength);
        IOBuffer.putFrom(this.addr, (int)this.length, value, valueOffset, valueLength);
        this.setLength(newLength);
        return this;
    }

    public final XString append(char[] value) throws IllegalArgumentException {
        return this.append(value, 0, value != null ? value.length : 0);
    }

    public final XString append(char[] value, int valueOffset, int valueLength) throws IllegalArgumentException {
        this.checkCanMutate();
        if (value == null) {
            return this;
        }
        if (valueOffset < 0 || valueOffset >= value.length) {
            throw new IllegalArgumentException("offset " + valueOffset + " is out of bounds for array of length " + value.length);
        }
        if (valueLength < 0 || valueLength + valueOffset > value.length) {
            throw new IllegalArgumentException("offset " + valueOffset + " and length " + valueLength + " are out of bounds for array of length " + value.length);
        }
        short newLength = this.checkLengthAndEnsureCapacity(this.length + valueLength);
        int appendPos = this.length;
        for (int i = valueOffset; i < valueOffset + valueLength; ++i) {
            char c = value[i];
            if (!asciiEncoder.canEncode(c)) {
                throw new IllegalArgumentException("'" + c + "' is not an ascii character. XString currently only supports appending ascii encodable characters");
            }
            IOBuffer.putByte(this.addr, appendPos++, (byte)c);
        }
        this.setLength(newLength);
        return this;
    }

    @Override
    public final XString append(CharSequence value) throws IllegalArgumentException {
        this.checkCanMutate();
        if (value == null) {
            return this;
        }
        this.append(value, 0, value.length());
        return this;
    }

    @Override
    public final Appendable append(CharSequence value, int start, int end) throws IllegalArgumentException {
        this.checkCanMutate();
        if (value == null) {
            return this;
        }
        short newLength = this.checkLengthAndEnsureCapacity(this.length + (end - start));
        IOBuffer.putASCIICharSequence(this.addr, this.length, value, start, end);
        this.setLength(newLength);
        return this;
    }

    public final XString append(XString value) {
        this.checkCanMutate();
        if (value == this) {
            throw new IllegalStateException("cannot append an XString to itself");
        }
        if (value == null || value.isNull()) {
            return this;
        }
        short newLength = this.checkLengthAndEnsureCapacity(this.length + value.length());
        IOBuffer.copy(value.addr, 0, this.addr, this.length, value.length());
        this.setLength(newLength);
        return this;
    }

    public final XString append(ByteBuffer value, int valueOffset, int valueLength) {
        this.checkCanMutate();
        if (value == null) {
            return this;
        }
        short newLength = this.checkLengthAndEnsureCapacity(this.length + valueLength);
        IOBuffer.putFrom(this.addr, (int)this.length, value, valueOffset, valueLength);
        this.setLength(newLength);
        return this;
    }

    public final XString append(ByteBuffer value) {
        if (value == null) {
            return this;
        }
        return this.append(value, value.position(), value.remaining());
    }

    public String getAsString() {
        return this.isNull() ? null : IOBuffer.getUTF8CharSequence(this.addr, 0, this.length);
    }

    public final long getAsLong() throws NumberFormatException {
        return this.getAsLong(10);
    }

    public final long getAsLongDecimal() {
        long num = 0L;
        long sign = -1L;
        int len = this.length;
        char ch = this.charAt(0);
        if (ch == '-') {
            sign = 1L;
        } else {
            num = 48 - ch;
        }
        int i = 1;
        while (i < len) {
            num = num * 10L + 48L - (long)this.charAt(i++);
        }
        return sign * num;
    }

    public final long getAsLong(int radix) throws NumberFormatException {
        if (this.isNull()) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = this.length;
        if (max > 0) {
            int digit;
            long limit;
            if (this.charAt(0) == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = radix == 10 ? (negative ? -922337203685477580L : -922337203685477580L) : limit / (long)radix;
            if (i < max) {
                if ((digit = Character.digit(this.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException(this.getAsString());
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(this.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException(this.getAsString());
                }
                if (result < multmin) {
                    throw new NumberFormatException(this.getAsString());
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw new NumberFormatException(this.getAsString());
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException(this.getAsString());
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(this.getAsString());
        }
        return -result;
    }

    public final int getTo(XString val) {
        val.setFrom(this);
        return this.length;
    }

    public final int getTo(byte[] val, int offset) {
        if (this.hasValue()) {
            IOBuffer.getTo(this.addr, 0, val, offset, (int)this.length);
        }
        return this.length;
    }

    public final int getTo(long addr, int offset) {
        if (this.hasValue()) {
            IOBuffer.copy(this.addr, 0, addr, offset, this.length);
        }
        return this.length;
    }

    public final int getTo(ByteBuffer target, int offset) {
        if (this.hasValue()) {
            IOBuffer.getTo(this.addr, 0, target, offset, (int)this.length);
        }
        return this.length;
    }

    public final int getTo(IOElasticBuffer target, int offset) {
        if (this.hasValue()) {
            target.putFrom(offset, this.addr, 0, (int)this.length);
        }
        return this.length;
    }

    public final String getValue() {
        return this.getAsString();
    }

    public final long getValueAsLong() throws NumberFormatException {
        return this.getAsLong();
    }

    @Deprecated
    public final int copyInto(XString val) {
        return this.getTo(val);
    }

    @Deprecated
    public final int copyInto(ByteBuffer target, int offset) {
        return this.getTo(target, offset);
    }

    public final int getTo(IOBuffer target, int offset) {
        if (this.hasValue()) {
            IOBuffer.copy(this.addr, 0, target.getNativeAddress(), offset, this.length);
        }
        return this.length;
    }

    @Deprecated
    public final int copyInto(IOBuffer target, int offset) {
        return this.getTo(target, offset);
    }

    @Deprecated
    public final int copyInto(IOElasticBuffer target, int offset) {
        return this.getTo(target, offset);
    }

    @Override
    public final int length() {
        return this.length;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int serializedLength() {
        return this.length;
    }

    public final long nativeAddress() {
        return this.addr;
    }

    @Deprecated
    public final int getSerializedLength() {
        return this.serializedLength();
    }

    @Override
    public final char charAt(int index) throws IndexOutOfBoundsException {
        if (this.isNull() || index < 0 || index > this.length - 1) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return (char)IOBuffer.getByte(this.addr, index);
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        if (end > this.length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        return new SubCharSequence(start, end - start);
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    public final String toDiagnosticString() {
        return this.getClass().getSimpleName() + ":[mutable=" + this.isMutable() + ", hasval=" + this.hasValue() + ", len=" + this.length() + ", slen=" + this.serializedLength() + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof XString) {
            XString other = (XString)object;
            if (other.isNull() != this.isNull()) {
                return false;
            }
            if (other.length() != this.length) {
                return false;
            }
            int p = 0;
            int t = 0;
            while (p < this.length) {
                if (IOBuffer.getByte(this.addr, p) != IOBuffer.getByte(other.addr, t)) {
                    return false;
                }
                ++p;
                ++t;
            }
            return true;
        }
        if (object instanceof SubCharSequence) {
            return XString.equalsCharSequence(this, (SubCharSequence)object);
        }
        return false;
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        if (this.length == 0) {
            return 0;
        }
        int h = 1;
        for (int p = 0; p < this.length; ++p) {
            h = 31 * h + IOBuffer.getByte(this.addr, p);
        }
        return h;
    }

    public final void close() {
        this.clearCore(true);
    }

    public static final class ImmutableExtension
    extends XString {
        private String str;

        ImmutableExtension(short initialCapacity) {
            super(false, initialCapacity);
        }

        ImmutableExtension(String val) {
            super(false, (short)0);
            this.str = val;
        }

        @Override
        public final String getAsString() {
            if (this.str == null) {
                this.str = super.getAsString();
            }
            return this.str;
        }
    }

    private final class SubCharSequence
    implements CharSequence {
        final int start;
        final int length;

        SubCharSequence(int start, int length) {
            this.start = start;
            this.length = length;
        }

        @Override
        public final int length() {
            return this.length;
        }

        @Override
        public final char charAt(int index) {
            if (index < 0 || index >= this.length) {
                throw new StringIndexOutOfBoundsException("" + index);
            }
            return XString.this.charAt(this.start + index);
        }

        @Override
        public final CharSequence subSequence(int start, int end) {
            if (start < 0) {
                throw new StringIndexOutOfBoundsException(start);
            }
            if (start > end) {
                throw new StringIndexOutOfBoundsException(end - start);
            }
            if (end > this.length) {
                throw new StringIndexOutOfBoundsException(end);
            }
            return XString.this.subSequence(this.start + start, this.start + end);
        }

        public final boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof XString || object instanceof SubCharSequence) {
                return XString.equalsCharSequence(this, (CharSequence)object);
            }
            return true;
        }

        public final int hashCode() {
            if (XString.this.isEmpty()) {
                return 0;
            }
            int h = 1;
            int len = this.length();
            for (int p = 0; p < len; ++p) {
                h = 31 * h + this.charAt(p);
            }
            return h;
        }

        @Override
        public String toString() {
            char[] chars = new char[this.length()];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = this.charAt(i);
            }
            return new String(chars);
        }
    }
}

