/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.neeve.config.Config;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.impl.RogDirectMetadataV2Deserializer;
import com.neeve.rog.impl.RogUtil;
import com.neeve.sma.MessageTransportHeaders;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

@JsonPropertyOrder(value={"enqueueTs", "enqueueTsMicros", "graphId", "inMsgsInTransaction", "isInboundMessage", "isInternal", "isLastTransaction", "isMessage", "isOutboundMessage", "isReplayedMessage", "messageBus", "messageChannel", "messageFlow", "messageKey", "messageSender", "messageSequenceNumber", "requestorId", "requestId", "messageTransportHeaders", "outMsgsInTransaction", "outTs", "outTsMicros", "parentId", "preProcessingTs", "preProcessingTsMicros", "possibleDuplicate", "transactionInSequenceNumber", "transactionOutSequenceNumber"})
public final class RogDirectMetadata
implements IRogMetadata {
    private static final boolean DISABLE_MICROSECOND_TIMESTAMPS = Config.getValue((String)"nv.rog.metadata.disablemicrotimestamps", (boolean)Boolean.FALSE);
    private static final byte V3 = 3;
    private static final byte V4 = 4;
    private static final byte V5 = 5;
    private static final byte V6 = 6;
    private static final byte VERSION = 6;
    private static final int FLAG_IN_MSGS_IN_TRANSACTION = 1;
    private static final int FLAG_OUT_MSGS_IN_TRANSACTION = 2;
    private static final int FLAG_POSDUP = 4;
    private static final int FLAG_IS_MESSAGE = 8;
    private static final int FLAG_IS_MESSAGE_OUTBOUND = 16;
    private static final int FLAG_IS_MESSAGE_REPLAYED = 32;
    private static final int FLAG_LAST_TRANSACTION = 64;
    private static final int FLAG_INTERNAL = 128;
    private static final int FLAG_IS_MESSAGE_INBOUND = 256;
    private static final int FLAG_TS_IN_MICROS = 512;
    private static final int HAS_FLAGS = 1;
    private static final int HAS_TRANSACTION_IN_SEQ_NO = 2;
    private static final int HAS_TRANSACTION_OUT_SEQ_NO = 4;
    private static final int HAS_GRAPH_ID = 8;
    private static final int HAS_PARENT_ID = 16;
    private static final int HAS_PREPROCESSING_TS = 32;
    private static final int HAS_OUT_TS = 64;
    private static final int HAS_MESSAGE_SENDER = 128;
    private static final int HAS_MESSAGE_FLOW = 256;
    private static final int HAS_MESSAGE_SEQ_NUMBER = 512;
    private static final int HAS_MESSAGE_BUS = 1024;
    private static final int HAS_MESSAGE_CHANNEL = 2048;
    private static final int HAS_MESSAGE_KEY = 4096;
    private static final int HAS_ENQUEUE_TS = 8192;
    private static final int HAS_TRANSPORT_HEADERS = 16384;
    private static final int HAS_REQUESTOR_ID = 32768;
    private static final int HAS_REQUEST_ID = 65536;
    private static final MemoryStats memoryStats = MemoryStats.getInstance();
    private int hasFlags;
    private int flags;
    private int graphId;
    private UUID parentId;
    private final MessagingFields messagingFields;
    private IOElasticBuffer buffer;
    private final Offsets offsets;
    private static final String DATE_FORMAT = "yyyyMMdd-HH:mm:ss.SSS";
    private static final byte FLG_READONLY = 1;
    private static final byte FLG_WRAPBUFFER = 2;
    private byte stateFlags;

    RogDirectMetadata(boolean forMessage, boolean copyDeserialize) {
        this.messagingFields = forMessage ? new MessagingFields() : null;
        this.offsets = copyDeserialize ? null : new Offsets();
    }

    RogDirectMetadata() {
        this(true, false);
    }

    private static final String tsToDateString(long ts, SimpleDateFormat dateFormat) {
        return ts == 0L ? "0" : dateFormat.format(new Date(ts));
    }

    public static final RogDirectMetadata create() {
        return new RogDirectMetadata(true, false);
    }

    public static final RogDirectMetadata create(boolean forMessage, boolean copyDeserialize) {
        return new RogDirectMetadata(forMessage, copyDeserialize);
    }

    public static final RogDirectMetadata create(boolean copyDeserialize) {
        return new RogDirectMetadata(true, copyDeserialize);
    }

    public static final RogDirectMetadata createFrom(IOElasticBuffer metadata, int metadataOffset, boolean forMessage, boolean copyDeserialize) {
        return new RogDirectMetadata(forMessage, copyDeserialize).deserializeCore(metadata, metadataOffset, copyDeserialize);
    }

    public static final RogDirectMetadata createFrom(IOElasticBuffer metadata, int metadataOffset) {
        return RogDirectMetadata.createFrom(metadata, metadataOffset, true, false);
    }

    private final void setReadOnly(boolean val) {
        this.stateFlags = val ? (byte)(this.stateFlags | 1) : (byte)(this.stateFlags & 0xFFFFFFFE);
    }

    private final boolean isReadOnly() {
        return (this.stateFlags & 1) != 0;
    }

    private final void checkReadOnly() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Metadata is readonly");
        }
    }

    private final boolean hasField(int flag) {
        return (this.hasFlags & flag) == flag;
    }

    private final void setHasField(int flag) {
        this.hasFlags |= flag;
    }

    private final void clearHasField(int flag) {
        this.hasFlags &= ~flag;
    }

    private final void setFlag(int flag) {
        this.flags |= flag;
        this.setHasField(1);
    }

    private final void clearFlag(int flag) {
        this.flags &= ~flag;
        if (this.flags == 0) {
            this.clearHasField(1);
        }
    }

    private final boolean getFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    private final XString messageBusBuffer(short initialLength) {
        if (this.messagingFields.messageBusBuffer == null) {
            this.messagingFields.messageBusBuffer = XString.create((short)initialLength);
        }
        return this.messagingFields.messageBusBuffer;
    }

    private final XString messageChannelBuffer(short initialLength) {
        if (this.messagingFields.messageChannelBuffer == null) {
            this.messagingFields.messageChannelBuffer = XString.create((short)initialLength);
        }
        return this.messagingFields.messageChannelBuffer;
    }

    final XString messageKeyBuffer(short initialLength) {
        if (this.messagingFields.messageKeyBuffer == null) {
            this.messagingFields.messageKeyBuffer = XString.create((short)initialLength);
        } else {
            this.messagingFields.messageKeyBuffer.ensureCapacity(initialLength);
        }
        return this.messagingFields.messageKeyBuffer;
    }

    private final XString requestorIdBuffer(short initialLength) {
        if (this.messagingFields.requestorIdBuffer == null) {
            this.messagingFields.requestorIdBuffer = XString.create((short)initialLength);
        }
        return this.messagingFields.requestorIdBuffer;
    }

    private final RogDirectMetadata deserializeCore(IOElasticBuffer metadata, int metadataOffset, boolean copyDeserialize) {
        boolean frameDeserialize;
        boolean bl = frameDeserialize = !copyDeserialize && this.offsets != null;
        if (metadata != null) {
            int len = 0;
            byte version = metadata.get(metadataOffset + len);
            if (version >= 3) {
                len = (short)(len + 1);
                this.hasFlags = metadata.getInt(metadataOffset + len);
                len = (short)(len + 4);
                if (this.hasField(1)) {
                    this.flags = metadata.getInt(metadataOffset + len);
                    len = (short)(len + 4);
                }
                if (this.hasField(2)) {
                    if (frameDeserialize) {
                        this.offsets.transactionInSequenceNumberOffset = (short)len;
                    } else {
                        this.messagingFields.transactionInSequenceNumber = metadata.getInt(metadataOffset + len);
                    }
                    len = (short)(len + 4);
                }
                if (this.hasField(4)) {
                    if (frameDeserialize) {
                        this.offsets.transactionOutSequenceNumberOffset = (short)len;
                    } else {
                        this.messagingFields.transactionOutSequenceNumber = metadata.getInt(metadataOffset + len);
                    }
                    len = (short)(len + 4);
                }
                if (this.hasField(8)) {
                    if (frameDeserialize) {
                        this.offsets.graphIdOffset = (short)len;
                    } else {
                        this.graphId = metadata.getInt(metadataOffset + len);
                    }
                    len = (short)(len + 4);
                }
                if (this.hasField(16)) {
                    if (frameDeserialize) {
                        this.offsets.parentIdOffset = (short)len;
                    } else {
                        long time = metadata.getLong(metadataOffset + len);
                        long cas = metadata.getLong(metadataOffset + len + 8);
                        this.parentId = new UUID(time, cas);
                    }
                    len = (short)(len + 16);
                }
                if (this.hasField(32)) {
                    if (frameDeserialize) {
                        this.offsets.preprocTsOffset = (short)len;
                    } else {
                        this.messagingFields.preprocTs = metadata.getLong(metadataOffset + len);
                        if (!this.getFlag(512)) {
                            this.messagingFields.preprocTs = this.messagingFields.preprocTs * 1000L;
                        }
                    }
                    len = (short)(len + 8);
                }
                if (this.hasField(64)) {
                    if (frameDeserialize) {
                        this.offsets.outTsOffset = (short)len;
                    } else {
                        this.messagingFields.outTs = metadata.getLong(metadataOffset + len);
                        if (!this.getFlag(512)) {
                            this.messagingFields.outTs = this.messagingFields.outTs * 1000L;
                        }
                    }
                    len = (short)(len + 8);
                }
                if (version > 3 && this.hasField(8192)) {
                    if (frameDeserialize) {
                        this.offsets.enqueueTsOffset = (short)len;
                    } else {
                        this.messagingFields.enqueueTs = metadata.getLong(metadataOffset + len);
                        if (!this.getFlag(512)) {
                            this.messagingFields.enqueueTs = this.messagingFields.enqueueTs * 1000L;
                        }
                    }
                    len = (short)(len + 8);
                }
                if (this.hasField(128)) {
                    if (frameDeserialize) {
                        this.offsets.messageSenderOffset = (short)len;
                    } else {
                        this.messagingFields.messageSender = metadata.getInt(metadataOffset + len);
                    }
                    len = (short)(len + 4);
                }
                if (this.hasField(256)) {
                    if (frameDeserialize) {
                        this.offsets.messageFlowOffset = (short)len;
                    } else {
                        this.messagingFields.messageFlow = metadata.getInt(metadataOffset + len);
                    }
                    len = (short)(len + 4);
                }
                if (this.hasField(512)) {
                    if (frameDeserialize) {
                        this.offsets.messageSnoOffset = (short)len;
                    } else {
                        this.messagingFields.messageSno = metadata.getLong(metadataOffset + len);
                    }
                    len = (short)(len + 8);
                }
                if (this.hasField(1024)) {
                    short messageBusLen = metadata.getShort(metadataOffset + len);
                    if (frameDeserialize) {
                        this.offsets.messageBusOffset = (short)len;
                    } else {
                        (this.messagingFields.messageBus = this.messageBusBuffer(messageBusLen)).setValue(metadata, metadataOffset + len + 2, (int)messageBusLen);
                    }
                    len = (short)(len + (2 + messageBusLen));
                }
                if (this.hasField(2048)) {
                    short messageChannelLen = metadata.getShort(metadataOffset + len);
                    if (frameDeserialize) {
                        this.offsets.messageChannelOffset = (short)len;
                    } else {
                        (this.messagingFields.messageChannel = this.messageChannelBuffer(messageChannelLen)).setValue(metadata, metadataOffset + len + 2, (int)messageChannelLen);
                    }
                    len = (short)(len + (2 + messageChannelLen));
                }
                if (this.hasField(4096)) {
                    short messageKeyLen = metadata.getShort(metadataOffset + len);
                    if (frameDeserialize) {
                        this.offsets.messageKeyOffset = (short)len;
                    } else {
                        (this.messagingFields.messageKey = this.messageKeyBuffer(messageKeyLen)).setValue(metadata, metadataOffset + len + 2, (int)messageKeyLen);
                    }
                    len = (short)(len + (2 + messageKeyLen));
                }
                if (version > 5 && this.hasField(32768)) {
                    short requestorIdLen = metadata.getShort(metadataOffset + len);
                    if (frameDeserialize) {
                        this.offsets.requestorIdOffset = (short)len;
                    } else {
                        (this.messagingFields.requestorId = this.requestorIdBuffer(requestorIdLen)).setValue(metadata, metadataOffset + len + 2, (int)requestorIdLen);
                    }
                    len = (short)(len + (2 + requestorIdLen));
                }
                if (version > 5 && this.hasField(65536)) {
                    if (frameDeserialize) {
                        this.offsets.requestIdOffset = (short)len;
                    } else {
                        this.messagingFields.requestId = metadata.getLong(metadataOffset + len);
                    }
                    len = (short)(len + 8);
                }
                if (version > 4 && this.hasField(16384)) {
                    int messageTransportHeadersLen = MessageTransportHeaders.getSerializedLength((IOElasticBuffer)metadata, (int)len);
                    if (frameDeserialize) {
                        this.offsets.messageTransportHeadersOffset = (short)len;
                    } else {
                        if (this.messagingFields.messageTransportHeaders == null) {
                            this.messagingFields.messageTransportHeaders = MessageTransportHeaders.create();
                        }
                        this.messagingFields.messageTransportHeaders.deserialize(metadata, len);
                    }
                    len = (short)(len + messageTransportHeadersLen);
                }
                if (frameDeserialize) {
                    if (this.buffer == null) {
                        this.buffer = IOElasticBuffer.create((int)(Config.conserveMemory() ? 1 : 128));
                    }
                    if (this.isWrapDeserializeBuffer()) {
                        this.buffer.wrapBackingBuffer(metadata.getBackingBufferUnsafe(), metadata.getOffset() + metadataOffset, metadata.getLength() - metadataOffset);
                    } else {
                        this.buffer.putFrom(0, metadata, metadataOffset, len);
                    }
                }
            } else if (version == 2) {
                this.setGraphId(RogDirectMetadataV2Deserializer.getGraphId(metadata));
                this.setInMsgsInTransaction(RogDirectMetadataV2Deserializer.getInMsgsInTransaction(metadata));
                this.setIsInboundMessage(RogDirectMetadataV2Deserializer.getIsInboundMessage(metadata));
                this.setIsInternal(RogDirectMetadataV2Deserializer.getIsInternal(metadata));
                this.setIsLastTransaction(RogDirectMetadataV2Deserializer.getIsLastTransaction(metadata));
                this.setIsMessage(RogDirectMetadataV2Deserializer.getIsMessage(metadata));
                this.setIsOutboundMessage(RogDirectMetadataV2Deserializer.getIsOutboundMessage(metadata));
                this.setIsReplayedMessage(RogDirectMetadataV2Deserializer.getIsReplayedMessage(metadata));
                this.setMessageFlow(RogDirectMetadataV2Deserializer.getMessageFlow(metadata));
                this.setMessageSender(RogDirectMetadataV2Deserializer.getMessageSender(metadata));
                this.setMessageSequenceNumber(RogDirectMetadataV2Deserializer.getMessageSequenceNumber(metadata));
                this.setOutMsgsInTransaction(RogDirectMetadataV2Deserializer.getOutMsgsInTransaction(metadata));
                this.setOutTs(RogDirectMetadataV2Deserializer.getOutTs(metadata));
                this.setParentId(RogDirectMetadataV2Deserializer.getParentId(metadata));
                this.setPossibleDuplicate(RogDirectMetadataV2Deserializer.isPossibleDuplicate(metadata));
                this.setPreProcessingTs(RogDirectMetadataV2Deserializer.getPreProcessingTs(metadata));
                this.setTransactionInSequenceNumber(RogDirectMetadataV2Deserializer.getTransactionInSequenceNumber(metadata));
                this.setTransactionOutSequenceNumber(RogDirectMetadataV2Deserializer.getTransactionOutSequenceNumber(metadata));
                if (RogDirectMetadataV2Deserializer.hasMessageBus(metadata)) {
                    RogDirectMetadataV2Deserializer.getMessageBus(metadata, this.messagingFields.messageBus = this.messageBusBuffer(RogDirectMetadataV2Deserializer.getMessageBusLength(metadata)));
                    this.setHasField(1024);
                }
                if (RogDirectMetadataV2Deserializer.hasMessageChannel(metadata)) {
                    RogDirectMetadataV2Deserializer.getMessageChannel(metadata, this.messagingFields.messageChannel = this.messageChannelBuffer(RogDirectMetadataV2Deserializer.getMessageChannelLength(metadata)));
                    this.setHasField(2048);
                }
                if (RogDirectMetadataV2Deserializer.hasMessageKey(metadata)) {
                    RogDirectMetadataV2Deserializer.getMessageKey(metadata, this.messagingFields.messageKey = this.messageKeyBuffer(RogDirectMetadataV2Deserializer.getMessageKeyLength(metadata)));
                    this.setHasField(4096);
                }
            } else {
                if (version > 6) {
                    throw new RuntimeException("Unsupported ROG metadata version: " + version + " (possibly created with a newer version?)");
                }
                throw new RuntimeException("Unsupported ROG metadata version: " + version + " (corrupt?)");
            }
        }
        this.setReadOnly(frameDeserialize);
        return this;
    }

    private final byte resolveSerializedVersion() {
        int val = 4;
        if (this.hasField(65536) || this.hasField(32768)) {
            val = 6;
        } else if (this.hasField(16384)) {
            val = 5;
        }
        return (byte)val;
    }

    public final RogDirectMetadata init() {
        this.hasFlags = 0;
        this.flags = 0;
        this.graphId = 0;
        this.parentId = null;
        if (this.messagingFields != null) {
            this.messagingFields.init();
        }
        if (this.buffer != null) {
            if (Config.conserveMemory()) {
                this.buffer.reset();
            } else {
                this.buffer.setLength(0);
            }
        }
        if (this.offsets != null) {
            this.offsets.init();
        }
        return this;
    }

    public final RogDirectMetadata reset() {
        this.init();
        this.stateFlags = 0;
        return this;
    }

    @Override
    @JsonProperty
    public final boolean getInMsgsInTransaction() {
        return this.getFlag(1);
    }

    public final void setInMsgsInTransaction(boolean val) {
        if (val) {
            this.setFlag(1);
        } else {
            this.clearFlag(1);
        }
    }

    @Override
    @JsonProperty
    public final boolean getOutMsgsInTransaction() {
        return this.getFlag(2);
    }

    public final void setOutMsgsInTransaction(boolean val) {
        if (val) {
            this.setFlag(2);
        } else {
            this.clearFlag(2);
        }
    }

    @Override
    @JsonProperty
    public final boolean getIsMessage() {
        return this.getFlag(8);
    }

    public final void setIsMessage(boolean val) {
        if (val) {
            this.setFlag(8);
        } else {
            this.clearFlag(8);
        }
    }

    @Override
    @JsonProperty
    public final boolean getIsInboundMessage() {
        return this.getFlag(256);
    }

    public final void setIsInboundMessage(boolean val) {
        if (val) {
            this.setFlag(256);
        } else {
            this.clearFlag(256);
        }
    }

    @Override
    @JsonProperty
    public final boolean getIsOutboundMessage() {
        return this.getFlag(16);
    }

    public final void setIsOutboundMessage(boolean val) {
        if (val) {
            this.setFlag(16);
        } else {
            this.clearFlag(16);
        }
    }

    @Override
    @JsonProperty
    public final boolean getIsReplayedMessage() {
        return this.getFlag(32);
    }

    public final void setIsReplayedMessage(boolean val) {
        if (val) {
            this.setFlag(32);
        } else {
            this.clearFlag(32);
        }
    }

    @Override
    @JsonProperty
    public final boolean getIsLastTransaction() {
        return this.getFlag(64);
    }

    public final void setIsLastTransaction(boolean val) {
        if (val) {
            this.setFlag(64);
        } else {
            this.clearFlag(64);
        }
    }

    @Override
    @JsonProperty
    public final boolean getIsInternal() {
        return this.getFlag(128);
    }

    public final void setIsInternal(boolean val) {
        if (val) {
            this.setFlag(128);
        } else {
            this.clearFlag(128);
        }
    }

    @Override
    @JsonProperty
    public final boolean isPossibleDuplicate() {
        return this.getFlag(4);
    }

    public final void setPossibleDuplicate(boolean val) {
        if (val) {
            this.setFlag(4);
        } else {
            this.clearFlag(4);
        }
    }

    @Override
    @JsonProperty
    public final int getTransactionInSequenceNumber() {
        if (this.messagingFields == null) {
            return 0;
        }
        if (this.offsets != null && this.offsets.transactionInSequenceNumberOffset > 0) {
            this.messagingFields.transactionInSequenceNumber = this.buffer.getInt((int)this.offsets.transactionInSequenceNumberOffset);
            this.offsets.transactionInSequenceNumberOffset = 0;
        }
        return this.messagingFields.transactionInSequenceNumber;
    }

    public final void setTransactionInSequenceNumber(int val) {
        this.checkReadOnly();
        if (val != 0) {
            this.setHasField(2);
        } else {
            this.clearHasField(2);
        }
        this.messagingFields.transactionInSequenceNumber = val;
    }

    @Override
    @JsonProperty
    public final int getTransactionOutSequenceNumber() {
        if (this.messagingFields == null) {
            return 0;
        }
        if (this.offsets != null && this.offsets.transactionOutSequenceNumberOffset > 0) {
            this.messagingFields.transactionOutSequenceNumber = this.buffer.getInt((int)this.offsets.transactionOutSequenceNumberOffset);
            this.offsets.transactionOutSequenceNumberOffset = 0;
        }
        return this.messagingFields.transactionOutSequenceNumber;
    }

    public final void setTransactionOutSequenceNumber(int val) {
        this.checkReadOnly();
        if (val != 0) {
            this.setHasField(4);
        } else {
            this.clearHasField(4);
        }
        this.messagingFields.transactionOutSequenceNumber = val;
    }

    @Override
    @JsonProperty
    public final int getGraphId() {
        if (this.offsets != null && this.offsets.graphIdOffset > 0) {
            this.graphId = this.buffer.getInt((int)this.offsets.graphIdOffset);
            this.offsets.graphIdOffset = 0;
        }
        return this.graphId;
    }

    public final void setGraphId(int val) {
        this.checkReadOnly();
        if (val != 0) {
            this.setHasField(8);
        } else {
            this.clearHasField(8);
        }
        this.graphId = val;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RogUtil.UUIDToStringConverter.class)
    public final UUID getParentId() {
        if (this.offsets != null && this.offsets.parentIdOffset > 0) {
            long time = this.buffer.getLong((int)this.offsets.parentIdOffset);
            long cas = this.buffer.getLong(this.offsets.parentIdOffset + 8);
            this.parentId = new UUID(time, cas);
            this.offsets.parentIdOffset = 0;
        }
        return this.parentId;
    }

    @JsonSerialize(converter=RogUtil.StringToUUIDConverter.class)
    public final void setParentId(UUID val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(16);
        } else {
            this.clearHasField(16);
        }
        this.parentId = val;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RogUtil.TimestampToDateConverter.class)
    public final long getPreProcessingTs() {
        if (this.messagingFields == null) {
            return 0L;
        }
        if (this.offsets != null && this.offsets.preprocTsOffset > 0) {
            this.messagingFields.preprocTs = this.buffer.getLong((int)this.offsets.preprocTsOffset);
            if (!this.getFlag(512)) {
                this.messagingFields.preprocTs = this.messagingFields.preprocTs * 1000L;
            }
            this.offsets.preprocTsOffset = 0;
        }
        return this.messagingFields.preprocTs / 1000L;
    }

    @JsonDeserialize(converter=RogUtil.DateToTimestampConverter.class)
    public final void setPreProcessingTs(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(32);
        } else {
            this.clearHasField(32);
        }
        this.messagingFields.preprocTs = val * 1000L;
    }

    @Override
    @JsonProperty
    public final long getPreProcessingTsMicros() {
        if (this.messagingFields == null) {
            return 0L;
        }
        if (this.offsets != null && this.offsets.preprocTsOffset > 0) {
            this.messagingFields.preprocTs = this.buffer.getLong((int)this.offsets.preprocTsOffset);
            if (!this.getFlag(512)) {
                this.messagingFields.preprocTs = this.messagingFields.preprocTs * 1000L;
            }
            this.offsets.preprocTsOffset = 0;
        }
        return this.messagingFields.preprocTs;
    }

    public final void setPreProcessingTsMicros(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(32);
        } else {
            this.clearHasField(32);
        }
        this.messagingFields.preprocTs = val;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RogUtil.TimestampToDateConverter.class)
    public final long getOutTs() {
        if (this.messagingFields == null) {
            return 0L;
        }
        if (this.offsets != null && this.offsets.outTsOffset > 0) {
            this.messagingFields.outTs = this.buffer.getLong((int)this.offsets.outTsOffset);
            if (!this.getFlag(512)) {
                this.messagingFields.outTs = this.messagingFields.outTs * 1000L;
            }
            this.offsets.outTsOffset = 0;
        }
        return this.messagingFields.outTs / 1000L;
    }

    @JsonDeserialize(converter=RogUtil.DateToTimestampConverter.class)
    public final void setOutTs(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(64);
        } else {
            this.clearHasField(64);
        }
        this.messagingFields.outTs = val * 1000L;
    }

    @Override
    @JsonProperty
    public final long getOutTsMicros() {
        if (this.messagingFields == null) {
            return 0L;
        }
        if (this.offsets != null && this.offsets.outTsOffset > 0) {
            this.messagingFields.outTs = this.buffer.getLong((int)this.offsets.outTsOffset);
            if (!this.getFlag(512)) {
                this.messagingFields.outTs = this.messagingFields.outTs * 1000L;
            }
            this.offsets.outTsOffset = 0;
        }
        return this.messagingFields.outTs;
    }

    public final void setOutTsMicros(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(64);
        } else {
            this.clearHasField(64);
        }
        this.messagingFields.outTs = val;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RogUtil.TimestampToDateConverter.class)
    public final long getEnqueueTs() {
        if (this.messagingFields == null) {
            return 0L;
        }
        if (this.offsets != null && this.offsets.enqueueTsOffset > 0) {
            this.messagingFields.enqueueTs = this.buffer.getLong((int)this.offsets.enqueueTsOffset);
            if (!this.getFlag(512)) {
                this.messagingFields.enqueueTs = this.messagingFields.enqueueTs * 1000L;
            }
            this.offsets.enqueueTsOffset = 0;
        }
        return this.messagingFields.enqueueTs / 1000L;
    }

    @JsonDeserialize(converter=RogUtil.DateToTimestampConverter.class)
    public final void setEnqueueTs(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(8192);
        } else {
            this.clearHasField(8192);
        }
        this.messagingFields.enqueueTs = val * 1000L;
    }

    @Override
    @JsonProperty
    public final long getEnqueueTsMicros() {
        if (this.messagingFields == null) {
            return 0L;
        }
        if (this.offsets != null && this.offsets.enqueueTsOffset > 0) {
            this.messagingFields.enqueueTs = this.buffer.getLong((int)this.offsets.enqueueTsOffset);
            if (!this.getFlag(512)) {
                this.messagingFields.enqueueTs = this.messagingFields.enqueueTs * 1000L;
            }
            this.offsets.enqueueTsOffset = 0;
        }
        return this.messagingFields.enqueueTs;
    }

    public final void setEnqueueTsMicros(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(8192);
        } else {
            this.clearHasField(8192);
        }
        this.messagingFields.enqueueTs = val;
    }

    @Override
    @JsonProperty
    public final int getMessageSender() {
        if (this.messagingFields == null) {
            return 0;
        }
        if (this.offsets != null && this.offsets.messageSenderOffset > 0) {
            this.messagingFields.messageSender = this.buffer.getInt((int)this.offsets.messageSenderOffset);
            this.offsets.messageSenderOffset = 0;
        }
        return this.messagingFields.messageSender;
    }

    public final void setMessageSender(int val) {
        this.checkReadOnly();
        if (val != 0) {
            this.setHasField(128);
        } else {
            this.clearHasField(128);
        }
        this.messagingFields.messageSender = val;
    }

    @Override
    @JsonProperty
    public final int getMessageFlow() {
        if (this.messagingFields == null) {
            return 0;
        }
        if (this.offsets != null && this.offsets.messageFlowOffset > 0) {
            this.messagingFields.messageFlow = this.buffer.getInt((int)this.offsets.messageFlowOffset);
            this.offsets.messageFlowOffset = 0;
        }
        return this.messagingFields.messageFlow;
    }

    public final void setMessageFlow(int val) {
        this.checkReadOnly();
        if (val != 0) {
            this.setHasField(256);
        } else {
            this.clearHasField(256);
        }
        this.messagingFields.messageFlow = val;
    }

    @Override
    @JsonProperty
    public final long getMessageSequenceNumber() {
        if (this.messagingFields == null) {
            return 0L;
        }
        if (this.offsets != null && this.offsets.messageSnoOffset > 0) {
            this.messagingFields.messageSno = this.buffer.getLong((int)this.offsets.messageSnoOffset);
            this.offsets.messageSnoOffset = 0;
        }
        return this.messagingFields.messageSno;
    }

    public final void setMessageSequenceNumber(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(512);
        } else {
            this.clearHasField(512);
        }
        this.messagingFields.messageSno = val;
    }

    @Override
    @JsonProperty
    public final String getMessageBus() {
        XString rc = this.getMessageBusAsRaw();
        if (rc == null) {
            return null;
        }
        return rc.getValue();
    }

    @JsonIgnore
    public final XString getMessageBusAsRaw() {
        if (this.messagingFields == null) {
            return null;
        }
        if (this.offsets != null && this.offsets.messageBusOffset > 0) {
            short messageBusLength = this.buffer.getShort((int)this.offsets.messageBusOffset);
            (this.messagingFields.messageBus = this.messageBusBuffer(messageBusLength)).setValue(this.buffer.getBackingBufferUnsafe(), this.buffer.getOffset() + this.offsets.messageBusOffset + 2, (int)messageBusLength);
            this.offsets.messageBusOffset = 0;
        }
        if (this.messagingFields.messageBus == null || this.messagingFields.messageBus.isNull()) {
            return null;
        }
        return this.messagingFields.messageBus;
    }

    public final void setMessageBus(String val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(1024);
            (this.messagingFields.messageBus = this.messageBusBuffer((short)val.length())).setValue(val);
        } else {
            this.clearHasField(1024);
            if (this.messagingFields.messageBusBuffer != null) {
                (this.messagingFields.messageBus = this.messagingFields.messageBusBuffer).setValue((String)null);
            } else {
                this.messagingFields.messageBus = null;
            }
        }
    }

    public final void setMessageBusAsRaw(XString val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(1024);
        } else {
            this.clearHasField(1024);
        }
        if (val != null && val.isMutable()) {
            val.getTo(this.messagingFields.messageBus = this.messageBusBuffer((short)val.length()));
        } else {
            this.messagingFields.messageBus = val;
        }
    }

    @Override
    @JsonProperty
    public final String getMessageChannel() {
        XString rc = this.getMessageChannelAsRaw();
        if (rc == null) {
            return null;
        }
        return rc.getValue();
    }

    @JsonIgnore
    public final XString getMessageChannelAsRaw() {
        if (this.messagingFields == null) {
            return null;
        }
        if (this.offsets != null && this.offsets.messageChannelOffset > 0) {
            short messageChannelLength = this.buffer.getShort((int)this.offsets.messageChannelOffset);
            (this.messagingFields.messageChannel = this.messageChannelBuffer(messageChannelLength)).setValue(this.buffer.getBackingBufferUnsafe(), this.buffer.getOffset() + this.offsets.messageChannelOffset + 2, (int)messageChannelLength);
            this.offsets.messageChannelOffset = 0;
        }
        if (this.messagingFields.messageChannel == null || this.messagingFields.messageChannel.isNull()) {
            return null;
        }
        return this.messagingFields.messageChannel;
    }

    public final void setMessageChannel(String val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(2048);
            (this.messagingFields.messageChannel = this.messageChannelBuffer((short)val.length())).setValue(val);
        } else {
            this.clearHasField(2048);
            if (this.messagingFields.messageChannelBuffer != null) {
                (this.messagingFields.messageChannel = this.messagingFields.messageChannelBuffer).setValue((String)null);
            } else {
                this.messagingFields.messageChannel = null;
            }
        }
    }

    public final void setMessageChannelAsRaw(XString val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(2048);
        } else {
            this.clearHasField(2048);
        }
        if (val != null && val.isMutable()) {
            val.getTo(this.messagingFields.messageChannel = this.messageChannelBuffer((short)val.length()));
        } else {
            this.messagingFields.messageChannel = val;
        }
    }

    @Override
    @JsonProperty
    public final String getMessageKey() {
        XString rc = this.getMessageKeyAsRaw();
        if (rc == null) {
            return null;
        }
        return rc.getValue();
    }

    @JsonIgnore
    public final XString getMessageKeyAsRaw() {
        if (this.messagingFields == null) {
            return null;
        }
        if (this.offsets != null && this.offsets.messageKeyOffset > 0) {
            short messageKeyLength = this.buffer.getShort((int)this.offsets.messageKeyOffset);
            (this.messagingFields.messageKey = this.messageKeyBuffer(messageKeyLength)).setValue(this.buffer.getBackingBufferUnsafe(), this.buffer.getOffset() + this.offsets.messageKeyOffset + 2, (int)messageKeyLength);
            this.offsets.messageKeyOffset = 0;
        }
        if (this.messagingFields.messageKey == null || this.messagingFields.messageKey.isNull()) {
            return null;
        }
        return this.messagingFields.messageKey;
    }

    public final void setMessageKey(String val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(4096);
            (this.messagingFields.messageKey = this.messageKeyBuffer((short)(val.length() + 1))).setValue(val);
        } else {
            this.clearHasField(4096);
            if (this.messagingFields.messageKeyBuffer != null) {
                (this.messagingFields.messageKey = this.messagingFields.messageKeyBuffer).setValue(val);
            } else {
                this.messagingFields.messageKey = null;
            }
        }
    }

    public final void setMessageKeyAsRaw(XString val) {
        this.checkReadOnly();
        if (val != null && !val.isNull()) {
            this.setHasField(4096);
        } else {
            this.clearHasField(4096);
        }
        if (val != null && val.isMutable()) {
            short requiredCapacity = (short)(val.length() + 1);
            if (val == this.messagingFields.messageKeyBuffer) {
                this.messagingFields.messageKey = val;
                val.ensureCapacity(requiredCapacity);
            } else {
                val.getTo(this.messagingFields.messageKey = this.messageKeyBuffer(requiredCapacity));
            }
        } else {
            this.messagingFields.messageKey = val;
        }
    }

    @Override
    @JsonProperty
    public final String getRequestorId() {
        XString rc = this.getRequestorIdAsRaw();
        if (rc == null) {
            return null;
        }
        return rc.getValue();
    }

    @JsonIgnore
    public final XString getRequestorIdAsRaw() {
        if (this.messagingFields == null) {
            return null;
        }
        if (this.offsets != null && this.offsets.requestorIdOffset > 0) {
            short requestorIdLength = this.buffer.getShort((int)this.offsets.requestorIdOffset);
            (this.messagingFields.requestorId = this.requestorIdBuffer(requestorIdLength)).setValue(this.buffer.getBackingBufferUnsafe(), this.buffer.getOffset() + this.offsets.requestorIdOffset + 2, (int)requestorIdLength);
            this.offsets.requestorIdOffset = 0;
        }
        if (this.messagingFields.requestorId == null || this.messagingFields.requestorId.isNull()) {
            return null;
        }
        return this.messagingFields.requestorId;
    }

    public final void setRequestorId(String val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(32768);
            (this.messagingFields.requestorId = this.requestorIdBuffer((short)val.length())).setValue(val);
        } else {
            this.clearHasField(32768);
            if (this.messagingFields.requestorIdBuffer != null) {
                (this.messagingFields.requestorId = this.messagingFields.requestorIdBuffer).setValue(val);
            } else {
                this.messagingFields.requestorId = null;
            }
        }
    }

    public final void setRequestorIdAsRaw(XString val) {
        this.checkReadOnly();
        if (val != null && !val.isNull()) {
            this.setHasField(32768);
        } else {
            this.clearHasField(32768);
        }
        if (val != null && val.isMutable()) {
            val.getTo(this.messagingFields.requestorId = this.requestorIdBuffer((short)val.length()));
        } else {
            this.messagingFields.requestorId = val;
        }
    }

    @Override
    @JsonProperty
    public final long getRequestId() {
        if (this.messagingFields == null) {
            return 0L;
        }
        if (this.offsets != null && this.offsets.requestIdOffset > 0) {
            this.messagingFields.requestId = this.buffer.getLong((int)this.offsets.requestIdOffset);
            this.offsets.requestIdOffset = 0;
        }
        return this.messagingFields.requestId;
    }

    public final void setRequestId(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(65536);
        } else {
            this.clearHasField(65536);
        }
        this.messagingFields.requestId = val;
    }

    @Override
    public final MessageTransportHeaders activateMessageTransportHeaders() {
        MessageTransportHeaders headers = this.getMessageTransportHeaders();
        if (headers == null) {
            this.checkReadOnly();
            this.setHasField(16384);
            headers = this.messagingFields.messageTransportHeaders;
            if (headers == null) {
                headers = this.messagingFields.messageTransportHeaders = MessageTransportHeaders.create();
            }
        }
        return headers;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RogUtil.MessageTransportHeadersToMapConverter.class)
    public final MessageTransportHeaders getMessageTransportHeaders() {
        if (this.messagingFields == null) {
            return null;
        }
        if (this.hasField(16384)) {
            if (this.offsets != null && this.offsets.messageTransportHeadersOffset > 0) {
                if (this.messagingFields.messageTransportHeaders == null) {
                    this.messagingFields.messageTransportHeaders = MessageTransportHeaders.create();
                }
                this.messagingFields.messageTransportHeaders.deserialize(this.buffer, (int)this.offsets.messageTransportHeadersOffset);
                this.offsets.messageTransportHeadersOffset = 0;
            } else if (this.messagingFields.messageTransportHeaders == null) {
                this.messagingFields.messageTransportHeaders = MessageTransportHeaders.create();
            }
            return this.messagingFields.messageTransportHeaders;
        }
        return null;
    }

    @JsonDeserialize(converter=RogUtil.MapToMessageTransportHeadersConverter.class)
    public final void setMessageTransportHeaders(MessageTransportHeaders val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(16384);
            if (val == this.messagingFields.messageTransportHeaders) {
                return;
            }
            if (this.messagingFields.messageTransportHeaders != null) {
                this.messagingFields.messageTransportHeaders.dispose();
            }
            this.messagingFields.messageTransportHeaders = val;
        } else {
            this.clearHasField(16384);
            if (this.messagingFields.messageTransportHeaders != null) {
                this.messagingFields.messageTransportHeaders.dispose();
                this.messagingFields.messageTransportHeaders = null;
            }
        }
    }

    public final int serializedLength() {
        int len = 0;
        ++len;
        len += 4;
        if (this.hasField(1)) {
            len += 4;
        }
        if (this.hasField(2)) {
            len += 4;
        }
        if (this.hasField(4)) {
            len += 4;
        }
        if (this.hasField(8)) {
            len += 4;
        }
        if (this.hasField(16)) {
            len += 16;
        }
        if (this.hasField(32)) {
            len += 8;
        }
        if (this.hasField(64)) {
            len += 8;
        }
        if (this.hasField(8192)) {
            len += 8;
        }
        if (this.hasField(128)) {
            len += 4;
        }
        if (this.hasField(256)) {
            len += 4;
        }
        if (this.hasField(512)) {
            len += 8;
        }
        if (this.hasField(1024)) {
            len += 2 + this.getMessageBusAsRaw().serializedLength();
        }
        if (this.hasField(2048)) {
            len += 2 + this.getMessageChannelAsRaw().serializedLength();
        }
        if (this.hasField(4096)) {
            len += 2 + this.getMessageKeyAsRaw().serializedLength();
        }
        if (this.hasField(32768)) {
            len += 2 + this.getRequestorIdAsRaw().serializedLength();
        }
        if (this.hasField(65536)) {
            len += 8;
        }
        if (this.hasField(16384)) {
            len += this.getMessageTransportHeaders().serializedLength();
        }
        return len;
    }

    public final int serialize(IOElasticBuffer buffer, int offset) {
        int len = 0;
        if (DISABLE_MICROSECOND_TIMESTAMPS) {
            this.clearFlag(512);
        } else if (this.hasField(1)) {
            this.setFlag(512);
        }
        buffer.put(offset + len, this.resolveSerializedVersion());
        buffer.putInt(offset + ++len, this.hasFlags);
        len += 4;
        if (this.hasField(1)) {
            buffer.putInt(offset + len, this.flags);
            len += 4;
        }
        if (this.hasField(2)) {
            buffer.putInt(offset + len, this.getTransactionInSequenceNumber());
            len += 4;
        }
        if (this.hasField(4)) {
            buffer.putInt(offset + len, this.getTransactionOutSequenceNumber());
            len += 4;
        }
        if (this.hasField(8)) {
            buffer.putInt(offset + len, this.getGraphId());
            len += 4;
        }
        if (this.hasField(16)) {
            UUID parentId = this.getParentId();
            buffer.putLong(offset + len, parentId.getTime());
            buffer.putLong(offset + (len += 8), parentId.getClockSeqAndNode());
            len += 8;
        }
        if (this.hasField(32)) {
            buffer.putLong(offset + len, DISABLE_MICROSECOND_TIMESTAMPS ? this.getPreProcessingTs() : this.getPreProcessingTsMicros());
            len += 8;
        }
        if (this.hasField(64)) {
            buffer.putLong(offset + len, DISABLE_MICROSECOND_TIMESTAMPS ? this.getOutTs() : this.getOutTsMicros());
            len += 8;
        }
        if (this.hasField(8192)) {
            buffer.putLong(offset + len, DISABLE_MICROSECOND_TIMESTAMPS ? this.getEnqueueTs() : this.getEnqueueTsMicros());
            len += 8;
        }
        if (this.hasField(128)) {
            buffer.putInt(offset + len, this.getMessageSender());
            len += 4;
        }
        if (this.hasField(256)) {
            buffer.putInt(offset + len, this.getMessageFlow());
            len += 4;
        }
        if (this.hasField(512)) {
            buffer.putLong(offset + len, this.getMessageSequenceNumber());
            len += 8;
        }
        if (this.hasField(1024)) {
            XString messageBus = this.getMessageBusAsRaw();
            short messageBusLen = (short)this.messagingFields.messageBus.serializedLength();
            buffer.putShort(offset + len, messageBusLen);
            this.messagingFields.messageBus.getTo(buffer, offset + (len += 2));
            len += messageBusLen;
        }
        if (this.hasField(2048)) {
            XString messageChannel = this.getMessageChannelAsRaw();
            short messageChannelLen = (short)this.messagingFields.messageChannel.serializedLength();
            buffer.putShort(offset + len, messageChannelLen);
            this.messagingFields.messageChannel.getTo(buffer, offset + (len += 2));
            len += messageChannelLen;
        }
        if (this.hasField(4096)) {
            XString messageKey = this.getMessageKeyAsRaw();
            short messageKeyLen = (short)this.messagingFields.messageKey.serializedLength();
            buffer.putShort(offset + len, messageKeyLen);
            this.messagingFields.messageKey.getTo(buffer, offset + (len += 2));
            len += messageKeyLen;
        }
        if (this.hasField(32768)) {
            XString requestorId = this.getRequestorIdAsRaw();
            short requestorIdLen = (short)this.messagingFields.requestorId.serializedLength();
            buffer.putShort(offset + len, requestorIdLen);
            this.messagingFields.requestorId.getTo(buffer, offset + (len += 2));
            len += requestorIdLen;
        }
        if (this.hasField(65536)) {
            buffer.putLong(offset + len, this.getRequestId());
            len += 8;
        }
        if (this.hasField(16384)) {
            MessageTransportHeaders headers = this.getMessageTransportHeaders();
            len += headers.serialize(buffer, offset + len);
        }
        buffer.setLength(len);
        return len;
    }

    public final RogDirectMetadata setWrapDeserializeBuffer(boolean val) {
        this.stateFlags = val ? (byte)(this.stateFlags | 2) : (byte)(this.stateFlags & 0xFFFFFFFD);
        return this;
    }

    private final boolean isWrapDeserializeBuffer() {
        return (this.stateFlags & 2) != 0;
    }

    public final RogDirectMetadata deserialize(IOElasticBuffer metadata, int metadataOffset, boolean copyDeserialize) {
        return this.init().deserializeCore(metadata, metadataOffset, copyDeserialize);
    }

    public final RogDirectMetadata deserialize(IOElasticBuffer metadata, int metadataOffset) {
        return this.init().deserializeCore(metadata, metadataOffset, false);
    }

    @Override
    public final String metadataToJsonString() {
        return this.metadataToJsonString(Config.getValue((String)"nv.indent.json", (boolean)false));
    }

    @Override
    public final String metadataToJsonString(boolean indentOutput) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder sb = new StringBuilder("{");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"class\":\"" + this.getClass().getSimpleName() + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"int\":" + this.getIsInternal());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"msg\":" + this.getIsMessage());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"dir\":\"" + (this.getIsMessage() ? (this.getIsOutboundMessage() ? "out" : (this.getIsInboundMessage() ? "in" : "?")) : "---") + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"bus\":" + (this.getMessageBus() == null ? "null" : "\"" + this.getMessageBus() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"channel\":" + (this.getMessageChannel() == null ? "null" : "\"" + this.getMessageChannel() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"key\":" + (this.getMessageKey() == null ? "null" : "\"" + this.getMessageKey() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"sender\":" + this.getMessageSender());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"flow\":" + this.getMessageFlow());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"sno\":" + this.getMessageSequenceNumber());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"requestorId\":" + (this.getRequestorId() == null ? "null" : "\"" + this.getRequestorId() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"requestId\":" + this.getRequestId());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"graphid\":" + this.getGraphId());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"parentid\":" + (this.getParentId() == null ? "null" : "\"" + this.getParentId().toString() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"inmsgs\":" + this.getInMsgsInTransaction());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"outmsgs\":" + this.getOutMsgsInTransaction());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"insno\":" + this.getTransactionInSequenceNumber());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"outsno\":" + this.getTransactionOutSequenceNumber());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"posdup\":" + this.isPossibleDuplicate());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"lasttxn\":" + this.getIsLastTransaction());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"outTs\":\"" + RogDirectMetadata.tsToDateString(this.getOutTs(), dateFormat) + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"outTsMicros\":\"" + this.getOutTsMicros() + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"enqueueTs\":\"" + RogDirectMetadata.tsToDateString(this.getEnqueueTs(), dateFormat) + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"enqueueTsMicros\":\"" + this.getEnqueueTsMicros() + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"preprocTs\":\"" + RogDirectMetadata.tsToDateString(this.getPreProcessingTs(), dateFormat) + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"preprocTsMicros\":\"" + this.getPreProcessingTsMicros() + "\"");
        if (this.hasField(16384)) {
            sb.append(",");
            if (indentOutput) {
                sb.append("\n  ");
            }
            sb.append("\"messageTransportHeaders\":");
            MessageTransportHeaders headers = this.getMessageTransportHeaders();
            headers.toJsonString(indentOutput, 1, true, sb);
        }
        if (indentOutput) {
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final String metadataToString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("\n");
        sb.append("   int..............").append(this.getIsInternal()).append("\n");
        sb.append("   .................").append("\n");
        sb.append("   msg..............").append(this.getIsMessage()).append("\n");
        sb.append("   dir..............").append(this.getIsMessage() ? (this.getIsOutboundMessage() ? "out" : (this.getIsInboundMessage() ? "in" : "?")) : "---").append("\n");
        sb.append("   .................").append("\n");
        sb.append("   bus..............").append(this.getMessageBus()).append("\n");
        sb.append("   channel..........").append(this.getMessageChannel()).append("\n");
        sb.append("   key..............").append(this.getMessageKey()).append("\n");
        sb.append("   sender...........").append(this.getMessageSender()).append("\n");
        sb.append("   flow.............").append(this.getMessageFlow()).append("\n");
        sb.append("   sno..............").append(this.getMessageSequenceNumber()).append("\n");
        sb.append("   .................").append("\n");
        sb.append("   requestorId......").append(this.getRequestorId()).append("\n");
        sb.append("   requestId........").append(this.getRequestId()).append("\n");
        sb.append("   .................").append("\n");
        if (this.hasField(16384)) {
            sb.append("   transportHeaders {").append("\n");
            for (MessageTransportHeaders.Header header : this.getMessageTransportHeaders()) {
                sb.append("      ").append(header.getName()).append("=").append(header.getValue()).append("\n");
            }
            sb.append("   }\n");
        }
        sb.append("   .................").append("\n");
        sb.append("   graphid..........").append(this.getGraphId()).append("\n");
        sb.append("   parentid.........").append(this.getParentId()).append("\n");
        sb.append("   .................").append("\n");
        sb.append("   inmsgs...........").append(this.getInMsgsInTransaction()).append("\n");
        sb.append("   outmsgs..........").append(this.getOutMsgsInTransaction()).append("\n");
        sb.append("   insno............").append(this.getTransactionInSequenceNumber()).append("\n");
        sb.append("   outsno...........").append(this.getTransactionOutSequenceNumber()).append("\n");
        sb.append("   posdup...........").append(this.isPossibleDuplicate()).append("\n");
        sb.append("   lasttxn..........").append(this.getIsLastTransaction()).append("\n");
        sb.append("   .................").append("\n");
        sb.append("   outTs............").append(RogDirectMetadata.tsToDateString(this.getOutTs(), dateFormat)).append("\n");
        sb.append("   outTsMicros......").append(this.getOutTsMicros()).append("\n");
        sb.append("   enqueueTs........").append(RogDirectMetadata.tsToDateString(this.getEnqueueTs(), dateFormat)).append("\n");
        sb.append("   enqueueTsMicros..").append(this.getEnqueueTsMicros()).append("\n");
        sb.append("   preprocTs........").append(RogDirectMetadata.tsToDateString(this.getPreProcessingTs(), dateFormat)).append("\n");
        sb.append("   preprocTsMicros..").append(this.getPreProcessingTsMicros()).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public final String toString() {
        return this.metadataToString();
    }

    private static final class MessagingFields {
        private int transactionInSequenceNumber;
        private int transactionOutSequenceNumber;
        private long preprocTs;
        private long outTs;
        private long enqueueTs;
        private int messageSender;
        private int messageFlow;
        private long messageSno;
        private XString messageBus;
        private XString messageBusBuffer;
        private XString messageChannel;
        private XString messageChannelBuffer;
        private XString messageKey;
        private XString messageKeyBuffer;
        private XString requestorId;
        private XString requestorIdBuffer;
        private long requestId;
        private MessageTransportHeaders messageTransportHeaders;

        private MessagingFields() {
        }

        final void init() {
            this.transactionInSequenceNumber = 0;
            this.transactionOutSequenceNumber = 0;
            this.preprocTs = 0L;
            this.outTs = 0L;
            this.enqueueTs = 0L;
            this.messageSender = 0;
            this.messageFlow = 0;
            this.messageSno = 0L;
            this.messageBus = null;
            if (this.messageBusBuffer != null) {
                this.messageBusBuffer.clear(false);
            }
            this.messageChannel = null;
            if (this.messageChannelBuffer != null) {
                this.messageChannelBuffer.clear(false);
            }
            this.messageKey = null;
            if (this.messageKeyBuffer != null) {
                this.messageKeyBuffer.clear(false);
            }
            this.requestorId = null;
            if (this.requestorIdBuffer != null) {
                this.requestorIdBuffer.clear(false);
            }
            this.requestId = 0L;
            if (this.messageTransportHeaders != null) {
                this.messageTransportHeaders.init();
            }
        }
    }

    private static final class Offsets {
        short transactionInSequenceNumberOffset;
        short transactionOutSequenceNumberOffset;
        short graphIdOffset;
        short parentIdOffset;
        short preprocTsOffset;
        short outTsOffset;
        short enqueueTsOffset;
        short messageSenderOffset;
        short messageFlowOffset;
        short messageSnoOffset;
        short messageBusOffset;
        short messageChannelOffset;
        short messageKeyOffset;
        short requestorIdOffset;
        short requestIdOffset;
        short messageTransportHeadersOffset;

        private Offsets() {
        }

        final void init() {
            this.transactionInSequenceNumberOffset = 0;
            this.transactionOutSequenceNumberOffset = 0;
            this.graphIdOffset = 0;
            this.parentIdOffset = 0;
            this.preprocTsOffset = 0;
            this.outTsOffset = 0;
            this.enqueueTsOffset = 0;
            this.messageSenderOffset = 0;
            this.messageFlowOffset = 0;
            this.messageSnoOffset = 0;
            this.messageBusOffset = 0;
            this.messageChannelOffset = 0;
            this.messageKeyOffset = 0;
            this.requestorIdOffset = 0;
            this.requestIdOffset = 0;
            this.messageTransportHeadersOffset = 0;
        }
    }
}

