/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.predicates;

import com.neeve.query.impl.predicates.PredicatesImpl;
import com.neeve.query.predicates.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public abstract class PredicateBase<T>
implements Predicate<T> {
    public static Comparator<Predicate<?>> COST_COMPARATOR = new Comparator<Predicate<?>>(){

        @Override
        public int compare(Predicate<?> predicate1, Predicate<?> predicate2) {
            return Double.compare(predicate1.getCost(), predicate2.getCost());
        }
    };

    @Override
    public final Predicate<T> and(Predicate<T> ... predicates) {
        ArrayList preds = new ArrayList(predicates.length + 1);
        preds.add(this);
        for (Predicate<T> p : predicates) {
            preds.add(p);
        }
        return PredicatesImpl.get().and(preds);
    }

    @Override
    public final Predicate<T> and(Collection<Predicate<T>> predicates) {
        ArrayList preds = new ArrayList(predicates.size() + 1);
        preds.add(this);
        for (Predicate<T> p : predicates) {
            preds.add(p);
        }
        return PredicatesImpl.get().and(preds);
    }

    @Override
    public final Predicate<T> or(Predicate<T> ... predicates) {
        ArrayList preds = new ArrayList(predicates.length + 1);
        preds.add(this);
        for (Predicate<T> p : predicates) {
            preds.add(p);
        }
        return PredicatesImpl.get().or(preds);
    }

    @Override
    public final Predicate<T> or(Collection<Predicate<T>> predicates) {
        ArrayList preds = new ArrayList(predicates.size() + 1);
        preds.add(this);
        for (Predicate<T> p : predicates) {
            preds.add(p);
        }
        return PredicatesImpl.get().or(preds);
    }

    public abstract void regularize();

    public abstract void prioritizeBy(Comparator<Predicate<?>> var1);

    public void prioritizeByCost() {
        this.prioritizeBy(COST_COMPARATOR);
    }
}

