/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.NativeKernel;
import com.neeve.config.Config;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class UtlTime {
    private static String dateFormat = "yyyyMMdd-HH:mm:ss.SSS";
    private static TimeZone dateFormatTimezone = TimeZone.getTimeZone("GMT");
    private static ThreadLocal<TimestampFormatHolder> formatters = new ThreadLocal();
    private static final boolean nativeKernelLoaded;
    private static final boolean USE_NATIVE;
    private static final long bootTimeEpochOffsetInNanos;

    private static final native long nativeRes();

    private static final native long nativeNow();

    public static final boolean isNativeTimeEnabled() {
        return USE_NATIVE;
    }

    public static final long now() {
        return USE_NATIVE ? UtlTime.nativeNow() : bootTimeEpochOffsetInNanos + System.nanoTime();
    }

    public static final long nowInMicros() {
        return UtlTime.now() / 1000L;
    }

    public static final long nowInMillis() {
        return UtlTime.now() / 1000000L;
    }

    public static final void setTimestampFormat(String dateFormat) {
        new SimpleDateFormat(dateFormat);
        UtlTime.dateFormat = dateFormat;
    }

    public static final String getTimestampFormat() {
        return dateFormat;
    }

    public static final void setTimestampFormatTimeZone(TimeZone timezone) {
        dateFormatTimezone = timezone;
    }

    public static final TimeZone setTimestampFormatTimeZone(String timezone) {
        TimeZone toSet;
        dateFormatTimezone = toSet = TimeZone.getTimeZone(timezone);
        return toSet;
    }

    public static final TimeZone getTimestampFormatTimeZone() {
        return dateFormatTimezone;
    }

    public static final DateFormat getTimestampFormatter() {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        df.setTimeZone(dateFormatTimezone);
        return df;
    }

    public static final String format(Date date) {
        TimestampFormatHolder holder = formatters.get();
        if (holder == null) {
            holder = new TimestampFormatHolder();
            formatters.set(holder);
        }
        return holder.format(date);
    }

    public static final Date parse(String timestamp) throws ParseException {
        TimestampFormatHolder holder = formatters.get();
        if (holder == null) {
            holder = new TimestampFormatHolder();
            formatters.set(holder);
        }
        return holder.formatter.parse(timestamp);
    }

    public static final DateFormat getCachedTimestampFormatter() {
        TimestampFormatHolder holder = formatters.get();
        if (holder == null) {
            holder = new TimestampFormatHolder();
            formatters.set(holder);
        }
        return holder.formatter;
    }

    public static final void cleanupFormatter() {
        formatters.remove();
    }

    public static final void main(String[] args) {
        UtlTime.setTimestampFormatTimeZone(Calendar.getInstance().getTimeZone());
        long now = UtlTime.now();
        long micros = now % 1000L;
        System.out.println("Time: " + UtlTime.getTimestampFormatter().format(new Date(now / 1000000L)) + String.format("%03d", micros));
    }

    static {
        UtlTime.setTimestampFormat(Config.getValue((String)"nv.time.format", (String)"yyyyMMdd-HH:mm:ss.SSS"));
        UtlTime.setTimestampFormatTimeZone(Config.getValue((String)"nv.time.timezoneformat", (String)"GMT"));
        boolean val = false;
        try {
            NativeKernel.initialize();
            val = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        nativeKernelLoaded = val;
        USE_NATIVE = nativeKernelLoaded && Config.getValue((String)"nv.time.usenative", (boolean)false);
        bootTimeEpochOffsetInNanos = System.currentTimeMillis() * 1000000L - System.nanoTime();
        if (Config.getValue((String)"nv.native.configtrace", (boolean)false)) {
            if (USE_NATIVE) {
                System.out.println("NATIVE TIME IS ENABLED (CLOCK RESOLUTION IS " + UtlTime.nativeRes() + "ns)");
            } else {
                System.out.println("NATIVE TIME IS DISABLED (CLOCK RESOLUTION IS RESOLUTION OF System.nanoTime())");
            }
        }
    }

    private static final class TimestampFormatHolder {
        String dateFormat;
        TimeZone tz;
        DateFormat formatter;

        TimestampFormatHolder() {
            this.updateFormatter();
        }

        public final String format(Date date) {
            if (this.dateFormat != dateFormat || this.tz != dateFormatTimezone) {
                this.updateFormatter();
            }
            return this.formatter.format(date);
        }

        private final void updateFormatter() {
            this.dateFormat = dateFormat;
            this.tz = dateFormatTimezone;
            this.formatter = new SimpleDateFormat(this.dateFormat);
            this.formatter.setTimeZone(this.tz);
        }
    }
}

