/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cli;

import com.neeve.cli.CliException;
import com.neeve.cli.ValueApplier;
import com.neeve.cli.annotations.RemainingArgs;
import com.neeve.util.UtlText;
import java.io.IOException;

public final class RemainingArgsHandler {
    private final RemainingArgs arg;
    private final ValueApplier applier;

    RemainingArgsHandler(ValueApplier applier, RemainingArgs arg) throws CliException {
        this.arg = arg;
        this.applier = applier;
        if (!applier.getTargetType().equals(String.class) && !applier.getTargetType().equals(new String[0].getClass())) {
            throw new CliException("Invalid target type for remaining args: '" + applier.getTargetType() + "', expected String or String []");
        }
    }

    final void parse(String[] value) throws Exception {
        if (value == null || value.length == 0) {
            if (this.arg.required() && "<null>".equals(this.arg.defaultValue())) {
                throw new IllegalArgumentException("Missing argument, expected " + this.arg.name());
            }
            value = !"<null>".equals(this.arg.defaultValue()) ? (this.applier.getTargetType().equals(String.class) ? new String[]{this.arg.defaultValue()} : UtlText.parseAsArgs(this.arg.defaultValue(), false)) : new String[]{};
        }
        if (this.applier.getTargetType().equals(String.class)) {
            String str = null;
            if (value.length > 0) {
                str = this.arg.requoteForSingleString() ? UtlText.quoteAndEscape(value[0]) : value[0];
                for (int i = 1; i < value.length; ++i) {
                    str = str + " " + (this.arg.requoteForSingleString() ? UtlText.quoteAndEscape(value[i]) : value[i]);
                }
            }
            this.applier.applyParsedValue(str);
        } else {
            this.applier.applyParsedValue(value);
        }
    }

    public String getDescription() {
        return "<null>".equals(this.arg.description()) ? null : this.arg.description();
    }

    public String getDisplayName() {
        return "<null>".equals(this.arg.displayName()) ? null : this.arg.displayName();
    }

    public void appendUsage(Appendable buf) {
        try {
            if (!this.arg.required()) {
                buf.append("[");
            }
            buf.append(this.arg.name());
            if (this.getDescription() != null) {
                buf.append(": ").append(this.arg.description());
            }
            if (!"<null>".equals(this.arg.defaultValue())) {
                buf.append(" default='" + this.arg.defaultValue() + "'");
            }
            if (!this.arg.required()) {
                buf.append("]");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error appending remaining arguments usage: " + e.getMessage(), e);
        }
    }
}

