/*
 * Decompiled with CFR 0.152.
 */
package com.neeve;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class NativeKernel {
    private static final boolean DEBUG = Boolean.getBoolean("nv.native.debug");
    public static final String PROP_NATIVE_LIBDIR = "nv.native.libdir";
    public static final String PROP_NATIVE_SUPPRESSEXTRACTION = "nv.native.suppressextraction";
    public static final String PROP_NATIVE_EXITIFNONATIVELIBS = "nv.native.exitifnonativelibs";
    private static final String RESOURCE_ROOT = "nvx-native/";

    private static final void copyFile(InputStream is, File dest) throws Exception {
        int len;
        if (DEBUG) {
            System.err.println("[nv.native] extracting " + dest);
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dest));
        byte[] data = new byte[8192];
        while ((len = bis.read(data, 0, data.length)) >= 0) {
            bos.write(data, 0, len);
        }
        bos.close();
        bis.close();
    }

    private static final void copyBinaries() throws Exception {
        if (!Boolean.getBoolean(PROP_NATIVE_SUPPRESSEXTRACTION)) {
            File dest = new File(System.getProperty(PROP_NATIVE_LIBDIR, System.getProperty("user.home") + File.separator + ".nvx" + File.separator + "native"));
            if (dest.exists()) {
                for (File f : dest.listFiles()) {
                    f.delete();
                }
            } else {
                dest.mkdirs();
            }
            URL url = NativeKernel.class.getClassLoader().getResource(RESOURCE_ROOT);
            if (url != null) {
                if (DEBUG) {
                    System.err.println("[nv.native] ...bundled native libs found: " + url);
                }
                if (url.getPath().contains(".jar!/nvx-native/")) {
                    String fileName = url.getPath().split("!")[0];
                    String jarFileName = fileName.substring(5);
                    JarFile jar = new JarFile(new File(jarFileName));
                    Enumeration<JarEntry> jarEntries = jar.entries();
                    while (jarEntries.hasMoreElements()) {
                        JarEntry entry = jarEntries.nextElement();
                        if (!entry.getName().startsWith(RESOURCE_ROOT) || entry.isDirectory()) continue;
                        NativeKernel.copyFile(jar.getInputStream(entry), new File(dest.getAbsolutePath() + File.separator + entry.getName().substring(RESOURCE_ROOT.length())));
                    }
                } else {
                    File dir = new File(url.toURI());
                    for (File f : dir.listFiles()) {
                        NativeKernel.copyFile(new FileInputStream(f), new File(dest.getAbsolutePath() + File.separator + f.getName()));
                    }
                }
            } else if (Boolean.getBoolean(PROP_NATIVE_EXITIFNONATIVELIBS)) {
                System.err.println("[nv.native] ...no bundled native libraries found. exiting... (configured to exit if no native libs found on classpath).");
                System.exit(1);
            } else if (DEBUG) {
                System.err.println("[nv.native] ...no bundled native libraries found.");
            }
        } else if (DEBUG) {
            System.err.println("[nv.native] ...native library extraction suppressed.");
        }
    }

    public static final native void initialize();

    public static final void main(String[] args) {
    }

    static {
        if (DEBUG) {
            System.err.println("[nv.native] Initializing X native runtime...");
        }
        boolean success = false;
        try {
            try {
                NativeKernel.copyBinaries();
            }
            catch (Throwable e) {
                System.err.println("**** FAILED TO EXTRACT NATIVE BINARIES. SYSTEM WILL FALL BACK TO USING NON-NATIVE CODE ***");
                e.printStackTrace();
            }
            if (DEBUG) {
                System.err.println("[nv.native] ...attempting to load native libraries.");
            }
            try {
                System.loadLibrary("nvrtjni");
            }
            catch (RuntimeException re) {
                if (DEBUG) {
                    System.err.println("[nv.native] ...failed to load native libraries [" + re.getMessage() + "].");
                }
                throw re;
            }
            catch (Error e) {
                if (DEBUG) {
                    System.err.println("[nv.native] ...failed to load native libraries [" + e.getMessage() + "].");
                }
                throw e;
            }
            if (DEBUG) {
                System.err.println("[nv.native] ...native libraries loaded");
            }
            try {
                NativeKernel.initialize();
            }
            catch (RuntimeException re) {
                if (DEBUG) {
                    System.err.println("[nv.native] ...failed to initialize X native runtime [" + re.getMessage() + "].");
                }
                throw re;
            }
            catch (Error e) {
                if (DEBUG) {
                    System.err.println("[nv.native] ...failed to initialize X native runtime [" + e.getMessage() + "].");
                }
                throw e;
            }
            success = true;
            if (DEBUG) {
                System.err.println("[nv.native] ...initialization complete: X native runtime is " + (success ? "AVAILABLE" : "UNAVAILABLE") + ".");
            }
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                System.err.println("[nv.native] ...initialization complete: X native runtime is " + (success ? "AVAILABLE" : "UNAVAILABLE") + ".");
            }
            throw throwable;
        }
    }
}

