/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmPrimitive;
import com.neeve.adm.AdmSourceCodeBuilder;
import java.io.File;
import java.io.IOException;

public class AdmPooledString
extends AdmPrimitive {
    private int length;
    private final AdmModel model;
    private final String name;
    private final String namespace;

    AdmPooledString(AdmModel model, String namespace, String name) {
        super(name, AdmPrimitive.Type.String);
        this.namespace = namespace;
        this.name = name;
        this.model = model;
    }

    private final void generateType(File outputFolder) throws IOException {
        String typeNameImpl = this.getPooledTypeName();
        AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder(this.getModel());
        this.generateType(codeBuilder);
        File file = new File(outputFolder, typeNameImpl + ".java");
        codeBuilder.write(file);
    }

    private final void generateType(AdmSourceCodeBuilder codeBuilder) {
        String typeName = this.getPooledTypeName();
        String packageName = this.getNamespace();
        codeBuilder.header().appendln("/**");
        codeBuilder.header().appendln(" * ******************************************************************");
        codeBuilder.header().appendln(" * *** THIS FILE IS GENERATED BY X PLATFORM CODE GENERATION TOOLS ***");
        codeBuilder.header().appendln(" * ******************************************************************");
        codeBuilder.header().append(" */");
        codeBuilder.packageName(packageName);
        codeBuilder.last().appendln();
        if (this.getDocumentation() != null) {
            AdmGenerator.writeJavadocTypeComment("", this, codeBuilder);
        }
        AdmGenerator.writeAdmGeneratedAnnotations(((Object)((Object)this)).getClass(), null, this.getModel(), codeBuilder);
        codeBuilder.last().appendln("final public class " + typeName + " extends %{com.neeve.lang.XAbstractPooledString}<" + typeName + "> {");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The default factory used to create new " + typeName + " instances.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static Factory FACTORY;");
        codeBuilder.last().appendln();
        codeBuilder.last().appendln("    static {");
        codeBuilder.last().appendln("        %{com.neeve.adm.runtime.AdmCompatibility}.assertRuntimeCompatibility(%{com.neeve.adm.runtime.AdmCompatibility}.COMPATIBILITY_LEVEL, " + typeName + ".class);");
        codeBuilder.last().appendln("        FACTORY = new Factory();");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * An optionally pool backed factory for {@link " + typeName + "}s");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    public static class Factory extends %{com.neeve.lang.XAbstractPooledString}.PooledStringFactory<" + typeName + "> {");
        codeBuilder.last().appendln("        private Factory() {");
        codeBuilder.last().appendln("            super();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        protected Factory(String name, short initialCapacity, boolean pooled, int preallocationCount, boolean threaded) {");
        codeBuilder.last().appendln("            super(name, initialCapacity, pooled, preallocationCount, threaded);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln(" ");
        codeBuilder.last().appendln("        protected Factory(String name, %{java.util.Map}<String, Object> props) {");
        codeBuilder.last().appendln("            super(name, props);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln(" ");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        protected final Class<" + typeName + "> getType() {");
        codeBuilder.last().appendln("            return " + typeName + ".class;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        protected final " + typeName + " create(boolean mutable, short initialCapacity) {");
        codeBuilder.last().appendln("            return new " + typeName + "(mutable, initialCapacity);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        protected final " + typeName + "[] newArray(int size) {");
        codeBuilder.last().appendln("            return new " + typeName + "[size];");
        codeBuilder.last().appendln("        }");
        if (this.length > 0) {
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        protected final int getDefaultInitialCapacity() {");
            codeBuilder.last().appendln("            return " + this.length + ";");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * Constructs a new Factory for {@link " + typeName + "}s.");
        codeBuilder.last().appendln("     *");
        codeBuilder.last().appendln("     * @param name A name unique to this factory type which is used to uniquely identify the underlying pool.");
        codeBuilder.last().appendln("     * @param initialCapacity The initial capacity backing storage of the string created by this factory.");
        codeBuilder.last().appendln("     * @param pooled Whether or not to back the factory with a pool.");
        codeBuilder.last().appendln("     * @param preallocationCount The number of {@link " + typeName + "} to preallocate.");
        codeBuilder.last().appendln("     * @param threaded Whether or not the backing pool should be thread safe.");
        codeBuilder.last().appendln("     *");
        codeBuilder.last().appendln("     * @return A new Factory.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    public static Factory newFactory(final String name,");
        codeBuilder.last().appendln("                                     final short initialCapacity,");
        codeBuilder.last().appendln("                                     final boolean pooled,");
        codeBuilder.last().appendln("                                     final int preallocationCount,");
        codeBuilder.last().appendln("                                     final boolean threaded) {");
        codeBuilder.last().appendln("        return new Factory(name, initialCapacity, pooled, preallocationCount, threaded);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * Constructs a new Factory for {@link " + typeName + "}s.");
        codeBuilder.last().appendln("     * <p>");
        codeBuilder.last().appendln("     * See {@link com.neeve.lang.XString.Factory} for reference on permissible values.");
        codeBuilder.last().appendln("     *");
        codeBuilder.last().appendln("     * @param name A name unique to this factory type which is used to uniquely identify the underlying pool.");
        codeBuilder.last().appendln("     * @param props The properties with which to create the factory.");
        codeBuilder.last().appendln("     *");
        codeBuilder.last().appendln("     * @return A new Factory.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    public static Factory newFactory(final String name,");
        codeBuilder.last().appendln("                                     final %{java.util.Map}<String, Object> props) {");
        codeBuilder.last().appendln("        return new Factory(name, props);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    private " + typeName + "(boolean mutable, short initialCapacity) {");
        codeBuilder.last().appendln("        super(mutable, initialCapacity);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * Creates a new, mutable, uninitialized {@link " + typeName + "} using this type's");
        codeBuilder.last().appendln("     * default {@link Factory}.");
        codeBuilder.last().appendln("     * ");
        codeBuilder.last().appendln("     * @return a new, uninitialized {@link " + typeName + "}.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static " + typeName + " create() {");
        codeBuilder.last().appendln("        return FACTORY.create();");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * Creates a new immutable {@link " + typeName + "} initialized to the given value using this type's");
        codeBuilder.last().appendln("     * default {@link com.neeve.lang.XString.Factory}.");
        codeBuilder.last().appendln("     * <p>");
        codeBuilder.last().appendln("     * This method does not preallocate the backing buffer. The caller may call {@link #getBackingBuffer()} on the");
        codeBuilder.last().appendln("     * returned string to create the backing buffer based on the length of the string value.");
        codeBuilder.last().appendln("     * ");
        codeBuilder.last().appendln("     * @param value the String value for the new {@link " + typeName + "}.");
        codeBuilder.last().appendln("     * ");
        codeBuilder.last().appendln("     * @return a new " + typeName + " initialized to the given value");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static " + typeName + " create(final String value) {");
        codeBuilder.last().appendln("        return FACTORY.create(value, false);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * Creates a new, uninitialized {@link " + typeName + "} using this type's");
        codeBuilder.last().appendln("     * default {@link com.neeve.lang.XString.Factory}.");
        codeBuilder.last().appendln("     * ");
        codeBuilder.last().appendln("     * @param mutable Whether the returned {@link " + typeName + "} is mutable");
        codeBuilder.last().appendln("     * ");
        codeBuilder.last().appendln("     * @return a new, uninitialized {@link " + typeName + "}.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static " + typeName + " create(final boolean mutable) {");
        codeBuilder.last().appendln("        return FACTORY.create(mutable);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * Creates a new {@link " + typeName + "} initialized to the given value using this type's");
        codeBuilder.last().appendln("     * default {@link com.neeve.lang.XString.Factory}.");
        codeBuilder.last().appendln("     * <p>");
        codeBuilder.last().appendln("     * This method does not preallocate the backing buffer. The caller may call {@link #getBackingBuffer()} on the");
        codeBuilder.last().appendln("     * returned string to create the backing buffer based on the length of the initial value.");
        codeBuilder.last().appendln("     * ");
        codeBuilder.last().appendln("     * @param mutable Whether the returned {@link " + typeName + "} is mutable");
        codeBuilder.last().appendln("     * @param initialValue the initial String value for the new {@link " + typeName + "}.");
        codeBuilder.last().appendln("     * ");
        codeBuilder.last().appendln("     * @return a new " + typeName + " initialized to the given value");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static " + typeName + " create(final String initialValue, final boolean mutable) {");
        codeBuilder.last().appendln("        return FACTORY.create(initialValue, mutable);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * Creates a new {@link " + typeName + "} initialized to the given value using this type's");
        codeBuilder.last().appendln("     * default {@link com.neeve.lang.XString.Factory}.");
        codeBuilder.last().appendln("     * <p>");
        codeBuilder.last().appendln("     * @param mutable Whether the returned {@link " + typeName + "} is mutable");
        codeBuilder.last().appendln("     * @param initialValue the initial String value for the new {@link " + typeName + "}.");
        codeBuilder.last().appendln("     * ");
        codeBuilder.last().appendln("     * @return a new " + typeName + " initialized to the given value");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static " + typeName + " create(final %{com.neeve.lang.XString} initialValue, final boolean mutable) {");
        codeBuilder.last().appendln("        return FACTORY.create(initialValue, mutable);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("}");
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public AdmModel getModel() {
        return this.model;
    }

    public String getPooledTypeName() {
        return this.name;
    }

    public final void generateClasses(File outdir, boolean absolute) throws Exception {
        File javaFile = AdmModel.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace(), this.getName());
        File dir = javaFile.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        this.generateType(dir);
    }
}

