/*
 * Decompiled with CFR 0.152.
 */
package com.mdimension.jchronic.repeaters;

import com.mdimension.jchronic.Options;
import com.mdimension.jchronic.repeaters.RepeaterDayName;
import com.mdimension.jchronic.repeaters.RepeaterDayPortion;
import com.mdimension.jchronic.repeaters.RepeaterMonthName;
import com.mdimension.jchronic.repeaters.RepeaterTime;
import com.mdimension.jchronic.repeaters.RepeaterUnit;
import com.mdimension.jchronic.tags.Pointer;
import com.mdimension.jchronic.tags.Tag;
import com.mdimension.jchronic.utils.Span;
import com.mdimension.jchronic.utils.Token;
import java.util.List;

public abstract class Repeater<T>
extends Tag<T>
implements Comparable<Repeater<?>> {
    public Repeater(T type) {
        super(type);
    }

    public static List<Token> scan(List<Token> tokens) {
        return Repeater.scan(tokens, new Options());
    }

    public static List<Token> scan(List<Token> tokens, Options options) {
        for (Token token : tokens) {
            Repeater t = RepeaterMonthName.scan(token);
            if (t != null) {
                token.tag(t);
            }
            if ((t = RepeaterDayName.scan(token)) != null) {
                token.tag(t);
            }
            if ((t = RepeaterDayPortion.scan(token)) != null) {
                token.tag(t);
            }
            if ((t = RepeaterTime.scan(token, tokens, options)) != null) {
                token.tag(t);
            }
            if ((t = RepeaterUnit.scan(token)) == null) continue;
            token.tag(t);
        }
        return tokens;
    }

    @Override
    public int compareTo(Repeater<?> other) {
        return Integer.valueOf(this.getWidth()).compareTo(other.getWidth());
    }

    public abstract int getWidth();

    public Span nextSpan(Pointer.PointerType pointer) {
        if (this.getNow() == null) {
            throw new IllegalStateException("Start point must be set before calling #next");
        }
        return this._nextSpan(pointer);
    }

    protected abstract Span _nextSpan(Pointer.PointerType var1);

    public Span thisSpan(Pointer.PointerType pointer) {
        if (this.getNow() == null) {
            throw new IllegalStateException("Start point must be set before calling #this");
        }
        return this._thisSpan(pointer);
    }

    protected abstract Span _thisSpan(Pointer.PointerType var1);

    public abstract Span getOffset(Span var1, int var2, Pointer.PointerType var3);

    public String toString() {
        return "repeater";
    }
}

