/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.ILnkServerEndpoint;
import com.neeve.link.LnkContainer;
import com.neeve.link.LnkFactory;
import com.neeve.link.LnkSynchronousAcceptor;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.tools.interactive.commands.Join;
import com.neeve.tools.interactive.commands.Links;

public final class Accept
extends Command {
    private final LnkContainer container;
    private final Links links;
    private final Join join;

    public Accept(LnkContainer container, Links links, Join join) {
        this.container = container;
        this.links = links;
        this.join = join;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processAccept(String descriptor, int timeout) {
        System.out.println("Accepting link [descriptor='" + descriptor + "'] (timeout=" + timeout + ")...");
        ILnkServerEndpoint sep = null;
        ILnkPeerEndpoint pep = null;
        try {
            sep = LnkFactory.getInstance().createServerEndpoint(this.container.touch(descriptor), null);
            pep = LnkSynchronousAcceptor.create().run(sep, timeout);
            this.join.run(new String[]{pep.getName()});
            System.out.println("Successfully accepted link [name='" + pep.getName() + "'].");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("Failure [" + e.toString() + "]");
        }
        finally {
            if (sep != null) {
                try {
                    sep.close();
                }
                catch (Exception e) {
                    System.out.println("Failed to close link server endpoint [" + e.toString() + "]");
                }
            }
        }
        return false;
    }

    public final void run(String[] args) {
        if (args.length != 2) {
            System.out.println("Syntax error: accept <descriptor> <timeout>");
        } else if (this.processAccept(args[0], Integer.parseInt(args[1]))) {
            this.links.run(new String[0]);
        }
    }

    public final void help() {
        System.out.println("accept <descriptor> <timeout>");
        System.out.println("  Accept a link using a link descriptor");
    }

    public final String[] keywords() {
        return new String[]{"accept"};
    }
}

