/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import java.nio.ByteBuffer;

public final class StoByteField
extends StoField {
    private byte val;

    private StoByteField(String name) {
        super(StoField.Type.BYTE, name);
    }

    private StoByteField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final void doSyncToBuffer(ByteBuffer buffer, int bufferOffset) {
        StoByteField.put(buffer, bufferOffset, this.val);
    }

    @Override
    protected final void onBackingBufferAttach() {
        StoByteField.put(this.buffer, this.bodyOffset, this.val);
    }

    @Override
    protected final void onBackingBufferDetach() {
        if (this.val == 0) {
            this.val = StoByteField.get(this.buffer, this.bodyOffset);
        }
    }

    @Override
    protected final void onBackingBufferChange() {
        this.val = 0;
    }

    @Override
    protected final int getSerializedLength() {
        return 1;
    }

    @Override
    protected final String getValueString() {
        return String.valueOf(this.getValue());
    }

    @Override
    protected final boolean bodyContentsEquals(StoField other) {
        return this.getValue() == ((StoByteField)other).getValue();
    }

    @Override
    protected final void cloneBody(StoField clonee) {
        ((StoByteField)clonee).setValue(this.getValue());
    }

    public static StoByteField create(String name) {
        return new StoByteField(name);
    }

    public static StoByteField create(ByteBuffer buffer, int bufferOffset) {
        return new StoByteField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        return 1;
    }

    public static void put(ByteBuffer buffer, int offset, byte val) {
        buffer.put(offset, val);
    }

    public static byte get(ByteBuffer buffer, int offset) {
        return buffer.get(offset);
    }

    @Override
    public final boolean isVariableLength() {
        return false;
    }

    @Override
    public final void reset() {
        this.setValue((byte)0);
    }

    public final void setValue(byte val) {
        this.val = val;
        if (this.buffer != null) {
            StoByteField.put(this.buffer, this.bodyOffset, val);
        }
    }

    public final byte getValue() {
        if (this.val == 0 && this.buffer != null) {
            this.val = StoByteField.get(this.buffer, this.bodyOffset);
        }
        return this.val;
    }
}

