/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.util.UtlListElement;
import java.nio.ByteBuffer;

public abstract class PktBody
extends UtlListElement
implements IOElasticBuffer.Sizer,
IOElasticBuffer.Initializer {
    protected final int type;
    protected final IOElasticBuffer buffer;
    protected boolean inDeserialize;
    protected boolean partialDeserialize;

    protected PktBody(int type) {
        this.type = type;
        PktFactory.PktType pktType = PktFactory.getInstance().getPacketType(type);
        this.buffer = IOElasticBuffer.create((IOElasticBuffer.Sizer)this);
        this.buffer.setInitializer((IOElasticBuffer.Initializer)this);
        this.initialize();
    }

    private final void setPartialDeserialize() {
        this.partialDeserialize = true;
        if (!this.buffer.isWrapped()) {
            this.buffer.setReadOnly();
        }
    }

    private final void clearPartialDeserialize() {
        this.partialDeserialize = false;
        if (!this.buffer.isWrapped()) {
            this.buffer.clearReadOnly();
        }
    }

    protected int doGetInitialBufferLength() {
        return this.doGetSerializedLength();
    }

    protected abstract int doGetSerializedLength();

    protected boolean isResettable() {
        return false;
    }

    protected void doReset() {
    }

    protected void initialize() {
    }

    protected void doSync() {
    }

    protected void doDesync(int len) {
    }

    public final int getType() {
        return this.type;
    }

    public final IOElasticBuffer getBuffer() {
        return this.buffer;
    }

    public final void reset(boolean initBackingBuffer) {
        if (this.isResettable()) {
            this.doReset();
            this.clearPartialDeserialize();
            if (initBackingBuffer) {
                this.buffer.reset();
            } else {
                this.buffer.setLength(0);
            }
        } else {
            throw new UnsupportedOperationException("not a resettable packet type");
        }
        this.inDeserialize = false;
    }

    public final void reset() {
        this.reset(true);
    }

    public final int getSerializedLength() {
        return this.buffer.isReadOnly() ? this.buffer.getLength() : this.doGetSerializedLength();
    }

    public final int sync() {
        if (!this.buffer.isReadOnly()) {
            this.doSync();
            this.buffer.ensureBackingBufferExists();
            this.buffer.setLength(this.doGetSerializedLength());
        }
        return this.buffer.getLength();
    }

    public final PktBody syncf() {
        this.sync();
        return this;
    }

    public final void desync() {
        this.inDeserialize = true;
        try {
            this.clearPartialDeserialize();
            this.doDesync(this.buffer.getLength());
        }
        finally {
            this.inDeserialize = false;
        }
    }

    public final int getTo(ByteBuffer buf, int bufOffset) {
        int bodySerializedLength = this.buffer.getLength();
        this.buffer.getTo(0, buf, bufOffset, bodySerializedLength);
        return bodySerializedLength;
    }

    public final int getTo(ByteBuffer buf) {
        return this.getTo(buf, buf.position());
    }

    public final int getTo(byte[] array, int arrayOffset) {
        int bodySerializedLength = this.buffer.getLength();
        this.buffer.getTo(0, array, arrayOffset, bodySerializedLength);
        return bodySerializedLength;
    }

    public final int getTo(byte[] array) {
        return this.getTo(array, 0);
    }

    public final int getTo(IOBuffer iobuf, int iobufOffset) {
        int bodySerializedLength = this.buffer.getLength();
        this.buffer.getTo(0, iobuf.getBufferUnsafe(), iobufOffset, bodySerializedLength);
        return bodySerializedLength;
    }

    public final int getTo(IOElasticBuffer iobuf, int iobufOffset) {
        int bodySerializedLength = this.buffer.getLength();
        iobuf.putFrom(iobufOffset, this.buffer, 0, bodySerializedLength);
        return bodySerializedLength;
    }

    public final int getTo(long addr, int addrOffset) {
        int bodySerializedLength = this.buffer.getLength();
        this.buffer.getToNative(0, addr, addrOffset, bodySerializedLength);
        return bodySerializedLength;
    }

    public final PktBody putFrom(ByteBuffer buf, int bufOffset, int length) {
        this.buffer.putFrom(0, buf, bufOffset, length);
        this.buffer.setLength(length);
        this.setPartialDeserialize();
        return this;
    }

    public final PktBody putFrom(ByteBuffer buf, int length) {
        return this.putFrom(buf, buf.position(), length);
    }

    public final PktBody putFrom(byte[] array, int arrayOffset, int length) {
        this.buffer.putFrom(0, array, arrayOffset, length);
        this.buffer.setLength(length);
        this.setPartialDeserialize();
        return this;
    }

    public final PktBody putFrom(IOBuffer iobuf, int iobufOffset, int length, boolean wrap) {
        if (wrap) {
            this.buffer.wrapBackingBuffer(iobuf, iobufOffset, length);
        } else {
            this.buffer.putFrom(0, iobuf.getBufferUnsafe(), iobufOffset, length);
        }
        this.buffer.setLength(length);
        this.setPartialDeserialize();
        return this;
    }

    public final PktBody putFrom(IOBuffer iobuf, int iobufOffset, int length) {
        return this.putFrom(iobuf, iobufOffset, length, false);
    }

    public final PktBody putFrom(IOElasticBuffer iobuf, int iobufOffset, int length) {
        this.buffer.putFrom(0, iobuf, iobufOffset, length);
        this.buffer.setLength(length);
        this.setPartialDeserialize();
        return this;
    }

    public final PktBody putFrom(long addr, int addrOffset, int length) {
        this.buffer.putFromNative(0, addr, addrOffset, length);
        this.buffer.setLength(length);
        this.setPartialDeserialize();
        return this;
    }

    public final PktBody putFrom(PktBody src) {
        this.putFrom(src.getBuffer(), 0, src.getBuffer().getLength());
        return this;
    }

    public final int serialize(ByteBuffer buf) {
        return this.serialize(buf, buf.position());
    }

    public final int serialize(ByteBuffer buf, int bufOffset) {
        return this.syncf().getTo(buf, bufOffset);
    }

    public final int serialize(byte[] array, int arrayOffset) {
        return this.syncf().getTo(array, arrayOffset);
    }

    public final int serialize(IOBuffer iobuf, int iobufOffset) {
        return this.syncf().getTo(iobuf, iobufOffset);
    }

    public final int serialize(IOElasticBuffer iobuf, int iobufOffset) {
        return this.syncf().getTo(iobuf, iobufOffset);
    }

    public final int serialize(long addr, int addrOffset) {
        return this.syncf().getTo(addr, addrOffset);
    }

    public final void deserialize(ByteBuffer buf, int length) {
        this.deserialize(buf, buf.position(), length);
    }

    public final void deserialize(ByteBuffer buf, int bufOffset, int length) {
        this.putFrom(buf, bufOffset, length).desync();
    }

    public final void deserialize(byte[] array, int arrayOffset, int length) {
        this.putFrom(array, arrayOffset, length).desync();
    }

    public final void deserialize(IOBuffer iobuf, int iobufOffset, int length, boolean wrap) {
        this.putFrom(iobuf, iobufOffset, length, wrap).desync();
    }

    public final void deserialize(IOBuffer iobuf, int iobufOffset, int length) {
        this.deserialize(iobuf, iobufOffset, length, false);
    }

    public final void deserialize(IOElasticBuffer iobuf, int iobufOffset, int length) {
        this.putFrom(iobuf, iobufOffset, length).desync();
    }

    public final void deserialize(long addr, int addrOffset, int length) {
        this.putFrom(addr, addrOffset, length).desync();
    }

    public final String dump(String prefix) {
        return this.buffer.dump(prefix, 0, this.getSerializedLength());
    }

    public final int getInitialBufferLength() {
        if (this.buffer.isWrapped()) {
            throw new IllegalStateException("getInitialBufferLength() invoked for a wrapped buffer");
        }
        return this.partialDeserialize ? this.buffer.getLength() : this.doGetInitialBufferLength();
    }

    public void initializeBuffer() {
    }
}

