/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.network;

import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.link.network.LnkNwPeerEndpointStats;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;

final class LnkNwPeerEndpointOutputBuffer {
    private final Tracer tracer;
    private final String tracePrefix;
    private final IOElasticBuffer buffer;
    private final ByteBuffer[] flushBuffers;
    private final LnkNwPeerEndpointStats stats;
    private final int autoFlushSize;
    private final int maxBufferSize;
    private boolean stampOutTs;
    private int meanFlushSize;
    private double meanFlushSizeChangeLambda;
    private int flushedToDrain;

    LnkNwPeerEndpointOutputBuffer(String name, Tracer tracer, int autoFlushSize, int maxBufferSize, boolean stampOutTs, LnkNwPeerEndpointStats stats) {
        this.tracer = tracer;
        this.tracePrefix = "[obuf] ";
        this.stats = stats;
        this.autoFlushSize = autoFlushSize;
        this.maxBufferSize = maxBufferSize;
        this.stampOutTs = stampOutTs;
        this.meanFlushSize = this.autoFlushSize;
        this.meanFlushSizeChangeLambda = 0.1;
        this.flushedToDrain = 0;
        this.buffer = IOElasticBuffer.create((int)IOBuffer.slabSize((int)this.meanFlushSize));
        this.buffer.setLength(0);
        this.flushBuffers = new ByteBuffer[1];
        tracer.log("Network Link Endpoint Configuration (Output Buffer)...", Tracer.Level.CONFIG);
        tracer.log("....link=" + name, Tracer.Level.CONFIG);
        tracer.log("........maxBufferSize=" + this.maxBufferSize, Tracer.Level.CONFIG);
        tracer.log("........autoFlushSize=" + this.autoFlushSize, Tracer.Level.CONFIG);
        tracer.log("........stampOutTs=" + stampOutTs, Tracer.Level.CONFIG);
    }

    final void enableIOTimestamps(boolean enabled) {
        this.stampOutTs = enabled;
    }

    final boolean serialize(PktPacket packet) {
        int preSerializeBufferLength = this.buffer.getLength();
        packet.serialize(this.buffer, this.buffer.getLength());
        int postSerializeBufferLength = this.buffer.getLength();
        if (this.tracer.debug) {
            this.tracer.log("Serialized packet to output buffer [postSerializeBufferLength=" + postSerializeBufferLength + " autoFlushSize=" + this.autoFlushSize + "].", Tracer.Level.DEBUG);
        }
        ++this.stats.numPacketsEnqueued;
        if (this.stampOutTs) {
            packet.getHeader();
            PktHeader.setPreWireTs(this.buffer.getBackingBufferUnsafe().getBufferUnsafe(), preSerializeBufferLength, UtlTime.now());
        }
        this.stats.numBytesEnqueued += (long)(postSerializeBufferLength - preSerializeBufferLength);
        return this.autoFlushSize > 0 && postSerializeBufferLength >= this.autoFlushSize;
    }

    final boolean flush(IEmxNwLnkPeerEndpoint pep, EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        long preWriteTs = this.stampOutTs ? UtlTime.now() : 0L;
        IOBuffer backingBuffer = this.buffer.getBackingBufferUnsafe();
        int size = this.buffer.getLength();
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Flush start [buffer length=" + size + " flushed to drain=" + this.flushedToDrain + "]", Tracer.Level.DEBUG);
        }
        int numWrittenTotal = 0;
        while (size > 0) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Writing buffer [offset =" + numWrittenTotal + ", size=" + (size - numWrittenTotal) + "]", Tracer.Level.DEBUG);
            }
            int numWritten = (int)pep.write(backingBuffer, numWrittenTotal, size - numWrittenTotal, waitCond);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Written buffer [bytes written=(" + numWritten + "," + (numWrittenTotal + numWritten) + ")]", Tracer.Level.DEBUG);
            }
            if (numWritten == 0) break;
            numWrittenTotal += numWritten;
            this.flushedToDrain += numWritten;
            this.stats.numBytesFlushed += (long)numWritten;
            if ((size -= numWritten) >= 0) continue;
            throw new InternalError("Buffer size is negative after a flush!");
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Flush complete [size=" + size + " flushed to drain=" + this.flushedToDrain + "]", Tracer.Level.DEBUG);
        }
        if (size == 0) {
            int currentBufferCapacity;
            int meanBufferSize;
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Buffer fully drained", Tracer.Level.DEBUG);
            }
            this.stats.meanFlushSize = this.meanFlushSize = (int)Math.ceil(this.meanFlushSizeChangeLambda * (double)this.flushedToDrain + (1.0 - this.meanFlushSizeChangeLambda) * (double)this.meanFlushSize);
            this.stats.meanBufferSize = meanBufferSize = Math.min(Math.max(this.meanFlushSize, this.autoFlushSize), this.maxBufferSize > 0 ? this.maxBufferSize : Integer.MAX_VALUE);
            int newBufferCapacity = currentBufferCapacity = backingBuffer.getCapacity();
            if (meanBufferSize > currentBufferCapacity) {
                newBufferCapacity = currentBufferCapacity * 2;
            } else if (meanBufferSize < newBufferCapacity / 2) {
                newBufferCapacity = currentBufferCapacity / 2;
            }
            if (currentBufferCapacity != newBufferCapacity) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Replacing first buffer [oldCapacity=" + currentBufferCapacity + " newCapacity=" + newBufferCapacity + "]", Tracer.Level.DEBUG);
                }
                this.buffer.reset(false);
                newBufferCapacity = IOBuffer.slabSize((int)newBufferCapacity);
                this.buffer.setLength(newBufferCapacity).setLength(0);
                this.stats.numOutputBufBytesAllocated += (long)newBufferCapacity;
            } else {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Old and new capacities the same. Retaining first buffer", Tracer.Level.DEBUG);
                }
                this.buffer.setLength(0);
            }
            this.flushedToDrain = 0;
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Post drain processing complete [buffer size=" + size + " mean flush size=" + this.meanFlushSize + "]", Tracer.Level.DEBUG);
            }
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Buffers not fully drained [size=" + size + "]", Tracer.Level.DEBUG);
            }
            IOBuffer.copy((long)backingBuffer.getNativeAddress(), (int)(this.buffer.getLength() - size), (long)backingBuffer.getNativeAddress(), (int)0, (int)size);
            this.buffer.setLength(size);
        }
        if (this.stampOutTs) {
            this.stats.w.add((double)(UtlTime.now() - preWriteTs));
        }
        return this.buffer.getLength() == 0;
    }

    final int getSize() {
        return this.buffer.getLength();
    }
}

